/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.postgresql.db;

import com.openbravo.basic.BasicException;
import com.openbravo.keen.pojo.Costumer_Fidelite;
import com.openbravo.keen.pojo.Transaction_Fidelite;
import com.openbravo.keen.writer.Costumer_FideliteWriter;
import com.openbravo.keen.writer.Transaction_FideliteWriter;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.MarqueNFC;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.postgresql.db.PostgreObject;
import fr.protactile.norm.beans.GrandTotalPeriode;
import fr.protactile.procaisse.dao.entities.AddressInfo;
import fr.protactile.procaisse.dao.entities.CustomerInfo;
import fr.protactile.procaisse.dao.impl.AddressInfoDao;
import fr.protactile.procaisse.services.CustomerService;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONArray;
import org.json.simple.JSONObject;

public class PostgreService {
    private final String URL_ADDING_DATA_POSTGRE_API = "https://json.biborne.com/api/v1";
    private boolean is_synchronizing = false;
    private static PostgreService m_instance = null;
    private CustomerService mCustomerService = CustomerService.getInstance();
    private AddressInfoDao addressInfoDao = new AddressInfoDao();
    private Transaction_FideliteWriter transaction;
    private Costumer_FideliteWriter mCostumer_FideliteWriter;
    private String SIRET_VAL = "";

    public static PostgreService getInstance() {
        if (m_instance == null) {
            m_instance = new PostgreService();
        }
        return m_instance;
    }

    public PostgreService() {
        if (AppLocal.dlSales != null) {
            try {
                MarqueNFC marqueNF = AppLocal.dlSales.getMarqueNF();
                if (marqueNF != null) {
                    this.SIRET_VAL = marqueNF.getSiret();
                }
            }
            catch (BasicException ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public void uploadZjour(GrandTotalPeriode cloture) throws IOException, BasicException {
        JSONObject jsonZjour = null;
        PostgreObject mPostgreObject = new PostgreObject();
        jsonZjour = mPostgreObject.getZDetailsJson(cloture);
        System.out.println("jsonZjour : " + jsonZjour.toJSONString());
        OkHttpClient client = new OkHttpClient.Builder().writeTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).build();
        String resourceUrl = "https://json.biborne.com/api/v1/zjour/NewZjourBulk";
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonZjour.toString());
        Request request = new Request.Builder().url(resourceUrl).post(requestBody).build();
        Response response = client.newCall(request).execute();
        String response_body = response.body().string();
        System.out.println("response_body : " + response_body);
        System.out.println("response.code() : uploadZjour " + response.code());
        if (response.code() == 201) {
            AppLocal.dlItems.updateIsSynchronisedCloture(cloture.getId());
            System.out.println("Cloture Journaliere remont\u00e9e : " + cloture.getId());
        }
        response.close();
    }

    public void uploadLogPanier() throws IOException, BasicException {
        JSONArray jsonLogPanier = null;
        PostgreObject mPostgreObject = new PostgreObject();
        jsonLogPanier = mPostgreObject.getLogPanierJson();
        OkHttpClient client = new OkHttpClient.Builder().writeTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).build();
        String resourceUrl = "https://json.biborne.com/api/v1/commande/NewBasketLinesLogsBulk";
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonLogPanier.toString());
        Request request = new Request.Builder().url(resourceUrl).post(requestBody).build();
        Response response = client.newCall(request).execute();
        String responseBody = response.body().string();
        System.out.println("response.code() : uploadLogPanier " + response.code());
        if (response.code() == 201 && jsonLogPanier != null && jsonLogPanier.length() > 0) {
            for (int i = 0; i < jsonLogPanier.length(); ++i) {
                org.json.JSONObject jsonLog = jsonLogPanier.getJSONObject(i);
                AppLocal.dlItems.updateSynchroLogPanier(jsonLog.getInt("id"));
                System.out.println("LogPanier remont\u00e9e : " + jsonLog.getInt("id"));
            }
        }
        response.close();
    }

    public void uploadZmois(GrandTotalPeriode cloture) throws IOException, BasicException {
        JSONObject jsonZmois = null;
        PostgreObject mPostgreObject = new PostgreObject();
        jsonZmois = mPostgreObject.getZDetailsJson(cloture);
        OkHttpClient client = new OkHttpClient.Builder().writeTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).build();
        String resourceUrl = "https://json.biborne.com/api/v1/zmois/NewZmoisBulk";
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonZmois.toString());
        Request request = new Request.Builder().url(resourceUrl).post(requestBody).build();
        Response response = client.newCall(request).execute();
        String response_body = response.body().string();
        if (response.code() == 201) {
            AppLocal.dlItems.updateIsSynchronisedCloture(cloture.getId());
            System.out.println("Cloture monsuelle remont\u00e9e : " + cloture.getId());
        }
        response.close();
    }

    public void SendDataToPostgree() {
        try {
            PostgreObject mPostgreObject = new PostgreObject();
            System.out.println("++++++++++++++  SendDataToPostgree()");
            if (this.isNetworkConnected()) {
                List<GrandTotalPeriode> cloturesMonthData;
                List<GrandTotalPeriode> cloturesDayData = AppLocal.dlItems.loadGrandTotalPeriod("j");
                if (cloturesDayData != null && cloturesDayData.size() > 0) {
                    for (GrandTotalPeriode cloture : cloturesDayData) {
                        this.uploadZjour(cloture);
                    }
                }
                if (AppLocal.SEND_MONTHLY_REPORT && (cloturesMonthData = AppLocal.dlItems.loadGrandTotalPeriod("m")) != null && cloturesMonthData.size() > 0) {
                    for (GrandTotalPeriode cloture : cloturesMonthData) {
                        this.uploadZmois(cloture);
                    }
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
    }

    public void doSynchronizeOrderData() {
        this.doSynchronizeOrderData(500, null);
    }

    public void uploadOrder(TicketInfo ticket) {
        try {
            JSONObject jsonOrder = null;
            AppLocal.dlItems.updateOrderProgress(ticket.getId(), "Pending");
            PostgreObject mPostgreObject = new PostgreObject();
            jsonOrder = mPostgreObject.getOrderJson(ticket);
            OkHttpClient client = new OkHttpClient.Builder().writeTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).build();
            String resourceUrl = "https://json.biborne.com/api/v1/commande/NewGlobalOrderBulk";
            System.out.println("++++++++ jsonOrder.toString() : " + jsonOrder.toString());
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonOrder.toString());
            Request request = new Request.Builder().url(resourceUrl).post(requestBody).build();
            Response response = client.newCall(request).execute();
            System.out.println("++++++++++ response upload one order ***********: " + response);
            String response_body = response.body().string();
            if (response.code() == 201) {
                AppLocal.dlItems.updateOrderProgress(ticket.getId(), "Finished");
                AppLocal.dlItems.updateOrderSynchro(ticket.getId(), true);
                System.out.println("Commande remont\u00e9e : " + ticket.getId());
            } else {
                AppLocal.dlItems.updateOrderProgress(ticket.getId(), "Started");
            }
            response.close();
        }
        catch (Exception ex) {
            AppLocal.dlItems.updateOrderProgress(ticket.getId(), "Started");
            LogToFile.log("severe", null, ex);
        }
    }

    public boolean isNetworkConnected() {
        return PostgreService.isNetworkConnected("www.google.com", 80, 5000);
    }

    public static boolean isNetworkConnected(String host, Integer port, Integer timeOutInMilliSec) {
        try {
            Socket socket = new Socket();
            socket.connect(new InetSocketAddress(host, (int)port), timeOutInMilliSec);
            return true;
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
            return false;
        }
    }

    public void doSynchronizeOrderDataTimer() {
        if (!this.is_synchronizing) {
            this.doSynchronizeOrderData();
        }
    }

    public void setSynchronizing(boolean is_synchronizing) {
        this.is_synchronizing = is_synchronizing;
    }

    public void updateStatusPayments(TicketInfo ticket) throws IOException, BasicException {
        JSONObject jsonUpdatestatus = null;
        PostgreObject mPostgreObject = new PostgreObject();
        jsonUpdatestatus = mPostgreObject.changePaymentsStatus(ticket);
        OkHttpClient client = new OkHttpClient.Builder().writeTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).build();
        String resourceUrl = "https://json.biborne.com/api/v1/commande/UpdatePaymentStatus";
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonUpdatestatus.toString());
        Request request = new Request.Builder().url(resourceUrl).post(requestBody).build();
        Response response = client.newCall(request).execute();
        String response_body = response.body().string();
        if (response.code() == 201) {
            AppLocal.dlItems.updateCancledPostgre(ticket.getId());
        }
        response.close();
    }

    public void cancelOrder(TicketInfo ticket) throws IOException, BasicException {
        JSONObject jsonCancelstatus = null;
        PostgreObject mPostgreObject = new PostgreObject();
        jsonCancelstatus = mPostgreObject.cancelOrder(ticket);
        System.out.println("jsonCancelstatus.toString() : " + jsonCancelstatus.toString());
        OkHttpClient client = new OkHttpClient.Builder().writeTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).build();
        String resourceUrl = "https://json.biborne.com/api/v1/commande/UpdateOrderStatus";
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonCancelstatus.toString());
        Request request = new Request.Builder().url(resourceUrl).post(requestBody).build();
        Response response = client.newCall(request).execute();
        String response_body = response.body().string();
        if (response.code() == 201) {
            AppLocal.dlItems.updateCancledPostgre(ticket.getId());
        }
        response.close();
    }

    public void canceledOrder(TicketInfo ticket) {
        try {
            if (this.isNetworkConnected()) {
                this.cancelOrder(ticket);
                this.updateStatusPayments(ticket);
                AppLocal.dlItems.updateCancledPostgre(ticket.getId());
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
    }

    public void uploadBulkOrder(JSONArray jsonRoot, List<TicketInfo> sentTickets) {
        ArrayList<String> ordersInjectedInPostgre = new ArrayList<String>();
        ArrayList<String> ordersAlreadyInjectedInPostgre = new ArrayList<String>();
        try {
            System.out.println("+++++++++++++ send orders postgre****************");
            for (TicketInfo sentTicket : sentTickets) {
                AppLocal.dlItems.updateOrderProgress(sentTicket.getId(), "Pending");
            }
            OkHttpClient client = new OkHttpClient.Builder().writeTimeout(2L, TimeUnit.MINUTES).readTimeout(2L, TimeUnit.MINUTES).build();
            String resourceUrl = "https://json.biborne.com/api/v1/commande/checkOrderReturnOrderIds";
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonRoot.toString());
            Request request = new Request.Builder().url(resourceUrl).post(requestBody).build();
            Response response = client.newCall(request).execute();
            String response_body = response.body().string();
            if (response.code() == 200 && response_body != null && !response_body.isEmpty()) {
                String orderId;
                int i;
                org.json.JSONObject jsonResponse = new org.json.JSONObject(response_body);
                if (!jsonResponse.isNull("insertedOrderIds")) {
                    JSONArray arrayOrders = jsonResponse.getJSONArray("insertedOrderIds");
                    for (i = 0; i < arrayOrders.length(); ++i) {
                        orderId = arrayOrders.getString(i);
                        ordersInjectedInPostgre.add(orderId);
                        AppLocal.dlItems.updateOrderProgress(orderId, "Finished");
                        AppLocal.dlItems.updateOrderSynchro(orderId, true);
                        System.out.println("Commande remont\u00e9e : " + orderId);
                    }
                }
                if (!jsonResponse.isNull("existedOrderIds")) {
                    JSONArray arrayOrdersAlreadyInjected = jsonResponse.getJSONArray("existedOrderIds");
                    for (i = 0; i < arrayOrdersAlreadyInjected.length(); ++i) {
                        orderId = arrayOrdersAlreadyInjected.getString(i);
                        ordersAlreadyInjectedInPostgre.add(orderId);
                        AppLocal.dlItems.updateOrderProgress(orderId, "Finished");
                        AppLocal.dlItems.updateOrderSynchro(orderId, true);
                        System.out.println("Commande remont\u00e9e : " + orderId);
                    }
                }
            }
            response.close();
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
        for (TicketInfo sentTicket : sentTickets) {
            if (ordersInjectedInPostgre.contains(sentTicket.getId()) || ordersAlreadyInjectedInPostgre.contains(sentTicket.getId())) continue;
            AppLocal.dlItems.updateOrderProgress(sentTicket.getId(), "Started");
        }
    }

    public void doSynchronizeOrderData(int rows, TicketInfo currentTicket) {
        try {
            System.out.println("++++++++++++++++++++++++++ doSynchronizePostgreData()");
            PostgreObject mPostgreObject = new PostgreObject();
            ArrayList<TicketInfo> sentTickets = new ArrayList<TicketInfo>();
            JSONArray jsonRoot = new JSONArray();
            if (AppLocal.dlItems != null && this.isNetworkConnected()) {
                List<String> mListIds;
                if (currentTicket != null) {
                    AppLocal.dlItems.updateOrderProgress(currentTicket.getId(), "preSending");
                    jsonRoot.put((Map)mPostgreObject.getOrderJson(currentTicket));
                    sentTickets.add(currentTicket);
                }
                if ((mListIds = AppLocal.dlItems.loadPostgreOrderIdsNotSynchronized(rows)) != null && !mListIds.isEmpty()) {
                    AppLocal.dlItems.updateOrderProgress(mListIds, "preSending");
                }
                for (String mListId : mListIds) {
                    String idTicket = mListId;
                    TicketInfo mTicketInfo = AppLocal.dlItems.fetchPostgreTicketNotSynchronized(idTicket, true);
                    if (mTicketInfo == null) continue;
                    jsonRoot.put((Map)mPostgreObject.getOrderJson(mTicketInfo));
                    sentTickets.add(mTicketInfo);
                }
                if (!sentTickets.isEmpty()) {
                    this.uploadBulkOrder(jsonRoot, sentTickets);
                }
                List<TicketInfo> cancledTicket = AppLocal.dlItems.CancledloadOrder();
                for (TicketInfo next : cancledTicket) {
                    this.canceledOrder(next);
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
    }

    public void uploadClients(JSONArray jsonClients, List<CustomerInfo> customersList) throws IOException, BasicException {
        System.out.println("+++++++++++++++++++jsonClients : " + jsonClients);
        OkHttpClient client = new OkHttpClient.Builder().writeTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).build();
        String resourceUrl = "https://json.biborne.com/api/v1/Customers/NewCustomersLoop";
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonClients.toString());
        Request request = new Request.Builder().url(resourceUrl).post(requestBody).build();
        Response response = client.newCall(request).execute();
        String response_body = response.body().string();
        System.out.println("+++++++++++++++response.code costumer: " + response.code());
        if (response.code() == 200) {
            for (CustomerInfo customer : customersList) {
                AppLocal.dlItems.updateIsSynchronisedClient(customer.getId());
            }
        }
        response.close();
    }

    public void uploadAddress(JSONArray jsonAdresses, List<AddressInfo> adresses) throws IOException, BasicException {
        OkHttpClient client = new OkHttpClient.Builder().writeTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).build();
        String resourceUrl = "https://json.biborne.com/api/v1/Address/NewAddressLoop";
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonAdresses.toString());
        Request request = new Request.Builder().url(resourceUrl).post(requestBody).build();
        Response response = client.newCall(request).execute();
        String response_body = response.body().string();
        System.out.println("+++++++++++++++response.code Adress: " + response.code());
        if (response.code() == 200) {
            for (AddressInfo address : adresses) {
                AppLocal.dlItems.updateIsSynchronisedAddress(address.getId());
            }
        }
        response.close();
    }

    public void uploadTransactions(JSONArray Transactions, List<Transaction_Fidelite> mList) throws IOException, BasicException {
        System.out.println("+++++++++++++++++++++++++++++++uploadTransactions()" + Transactions.toString());
        if (Transactions != null && !Transactions.toString().isEmpty()) {
            OkHttpClient client = new OkHttpClient.Builder().writeTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).build();
            String resourceUrl = "https://json.biborne.com/api/v1/transaction_fidelite/NewTransactionsFideliteBulk";
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)Transactions.toString());
            Request request = new Request.Builder().url(resourceUrl).post(requestBody).build();
            Response response = client.newCall(request).execute();
            String response_body = response.body().string();
            System.out.println("+++++++++++++++++++++++++++++++response.code() uploadTransactions " + response.code());
            if (response.code() == 201) {
                for (Transaction_Fidelite transaction_Fidelite : mList) {
                    this.transaction.updateMigratedTransaction(transaction_Fidelite.getFranchise_uuid(), transaction_Fidelite.getId(), transaction_Fidelite.getPhone());
                }
            }
            response.close();
        }
    }

    public void uploadCustomer_Fedilite(JSONArray customersJson, List<Costumer_Fidelite> mList) throws IOException, BasicException {
        System.out.println("+++++++++++++++++++++++++++++++uploadCustomer_Fedilite()" + customersJson.toString());
        if (customersJson != null && !customersJson.toString().isEmpty()) {
            OkHttpClient client = new OkHttpClient.Builder().writeTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).build();
            String resourceUrl = "https://json.biborne.com/api/v1/Customer_fidelite/NewCustomersFideliteBulk";
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)customersJson.toString());
            Request request = new Request.Builder().url(resourceUrl).post(requestBody).build();
            Response response = client.newCall(request).execute();
            String response_body = response.body().string();
            System.out.println("+++++++++++++++++++++++++++++++response.code uploadCustomer_Fedilite()" + response.code());
            if (this.mCostumer_FideliteWriter == null) {
                this.mCostumer_FideliteWriter = new Costumer_FideliteWriter();
            }
            if (response.code() == 201) {
                for (Costumer_Fidelite costumer : mList) {
                    this.mCostumer_FideliteWriter.updateMigratedCustomer(costumer.getFranchise_uuid(), costumer.getId(), costumer.getPhone());
                }
            }
            response.close();
        }
    }

    public void updateZjour(GrandTotalPeriode cloture) throws IOException, BasicException {
        PostgreObject mPostgreObject = new PostgreObject();
        JSONObject jsonZjour = mPostgreObject.getZJson(cloture);
        System.out.println("+++++++jsonZjour : " + jsonZjour);
        OkHttpClient client = new OkHttpClient.Builder().writeTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).build();
        String resourceUrl = "https://json.biborne.com/api/v1/zjour/updateZjourObject";
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonZjour.toString());
        Request request = new Request.Builder().url(resourceUrl).put(requestBody).build();
        Response response = client.newCall(request).execute();
        if (response.code() == 200) {
            AppLocal.dlItems.setZUpdated(cloture.getId());
            System.out.println("Cloture Journaliere modifi\u00e9 : " + cloture.getId());
        }
        response.close();
    }

    public void updateNbPlatform(GrandTotalPeriode cloture) throws IOException, BasicException {
        PostgreObject mPostgreObject = new PostgreObject();
        JSONObject jsonZjour = mPostgreObject.getnbPlatformJson(cloture);
        System.out.println("+++++++jsonZjour : " + jsonZjour);
        OkHttpClient client = new OkHttpClient.Builder().writeTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).build();
        String resourceUrl = "https://json.biborne.com/api/v1/zjour/updateZjourObjectNOP";
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonZjour.toString());
        Request request = new Request.Builder().url(resourceUrl).put(requestBody).build();
        Response response = client.newCall(request).execute();
        if (response.code() == 200) {
            AppLocal.dlItems.setNbPlatformUpdated(cloture.getId());
            System.out.println(" NUMBER_ORDERS_PLATFORM modifi\u00e9 | Cloture : " + cloture.getId());
        }
        response.close();
    }

    public void bulkDataInsert() {
        JSONArray Transactions = new JSONArray();
        JSONArray customers_fidelite = new JSONArray();
        JSONArray jsonClients = new JSONArray();
        JSONArray jsonAdresses = new JSONArray();
        PostgreObject mPostgreObject = null;
        if (this.isNetworkConnected()) {
            try {
                List<GrandTotalPeriode> list;
                List<GrandTotalPeriode> cloturesDayDataToUpdateNbPlatform;
                List<GrandTotalPeriode> cloturesDayDataToUpdate;
                mPostgreObject = new PostgreObject();
                if (AppLocal.CLICK_COLLECT_V5) {
                    List<Transaction_Fidelite> mList;
                    if (this.transaction == null) {
                        this.transaction = new Transaction_FideliteWriter();
                    }
                    if (this.mCostumer_FideliteWriter == null) {
                        this.mCostumer_FideliteWriter = new Costumer_FideliteWriter();
                    }
                    if ((mList = this.transaction.findBySiret(Long.parseLong(this.SIRET_VAL))) != null && !mList.isEmpty()) {
                        Transactions = mPostgreObject.getOldTransactions(mList);
                        this.uploadTransactions(Transactions, mList);
                        System.out.println("++++++++++++++++++++++++++END Transaction_Fidelite Upload " + System.currentTimeMillis());
                    }
                    System.out.println("++++++++++++++++++++++++++begin Costumer_Fidelite Upload " + System.currentTimeMillis());
                    List<Costumer_Fidelite> mList_customers_Fidelite = this.mCostumer_FideliteWriter.findBySiret(Long.parseLong(this.SIRET_VAL));
                    if (mList_customers_Fidelite != null && !mList_customers_Fidelite.isEmpty()) {
                        customers_fidelite = mPostgreObject.getOldCustomers_Fidelite(mList_customers_Fidelite);
                        this.uploadCustomer_Fedilite(customers_fidelite, mList_customers_Fidelite);
                    }
                }
                if ((cloturesDayDataToUpdate = AppLocal.dlItems.loadGrandTotalPeriodToUpdate("j")) != null && cloturesDayDataToUpdate.size() > 0) {
                    for (GrandTotalPeriode grandTotalPeriode : cloturesDayDataToUpdate) {
                        this.updateZjour(grandTotalPeriode);
                    }
                }
                if ((cloturesDayDataToUpdateNbPlatform = AppLocal.dlItems.loadGrandTotalToUpdateNbPlatform("j")) != null && cloturesDayDataToUpdateNbPlatform.size() > 0) {
                    for (GrandTotalPeriode cloture : cloturesDayDataToUpdateNbPlatform) {
                        this.updateNbPlatform(cloture);
                    }
                }
                if ((list = AppLocal.dlItems.loadGTPToUpdateCashlogy("j")) != null && !list.isEmpty()) {
                    this.updateCashlogyData(list);
                }
                this.uploadLogPanier();
                this.uploadClientsToPostgre(mPostgreObject);
                this.uploadAdressToPostgre(mPostgreObject);
                JSONObject jsonModule = mPostgreObject.getModuleJson();
                this.uploadModuleToPostgre(jsonModule);
                if (AppLocal.MODULE_UBER_EATS) {
                    this.sendTvaUber();
                }
                List<TicketInfo> cancelNotes = AppLocal.dlItems.getCancelNotes();
                System.out.println(" cancelNotes :" + cancelNotes);
                this.SendNoteToPostgreDb(cancelNotes);
            }
            catch (Exception ex) {
                LogToFile.log("severe", null, ex);
            }
        }
    }

    public void uploadClientsToPostgre(PostgreObject mPostgreObject) {
        try {
            JSONArray jsonClients = new JSONArray();
            int batchSize = 500;
            List<CustomerInfo> customers = this.mCustomerService.fetchNotSynchronizedCostumors();
            for (int i = 0; i < customers.size(); i += batchSize) {
                List<CustomerInfo> batch = customers.subList(i, Math.min(i + batchSize, customers.size()));
                System.out.println("++++++++++ customers size : " + batch.size());
                jsonClients = mPostgreObject.getJsonClients(batch);
                this.uploadClients(jsonClients, batch);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
    }

    public void uploadAdressToPostgre(PostgreObject mPostgreObject) {
        try {
            JSONArray jsonAdresses = new JSONArray();
            int batchSize = 500;
            List<AddressInfo> adresses = this.addressInfoDao.fetchNotSynchronizedAdress();
            for (int i = 0; i < adresses.size(); i += batchSize) {
                List<AddressInfo> batch = adresses.subList(i, Math.min(i + batchSize, adresses.size()));
                System.out.println("++++++++++ address size : " + batch.size());
                jsonAdresses = mPostgreObject.getJsonAdress(batch);
                this.uploadAddress(jsonAdresses, batch);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
    }

    public void uploadModuleToPostgre(JSONObject jsonModules) throws IOException, BasicException {
        OkHttpClient client = new OkHttpClient.Builder().writeTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).build();
        String resourceUrl = "https://json.biborne.com/api/v1/Modules/NewModule";
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonModules.toString());
        Request request = new Request.Builder().url(resourceUrl).post(requestBody).build();
        Response response = client.newCall(request).execute();
        String response_body = response.body().string();
        System.out.println("+++++++++++++++response.code Modules: " + response.code());
        if (response.code() == 200) {
            System.out.println("Upload Of Modules is dones ");
        }
        response.close();
    }

    public void uploadOldTaxes() throws BasicException, IOException {
        List<GrandTotalPeriode> gtp = AppLocal.dlOrders.loadGTPToUpdateTaxes("j");
        if (gtp != null && gtp.size() > 0) {
            for (GrandTotalPeriode grandTotalPeriode : gtp) {
                this.uploadOldTaxes(grandTotalPeriode);
            }
        }
    }

    public void uploadOldTaxes(GrandTotalPeriode grandTotalPeriode) throws IOException, BasicException {
        PostgreObject mPostgreObject = new PostgreObject();
        JSONObject jsonZjour = mPostgreObject.getZTaxesJson(grandTotalPeriode);
        System.out.println("+++++++jsonZjour : " + jsonZjour);
        OkHttpClient client = new OkHttpClient.Builder().writeTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).build();
        String resourceUrl = "https://json.biborne.com/api/v1/zjour/updateZjourObjectNOPV3";
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonZjour.toString());
        Request request = new Request.Builder().url(resourceUrl).put(requestBody).build();
        Response response = client.newCall(request).execute();
        if (response.code() == 200) {
            System.out.println("Taxes Cloture Journaliere modifi\u00e9 : " + grandTotalPeriode.getId());
        }
        response.close();
    }

    public void sendTvaUber() {
        try {
            PostgreObject MPostgreObject = new PostgreObject();
            JSONArray jsonTvas = MPostgreObject.getJsonTvaUber();
            OkHttpClient client = new OkHttpClient.Builder().writeTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).build();
            String resourceUrl = "https://json.biborne.com/api/v1/zjour/ZjourBulkUpdateUber";
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonTvas.toString());
            Request request = new Request.Builder().url(resourceUrl).put(requestBody).build();
            Response response = client.newCall(request).execute();
            System.out.println("++++++++++++++response.code()" + response.code());
            if (response.code() == 200) {
                for (int i = 0; i < jsonTvas.length(); ++i) {
                    org.json.JSONObject jsonTva = jsonTvas.getJSONObject(i);
                    String idGrand = jsonTva.getString("id");
                    AppLocal.dlItems.setTvaUberUpdated(idGrand);
                    System.out.println(" UBER_TVA_10 | UBER_TVA_5_5  modifi\u00e9 | Jour : " + idGrand);
                }
            }
            response.close();
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
    }

    public void sendZjours(Date startDate, Date endDate) {
        try {
            PostgreObject MPostgreObject = new PostgreObject();
            JSONArray jsonZjours = MPostgreObject.getZjoursBetweenDates(startDate, endDate);
            OkHttpClient client = new OkHttpClient.Builder().writeTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).build();
            String resourceUrl = "https://json.biborne.com/api/v1/zjour/createBulkPerDates/" + startDate + "&" + endDate;
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonZjours.toString());
            Request request = new Request.Builder().url(resourceUrl).post(requestBody).build();
            try (Response response = client.newCall(request).execute();){
                System.out.println("Response Code: " + response.code());
                if (response.code() == 200) {
                    System.out.println("Data successfully sent.");
                } else {
                    System.out.println("Failed to send data. Response Code: " + response.code());
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
    }

    public void SendNoteToPostgreDb(List<TicketInfo> canceledNotes) throws IOException, BasicException {
        JSONArray jsonLogPanier = null;
        PostgreObject mPostgreObject = new PostgreObject();
        jsonLogPanier = mPostgreObject.getCancelledNoteJson(canceledNotes);
        OkHttpClient client = new OkHttpClient.Builder().writeTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).build();
        String resourceUrl = "https://json.biborne.com/api/v1/commande/NewOrdersCancellationLogsBulk";
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonLogPanier.toString());
        Request request = new Request.Builder().url(resourceUrl).post(requestBody).build();
        Response response = client.newCall(request).execute();
        String responseBody = response.body().string();
        System.out.println("response.code() : SendNoteToPostgreDb " + response.code());
        if (response.code() == 201) {
            for (TicketInfo note : canceledNotes) {
                AppLocal.dlItems.updateCancelledNoteSynchro(note, true);
                System.out.println("Cancled Note remont\u00e9e : " + note.getId());
            }
        }
        response.close();
    }

    public void updateCashlogyData(List<GrandTotalPeriode> gtpToUpdateCashlogy) throws IOException, BasicException {
        PostgreObject mPostgreObject = new PostgreObject();
        JSONArray jsonRoot = new JSONArray();
        for (GrandTotalPeriode grandTotalPeriode : gtpToUpdateCashlogy) {
            JSONObject jsonZjour = mPostgreObject.getCashlogyJson(grandTotalPeriode);
            jsonRoot.put((Map)jsonZjour);
        }
        System.out.println("+++++++jsonRoot : " + jsonRoot);
        OkHttpClient client = new OkHttpClient.Builder().writeTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).build();
        String resourceUrl = "https://json.biborne.com/api/v1/zjour/zjour-bulk-update-cashlogy";
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonRoot.toString());
        Request request = new Request.Builder().url(resourceUrl).post(requestBody).build();
        Response response = client.newCall(request).execute();
        System.out.println("******response.code() " + response.code());
        if (response.code() == 200) {
            for (GrandTotalPeriode grandTotalPeriode : gtpToUpdateCashlogy) {
                AppLocal.dlItems.setCashlogyUpdated(grandTotalPeriode.getId());
                System.out.println(" CASHLOGY_TOTAL  modifi\u00e9 | Cloture : " + grandTotalPeriode.getId());
            }
        }
        response.close();
    }
}

