/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.postgresql.db;

import com.datastax.driver.core.utils.UUIDs;
import com.openbravo.basic.BasicException;
import com.openbravo.keen.pojo.Costumer_Fidelite;
import com.openbravo.keen.pojo.Transaction_Fidelite;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.payment.PaymentInfo;
import com.openbravo.pos.ticket.LogPanier;
import com.openbravo.pos.ticket.MarqueNFC;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.TaxLineTicket;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.NumericUtils;
import com.openbravo.pos.util.StringUtils;
import com.openbravo.service.DeliveroService;
import com.openbravo.service.DishopService;
import com.openbravo.service.LoyaltyService;
import com.openbravo.service.OtterService;
import com.openbravo.service.RusHourService;
import com.openbravo.service.UberService;
import fr.protactile.norm.beans.GrandTotalPeriode;
import fr.protactile.procaisse.dao.entities.AddressInfo;
import fr.protactile.procaisse.dao.entities.CustomerInfo;
import fr.protactile.procaisse.dao.impl.CustomerInfoDao;
import fr.protactile.procaisse.services.CustomerService;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.simple.JSONObject;

public class PostgreObject {
    private final SimpleDateFormat dateFormatter = DateUtils.formatterDayMonthYear;
    String keenio;
    double points;
    double used_points;
    boolean actif;
    String birthdate;
    String gender;
    boolean isLoyaltyClient;
    double earned_points;
    private final String SOURCE_CAISSE = "caisse";
    private final String SOURCE_UBEREAT = "Uber Eats";
    private final String SOURCE_BORNE_CB = "borne cb";
    private final String SOURCE_BORNE = "borne";
    private final String SOURCE_ONLINE = "online";
    private final String SOURCE_WEB = "web";
    private final String MODE_CAISSE = "Caisse";
    private final String INSIDE = "inside";
    MarqueNFC marqueNF;
    String siret;
    private LoyaltyService mLoyaltyService;
    private CustomerService mCustomerService = CustomerService.getInstance();
    private CustomerInfoDao customerInfoDao = new CustomerInfoDao();
    private UberService mUberService;
    private OtterService mOtterService;
    private DeliveroService mDeliveroService;
    private DishopService mDeliverooDishopService;
    private RusHourService mRusHourService;

    public PostgreObject() throws BasicException {
        this.marqueNF = MarqueNFC.fetchOrStore(AppLocal.dlSales);
        if (this.marqueNF != null && this.marqueNF.getSiret() != null && !this.marqueNF.getSiret().isEmpty()) {
            this.siret = this.marqueNF.getSiret();
        }
        if (AppLocal.dlItems != null) {
            try {
                this.keenio = AppLocal.dlItems.getUserKeenIo();
                if (this.keenio == null) {
                    this.keenio = "-";
                }
            }
            catch (BasicException ex) {
                LogToFile.log("severe", null, ex);
            }
        }
    }

    public JSONObject getZDetailsJson(GrandTotalPeriode cloture) {
        JSONObject jsonRoot = new JSONObject();
        JSONArray jsonClotures = new JSONArray();
        JSONObject clotureObject = new JSONObject();
        try {
            clotureObject.put((Object)"id", (Object)cloture.getId());
            clotureObject.put((Object)"franchise_id", (Object)AppLocal.FRANCHISE_ID);
            clotureObject.put((Object)"typeperiode", (Object)cloture.displayTypePeriode());
            clotureObject.put((Object)"displaytypeperiode", (Object)cloture.displayPeriodeName());
            clotureObject.put((Object)"cumul", (Object)String.valueOf(cloture.getCumul()));
            clotureObject.put((Object)"cumulperpetual", (Object)String.valueOf(cloture.getCumulPerpetual()));
            String date = this.dateFormatter.format(cloture.getTimestampGDH());
            clotureObject.put((Object)"timestampghd", (Object)date);
            if (this.keenio == null || this.keenio.isEmpty()) {
                this.keenio = AppLocal.dlItems.getUserKeenIo();
            }
            System.out.println("+++++++getZDetailsJson");
            if (this.keenio == null) {
                this.keenio = "-";
            }
            clotureObject.put((Object)"keenio", (Object)this.keenio);
            if (this.siret == null) {
                this.siret = "-";
            }
            clotureObject.put((Object)"siret", (Object)this.siret);
            clotureObject.put((Object)"cash_total", (Object)String.valueOf(cloture.getCash_total()));
            clotureObject.put((Object)"cb_total", (Object)String.valueOf(cloture.getCb_total()));
            clotureObject.put((Object)"tr_total", (Object)String.valueOf(cloture.getTr_total()));
            clotureObject.put((Object)"debit_total", (Object)String.valueOf(cloture.getDebit_total()));
            clotureObject.put((Object)"credit_employee_total", (Object)String.valueOf(cloture.getCredit_employee_total()));
            clotureObject.put((Object)"loyalty_card", (Object)String.valueOf(cloture.getLoyalty_card()));
            clotureObject.put((Object)"cashdro_total", (Object)String.valueOf(cloture.getCashdro_total()));
            clotureObject.put((Object)"virement_total", (Object)String.valueOf(cloture.getVirement_total()));
            clotureObject.put((Object)"cheque_total", (Object)String.valueOf(cloture.getCheque_total()));
            clotureObject.put((Object)"avoir_encaisse_total", (Object)String.valueOf(cloture.getAvoir_encaisse_total()));
            clotureObject.put((Object)"avoir_decaisse_total", (Object)String.valueOf(cloture.getAvoir_decaisse_total()));
            clotureObject.put((Object)"twint_total", (Object)String.valueOf(cloture.getTwint_total()));
            clotureObject.put((Object)"cash_glory_total", (Object)String.valueOf(cloture.getCash_glory_total()));
            clotureObject.put((Object)"cheque_vacances_total", (Object)String.valueOf(cloture.getCheque_vacances_total()));
            clotureObject.put((Object)"tva0", (Object)String.valueOf(cloture.getTva0()));
            clotureObject.put((Object)"tva5", (Object)String.valueOf(cloture.getTva5()));
            clotureObject.put((Object)"tva10", (Object)String.valueOf(cloture.getTva10()));
            clotureObject.put((Object)"tva20", (Object)String.valueOf(cloture.getTva20()));
            clotureObject.put((Object)"tva_7_7", (Object)String.valueOf(cloture.getTva_7_7()));
            clotureObject.put((Object)"tva_2_5", (Object)String.valueOf(cloture.getTva_2_5()));
            clotureObject.put((Object)"tva_2_1", (Object)String.valueOf(cloture.getTva_2_1()));
            clotureObject.put((Object)"tva_8_5", (Object)String.valueOf(cloture.getTva_8_5()));
            clotureObject.put((Object)"tva5_5__ht", (Object)String.valueOf(cloture.getTva_5_5_ht()));
            clotureObject.put((Object)"tva_10_ht", (Object)String.valueOf(cloture.getTva_10_ht()));
            clotureObject.put((Object)"tva_20_ht", (Object)String.valueOf(cloture.getTva_20_ht()));
            clotureObject.put((Object)"tva_7_7_ht", (Object)String.valueOf(cloture.getTva_7_7_ht()));
            clotureObject.put((Object)"tva_2_5_ht", (Object)String.valueOf(cloture.getTva_2_5_ht()));
            clotureObject.put((Object)"tva_2_1_ht", (Object)String.valueOf(cloture.getTva_2_1_ht()));
            clotureObject.put((Object)"tva_8_5_ht", (Object)String.valueOf(cloture.getTva_8_5_ht()));
            clotureObject.put((Object)"NUMBER_ORDERS", (Object)cloture.getNumber_orders());
            clotureObject.put((Object)"TURNOVER_CANCELED", (Object)String.valueOf(cloture.getTurnover_canceled()));
            clotureObject.put((Object)"TOTAL_DISCOUNT", (Object)String.valueOf(cloture.getTotal_discount()));
            clotureObject.put((Object)"TOTAL_DISCOUNT_LINES", (Object)String.valueOf(cloture.getTotal_discount_lines()));
            clotureObject.put((Object)"TOTAL_ORDERS_UBER", (Object)String.valueOf(cloture.getTotal_orders_uber()));
            clotureObject.put((Object)"TOTAL_ORDERS_DELIVERO", (Object)String.valueOf(cloture.getTotal_orders_delivero()));
            clotureObject.put((Object)"TOTAL_ORDERS_JUST_EAT", (Object)String.valueOf(cloture.getTotal_orders_just_eat()));
            clotureObject.put((Object)"TOTAL_ORDERS_SMOOD", (Object)String.valueOf(cloture.getTotal_orders_smood()));
            clotureObject.put((Object)"NUMBER_ORDERS_PLATFORM", (Object)cloture.getNumber_orders_platform());
            clotureObject.put((Object)"TOTAL_ORDERS_DELIVEROO", (Object)String.valueOf(cloture.getTotal_orders_deliveroo()));
            clotureObject.put((Object)"tva_6", (Object)String.valueOf(cloture.getTva_6()));
            clotureObject.put((Object)"tva_12", (Object)String.valueOf(cloture.getTva_12()));
            clotureObject.put((Object)"tva_21", (Object)String.valueOf(cloture.getTva_21()));
            clotureObject.put((Object)"tva_6_ht", (Object)String.valueOf(cloture.getTva_6_ht()));
            clotureObject.put((Object)"tva_12_ht", (Object)String.valueOf(cloture.getTva_12_ht()));
            clotureObject.put((Object)"tva_21_ht", (Object)String.valueOf(cloture.getTva_21_ht()));
            clotureObject.put((Object)"turnover_ubereat", (Object)String.valueOf(cloture.getTurnover_ubereat()));
            clotureObject.put((Object)"TOTAL_ORDERS_DISHOP", (Object)String.valueOf(cloture.getTotal_orders_dishop()));
            clotureObject.put((Object)"TOTAL_STRIPE_DISHOP", (Object)String.valueOf(cloture.getStripe_total()));
            clotureObject.put((Object)"tva_8_1", (Object)String.valueOf(cloture.getTva_8_1()));
            clotureObject.put((Object)"tva_2_6", (Object)String.valueOf(cloture.getTva_2_6()));
            clotureObject.put((Object)"tva_8_1_ht", (Object)String.valueOf(cloture.getTva_8_1_ht()));
            clotureObject.put((Object)"tva_2_6_ht", (Object)String.valueOf(cloture.getTva_2_6_ht()));
            clotureObject.put((Object)"tps", (Object)String.valueOf(cloture.getTaxeByName("TPS")));
            clotureObject.put((Object)"tvq", (Object)String.valueOf(cloture.getTaxeByName("TVQ")));
            clotureObject.put((Object)"CREDIT_CARD_TOTAL", (Object)String.valueOf(cloture.getCredit_card_total()));
            clotureObject.put((Object)"DEBIT_CARD_TOTAL", (Object)String.valueOf(cloture.getDebit_card_total()));
            clotureObject.put((Object)"total_ht_taxable", (Object)String.valueOf(cloture.getTotal_ht_taxable()));
            clotureObject.put((Object)"total_ht_no_taxable", (Object)String.valueOf(cloture.getTotal_ht_no_taxable()));
            clotureObject.put((Object)"hst", (Object)String.valueOf(cloture.getTaxeByName("HST")));
            clotureObject.put((Object)"TVA_5_5_UBEREATS", (Object)String.valueOf(cloture.getTva_5_5_ubereats()));
            clotureObject.put((Object)"TVA_10_UBEREATS", (Object)String.valueOf(cloture.getTva_10_ubereats()));
            clotureObject.put((Object)"total_ttc_orders_at_spot", (Object)NumericUtils.round(cloture.getTotal_orders_at_spot()));
            clotureObject.put((Object)"total_ttc_orders_take_away", (Object)NumericUtils.round(cloture.getTotal_orders_take_away()));
            clotureObject.put((Object)"total_ttc_orders_delivery", (Object)NumericUtils.round(cloture.getTotal_orders_delivery()));
            clotureObject.put((Object)"total_ttc_orders_drive", (Object)NumericUtils.round(cloture.getTotal_orders_drive()));
            clotureObject.put((Object)"total_ht_orders_at_spot", (Object)NumericUtils.round(cloture.getTotal_ht_orders_at_spot()));
            clotureObject.put((Object)"total_ht_orders_take_away", (Object)NumericUtils.round(cloture.getTotal_ht_orders_take_away()));
            clotureObject.put((Object)"total_ht_orders_delivery", (Object)NumericUtils.round(cloture.getTotal_ht_orders_delivery()));
            clotureObject.put((Object)"total_ht_orders_drive", (Object)NumericUtils.round(cloture.getTotal_ht_orders_drive()));
            clotureObject.put((Object)"number_orders_at_spot", (Object)cloture.getNumber_orders_at_spot());
            clotureObject.put((Object)"number_orders_take_away", (Object)cloture.getNumber_orders_take_away());
            clotureObject.put((Object)"number_orders_delivery", (Object)cloture.getNumber_orders_delivery());
            clotureObject.put((Object)"number_orders_drive", (Object)cloture.getNumber_orders_drive());
            clotureObject.put((Object)"carte_tr_total", (Object)cloture.getCarte_tr_total());
            clotureObject.put((Object)"bank_transfer_total", (Object)cloture.getBank_transfer_total());
            clotureObject.put((Object)"total_cashlogy", (Object)cloture.getCash_logy_total());
            jsonClotures.put((Map)clotureObject);
            jsonRoot.put((Object)"clotures", (Object)jsonClotures);
            System.out.println("jsonRoot : " + jsonRoot);
        }
        catch (BasicException ex) {
            LogToFile.log("severe", null, ex);
        }
        return jsonRoot;
    }

    public JSONArray getAllOrdersDetailsJson() {
        JSONArray jsonRoot = new JSONArray();
        try {
            if (AppLocal.dlItems != null) {
                List<String> mListIds = AppLocal.dlItems.loadPostgreOrderIdsNotSynchronized(50);
                for (String mListId : mListIds) {
                    String idTicket = mListId;
                    TicketInfo mTicketInfo = AppLocal.dlItems.fetchPostgreTicketNotSynchronized(idTicket, true);
                    if (mTicketInfo == null) continue;
                    jsonRoot.put((Map)this.getOrderJson(mTicketInfo));
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
        return jsonRoot;
    }

    public JSONObject getOrderJson(TicketInfo ticket) {
        JSONObject jsonRoot = new JSONObject();
        double totalTTC = 0.0;
        double Tva_55 = 0.0;
        double Tva_20 = 0.0;
        double Tva_10 = 0.0;
        double totalHT = 0.0;
        double total_point = 0.0;
        double totalTAX = 0.0;
        String franchise_id = AppLocal.FRANCHISE_ID;
        String licenceid = String.valueOf(AppLocal.getLicenceId());
        String type = ticket.getType();
        String user_id = ticket.getUser().getId();
        String user_name = ticket.getUser().getName();
        String source_order = ticket.getOrdered_from();
        String label_discount = ticket.getLabel_discount();
        String type_discount = ticket.getTypeDiscount();
        String sent_from = this.getSourceOrder(ticket);
        Timestamp paid_at = new Timestamp(ticket.getDatePaid() != null ? ticket.getDatePaid().getTime() : ticket.getM_dDate().getTime());
        Timestamp timestamp = new Timestamp(ticket.getM_dDate().getTime());
        String order_id = ticket.getId();
        int number_order_kitchen = 0;
        if (AppLocal.KITCHEN_COMPOSITE) {
            number_order_kitchen = ticket.getNum_order_kitchen();
        }
        if (order_id == null) {
            order_id = "-";
        }
        if (this.siret == null) {
            this.siret = "-";
        }
        if (franchise_id == null) {
            franchise_id = "-";
        }
        try {
            JSONObject jsonOrder = new JSONObject();
            jsonOrder.put((Object)"user_name", (Object)user_name);
            jsonOrder.put((Object)"user_id", (Object)user_id);
            jsonOrder.put((Object)"keenio_user_id", (Object)this.keenio);
            jsonOrder.put((Object)"procaisse_licence_id", (Object)licenceid);
            jsonOrder.put((Object)"real_total", (Object)ticket.getRealTotal());
            jsonOrder.put((Object)"total", (Object)ticket.getTotal());
            jsonOrder.put((Object)"order_id", (Object)order_id);
            jsonOrder.put((Object)"type", (Object)type);
            jsonOrder.put((Object)"timestamp", (Object)String.valueOf(timestamp));
            jsonOrder.put((Object)"paid_at", (Object)String.valueOf(paid_at));
            jsonOrder.put((Object)"source_order", (Object)source_order);
            jsonOrder.put((Object)"discount", (Object)ticket.getDiscount());
            jsonOrder.put((Object)"label_discount", (Object)label_discount);
            jsonOrder.put((Object)"type_discount", (Object)type_discount);
            jsonOrder.put((Object)"sent_from", (Object)sent_from);
            jsonOrder.put((Object)"franchise_id", (Object)franchise_id);
            jsonOrder.put((Object)"siret", (Object)this.siret);
            jsonOrder.put((Object)"status", (Object)ticket.getStatus());
            jsonOrder.put((Object)"phone_customer", (Object)ticket.getCustomerPhone());
            jsonOrder.put((Object)"name_customer", (Object)ticket.getCustomerName());
            jsonOrder.put((Object)"number_order_kitchen", (Object)number_order_kitchen);
            for (TicketLineInfo line : ticket.getLines()) {
                System.out.println("++++++++++ line.getPoints_loyalty() : " + line.getPoints_loyalty());
                total_point += line.getPoints_loyalty() * line.getMultiply();
            }
            System.out.println("+++++++++ total_point : " + total_point);
            jsonOrder.put((Object)"value_out", (Object)total_point);
            System.out.println("+++++++++ ticket.getTotal() : " + ticket.getTotal());
            jsonOrder.put((Object)"value_in", (Object)(ticket.getTotal() > 0.0 ? ticket.getTotal() : 0.0));
            JSONObject jsonTvaTicket = new JSONObject();
            UUID idTicketTva = UUIDs.random();
            jsonTvaTicket.put((Object)"id", (Object)String.valueOf(idTicketTva));
            jsonTvaTicket.put((Object)"user_name", (Object)user_name);
            jsonTvaTicket.put((Object)"user_id", (Object)user_id);
            jsonTvaTicket.put((Object)"keenio_user_id", (Object)this.keenio);
            jsonTvaTicket.put((Object)"procaisse_licence_id", (Object)licenceid);
            jsonTvaTicket.put((Object)"order_id", (Object)order_id);
            jsonTvaTicket.put((Object)"franchise_id", (Object)franchise_id);
            jsonTvaTicket.put((Object)"siret", (Object)this.siret);
            List<TaxLineTicket> taxes = AppLocal.dlSales.getTaxByTicket(ticket.getId());
            for (TaxLineTicket taxe : taxes) {
                totalHT += Math.abs(NumericUtils.round(taxe.getSumHT()));
                totalTTC += Math.abs(NumericUtils.round(taxe.getSumTTC()));
                totalTAX += Math.abs(NumericUtils.round(taxe.getAmount()));
                if (taxe.getRate() == 0.055) {
                    Tva_55 += taxe.getAmount();
                }
                if (taxe.getRate() == 0.1) {
                    Tva_10 += taxe.getAmount();
                }
                if (taxe.getRate() != 0.2) continue;
                Tva_20 += taxe.getAmount();
            }
            jsonTvaTicket.put((Object)"tva10", (Object)NumericUtils.round(Tva_10));
            jsonTvaTicket.put((Object)"tva20", (Object)NumericUtils.round(Tva_20));
            jsonTvaTicket.put((Object)"tva_55", (Object)NumericUtils.round(Tva_55));
            jsonTvaTicket.put((Object)"totalht", (Object)NumericUtils.round(totalHT));
            jsonTvaTicket.put((Object)"totalttc", (Object)NumericUtils.round(totalTTC));
            jsonOrder.put((Object)"totalht", (Object)totalHT);
            jsonOrder.put((Object)"totaltax", (Object)totalTAX);
            JSONObject jsonCashier = new JSONObject();
            UUID idcashier = UUIDs.random();
            jsonCashier.put((Object)"id", (Object)String.valueOf(idcashier));
            jsonCashier.put((Object)"user_name", (Object)user_name);
            jsonCashier.put((Object)"user_id", (Object)user_id);
            jsonCashier.put((Object)"keenio_user_id", (Object)this.keenio);
            jsonCashier.put((Object)"procaisse_licence_id", (Object)licenceid);
            jsonCashier.put((Object)"order_id", (Object)order_id);
            jsonCashier.put((Object)"franchise_id", (Object)franchise_id);
            jsonCashier.put((Object)"timestamp", (Object)String.valueOf(timestamp));
            jsonCashier.put((Object)"paid_at", (Object)String.valueOf(paid_at));
            jsonCashier.put((Object)"order_type", (Object)type);
            jsonCashier.put((Object)"total", (Object)ticket.getTotal());
            jsonCashier.put((Object)"siret", (Object)this.siret);
            jsonCashier.put((Object)"name", (Object)ticket.getUser().getName());
            jsonCashier.put((Object)"paid_at", (Object)String.valueOf(paid_at));
            jsonCashier.put((Object)"total", (Object)ticket.getTotal());
            JSONArray jsonPayments = new JSONArray();
            for (PaymentInfo p : ticket.getPayments()) {
                JSONObject jsonPayment = new JSONObject();
                UUID idpayment = UUIDs.random();
                jsonPayment.put((Object)"id", (Object)idpayment);
                jsonPayment.put((Object)"user_name", (Object)user_name);
                jsonPayment.put((Object)"user_id", (Object)user_id);
                jsonPayment.put((Object)"keenio_user_id", (Object)this.keenio);
                jsonPayment.put((Object)"procaisse_licence_id", (Object)licenceid);
                jsonPayment.put((Object)"order_id", (Object)order_id);
                jsonPayment.put((Object)"franchise_id", (Object)franchise_id);
                jsonPayment.put((Object)"timestamp", (Object)String.valueOf(timestamp));
                jsonPayment.put((Object)"paid_at", (Object)String.valueOf(new Timestamp(ticket.getDatePaid() != null ? ticket.getDatePaid().getTime() : ticket.getM_dDate().getTime())));
                jsonPayment.put((Object)"amount", (Object)p.getTotal());
                jsonPayment.put((Object)"source_order", (Object)source_order);
                jsonPayment.put((Object)"name", (Object)p.getName());
                jsonPayment.put((Object)"status", (Object)ticket.getStatus());
                jsonPayment.put((Object)"siret", (Object)this.siret);
                jsonPayment.put((Object)"order_type", (Object)type);
                jsonPayments.put((Map)jsonPayment);
            }
            HashMap<Integer, JSONObject> categories_products = new HashMap<Integer, JSONObject>();
            HashMap<Integer, JSONObject> categories_options = new HashMap<Integer, JSONObject>();
            JSONArray jsonOrdersItems = new JSONArray();
            JSONArray jsonOptions = new JSONArray();
            JSONArray jsonOptionsCategories = new JSONArray();
            JSONArray jsonCategoriesProduct = new JSONArray();
            for (TicketLineInfo line : ticket.getLines()) {
                if (line.isNext()) continue;
                String itemToken = StringUtils.uuidTimestamp();
                JSONObject jsonOrderItem = new JSONObject();
                UUID idOrderItem = UUIDs.random();
                jsonOrderItem.put((Object)"id", (Object)idOrderItem);
                jsonOrderItem.put((Object)"keenio_user_id", (Object)this.keenio);
                jsonOrderItem.put((Object)"procaisse_licence_id", (Object)licenceid);
                jsonOrderItem.put((Object)"order_id", (Object)order_id);
                jsonOrderItem.put((Object)"franchise_id", (Object)franchise_id);
                jsonOrderItem.put((Object)"timestamp", (Object)String.valueOf(timestamp));
                jsonOrderItem.put((Object)"paid_at", (Object)String.valueOf(paid_at));
                jsonOrderItem.put((Object)"item_id", (Object)line.getProductID());
                jsonOrderItem.put((Object)"name", (Object)line.getNameProduct());
                jsonOrderItem.put((Object)"quantity", (Object)line.getMultiply());
                jsonOrderItem.put((Object)"price", (Object)line.getPriceProduct());
                jsonOrderItem.put((Object)"price_amount", (Object)line.getValueProduct());
                jsonOrderItem.put((Object)"ht_amount", (Object)line.getHtAmount());
                jsonOrderItem.put((Object)"ttc_amount", (Object)line.getPriceAfterDiscount());
                jsonOrderItem.put((Object)"tax_rate", (Object)line.getTaxRate());
                jsonOrderItem.put((Object)"tax_amount", (Object)line.getTax());
                jsonOrderItem.put((Object)"menu", (Object)line.isMenu());
                jsonOrderItem.put((Object)"discount", (Object)line.getValueDiscount());
                jsonOrderItem.put((Object)"label_discount", (Object)line.getLabelDiscount());
                jsonOrderItem.put((Object)"type_discount", (Object)line.getType_discount());
                jsonOrderItem.put((Object)"size_item", (Object)line.getSizeProduct());
                jsonOrderItem.put((Object)"item_uuid", (Object)itemToken);
                jsonOrderItem.put((Object)"siret", (Object)this.siret);
                jsonOrderItem.put((Object)"order_type", (Object)type);
                ProductInfoExt mproduct = AppLocal.dlSales.getProductInfoById(line.getProductID(), false, false);
                jsonOrderItem.put((Object)"marque", (Object)(mproduct != null ? mproduct.getMarque() : 0));
                jsonOrderItem.put((Object)"id_global", mproduct != null && mproduct.getId_global() != null && !mproduct.getId_global().isEmpty() ? mproduct.getId_global() : org.json.JSONObject.NULL);
                Map<String, Object> item_info = null;
                try {
                    if (AppLocal.dlItems != null) {
                        item_info = AppLocal.dlItems.getItemInfoById(line.getProductID());
                        if (item_info != null && item_info.containsKey("price_buy")) {
                            jsonOrderItem.put((Object)"price_buy", (Object)((Double)item_info.get("price_buy")));
                        } else {
                            jsonOrderItem.put((Object)"price_buy", (Object)0.0);
                        }
                    }
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
                JSONObject jsonCategoryProduct = new JSONObject();
                if (item_info != null && item_info.containsKey("category_name")) {
                    String category_name = item_info.get("category_name").toString();
                    jsonOrderItem.put((Object)"category_name", (Object)category_name);
                    jsonCategoryProduct.put((Object)"category_name", (Object)category_name);
                } else {
                    jsonOrderItem.put((Object)"category_name", (Object)"");
                }
                if (item_info != null && item_info.containsKey("category_id")) {
                    int category_id = (Integer)item_info.get("category_id");
                    jsonOrderItem.put((Object)"category_id", (Object)category_id);
                    jsonCategoryProduct.put((Object)"category_id", (Object)category_id);
                } else {
                    jsonOrderItem.put((Object)"category_id", (Object)0);
                }
                if (item_info != null && item_info.containsKey("category_id_global")) {
                    String category_id_global = (String)item_info.get("category_id_global");
                    jsonCategoryProduct.put((Object)"id_global", category_id_global != null && !category_id_global.isEmpty() ? category_id_global : org.json.JSONObject.NULL);
                } else {
                    jsonCategoryProduct.put((Object)"id_global", org.json.JSONObject.NULL);
                }
                UUID idcategory = UUIDs.random();
                jsonCategoryProduct.put((Object)"id", (Object)idcategory);
                jsonCategoryProduct.put((Object)"order_id", (Object)order_id);
                jsonCategoryProduct.put((Object)"timestamp", (Object)String.valueOf(timestamp));
                jsonCategoryProduct.put((Object)"paid_at", (Object)String.valueOf(paid_at));
                jsonCategoryProduct.put((Object)"order_type", (Object)type);
                jsonCategoryProduct.put((Object)"quantity", (Object)line.getMultiply());
                jsonCategoryProduct.put((Object)"amount", (Object)line.getPriceAfterDiscount());
                jsonCategoryProduct.put((Object)"quantity", (Object)line.getMultiply());
                jsonCategoryProduct.put((Object)"procaisse_licence_id", (Object)licenceid);
                jsonCategoryProduct.put((Object)"keenio_user_id", (Object)this.keenio);
                jsonCategoryProduct.put((Object)"franchise_id", (Object)franchise_id);
                jsonCategoryProduct.put((Object)"siret", (Object)this.siret);
                Integer k = (Integer)jsonCategoryProduct.get((Object)"category_id");
                if (categories_products.containsKey(k)) {
                    JSONObject old = (JSONObject)categories_products.get(k);
                    double quantity = (Double)old.get((Object)"quantity") + line.getMultiply();
                    old.put((Object)"quantity", (Object)quantity);
                    old.put((Object)"amount", (Object)((Double)old.get((Object)"amount") + line.getPriceAfterDiscount()));
                    categories_products.replace(k, old);
                } else {
                    categories_products.put((Integer)jsonCategoryProduct.get((Object)"category_id"), jsonCategoryProduct);
                }
                for (OptionItemOrder opt : line.getListSupplements()) {
                    JSONObject jsonOption = new JSONObject();
                    Map<String, Object> option_info = null;
                    try {
                        if (AppLocal.dlItems != null && option_info == null) {
                            option_info = AppLocal.dlItems.getOptionInfoById(opt.getSupplement());
                        }
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                    jsonOption.put((Object)"item_uuid", (Object)itemToken);
                    jsonOption.put((Object)"timestamp", (Object)String.valueOf(timestamp));
                    jsonOption.put((Object)"paid_at", (Object)(ticket.getDatePaid() != null ? String.valueOf(paid_at) : String.valueOf(timestamp)));
                    jsonOption.put((Object)"item_id", (Object)line.getProductID());
                    jsonOption.put((Object)"procaisse_licence_id", (Object)licenceid);
                    jsonOption.put((Object)"keenio_user_id", (Object)this.keenio);
                    jsonOption.put((Object)"franchise_id", (Object)franchise_id);
                    jsonOption.put((Object)"siret", (Object)this.siret);
                    Integer option_id = opt.getSupplement();
                    if (option_id == null) {
                        option_id = 0;
                    }
                    jsonOption.put((Object)"option_id", (Object)option_id);
                    jsonOption.put((Object)"name", (Object)opt.getNameSupplement());
                    jsonOption.put((Object)"quantity", (Object)opt.getNumberOption());
                    jsonOption.put((Object)"quantity_total", (Object)((double)opt.getNumberOption() * line.getMultiply()));
                    jsonOption.put((Object)"order_type", (Object)type);
                    jsonOption.put((Object)"option_category_name", (Object)"");
                    jsonOption.put((Object)"option_category_id", (Object)0);
                    jsonOption.put((Object)"amount", (Object)opt.getPrice());
                    double price = opt.getNumberOption() == opt.getNumber_free() ? 0.0 : opt.getPrice() / (double)(opt.getNumberOption() - opt.getNumber_free());
                    jsonOption.put((Object)"price", (Object)price);
                    jsonOption.put((Object)"is_ingredient", (Object)false);
                    jsonOption.put((Object)"order_id", (Object)order_id);
                    UUID id = UUIDs.random();
                    jsonOption.put((Object)"id", (Object)String.valueOf(id));
                    jsonOption.put((Object)"amount_total", (Object)(opt.getPrice() * line.getMultiply()));
                    if (option_info != null) {
                        if (option_info.containsKey("id_global")) {
                            String option_id_global = (String)option_info.get("id_global");
                            jsonOption.put((Object)"id_global", option_id_global != null && !option_id_global.isEmpty() ? option_id_global : org.json.JSONObject.NULL);
                        } else {
                            jsonOption.put((Object)"id_global", org.json.JSONObject.NULL);
                        }
                        if (option_info.containsKey("category_id") && option_info.containsKey("category_name")) {
                            int option_category_id = (Integer)option_info.get("category_id");
                            String option_category_name = (String)option_info.get("category_name");
                            JSONObject jsonOptionCategory = new JSONObject();
                            jsonOptionCategory.put((Object)"keenio_user_id", (Object)this.keenio);
                            UUID idOptionCat = UUIDs.random();
                            jsonOptionCategory.put((Object)"id", (Object)idOptionCat);
                            jsonOptionCategory.put((Object)"siret", (Object)this.siret);
                            jsonOptionCategory.put((Object)"procaisse_licence_id", (Object)licenceid);
                            jsonOptionCategory.put((Object)"order_id", (Object)order_id);
                            jsonOptionCategory.put((Object)"franchise_id", (Object)franchise_id);
                            jsonOptionCategory.put((Object)"order_type", (Object)type);
                            jsonOptionCategory.put((Object)"timestamp", (Object)String.valueOf(timestamp));
                            jsonOptionCategory.put((Object)"paid_id", (Object)(ticket.getDatePaid() != null ? String.valueOf(paid_at) : String.valueOf(timestamp)));
                            jsonOptionCategory.put((Object)"category_name", (Object)option_category_name);
                            jsonOptionCategory.put((Object)"category_id", (Object)option_category_id);
                            jsonOptionCategory.put((Object)"quantity", (Object)((double)opt.getNumberOption() * line.getMultiply()));
                            jsonOptionCategory.put((Object)"amount", (Object)(opt.getPrice() * line.getMultiply()));
                            jsonOption.put((Object)"option_category_id", (Object)option_category_id);
                            jsonOption.put((Object)"option_category_name", (Object)option_category_name);
                            Integer keyCategoryOptions = (Integer)jsonOptionCategory.get((Object)"category_id");
                            if (categories_options.containsKey(keyCategoryOptions)) {
                                JSONObject oldCategoryOptions = (JSONObject)categories_options.get(keyCategoryOptions);
                                double quantity = (Double)oldCategoryOptions.get((Object)"quantity") + (double)opt.getNumberOption() * line.getMultiply();
                                oldCategoryOptions.put((Object)"quantity", (Object)quantity);
                                oldCategoryOptions.put((Object)"amount", (Object)((Double)oldCategoryOptions.get((Object)"amount") + opt.getPrice() * line.getMultiply()));
                                categories_options.replace(keyCategoryOptions, oldCategoryOptions);
                            } else {
                                categories_options.put((Integer)jsonOptionCategory.get((Object)"category_id"), jsonOptionCategory);
                            }
                            if (option_info.containsKey("category_id_global")) {
                                String category_option_id_global = (String)option_info.get("category_id_global");
                                jsonOptionCategory.put((Object)"id_global", category_option_id_global != null && !category_option_id_global.isEmpty() ? category_option_id_global : org.json.JSONObject.NULL);
                            } else {
                                jsonOptionCategory.put((Object)"id_global", org.json.JSONObject.NULL);
                            }
                        }
                    }
                    jsonOptions.put((Map)jsonOption);
                }
                jsonOrdersItems.put((Map)jsonOrderItem);
            }
            for (Map.Entry entry : categories_products.entrySet()) {
                jsonCategoriesProduct.put((Map)((JSONObject)entry.getValue()));
            }
            for (Map.Entry entry : categories_options.entrySet()) {
                jsonOptionsCategories.put((Map)((JSONObject)entry.getValue()));
            }
            jsonRoot.put((Object)"order", (Object)jsonOrder);
            jsonRoot.put((Object)"tvaticket", (Object)jsonTvaTicket);
            jsonRoot.put((Object)"payments", (Object)jsonPayments);
            jsonRoot.put((Object)"cashier", (Object)jsonCashier);
            jsonRoot.put((Object)"order_items", (Object)jsonOrdersItems);
            jsonRoot.put((Object)"categories", (Object)jsonCategoriesProduct);
            jsonRoot.put((Object)"options", (Object)jsonOptions);
            jsonRoot.put((Object)"options_categories", (Object)jsonOptionsCategories);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return jsonRoot;
    }

    private String getSourceOrder(TicketInfo ticket) {
        System.out.println("ticket.getOrdered_from() : " + ticket.getOrdered_from());
        System.out.println("ticket.getSent_from() : " + ticket.getSent_from());
        if (ticket.getOrdered_from() != null && ticket.getOrdered_from().equals("inside") && (ticket.getSent_from() == null || ticket.getSent_from().isEmpty())) {
            if (AppLocal.modeCaisse != null && AppLocal.modeCaisse.equals("Caisse")) {
                if (ticket.getType() != null && ticket.getType().equalsIgnoreCase("Drive")) {
                    return "Drive";
                }
                return "caisse";
            }
            return "borne cb";
        }
        if (ticket.getType() != null && ticket.getType().equalsIgnoreCase("Drive")) {
            return "Drive";
        }
        if (ticket.getSent_from() != null) {
            switch (ticket.getSent_from()) {
                case "borne": {
                    return "borne";
                }
                case "web": {
                    return "online";
                }
                case "Uber Eats": {
                    return "Uber Eats";
                }
                case "Just Eat": {
                    return "Just Eat";
                }
                case "Delivero": {
                    return "Delivero";
                }
            }
            return ticket.getSent_from();
        }
        return "";
    }

    public JSONObject cancelOrder(TicketInfo ticket) {
        JSONObject jChangeStatusOrder = new JSONObject();
        jChangeStatusOrder.put((Object)"order_id", (Object)ticket.getId());
        jChangeStatusOrder.put((Object)"keenio_user_id", (Object)this.keenio);
        jChangeStatusOrder.put((Object)"status", (Object)"cancel");
        jChangeStatusOrder.put((Object)"reason_cancel", (Object)ticket.getReason_cancel());
        return jChangeStatusOrder;
    }

    public JSONObject changePaymentsStatus(TicketInfo ticket) {
        JSONObject jChangeStatusPayments = new JSONObject();
        jChangeStatusPayments.put((Object)"order_id", (Object)ticket.getId());
        jChangeStatusPayments.put((Object)"keenio_user_id", (Object)this.keenio);
        jChangeStatusPayments.put((Object)"status", (Object)"cancel");
        return jChangeStatusPayments;
    }

    public JSONArray getJsonClients(List<CustomerInfo> customers) {
        JSONArray jsonClients = new JSONArray();
        JSONObject jsonClient = new JSONObject();
        if (customers != null && customers.size() > 0) {
            for (CustomerInfo customer : customers) {
                jsonClient.put((Object)"phone", (Object)(customer.getPhone() != null ? String.valueOf(customer.getPhone()) : ""));
                jsonClient.put((Object)"name", (Object)(customer.getName() != null ? String.valueOf(customer.getName()) : ""));
                jsonClient.put((Object)"email", (Object)(customer.getEmail() != null ? String.valueOf(customer.getEmail()) : ""));
                jsonClient.put((Object)"prefix", (Object)(customer.getPrefix_phone() != null ? String.valueOf(customer.getPrefix_phone()) : ""));
                jsonClient.put((Object)"siret", (Object)this.siret);
                jsonClient.put((Object)"licence_id", (Object)AppLocal.getLicenceId());
                jsonClient.put((Object)"companyname", (Object)(customer.getCompanyname() != null ? String.valueOf(customer.getCompanyname()) : ""));
                jsonClient.put((Object)"interlocutor", (Object)(customer.getInterlocutor() != null ? String.valueOf(customer.getInterlocutor()) : ""));
                jsonClient.put((Object)"type", (Object)(customer.getType() != null ? String.valueOf(customer.getType()) : ""));
                jsonClient.put((Object)"turnover", (Object)(customer.getTurnover() != null ? String.valueOf(customer.getTurnover()) : ""));
                jsonClient.put((Object)"nb_orders", (Object)customer.getNb_orders());
                jsonClient.put((Object)"isloyaltyclient", (Object)false);
                jsonClient.put((Object)"cagnote", (Object)0);
                jsonClient.put((Object)"gender", (Object)"");
                jsonClient.put((Object)"birthdate", (Object)"");
                jsonClient.put((Object)"actif", (Object)false);
                jsonClient.put((Object)"used_points", (Object)0);
                jsonClient.put((Object)"earned_points", (Object)0);
                jsonClient.put((Object)"source", (Object)AppLocal.MODE_DISPLAY);
                jsonClient.put((Object)"franchise_id", (Object)AppLocal.FRANCHISE_ID);
                jsonClients.put((Map)jsonClient);
            }
        }
        return jsonClients;
    }

    private HashMap<String, Object> getInfosByLoyaltyUser(String phone) {
        HashMap<String, Object> hashLoyalty = new HashMap<String, Object>();
        if (this.mLoyaltyService == null) {
            this.mLoyaltyService = LoyaltyService.getInstance();
        }
        if (phone != null) {
            AppLocal.currentCustomerLoyalty = this.mLoyaltyService.getCagnoteByLoyaltyUser(phone);
            if (AppLocal.currentCustomerLoyalty != null) {
                this.isLoyaltyClient = true;
                this.points = AppLocal.currentCustomerLoyalty.getPoints();
                this.actif = AppLocal.currentCustomerLoyalty.isActif();
                this.used_points = AppLocal.currentCustomerLoyalty.getUsed_points();
                this.earned_points = AppLocal.currentCustomerLoyalty.getEarned_points();
                hashLoyalty.put("isLoyaltyClient", true);
                hashLoyalty.put("points", this.points);
                hashLoyalty.put("actif", this.actif);
                hashLoyalty.put("used_points", this.used_points);
                hashLoyalty.put("earned_points", this.earned_points);
            } else {
                hashLoyalty.put("isLoyaltyClient", false);
                hashLoyalty.put("points", 0);
                hashLoyalty.put("actif", false);
                hashLoyalty.put("used_points", 0);
                hashLoyalty.put("earned_points", 0);
            }
            AppLocal.currentCustomerLoyalty = this.mLoyaltyService.getLoyaltyUserNew(phone);
            if (AppLocal.currentCustomerLoyalty != null) {
                this.gender = AppLocal.currentCustomerLoyalty.getGender();
                this.birthdate = AppLocal.currentCustomerLoyalty.getBirthdate();
                hashLoyalty.put("gender", this.gender);
                hashLoyalty.put("birthdate", this.birthdate);
            } else {
                hashLoyalty.put("gender", "-");
                hashLoyalty.put("birthdate", "-");
            }
        } else {
            hashLoyalty.put("isLoyaltyClient", false);
            hashLoyalty.put("points", 0);
            hashLoyalty.put("actif", false);
            hashLoyalty.put("used_points", 0);
            hashLoyalty.put("earned_points", 0);
            hashLoyalty.put("gender", "-");
            hashLoyalty.put("birthdate", "-");
            hashLoyalty.put("phone", "-");
        }
        return hashLoyalty;
    }

    public JSONArray getJsonAdress(List<AddressInfo> adresses) {
        JSONArray jsonAdresses = new JSONArray();
        JSONObject jsonAddress = new JSONObject();
        if (adresses != null && adresses.size() > 0) {
            for (AddressInfo address : adresses) {
                jsonAddress.put((Object)"address", (Object)(address.getAddress() != null ? String.valueOf(address.getAddress()) : ""));
                jsonAddress.put((Object)"zipcode", (Object)(address.getZipcode() != null ? String.valueOf(address.getZipcode()) : ""));
                jsonAddress.put((Object)"city", (Object)(address.getCity() != null ? String.valueOf(address.getCity()) : ""));
                jsonAddress.put((Object)"entrycode", (Object)(address.getEntrycode() != null ? String.valueOf(address.getEntrycode()) : ""));
                jsonAddress.put((Object)"interphone", (Object)address.getInterphone());
                jsonAddress.put((Object)"batiment", (Object)address.getBatiment());
                jsonAddress.put((Object)"escalier", (Object)address.getEscalier());
                jsonAddress.put((Object)"etage", (Object)address.getEtage());
                jsonAddress.put((Object)"apparemment", (Object)address.getAppartement());
                jsonAddress.put((Object)"societe", (Object)address.getSociete());
                jsonAddress.put((Object)"remarque", (Object)address.getRemarque());
                jsonAddress.put((Object)"lat", (Object)address.getLat());
                jsonAddress.put((Object)"long", (Object)address.getLon());
                jsonAddress.put((Object)"siret", (Object)this.siret);
                jsonAddress.put((Object)"franchise_id", (Object)AppLocal.FRANCHISE_ID);
                jsonAddress.put((Object)"licence_id", (Object)AppLocal.getLicenceId());
                CustomerInfo customer = address.getCustomer();
                if (customer != null) {
                    jsonAddress.put((Object)"phone", (Object)customer.getPhone());
                }
                jsonAdresses.put((Map)jsonAddress);
            }
        }
        return jsonAdresses;
    }

    public JSONArray getOldTransactions(List<Transaction_Fidelite> mList) {
        JSONArray jsonTransactions = new JSONArray();
        JSONObject jsontransaction = new JSONObject();
        try {
            if (mList != null) {
                for (Transaction_Fidelite transaction_Fidelite : mList) {
                    if (transaction_Fidelite.getIsMigrated().booleanValue() && transaction_Fidelite.getIsMigrated() != null) continue;
                    jsontransaction.put((Object)"id", (Object)transaction_Fidelite.getId());
                    jsontransaction.put((Object)"franchise_uuid", (Object)transaction_Fidelite.getFranchise_uuid());
                    jsontransaction.put((Object)"siret", (Object)transaction_Fidelite.getSiret());
                    jsontransaction.put((Object)"amount", (Object)transaction_Fidelite.getAmount());
                    jsontransaction.put((Object)"timestamp", (Object)transaction_Fidelite.getTimestamp());
                    jsontransaction.put((Object)"phone", (Object)transaction_Fidelite.getPhone());
                    jsontransaction.put((Object)"value_in", (Object)transaction_Fidelite.getValue_in());
                    jsontransaction.put((Object)"value_out", (Object)transaction_Fidelite.getValue_out());
                    jsonTransactions.put((Map)jsontransaction);
                }
            }
        }
        catch (Exception e) {
            LogToFile.log("severe", e.getMessage(), e);
        }
        return jsonTransactions;
    }

    public JSONArray getOldCustomers_Fidelite(List<Costumer_Fidelite> mList) {
        JSONArray jsoncustomers = new JSONArray();
        JSONObject jsoncustomer = new JSONObject();
        try {
            if (mList != null) {
                for (Costumer_Fidelite costumer : mList) {
                    if (costumer.getMigrated().booleanValue() && costumer.getMigrated() != null) continue;
                    jsoncustomer.put((Object)"id", (Object)costumer.getId());
                    jsoncustomer.put((Object)"franchise_uuid", (Object)costumer.getFranchise_uuid());
                    jsoncustomer.put((Object)"siret", (Object)costumer.getSiret());
                    jsoncustomer.put((Object)"phone", (Object)costumer.getPhone());
                    jsoncustomer.put((Object)"email", (Object)costumer.getEmail());
                    jsoncustomer.put((Object)"activated", (Object)costumer.getActivated());
                    jsoncustomer.put((Object)"active", (Object)costumer.isActive());
                    jsoncustomer.put((Object)"birthdate", (Object)costumer.getBirthdate());
                    jsoncustomer.put((Object)"created", (Object)costumer.getCreated());
                    jsoncustomer.put((Object)"first_name", (Object)costumer.getFirst_name());
                    jsoncustomer.put((Object)"gender", (Object)costumer.getGender());
                    jsoncustomer.put((Object)"last_name", (Object)costumer.getLast_name());
                    jsoncustomer.put((Object)"cagnote", (Object)costumer.getCagnote());
                    jsoncustomers.put((Map)jsoncustomer);
                }
            }
        }
        catch (Exception e) {
            LogToFile.log("severe", e.getMessage(), e);
        }
        return jsoncustomers;
    }

    public JSONObject getZJson(GrandTotalPeriode cloture) {
        JSONObject clotureObject = new JSONObject();
        try {
            clotureObject.put((Object)"id", (Object)cloture.getId());
            if (this.keenio == null || this.keenio.isEmpty()) {
                this.keenio = AppLocal.dlItems.getUserKeenIo();
            }
            if (this.keenio == null) {
                this.keenio = "-";
            }
            clotureObject.put((Object)"keenio", (Object)this.keenio);
            if (this.siret == null) {
                this.siret = "-";
            }
            clotureObject.put((Object)"siret", (Object)this.siret);
            clotureObject.put((Object)"NUMBER_ORDERS", (Object)cloture.getNumber_orders());
            clotureObject.put((Object)"TOTAL_DISCOUNT", (Object)cloture.getTotal_discount());
            clotureObject.put((Object)"TOTAL_DISCOUNT_LINES", (Object)cloture.getTotal_discount_lines());
        }
        catch (BasicException ex) {
            LogToFile.log("severe", null, ex);
        }
        return clotureObject;
    }

    public JSONObject getnbPlatformJson(GrandTotalPeriode cloture) {
        JSONObject clotureObject = new JSONObject();
        try {
            clotureObject.put((Object)"id", (Object)cloture.getId());
            if (this.keenio == null || this.keenio.isEmpty()) {
                this.keenio = AppLocal.dlItems.getUserKeenIo();
            }
            if (this.keenio == null) {
                this.keenio = "-";
            }
            clotureObject.put((Object)"keenio", (Object)this.keenio);
            if (this.siret == null) {
                this.siret = "-";
            }
            clotureObject.put((Object)"siret", (Object)this.siret);
            clotureObject.put((Object)"NUMBER_ORDERS_PLATFORM", (Object)cloture.getNumber_orders_platform());
        }
        catch (BasicException ex) {
            LogToFile.log("severe", null, ex);
        }
        return clotureObject;
    }

    public JSONObject getModuleJson() {
        JSONObject moduleInfo = new JSONObject();
        this.mUberService = UberService.getInstance();
        this.mOtterService = OtterService.getInstance();
        this.mDeliveroService = DeliveroService.getInstance();
        this.mDeliverooDishopService = DishopService.getInstance();
        this.mRusHourService = RusHourService.getInstance();
        try {
            moduleInfo.put((Object)"uber_eats", (Object)AppLocal.MODULE_UBER_EATS);
            moduleInfo.put((Object)"storeId_uber", (Object)this.mUberService.getStoreID());
            moduleInfo.put((Object)"otter", (Object)AppLocal.MODULE_OTTER);
            moduleInfo.put((Object)"storeId_otter", (Object)this.mOtterService.getStoreID());
            moduleInfo.put((Object)"deliveroo", (Object)AppLocal.MODULE_DELIVERO);
            moduleInfo.put((Object)"locationid_deliveroo", (Object)this.mDeliveroService.getLocationID());
            moduleInfo.put((Object)"plateforme", (Object)AppLocal.MODULE_PLATFORM);
            moduleInfo.put((Object)"dishop", (Object)AppLocal.MODULE_DISHOP);
            moduleInfo.put((Object)"locationid_dishop", (Object)this.mDeliverooDishopService.getLocationID());
            moduleInfo.put((Object)"drive", (Object)AppLocal.MODULE_DRIVE);
            moduleInfo.put((Object)"glory", (Object)AppLocal.GLORY_ENABLED);
            moduleInfo.put((Object)"qoodos", (Object)AppLocal.qoodos);
            moduleInfo.put((Object)"rushour", (Object)AppLocal.MODULE_RUSHOUR);
            moduleInfo.put((Object)"storeId_rushour", (Object)this.mRusHourService.getStoreID());
            moduleInfo.put((Object)"franchise_id", (Object)AppLocal.FRANCHISE_ID);
            if (this.keenio == null || this.keenio.isEmpty()) {
                this.keenio = AppLocal.dlItems.getUserKeenIo();
            }
            if (this.keenio == null) {
                this.keenio = "-";
            }
            moduleInfo.put((Object)"keenio", (Object)this.keenio);
            if (this.siret == null) {
                this.siret = "-";
            }
            moduleInfo.put((Object)"siret", (Object)this.siret);
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
        System.out.println("++++++++++++++++++++++++++++moduleInfo.toString()" + moduleInfo.toString());
        return moduleInfo;
    }

    public JSONArray getJsonTvaUber() throws BasicException, ParseException {
        JSONArray jsonTvas = new JSONArray();
        try {
            GrandTotalPeriode firstNotUpdatedGpt;
            if (this.keenio == null || this.keenio.isEmpty()) {
                this.keenio = AppLocal.dlItems.getUserKeenIo();
            }
            if (this.keenio == null) {
                this.keenio = "-";
            }
            if (this.siret == null) {
                this.siret = "-";
            }
            if ((firstNotUpdatedGpt = AppLocal.dlSales.getFirstNotUpdatedGrandTotalPeriode("j")) != null) {
                Date dateStart = DateUtils.SDF_YYYYMMDD.parse(firstNotUpdatedGpt.getId());
                Date dateEnd = new Date();
                double totalttc10 = 0.0;
                LocalDate localDateStart = dateStart.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                LocalDate localDateEnd = LocalDate.now();
                int daysBetween = (int)ChronoUnit.DAYS.between(localDateStart, localDateEnd);
                System.out.println("+++++++++++++++++++++++++++daysBetween : " + daysBetween + "dateStart : " + dateStart + "dateEnd : " + dateEnd);
                for (int i = 0; i < daysBetween; ++i) {
                    DateUtils.setDateHours(dateStart, dateEnd);
                    List<TaxLineTicket> taxes = AppLocal.dlStats.getTaxeUber(dateStart, dateEnd);
                    double tva10 = 0.0;
                    double tva5 = 0.0;
                    double tva2_1 = 0.0;
                    for (TaxLineTicket taxe : taxes) {
                        if (taxe.getRate() == 0.1) {
                            tva10 = NumericUtils.round(taxe.getAmount());
                            totalttc10 += NumericUtils.round(taxe.getSumTTC());
                        }
                        if (taxe.getRate() != 0.055) continue;
                        tva5 = NumericUtils.round(taxe.getAmount());
                    }
                    String idGRAND = DateUtils.SDF_ID_DAY_PERIOD.format(dateStart);
                    JSONObject jsonTva = new JSONObject();
                    jsonTva.put((Object)"id", (Object)idGRAND);
                    jsonTva.put((Object)"keenio", (Object)this.keenio);
                    jsonTva.put((Object)"siret", (Object)this.siret);
                    jsonTva.put((Object)"TVA_5_5_UBEREATS", (Object)tva5);
                    jsonTva.put((Object)"TVA_10_UBEREATS", (Object)tva10);
                    jsonTvas.put((Map)jsonTva);
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(dateStart);
                    calendar.add(5, 1);
                    dateStart = calendar.getTime();
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
        System.out.println("++++++++++++++++++++++jsonTvas : " + jsonTvas.toString());
        return jsonTvas;
    }

    public JSONObject getZTaxesJson(GrandTotalPeriode cloture) {
        JSONObject clotureObject = new JSONObject();
        try {
            clotureObject.put((Object)"id", (Object)cloture.getId());
            if (this.keenio == null || this.keenio.isEmpty()) {
                this.keenio = AppLocal.dlItems.getUserKeenIo();
            }
            if (this.keenio == null) {
                this.keenio = "-";
            }
            clotureObject.put((Object)"keenio", (Object)this.keenio);
            if (this.siret == null) {
                this.siret = "-";
            }
            clotureObject.put((Object)"siret", (Object)this.siret);
            clotureObject.put((Object)"tps", (Object)String.valueOf(cloture.getTps()));
            clotureObject.put((Object)"tvq", (Object)String.valueOf(cloture.getTvq()));
            System.out.println("cloture.getCredit_card_total() ************* : " + cloture.getCredit_card_total());
            clotureObject.put((Object)"CREDIT_CARD_TOTAL", (Object)String.valueOf(cloture.getCredit_card_total()));
            clotureObject.put((Object)"DEBIT_CARD_TOTAL", (Object)String.valueOf(cloture.getDebit_card_total()));
        }
        catch (BasicException ex) {
            LogToFile.log("severe", null, ex);
        }
        return clotureObject;
    }

    public JSONArray getLogPanierJson() throws BasicException {
        System.out.println("++++++++++++++++++++ getLogPanierJson");
        JSONObject LogPanierObject = new JSONObject();
        JSONArray LogPanierArray = new JSONArray();
        try {
            List<LogPanier> logPanierNotBeenSynch = AppLocal.dlItems.loadNotSynchLogPanier();
            if (logPanierNotBeenSynch != null && !logPanierNotBeenSynch.isEmpty()) {
                for (LogPanier logPanier : logPanierNotBeenSynch) {
                    LogPanierObject.put((Object)"id", (Object)logPanier.getId());
                    if (this.keenio == null || this.keenio.isEmpty()) {
                        this.keenio = AppLocal.dlItems.getUserKeenIo();
                    }
                    if (this.keenio == null) {
                        this.keenio = "-";
                    }
                    LogPanierObject.put((Object)"keenio", (Object)this.keenio);
                    if (this.siret == null) {
                        this.siret = "-";
                    }
                    LogPanierObject.put((Object)"siret", (Object)this.siret);
                    LogPanierObject.put((Object)"numero_order", (Object)logPanier.getNumero_order());
                    LogPanierObject.put((Object)"multiply", (Object)logPanier.getMultiply());
                    LogPanierObject.put((Object)"price", (Object)logPanier.getPrice());
                    LogPanierObject.put((Object)"nameProduct", (Object)logPanier.getNameProduct());
                    LogPanierObject.put((Object)"date_delete", (Object)logPanier.getDateSuppression());
                    LogPanierObject.put((Object)"discount", (Object)logPanier.getDiscount());
                    LogPanierObject.put((Object)"label_discount", (Object)logPanier.getLabelDiscount());
                    LogPanierObject.put((Object)"user_name", (Object)logPanier.getNameUser());
                    LogPanierObject.put((Object)"validate", (Object)logPanier.isValidate());
                    LogPanierArray.put((Map)LogPanierObject);
                }
            } else {
                System.out.println("+++++++++++++ no Logs to upload");
            }
        }
        catch (BasicException ex) {
            LogToFile.log("severe", null, ex);
        }
        return LogPanierArray;
    }

    public JSONArray getZjoursBetweenDates(Date dateStart, Date dateEnd) {
        JSONArray ZjoursBetweenDates = new JSONArray();
        try {
            List<GrandTotalPeriode> cloturesDayDataToSend = AppLocal.dlItems.loadGrandTotalPeriodBetween(dateStart, dateEnd);
            for (GrandTotalPeriode grandTotalPeriode : cloturesDayDataToSend) {
                JSONObject zjour = this.getZDetailsJson(grandTotalPeriode);
                ZjoursBetweenDates.put((Map)zjour);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
        return ZjoursBetweenDates;
    }

    public JSONArray getCancelledNoteJson(List<TicketInfo> canceledNotes) {
        JSONArray cencelNotArray = new JSONArray();
        try {
            for (TicketInfo canceledNote : canceledNotes) {
                String franchise_id = AppLocal.FRANCHISE_ID;
                String licenceid = String.valueOf(AppLocal.getLicenceId());
                String type = canceledNote.getType();
                String user_id = canceledNote.getUser().getId();
                String user_name = canceledNote.getUser().getName();
                String source_order = canceledNote.getOrdered_from();
                String label_discount = canceledNote.getLabel_discount();
                String type_discount = canceledNote.getTypeDiscount();
                String sent_from = this.getSourceOrder(canceledNote);
                Timestamp paid_at = new Timestamp(canceledNote.getDatePaid() != null ? canceledNote.getDatePaid().getTime() : canceledNote.getM_dDate().getTime());
                Timestamp timestamp = new Timestamp(canceledNote.getM_dDate().getTime());
                String order_id = canceledNote.getId();
                int number_order_kitchen = 0;
                if (AppLocal.KITCHEN_COMPOSITE) {
                    number_order_kitchen = canceledNote.getNum_order_kitchen();
                }
                if (order_id == null) {
                    order_id = "-";
                }
                if (this.siret == null) {
                    this.siret = "-";
                }
                if (franchise_id == null) {
                    franchise_id = "-";
                }
                JSONObject jsonOrder = new JSONObject();
                jsonOrder.put((Object)"user_name", (Object)user_name);
                jsonOrder.put((Object)"user_id", (Object)user_id);
                jsonOrder.put((Object)"keenio_user_id", (Object)this.keenio);
                jsonOrder.put((Object)"procaisse_licence_id", (Object)licenceid);
                jsonOrder.put((Object)"real_total", (Object)canceledNote.getRealTotal());
                jsonOrder.put((Object)"total", (Object)canceledNote.getTotalOrder());
                jsonOrder.put((Object)"order_id", (Object)order_id);
                jsonOrder.put((Object)"type", (Object)type);
                jsonOrder.put((Object)"timestamp", (Object)String.valueOf(timestamp));
                jsonOrder.put((Object)"paid_at", (Object)String.valueOf(paid_at));
                jsonOrder.put((Object)"source_order", (Object)source_order);
                jsonOrder.put((Object)"discount", (Object)canceledNote.getDiscount());
                jsonOrder.put((Object)"label_discount", (Object)label_discount);
                jsonOrder.put((Object)"type_discount", (Object)type_discount);
                jsonOrder.put((Object)"sent_from", (Object)sent_from);
                jsonOrder.put((Object)"franchise_id", (Object)franchise_id);
                jsonOrder.put((Object)"siret", (Object)this.siret);
                jsonOrder.put((Object)"status", (Object)canceledNote.getStatus());
                jsonOrder.put((Object)"phone_customer", (Object)canceledNote.getCustomerPhone());
                jsonOrder.put((Object)"name_customer", (Object)canceledNote.getCustomerName());
                jsonOrder.put((Object)"reason_cancel", (Object)canceledNote.getReason_cancel());
                jsonOrder.put((Object)"number_order_kitchen", (Object)number_order_kitchen);
                cencelNotArray.put((Map)jsonOrder);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
        System.out.println("*****cencelNotArray " + cencelNotArray);
        return cencelNotArray;
    }

    public JSONObject getCashlogyJson(GrandTotalPeriode cloture) {
        JSONObject clotureObject = new JSONObject();
        try {
            clotureObject.put((Object)"id", (Object)cloture.getId());
            if (this.keenio == null || this.keenio.isEmpty()) {
                this.keenio = AppLocal.dlItems.getUserKeenIo();
            }
            if (this.keenio == null) {
                this.keenio = "-";
            }
            clotureObject.put((Object)"keenio", (Object)this.keenio);
            if (this.siret == null) {
                this.siret = "-";
            }
            clotureObject.put((Object)"siret", (Object)this.siret);
            clotureObject.put((Object)"total_cashlogy", (Object)cloture.getCash_logy_total());
        }
        catch (BasicException ex) {
            LogToFile.log("severe", null, ex);
        }
        return clotureObject;
    }
}

