/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.util;

import com.openbravo.pos.util.LogToFile;
import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.Scanner;

public class SystemUtils {
    private static final String UNKNOWN_SYSTEM = "Unknown Operating System";
    private static final String SYS_PROPERTY_USER_HOME = "user.home";
    private static final String SYS_PROPERTY_DIR_PATH = "dirname.path";
    public static String SYS_USER_HOME = System.getProperty("user.home");
    public static String SYS_DIR_PATH = System.getProperty("dirname.path");
    private static final String KEYTOOL_ERROR = "keytool error";
    private static final String ALREADY_EXIST = "already exists";
    private static final String ACCESS_DENIED = "access denied";
    private static final String MESSAGE_ALREADY_EXIST = "le certificat existe d\u00e9j\u00e0";
    private static final String MESSAGE_ACCESS_DENIED = "ACC\u00c8S REFUS\u00c9";
    public static final String MESSAGE_SUCCESS = "Certificat import\u00e9 avec succ\u00e8s.";
    private static String url_directory_backup = "C:\\Program Files\\Biborne Tools\\Auto Restarter";

    public static String getLocalHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception ex) {
            LogToFile.log("sever", ex.getMessage(), ex);
            return UNKNOWN_SYSTEM;
        }
    }

    public static String getCurrentSystemPath() {
        String dirname = SYS_DIR_PATH;
        return dirname == null ? "./" : dirname;
    }

    public static String importTrustCertificate(String alias, String certFilePath) {
        String message_return = "Une erreur est servenu.";
        String javaHome = System.getProperty("java.home");
        String keytoolPath = javaHome + "/bin/keytool";
        String keystorePath = javaHome + "/lib/security/cacerts";
        String keystorePassword = "changeit";
        System.out.println("keytoolPath : " + keytoolPath);
        System.out.println("keystorePath : " + keystorePath);
        System.out.println("certFilePath : " + certFilePath);
        System.out.println("alias : " + alias);
        try {
            Process process = new ProcessBuilder(keytoolPath, "-import", "-noprompt", "-alias", alias, "-trustcacerts", "-file", certFilePath, "-keystore", keystorePath, "-storepass", keystorePassword).start();
            Scanner stdin = new Scanner(process.getInputStream());
            while (stdin.hasNextLine()) {
                String output = stdin.nextLine();
                System.out.println("output : " + output);
                if (output != null && !output.isEmpty() && output.startsWith(KEYTOOL_ERROR) && output.contains(ALREADY_EXIST)) {
                    message_return = MESSAGE_ALREADY_EXIST;
                }
                if (output == null || output.isEmpty() || !output.startsWith(KEYTOOL_ERROR) || !output.contains(ACCESS_DENIED)) continue;
                message_return = MESSAGE_ACCESS_DENIED;
            }
            stdin.close();
            Scanner stderr = new Scanner(process.getErrorStream());
            while (stderr.hasNextLine()) {
                System.out.println(stderr.nextLine());
            }
            stderr.close();
            System.out.println("start : " + new Date());
            int exitCode = process.waitFor();
            System.out.println("end : " + new Date());
            if (exitCode == 0) {
                message_return = MESSAGE_SUCCESS;
            }
        }
        catch (Exception ex) {
            LogToFile.log("sever", ex.getMessage(), ex);
        }
        return message_return;
    }

    public static void createAutoStartTask() {
        try {
            String batch_file_path = url_directory_backup + File.separator + "schedule_task.bat";
            System.out.println("batch_file_path createAutoStartTask : " + batch_file_path);
            String param = "-silent";
            ArrayList<String> command = new ArrayList<String>();
            command.add(batch_file_path);
            command.add(param);
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.command(command);
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            System.out.println("exitCode createAutoStartTask: " + exitCode);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public static void createAutoStart() {
        System.out.println("+++++++++++++++++createAutoStart () ");
        try {
            String batch_file_path = url_directory_backup + File.separator + "autorestarter.bat";
            System.out.println("batch_file_path createAutoStartTask : " + batch_file_path);
            ArrayList<String> command = new ArrayList<String>();
            command.add(batch_file_path);
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.command(command);
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            System.out.println("exitCode createAutoStart: " + exitCode);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }
}

