/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;

public class SwingWorkerProgress {
    public static void main(String[] args) {
        SwingWorkerProgress swingWorkerProgress = new SwingWorkerProgress();
    }

    public SwingWorkerProgress() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
                    // empty catch block
                }
                JFrame frame = new JFrame("Testing");
                frame.setDefaultCloseOperation(3);
                frame.setLayout(new BorderLayout());
                frame.add(new TestPane());
                frame.pack();
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
            }
        });
    }

    public class ProgressWorker
    extends SwingWorker<Object, Object> {
        @Override
        protected Object doInBackground() throws Exception {
            int i = 0;
            int max = 2000;
            while (i < max) {
                int progress = Math.round((float)(i += 10) / (float)max * 100.0f);
                this.setProgress(progress);
                try {
                    Thread.sleep(25L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return null;
        }
    }

    public class TestPane
    extends JPanel {
        private JProgressBar pbProgress;
        private JButton start;

        public TestPane() {
            this.setBorder(new EmptyBorder(10, 10, 10, 10));
            this.pbProgress = new JProgressBar();
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.gridx = 0;
            gbc.gridy = 0;
            this.add((Component)this.pbProgress, gbc);
            this.start = new JButton("Start");
            ++gbc.gridy;
            this.add((Component)this.start, gbc);
            this.start.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TestPane.this.start.setEnabled(false);
                    ProgressWorker pw = new ProgressWorker();
                    pw.addPropertyChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            String name;
                            switch (name = evt.getPropertyName()) {
                                case "progress": {
                                    int progress = (Integer)evt.getNewValue();
                                    TestPane.this.pbProgress.setValue(progress);
                                    TestPane.this.repaint();
                                    break;
                                }
                                case "state": {
                                    SwingWorker.StateValue state = (SwingWorker.StateValue)((Object)evt.getNewValue());
                                    switch (state) {
                                        case DONE: {
                                            TestPane.this.start.setEnabled(true);
                                        }
                                    }
                                }
                            }
                        }
                    });
                    pw.execute();
                }
            });
        }
    }
}

