/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.util;

import com.openbravo.pos.util.AutoSuggestor;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.border.LineBorder;

class SuggestionLabel
extends JLabel {
    private boolean focused = false;
    private final JWindow autoSuggestionsPopUpWindow;
    private final JTextField textField;
    private final AutoSuggestor autoSuggestor;
    private Color suggestionsTextColor;
    private Color suggestionBorderColor;

    public SuggestionLabel(String string, Color borderColor, Color suggestionsTextColor, AutoSuggestor autoSuggestor) {
        super(string);
        this.suggestionsTextColor = suggestionsTextColor;
        this.autoSuggestor = autoSuggestor;
        this.textField = autoSuggestor.getTextField();
        this.suggestionBorderColor = borderColor;
        this.autoSuggestionsPopUpWindow = autoSuggestor.getAutoSuggestionPopUpWindow();
        this.initComponent();
    }

    private void initComponent() {
        this.setFocusable(true);
        this.setForeground(this.suggestionsTextColor);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                super.mouseClicked(me);
                SuggestionLabel.this.replaceWithSuggestedText();
                SuggestionLabel.this.autoSuggestionsPopUpWindow.setVisible(false);
            }
        });
        this.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0, true), "Enter released");
        this.getActionMap().put("Enter released", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SuggestionLabel.this.replaceWithSuggestedText();
                SuggestionLabel.this.autoSuggestionsPopUpWindow.setVisible(false);
            }
        });
    }

    public void setFocused(boolean focused) {
        if (focused) {
            this.setBorder(new LineBorder(this.suggestionBorderColor));
        } else {
            this.setBorder(null);
        }
        this.repaint();
        this.focused = focused;
    }

    public boolean isFocused() {
        return this.focused;
    }

    private void replaceWithSuggestedText() {
        String suggestedWord = this.getText();
        String text = this.textField.getText();
        String typedWord = this.autoSuggestor.getCurrentlyTypedWord();
        String t = text.substring(0, text.lastIndexOf(typedWord));
        String tmp = t + text.substring(text.lastIndexOf(typedWord)).replace(typedWord, suggestedWord);
        this.textField.setText(tmp + " ");
    }
}

