/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.util;

import com.ibm.icu.text.Bidi;
import com.openbravo.pos.forms.AlphaNumericGenerator;
import com.openbravo.pos.util.LogToFile;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.UUID;

public class StringUtils {
    public static final String EMPTY_STRING = "";
    private static final char[] hexchars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final NumberFormat cardformat = new DecimalFormat("000000");
    private static final Random cardrandom = new Random();

    private StringUtils() {
    }

    public static String getCardNumber() {
        return cardformat.format(Math.abs(System.currentTimeMillis()) % 1000000L) + cardformat.format(Math.abs(cardrandom.nextLong()) % 1000000L);
    }

    public static String encodeXML(String sValue) {
        if (sValue == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < sValue.length(); ++i) {
            char charToCompare = sValue.charAt(i);
            if (charToCompare == '&') {
                buffer.append("&amp;");
                continue;
            }
            if (charToCompare == '<') {
                buffer.append("&lt;");
                continue;
            }
            if (charToCompare == '>') {
                buffer.append("&gt;");
                continue;
            }
            if (charToCompare == '\"') {
                buffer.append("&quot;");
                continue;
            }
            if (charToCompare == '\'') {
                buffer.append("&apos;");
                continue;
            }
            buffer.append(charToCompare);
        }
        return buffer.toString();
    }

    public static String byte2hex(byte[] binput) {
        StringBuilder sb = new StringBuilder(binput.length * 2);
        for (byte b : binput) {
            int high = (b & 0xF0) >> 4;
            int low = b & 0xF;
            sb.append(hexchars[high]);
            sb.append(hexchars[low]);
        }
        return sb.toString();
    }

    public static byte[] hex2byte(String sinput) {
        int length = sinput.length();
        if ((length & 1) != 0) {
            throw new IllegalArgumentException("odd number of characters.");
        }
        byte[] out = new byte[length >> 1];
        int i = 0;
        int j = 0;
        while (j < length) {
            int f = Character.digit(sinput.charAt(j++), 16) << 4;
            out[i] = (byte)((f |= Character.digit(sinput.charAt(j++), 16)) & 0xFF);
            ++i;
        }
        return out;
    }

    public static String readResource(String resource) throws IOException {
        int len;
        InputStream in = StringUtils.class.getResourceAsStream(resource);
        if (in == null) {
            throw new FileNotFoundException(resource);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
        byte[] data = out.toByteArray();
        return new String(data, "UTF-8");
    }

    public static boolean isNumber(String sCardNumber) {
        if (sCardNumber == null || sCardNumber.equals(EMPTY_STRING)) {
            return false;
        }
        for (int i = 0; i < sCardNumber.length(); ++i) {
            char c = sCardNumber.charAt(i);
            if (c == '0' || c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9') continue;
            return false;
        }
        return true;
    }

    public static String formatLicence4jID(String licence_id) {
        int i;
        StringBuilder stringBuilder = new StringBuilder();
        for (i = 0; i < 4; ++i) {
            stringBuilder.append(licence_id.charAt(i));
        }
        stringBuilder.append("-");
        i = 4;
        int j = 0;
        while (i < licence_id.length()) {
            stringBuilder.append(licence_id.charAt(i));
            if ((j + 1) % 3 == 0 && j != 0 && j != licence_id.length() - 5) {
                stringBuilder.append("-");
            }
            ++i;
            ++j;
        }
        return stringBuilder.toString();
    }

    public static String rGB2Hex(String rgb) {
        String[] rgbTab = rgb.split(",");
        return String.format("#%02X%02X%02X", Integer.valueOf(rgbTab[0]), Integer.valueOf(rgbTab[1]), Integer.valueOf(rgbTab[2]));
    }

    public static String hex2Rgb(String colorStrHex) {
        Color c = new Color(Integer.valueOf(colorStrHex.substring(1, 3), 16), Integer.valueOf(colorStrHex.substring(3, 5), 16), Integer.valueOf(colorStrHex.substring(5, 7), 16));
        return c.getRed() + "," + c.getGreen() + "," + c.getBlue();
    }

    public static List<String> asLines(String input) {
        return StringUtils.splitString(input, " ");
    }

    public static String asLineWithSpaceSeparation(String input) {
        String[] tabLine = input.split(" ");
        if (tabLine.length > 1) {
            return tabLine[1];
        }
        return null;
    }

    public static List<String> asLinesWithCommaSeparation(String input) {
        return StringUtils.splitString(input, ";");
    }

    private static List<String> splitString(String input, String regex) {
        String[] tabLine;
        LinkedList<String> lines = new LinkedList<String>();
        for (String line : tabLine = input.split(regex)) {
            if (line == null || line.isEmpty()) continue;
            lines.add(line);
        }
        return lines;
    }

    public static byte[] transcodeField(byte[] source, Charset from, Charset to) {
        return new String(source, from).getBytes(to);
    }

    public static String getToken() {
        return AlphaNumericGenerator.nextSessionId();
    }

    public static boolean isEmpty(String s) {
        return s != null && EMPTY_STRING.equals(s);
    }

    public static boolean isNotEmpty(String s) {
        return s != null && !EMPTY_STRING.equals(s);
    }

    public static String uuidTimestamp() {
        return UUID.randomUUID().toString() + "-" + System.currentTimeMillis();
    }

    public static String getStoreId() {
        return AlphaNumericGenerator.nextSessionId();
    }

    public static String getShortID() {
        return UUID.randomUUID().toString().replace("-", EMPTY_STRING).substring(0, 8);
    }

    public static String textRTL(String text) {
        try {
            Bidi bidi = new Bidi(text, 1);
            text = bidi.writeReordered(2);
            return text;
        }
        catch (Exception e) {
            e.printStackTrace();
            return text;
        }
    }

    public static boolean containsArabic(String text) {
        for (char c : text.toCharArray()) {
            if (!StringUtils.isArabic(c)) continue;
            return true;
        }
        return false;
    }

    private static boolean isArabic(char c) {
        return c >= '\u0600' && c <= '\u06ff' || c >= '\u0750' && c <= '\u077f' || c >= '\u08a0' && c <= '\u08ff' || c >= '\ufb50' && c <= '\ufdff' || c >= '\ufe70' && c <= '\ufeff';
    }

    public static List<Integer> getListIntegerFromString(String text, String separator) {
        ArrayList<Integer> listInteger = new ArrayList<Integer>();
        if (text != null && !text.isEmpty()) {
            String[] numbersArray;
            for (String number : numbersArray = text.split(separator)) {
                try {
                    listInteger.add(Integer.parseInt(number));
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        }
        return listInteger;
    }

    public static String CapitalizeFirstLetter(String input) {
        if (input != null && !input.isEmpty()) {
            String output = input.substring(0, 1).toUpperCase() + input.substring(1).toLowerCase();
            return output;
        }
        return EMPTY_STRING;
    }
}

