/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.util;

import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.StartPOS;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.Base64Encoder;
import com.openbravo.pos.util.LogToFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SignatureGenerator {
    private String privateKey = null;
    private static String key = "MOMTAZPA42OURKEY";
    private static String initVector = "AURESISOURVECTOR";
    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String MESSAGE_ALREADY_EXIST = "le certificat existe d\u00e9j\u00e0 ";
    private static final String MESSAGE_ACCESS_DENIED = "ACC\u00e9s REFUS\u00e9";
    public static final String MESSAGE_SUCCESS = "Certificat import\u00e9 avec succ\u00e9s.";
    private static final String KEYTOOL_ERROR = "keytool error";
    private static final String ALREADY_EXIST = "already exists";
    private static final String ACCESS_DENIED = "access denied";
    private static SignatureGenerator INSTANCE = null;
    private String myVar = "MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQC5RO0YhDDQki4sjL";

    private SignatureGenerator(String privateKey) {
        this.privateKey = privateKey;
    }

    private SignatureGenerator() throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append(this.myVar);
        builder.append(AppLocal.pathon);
        builder.append(StartPOS.pathto);
        this.privateKey = builder.toString();
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public static SignatureGenerator getGenerator() throws IOException {
        if (INSTANCE == null) {
            INSTANCE = new SignatureGenerator();
        }
        return INSTANCE;
    }

    public String encrypt(String plain) throws FileNotFoundException, IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchProviderException {
        new Base64Encoder();
        PrivateKey privateKeyObject = KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(Base64Encoder.decode(this.privateKey)));
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, privateKeyObject);
        String encryptedText = Base64.getUrlEncoder().encodeToString(cipher.doFinal(this.getHashCodeFromString(plain).getBytes("UTF-8")));
        return encryptedText;
    }

    public String digitalSign(String plain) throws FileNotFoundException, IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchProviderException {
        return this.encrypt(plain);
    }

    public String decryptToTest(String encryptedText) throws FileNotFoundException, IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        new Base64Encoder();
        PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(Base64Encoder.decode(AppVarUtils.pubkey)));
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, publicKey);
        String claire = new String(cipher.doFinal(Base64.getUrlDecoder().decode(encryptedText.getBytes())));
        return claire;
    }

    public String getHashCodeFromString(String str) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-512");
        md.update(str.getBytes());
        byte[] byteData = md.digest();
        StringBuilder hashCodeBuffer = new StringBuilder();
        for (int i = 0; i < byteData.length; ++i) {
            hashCodeBuffer.append(Integer.toString((byteData[i] & 0xFF) + 256, 16).substring(1));
        }
        return hashCodeBuffer.toString();
    }

    public String encryptWithoutHashing(String plain) throws FileNotFoundException, IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        new Base64Encoder();
        PrivateKey privateKeyObject = KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(Base64Encoder.decode(this.privateKey)));
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, privateKeyObject);
        String encryptedText = Base64.getUrlEncoder().encodeToString(cipher.doFinal(plain.getBytes()));
        return encryptedText;
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public void encryptFile(String inFile, String encFile) throws FileNotFoundException, IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        new Base64Encoder();
        PrivateKey privateKeyObject = KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(Base64Encoder.decode(this.privateKey)));
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, privateKeyObject);
        SignatureGenerator.processFile(cipher, inFile, encFile);
    }

    private static void processFile(Cipher ciph, String file1, String file2) throws IllegalBlockSizeException, BadPaddingException, IOException {
        byte[] encodedContent;
        File file = new File(file1);
        System.out.println("++++++++ FileUtils.readFileToString(file).length() : " + FileUtils.readFileToString((File)file).length());
        byte[] bytesToBeEncoded = new byte[FileUtils.readFileToString((File)file).length()];
        FileInputStream in = new FileInputStream(new File(file1));
        FileOutputStream out = new FileOutputStream(new File(file2));
        int readBytes = in.read(bytesToBeEncoded, 0, bytesToBeEncoded.length);
        System.out.println("+++++++ readBytes : " + readBytes);
        while (readBytes != -1) {
            encodedContent = ciph.update(bytesToBeEncoded, 0, readBytes);
            out.write(encodedContent);
            bytesToBeEncoded = new byte[FileUtils.readFileToString((File)file).length()];
            readBytes = in.read(bytesToBeEncoded, 0, bytesToBeEncoded.length);
        }
        encodedContent = ciph.doFinal();
        out.write(encodedContent);
    }

    public static String encryptFileWithAES(File fsource, File fdest) throws IOException {
        try {
            String value = FileUtils.readFileToString((File)fsource);
            IvParameterSpec iv = new IvParameterSpec(initVector.getBytes("UTF-8"));
            SecretKeySpec skeySpec = new SecretKeySpec(key.getBytes("UTF-8"), "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
            cipher.init(1, (Key)skeySpec, iv);
            byte[] encrypted = cipher.doFinal(value.getBytes());
            String encr = org.apache.commons.codec.binary.Base64.encodeBase64String((byte[])encrypted);
            FileUtils.writeStringToFile((File)fdest, (String)encr);
            return encr;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String decryptAES(File encFile, File fdest) {
        try {
            String encrypted = FileUtils.readFileToString((File)encFile);
            IvParameterSpec iv = new IvParameterSpec(initVector.getBytes("UTF-8"));
            SecretKeySpec skeySpec = new SecretKeySpec(key.getBytes("UTF-8"), "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
            cipher.init(2, (Key)skeySpec, iv);
            String original = new String(cipher.doFinal(org.apache.commons.codec.binary.Base64.decodeBase64((String)encrypted)));
            FileUtils.writeStringToFile((File)fdest, (String)original);
            return original;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void verifySignature(String encryptedText, String text) throws FileNotFoundException, IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        String dercryptedText = this.decryptToTest(encryptedText);
        String hashText = this.getHashCodeFromString(text);
        System.out.println("++++++++++++ dercryptedText : " + dercryptedText);
        System.out.println("++++++++++++ hashText : " + hashText);
    }

    public String sign(File file_all_data) {
        try {
            new Base64Encoder();
            PrivateKey privateKeyObject = KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(Base64Encoder.decode(this.privateKey)));
            Signature signature = Signature.getInstance("SHA256withRSA/PSS", "BC");
            signature.initSign(privateKeyObject);
            byte[] databytes = Files.readAllBytes(Paths.get(file_all_data.getAbsolutePath(), new String[0]));
            signature.update(databytes);
            byte[] digitalSignature = signature.sign();
            String signature_value = new String(org.apache.commons.codec.binary.Base64.encodeBase64((byte[])digitalSignature));
            return signature_value;
        }
        catch (Exception ex) {
            Logger.getLogger(SignatureGenerator.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public void verify(File file, String encr) {
        try {
            new Base64Encoder();
            PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(Base64Encoder.decode(AppVarUtils.pubkey)));
            Signature signature = Signature.getInstance("SHA512withRSA");
            signature.initVerify(publicKey);
            byte[] bytes = Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0]));
            signature.update(bytes);
            byte[] digitalSignature = org.apache.commons.codec.binary.Base64.decodeBase64((byte[])encr.getBytes());
            boolean verified = signature.verify(digitalSignature);
            if (verified) {
                System.out.println("Data verified.");
            } else {
                System.out.println("Cannot verify data.");
            }
        }
        catch (Exception ex) {
            Logger.getLogger(SignatureGenerator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean verifySignature(String data, String signature, Date dateSignature) throws Exception {
        String result = data.replace(' ', '_');
        String dataToverify = new String(result.getBytes("UTF-8"));
        System.out.println("encrypt ********************");
        String newSignature = this.encrypt(dataToverify);
        System.out.println("signature : " + signature);
        System.out.println("signature new : " + newSignature);
        return newSignature.equals(signature);
    }

    public Date getDateAddPaddingPSS() {
        try {
            Date date_add_padding_pss = this.formatter.parse(AppLocal.DATE_ADD_RSA_PAADING);
            return date_add_padding_pss;
        }
        catch (ParseException ex) {
            LogToFile.log("severe", null, ex);
            return null;
        }
    }

    public boolean verifyDigitalSignature(String data, String signature) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException, InvalidKeyException, SignatureException {
        new Base64Encoder();
        PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(Base64Encoder.decode(AppVarUtils.pubkey)));
        byte[] signatureBytes = Base64.getUrlDecoder().decode(signature);
        Signature verifier = Signature.getInstance("SHA256withRSA/PSS", "BC");
        verifier.initVerify(publicKey);
        verifier.update(data.getBytes(StandardCharsets.UTF_8));
        boolean verify = verifier.verify(signatureBytes);
        return verify;
    }
}

