/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.util;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPRow;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.draw.LineSeparator;
import com.openbravo.AppConstants;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.payment.PaymentInfo;
import com.openbravo.pos.printer.Decreaser;
import com.openbravo.pos.printer.PrinterHelper;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.ProductTicket;
import com.openbravo.pos.ticket.TaxLineInfo;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.EmailSender;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.NumericUtils;
import com.openbravo.pos.util.StringUtils;
import fr.protactile.norm.beans.Duplicata;
import fr.protactile.norm.beans.EnteteInfo;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SendETicketHelper {
    public final SimpleDateFormat timeFormatter = DateUtils.timeFormatter;
    private int nombreLignesInCammande;
    private List<String> platFormSourcesOrder;
    private List<String> platFormTypesOrder;
    private final String INSIDE = "inside";
    private final String OUTSIDE = "outside";
    private final String SOURCE_BORNE = "borne";
    private float height_reference;

    public SendETicketHelper() {
        this.initPlatFromInfosOrder();
    }

    public void sendETicket(int orderId, TicketInfo order, EnteteInfo entete, boolean has_drawer_permission, BufferedImage qrCodeImage, Decreaser decreaser, String holder_ticket, String email_customer, Duplicata duplicata) {
        String filePath = this.generateTicketPdf(orderId, order, entete, has_drawer_permission, qrCodeImage, decreaser, holder_ticket, duplicata);
        EmailSender.sendEmail(email_customer, "Votre Ticket", "Voici votre ticket \u00e9lectronique.", filePath, decreaser);
        File pdf = new File(filePath);
        pdf.delete();
    }

    private void addParagraph(Document document, String text, int alignment) {
        this.addParagraph(document, text, alignment, 10, 0);
    }

    private void addParagraph(Document document, String text, int alignment, int size) {
        this.addParagraph(document, text, alignment, size, 0);
    }

    private void addParagraph(Document document, PdfWriter writer, String textLeft, String textRight) {
        this.addParagraph(document, writer, textLeft, textRight, 10, 0);
    }

    private void addParagraph(Document document, PdfWriter writer, String textLeft, String textRight, int size, int fontText) {
        this.addParagraph(document, writer, textLeft, textRight, size, fontText, false, false);
    }

    private void addParagraph(Document document, PdfWriter writer, String textLeft, String textRight, int size, int fontText, boolean setHeightReference, boolean setNumberLinesOrder) {
        size = 8;
        try {
            BaseFont baseFont = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)true);
            Font font = new Font(baseFont, (float)size, fontText);
            PdfPTable table = new PdfPTable(2);
            table.setWidthPercentage(100.0f);
            table.setTotalWidth(194.0f);
            table.setLockedWidth(true);
            table.setWidths(new int[]{50, 50});
            Paragraph rightParagraph = new Paragraph(textLeft, font);
            PdfPCell leftCell = new PdfPCell((Phrase)rightParagraph);
            leftCell.setBorder(0);
            leftCell.setHorizontalAlignment(0);
            PdfPCell rightCell = new PdfPCell((Phrase)new Paragraph(textRight, font));
            rightCell.setBorder(0);
            rightCell.setHorizontalAlignment(2);
            table.addCell(leftCell);
            table.addCell(rightCell);
            document.add((Element)table);
            float maxHeight = 0.0f;
            for (PdfPRow curRow : table.getRows()) {
                for (PdfPCell curCell : curRow.getCells()) {
                    maxHeight = curCell.getHeight() > maxHeight ? curCell.getHeight() : maxHeight;
                }
            }
            if (setHeightReference) {
                this.height_reference = maxHeight;
            }
            if (setNumberLinesOrder) {
                int numberLinesOrder = (int)((maxHeight - this.height_reference) / (float)size);
                this.nombreLignesInCammande += numberLinesOrder;
            }
        }
        catch (Exception ex) {
            Logger.getLogger(SendETicketHelper.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void addParagraph(Document document, String text, int alignment, int size, int fontText) {
        size = 8;
        try {
            BaseFont baseFont = BaseFont.createFont((String)"Times-Roman", (String)"Cp1252", (boolean)true);
            Font font = new Font(baseFont, (float)size, fontText);
            Paragraph paragraph = new Paragraph(text, font);
            paragraph.setAlignment(alignment);
            document.add((Element)paragraph);
        }
        catch (Exception ex) {
            Logger.getLogger(SendETicketHelper.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void blankLine(Document document) {
        this.addParagraph(document, "\n", 0);
    }

    public String generateTicketPdf(int orderId, TicketInfo order, EnteteInfo entete, boolean has_drawer_permission, BufferedImage qrCodeImage, Decreaser decreaser, String holder_ticket, Duplicata duplicata) {
        PdfWriter writer = null;
        try {
            String signature;
            Date dateOrigin;
            Date dateOrder;
            long impressionNumber = duplicata != null ? duplicata.getImpression_Number() : 0L;
            String tempDir = System.getProperty("java.io.tmpdir");
            String pdfPath = tempDir + "eticket_" + UUID.randomUUID() + ".pdf";
            Document document = new Document(PageSize.A7, 8.0f, 8.0f, 8.0f, 8.0f);
            writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(pdfPath));
            document.open();
            this.nombreLignesInCammande = 0;
            this.blankLine(document);
            this.appendHeader(document, entete);
            if (order.getDelivered() != null && order.getDelivered().after(order.getDate())) {
                this.addParagraph(document, "Pr\u00e9vue : " + this.timeFormatter.format(order.getDelivered()), 1, 10, 1);
                this.blankLine(document);
            }
            this.addNumOrder(document, order);
            this.blankLine(document);
            if (this.isValidPrintInfosCustomer(order)) {
                this.appendInfoCustomer(order, document);
                this.blankLine(document);
            }
            String orderNum = String.valueOf(entete.getId());
            System.out.println("++++++++++++ order.getCaisse() : " + order.getCaisse());
            String postFix = " " + AppLocal.getIntString("Label.caisse") + " " + entete.getCode_caisse();
            if (impressionNumber > 0L && order.isPaid() && order.getTotal() >= 0.0) {
                this.addParagraph(document, AppLocal.getIntString("Text.duplicata") + " " + AppLocal.getIntString("Text.num.ticket") + orderNum + postFix, 1);
            } else if (order.isPaid() && order.getTotal() >= 0.0) {
                this.addParagraph(document, AppLocal.getIntString("Text.num.ticket") + orderNum + postFix, 1);
            } else if (order.getTotal() > 0.0) {
                this.addParagraph(document, AppLocal.getIntString("Label.num.order") + orderNum + postFix, 1);
            } else if (order.getTotal() < 0.0) {
                if (impressionNumber > 0L) {
                    this.addParagraph(document, AppLocal.getIntString("Text.duplicata") + " " + AppLocal.getIntString("Text.num.ticket") + orderNum + postFix, 1);
                } else {
                    this.addParagraph(document, AppLocal.getIntString("Text.num.ticket") + orderNum + postFix, 1);
                }
                this.addParagraph(document, AppLocal.getIntString("Text.cancel.ticket") + order.getOrigineCanceledTicket() + postFix, 1);
            }
            Date date = duplicata != null ? duplicata.getDate_impression() : (entete != null ? entete.getTimestampGDH() : (dateOrder = order.isPaid() ? order.getDatePaid() : order.getDate()));
            Date date2 = duplicata != null ? (order.isPaid() ? order.getDatePaid() : order.getDate()) : (dateOrigin = null);
            if (AppLocal.isVersionRetailSale().booleanValue()) {
                this.addParagraph(document, PrinterHelper.dateFormatterFull.format(dateOrder), 1);
            } else {
                this.addParagraph(document, PrinterHelper.dateFormatterFull.format(dateOrder) + " - " + AppConstants.getTypeOrder(order.getType()).toUpperCase(), 1, 10, 1);
            }
            if (dateOrigin != null) {
                this.addParagraph(document, "Date commande " + PrinterHelper.dateFormatterFull.format(dateOrigin), 1);
            }
            if (order.getNumTable() != 0) {
                String str = AppLocal.getIntString("Label.num.table") + " " + order.getNumTable();
                this.addParagraph(document, str, 1);
            }
            String sId = order.getUser().getCounter() > 0 ? "(" + order.getUser().getCounter() + ")" : "";
            this.addParagraph(document, AppLocal.getIntString("Text.seller") + " : " + order.getUser().getName() + sId, 1);
            if (order != null && order.getNumero_platform_order() != null && !order.getNumero_platform_order().isEmpty() && (order.getSent_from() != null && this.platFormSourcesOrder.contains(order.getSent_from()) || order.getType() != null && this.platFormTypesOrder.contains(order.getType()))) {
                this.addParagraph(document, "Commande N\u00b0 interne : " + order.getNumberOrderToPrint(), 1);
            }
            if (order.getBipper() != 0) {
                this.addParagraph(document, AppLocal.getIntString("Label.bipper") + "\u00b0 " + order.getBipper(), 1, 14);
            }
            if (order.getEasel_number() != 0) {
                this.addParagraph(document, "N\u00b0 chevalet " + order.getEasel_number(), 1, 14);
            }
            this.blankLine(document);
            this.addLineOfDashes(document, writer);
            this.addParagraph(document, writer, "QTE " + AppLocal.getIntString("Text.designation"), AppLocal.getIntString("Text.price") + "  TOTAL " + AppLocal.getIntString("Text.tva"), 10, 0, true, false);
            this.addLineOfDashes(document, writer);
            this.sortLinesOrder(order);
            for (TicketLineInfo line : order.getLines()) {
                if (line.isNext()) continue;
                this.appendProduct(line, document, writer);
            }
            this.blankLine(document);
            this.addParagraph(document, AppLocal.getIntString("Text.nb.articles") + " : " + order.getNbrArticles(), 0, 10);
            this.addParagraph(document, writer, AppLocal.getIntString("Text.tva") + "        Mt.TVA", "Base HT  Base TTC");
            double mtTva = 0.0;
            double baseHT = 0.0;
            double baseTTC = 0.0;
            for (TaxLineInfo taxe : order.getTaxes()) {
                Object name = taxe.getName();
                if (((String)name).length() == 3) {
                    name = (String)name + " ";
                }
                int nmbSpce = 11 - taxe.printSumTTC().length();
                StringBuilder stringBuilder = new StringBuilder("");
                stringBuilder.append(taxe.printSumHT());
                for (int i = 0; i < nmbSpce; ++i) {
                    stringBuilder.append(" ");
                }
                this.addParagraph(document, writer, Integer.valueOf(taxe.getId()) + " \u00e0 " + (String)name + "   " + taxe.printAmount(), stringBuilder.toString() + taxe.printSumTTC());
                mtTva += NumericUtils.round(taxe.getAmount());
                baseHT += NumericUtils.round(taxe.getSumHT());
                baseTTC += NumericUtils.round(taxe.getSumTTC());
            }
            int nmbSpce = 11 - TaxLineInfo.printThisDoubleAsAmount(baseTTC).length();
            StringBuilder stringTotal = new StringBuilder("");
            stringTotal.append(TaxLineInfo.printThisDoubleAsAmount(baseHT));
            for (int i = 0; i < nmbSpce; ++i) {
                stringTotal.append(" ");
            }
            this.addParagraph(document, writer, "Total        " + TaxLineInfo.printThisDoubleAsAmount(mtTva), stringTotal + TaxLineInfo.printThisDoubleAsAmount(baseTTC));
            this.addLineOfDashes(document, writer);
            this.addParagraph(document, writer, "Total T.T.C. ", TaxLineInfo.printThisDoubleAsAmount(baseTTC), 14, 1);
            this.addLineOfDashes(document, writer);
            if (order.getDiscount() > 0.0) {
                if (order.getTypeDiscount().contains("ourcen")) {
                    this.addParagraph(document, writer, AppLocal.getIntString("Button.discount") + " ", TaxLineInfo.printThisDoubleAsAmount(-Math.abs(order.getDiscount() * order.getRealTotal() / 100.0)));
                } else {
                    this.addParagraph(document, writer, AppLocal.getIntString("Button.discount") + " ", TaxLineInfo.printThisDoubleAsAmount(-Math.abs(order.getDiscount())));
                }
            }
            double discount_global = order.getGlobalDiscount();
            System.out.println("discount_global ************************** " + discount_global);
            if (discount_global > 0.0) {
                this.addParagraph(document, writer, "Total remise articles", Formats.CURRENCY.formatValue(-Math.abs(discount_global)));
            }
            Collections.sort(order.getPayments(), new Comparator<PaymentInfo>(){

                @Override
                public int compare(PaymentInfo s1, PaymentInfo s2) {
                    return s1.getName().compareToIgnoreCase(s2.getName());
                }
            });
            boolean isFirst = true;
            double renduMonnaie = 0.0;
            for (PaymentInfo payment : order.getPayments()) {
                if (isFirst) {
                    this.addParagraph(document, AppLocal.getIntString("Text.mode.payment"), 1);
                    isFirst = false;
                }
                this.addParagraph(document, writer, this.getOfficialPayement(payment.getName()), payment.printTotal());
                renduMonnaie += payment.getPaid() - payment.getTotal();
            }
            if (AppLocal.ISRENDMONNAIE.booleanValue() && renduMonnaie > 0.0) {
                this.blankLine(document);
                this.addParagraph(document, AppLocal.getIntString("Text.currency.return") + ": " + Formats.CURRENCY_PRINTED.formatValue(renduMonnaie), 1);
                for (PaymentInfo payment : order.getPayments()) {
                    if (!(renduMonnaie > 0.0) || !(payment.getPaid() - payment.getTotal() > 0.0)) continue;
                    this.addParagraph(document, writer, "Rendu " + this.getOfficialPayement(payment.getName()), Formats.CURRENCY_PRINTED.formatValue(payment.getPaid() - payment.getTotal()));
                }
            }
            this.blankLine(document);
            if (order.getComment() != null && !order.getComment().isEmpty()) {
                this.addNote(document, "Commentaire : " + order.getComment());
                this.blankLine(document);
            }
            String string = signature = duplicata != null ? duplicata.getSignature() : entete.getSignature();
            if (signature != null && !signature.isEmpty()) {
                this.setIdentificationLogiciel(document, signature, entete.getVersionSoft(), entete.getName_soft());
            }
            this.addParagraph(document, AppLocal.getIntString("Text.type.operation") + " : " + entete.getTypeOperation(), 1, 10, 1);
            if (entete.IsTicketRestituted()) {
                this.addParagraph(document, "re-Restitution " + impressionNumber + " - " + this.nombreLignesInCammande + " " + AppLocal.getIntString("Text.line") + "(s)", 1, 10, 1);
            } else if (order.isPaid()) {
                this.addParagraph(document, "Restitution 1 - " + this.nombreLignesInCammande + " " + AppLocal.getIntString("Text.line") + "(s)", 1, 10, 1);
            } else {
                this.addParagraph(document, this.nombreLignesInCammande + " " + AppLocal.getIntString("Text.line") + "(s)", 1, 10, 1);
            }
            if (entete.getTypeOperation().equalsIgnoreCase(AppLocal.getIntString("Text.order"))) {
                this.addParagraph(document, "C" + entete.getId(), 1, 10, 1);
            } else {
                this.addParagraph(document, "T" + entete.getId(), 1, 10, 1);
            }
            if (entete.getFootr() != null) {
                this.blankLine(document);
                this.addParagraph(document, entete.getFootr(), 1);
                this.blankLine(document);
            }
            System.out.println("++++++ holder_ticket test : " + holder_ticket);
            if (holder_ticket != null && !holder_ticket.isEmpty()) {
                this.blankLine(document);
                this.addParagraph(document, holder_ticket, 0);
            }
            this.addParagraph(document, "E-ticket", 1);
            document.close();
            return pdfPath;
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
            return null;
        }
    }

    private void appendHeader(Document document, EnteteInfo entete) {
        if (entete != null) {
            if (entete.getCompany() != null && !entete.getCompany().isEmpty()) {
                this.addParagraph(document, entete.getCompany(), 1, 10);
            }
            if (entete.getAddress() != null && !entete.getAddress().isEmpty()) {
                this.addParagraph(document, entete.getAddress(), 1, 10);
            }
            if (entete.getZipCode() != null && !entete.getZipCode().isEmpty() && entete.getCity() != null && !entete.getCity().isEmpty()) {
                this.addParagraph(document, entete.getZipCode() + " " + entete.getCity(), 1, 10);
            }
            if (entete.getCountry() != null && !entete.getCountry().isEmpty()) {
                this.addParagraph(document, AppLocal.getIntString("Label.country") + " : " + entete.getCountry(), 1, 10);
            }
            if (!AppLocal.IS_MOROCCAN_CUSTOMER.booleanValue()) {
                if (entete.getCodeNAF() != null && !entete.getCodeNAF().isEmpty()) {
                    this.addParagraph(document, "Code NAF : " + entete.getCodeNAF(), 1, 10);
                }
                if (entete.getSiret() != null && !entete.getSiret().isEmpty()) {
                    this.addParagraph(document, "Siret : " + entete.getSiret(), 1, 10);
                }
                if (entete.getTvaIntra() != null && !entete.getTvaIntra().isEmpty()) {
                    this.addParagraph(document, "TVA intra : " + entete.getTvaIntra(), 1, 10);
                }
            }
        }
        if (AppLocal.phoneRestaurant != null && !AppLocal.phoneRestaurant.isEmpty() && !AppLocal.phoneRestaurant.equals("")) {
            this.addParagraph(document, AppLocal.getIntString("Label.phone") + ": " + AppLocal.phoneRestaurant, 1, 10);
        }
        if (entete.getHeader() != null && !entete.getHeader().isEmpty()) {
            this.blankLine(document);
            this.addParagraph(document, entete.getHeader(), 1, 10);
            this.blankLine(document);
        }
    }

    private void addNumOrder(Document document, TicketInfo order) {
        int size = 16;
        Object str_number_order = "";
        if (order != null && order.getNumero_platform_order() != null && !order.getNumero_platform_order().isEmpty() && (order.getSent_from() != null && this.platFormSourcesOrder.contains(order.getSent_from()) || order.getType() != null && this.platFormTypesOrder.contains(order.getType()))) {
            str_number_order = order.getSent_from() != null && this.platFormSourcesOrder.contains(order.getSent_from()) ? order.getSent_from() : order.getType();
            str_number_order = (String)str_number_order + " N\u00b0" + order.getNumero_platform_order();
        } else {
            Object prefix = "";
            if (order.getNum_order_kitchen() != -1 && order.getNum_order_kitchen() != 0 || !AppLocal.KITCHEN_COMPOSITE) {
                if (!AppLocal.BLACK_BACKGROUND_NUM_ORDER) {
                    prefix = "Commande N\u00b0";
                } else {
                    size = 18;
                }
            } else {
                if (AppLocal.BLACK_BACKGROUND_NUM_ORDER) {
                    prefix = (String)prefix + " ";
                }
                prefix = (String)prefix + "PB connexion N\u00b0";
            }
            if (AppLocal.modeCaisse != null && AppLocal.modeCaisse.equals("Borne") || order.getSent_from() != null && order.getSent_from().equalsIgnoreCase("borne")) {
                prefix = (String)prefix + " B ";
            }
            if (AppLocal.modeCaisse != null && AppLocal.modeCaisse.equals("Caisse") && (order.getOrdered_from() != null && order.getOrdered_from().equalsIgnoreCase("inside") || order.getSent_from() != null && order.getSent_from().equalsIgnoreCase("caisse"))) {
                prefix = (String)prefix + " C ";
            }
            str_number_order = (String)prefix + order.getNumberOrderToPrint();
        }
        this.addParagraph(document, (String)str_number_order, 1, size);
    }

    private boolean isValidPrintInfosCustomer(TicketInfo order) {
        return order.getOrdered_from() != null && order.getOrdered_from().equalsIgnoreCase("outside") && (order.getSent_from() == null || !order.getSent_from().equalsIgnoreCase("borne")) || order.getType() != null && !order.getType().equalsIgnoreCase("Sur Place") && (!order.getType().equalsIgnoreCase("A Emporter") || order.isTake_away_phone());
    }

    private void initPlatFromInfosOrder() {
        this.platFormTypesOrder = new ArrayList<String>();
        this.platFormTypesOrder.add("Delivero");
        this.platFormTypesOrder.add("Uber Eats");
        this.platFormTypesOrder.add("Just Eat");
        this.platFormTypesOrder.add("Smood");
        this.platFormTypesOrder.add("Deliveroo");
        this.platFormSourcesOrder = new ArrayList<String>();
        this.platFormSourcesOrder.add("Delivero");
        this.platFormSourcesOrder.add("Uber Eats");
        this.platFormSourcesOrder.add("Just Eat");
        this.platFormSourcesOrder.add("Smood");
        this.platFormSourcesOrder.add("Deliveroo");
        this.platFormSourcesOrder.add("Dishop");
    }

    private String textAfterCheckLanguage(String text) {
        if (AppLocal.PRINT_ARABIC && AppLocal.PRINT_RTL && StringUtils.containsArabic(text)) {
            return StringUtils.textRTL(text);
        }
        return text;
    }

    private void appendInfoCustomer(TicketInfo order, Document document) {
        if (order.getCustomer() != null && order.getCustomer().getName() != null && !order.getCustomer().getName().isEmpty()) {
            this.addParagraph(document, this.textAfterCheckLanguage(AppLocal.getIntString("Label.client") + " : " + order.getCustomer().getName()), 1, 16);
        }
        if (order.getCustomer() != null && order.getCustomer().getPhone() != null && !order.getCustomer().getPhone().isEmpty()) {
            this.addParagraph(document, this.textAfterCheckLanguage(AppLocal.getIntString("Label.phone") + " : " + order.getCustomer().printPhone()), 1, 16);
        }
        if (order.getAddressInfo() != null && order.getAddressInfo().getBatiment() != null && !order.getAddressInfo().getBatiment().isEmpty() && order.getAddressInfo().getInterphone() != null && !order.getAddressInfo().getInterphone().isEmpty()) {
            this.addParagraph(document, AppLocal.getIntString("Text.batiment") + " :" + order.getAddressInfo().getBatiment() + ", " + AppLocal.getIntString("Text.interphone") + " : " + order.getAddressInfo().getInterphone(), 1, 16);
        } else {
            if (order.getAddressInfo() != null && order.getAddressInfo().getBatiment() != null && !order.getAddressInfo().getBatiment().isEmpty()) {
                this.addParagraph(document, AppLocal.getIntString("Text.batiment") + " :" + order.getAddressInfo().getBatiment(), 1, 16);
            }
            if (order.getAddressInfo() != null && order.getAddressInfo().getInterphone() != null && !order.getAddressInfo().getInterphone().isEmpty()) {
                this.addParagraph(document, AppLocal.getIntString("Text.interphone") + " : " + order.getAddressInfo().getInterphone(), 1, 16);
            }
        }
        if (order.getAddressInfo() != null && order.getAddressInfo().getEntrycode() != null && !order.getAddressInfo().getEntrycode().isEmpty() && order.getAddressInfo().getEscalier() != null && !order.getAddressInfo().getEscalier().isEmpty()) {
            this.addParagraph(document, AppLocal.getIntString("Text.codeEntree") + " : " + order.getAddressInfo().getEntrycode() + ", " + AppLocal.getIntString("Text.escalier") + " :" + order.getAddressInfo().getEscalier(), 1, 16);
        } else {
            if (order.getAddressInfo() != null && order.getAddressInfo().getEscalier() != null && !order.getAddressInfo().getEscalier().isEmpty()) {
                this.addParagraph(document, AppLocal.getIntString("Text.escalier") + " : " + order.getAddressInfo().getEscalier(), 1, 16);
            }
            if (order.getAddressInfo() != null && order.getAddressInfo().getEntrycode() != null && !order.getAddressInfo().getEntrycode().isEmpty()) {
                this.addParagraph(document, AppLocal.getIntString("Text.codeEntree") + " : " + order.getAddressInfo().getEntrycode(), 1, 16);
            }
        }
        if (order.getAddressInfo() != null && order.getAddressInfo().getEtage() != null && !order.getAddressInfo().getEtage().isEmpty() && order.getAddressInfo().getAppartement() != null && !order.getAddressInfo().getAppartement().isEmpty()) {
            this.addParagraph(document, AppLocal.getIntString("Text.etage") + " :" + order.getAddressInfo().getEtage() + ", " + AppLocal.getIntString("Text.appartement") + " :" + order.getAddressInfo().getAppartement(), 1, 16);
        } else {
            if (order.getAddressInfo() != null && order.getAddressInfo().getEtage() != null && !order.getAddressInfo().getEtage().isEmpty()) {
                this.addParagraph(document, AppLocal.getIntString("Text.etage") + " :" + order.getAddressInfo().getEtage(), 1, 16);
            }
            if (order.getAddressInfo() != null && order.getAddressInfo().getAppartement() != null && !order.getAddressInfo().getAppartement().isEmpty()) {
                this.addParagraph(document, AppLocal.getIntString("Text.appartement") + " :" + order.getAddressInfo().getAppartement(), 1, 16);
            }
        }
        if (order.getAddressInfo() != null && order.getAddressInfo().getAddress() != null && !order.getAddressInfo().getAddress().isEmpty()) {
            this.addParagraph(document, order.getAddressInfo().getAddress(), 1, 16);
        }
        if (order.getAddressInfo() != null && order.getAddressInfo().getCity() != null && !order.getAddressInfo().getCity().isEmpty() && order.getAddressInfo().getZipcode() != null && !order.getAddressInfo().getZipcode().isEmpty()) {
            this.addParagraph(document, order.getAddressInfo().getZipcode() + " " + order.getAddressInfo().getCity(), 1, 16);
        }
        if (order.getAddressInfo() != null && order.getAddressInfo().getRemarque() != null && !order.getAddressInfo().getRemarque().isEmpty()) {
            this.addParagraph(document, order.getAddressInfo().getRemarque(), 1, 16);
        }
        if (order.getLivreur() != null && order.getLivreur().getName() != null && !order.getLivreur().getName().isEmpty()) {
            this.addParagraph(document, AppLocal.getIntString("Text.name.delivery") + " : " + order.getLivreur().getName(), 0, 16);
        }
        if (order.getCustomer() == null && order.getName_customer() != null && !order.getName_customer().isEmpty()) {
            this.addParagraph(document, AppLocal.getIntString("Label.client") + " : " + order.getName_customer(), 0, 16);
        }
    }

    private void addLineOfDashes(Document document, PdfWriter writer) throws DocumentException {
        LineSeparator dashedLine = new LineSeparator();
        dashedLine.setLineWidth(1.0f);
        dashedLine.setLineColor(BaseColor.BLACK);
        document.add((Element)dashedLine);
    }

    private void sortLinesOrder(TicketInfo order) {
        if (order.getLinesCount() > 1) {
            ArrayList<TicketLineInfo> lines = new ArrayList<TicketLineInfo>();
            ArrayList<TicketLineInfo> lines_fees = new ArrayList<TicketLineInfo>();
            for (TicketLineInfo line : order.getLines()) {
                if (line.getProductName() == null || !line.getProductName().equalsIgnoreCase("Frais de livraison") && !line.getProductName().equalsIgnoreCase("Frais de gestion")) {
                    lines.add(line);
                    continue;
                }
                lines_fees.add(line);
            }
            order.setLines(lines);
            order.getLines().addAll(lines_fees);
        }
    }

    private void addNote(Document document, String note) {
        System.out.println("++++++++++ note : " + note);
        this.addParagraph(document, note, 0, 14);
    }

    public String getOfficialPayement(String payment) {
        switch (payment.toUpperCase()) {
            case "CB": {
                return AppLocal.getIntString("Text.bluecard").toUpperCase();
            }
            case "TICKET RESTO": {
                return AppConstants.PAYMENT_MODE.TICKET_RESTO.getName().toUpperCase();
            }
            case "ESPECE": {
                return AppLocal.getIntString("Button.cash").toUpperCase();
            }
            case "AVOIR": {
                return AppLocal.getIntString("Label.free").toUpperCase();
            }
            case "CHEQUE": {
                return AppLocal.getIntString("Label.cheque").toUpperCase();
            }
            case "DEBIT": {
                return AppLocal.getIntString("Label.debit").toUpperCase();
            }
        }
        return payment;
    }

    private void setIdentificationLogiciel(Document document, String signature, String versionSoftware, String nameSoftware) {
        this.addParagraph(document, "(NF525) B 0413 " + signature.charAt(2) + signature.charAt(6) + signature.charAt(10) + signature.charAt(16) + " " + nameSoftware + "  " + versionSoftware, 1, 10, 1);
    }

    private void appendProduct(TicketLineInfo line, Document document, PdfWriter writer) {
        String unit = line.printMultiply();
        StringBuilder name = new StringBuilder();
        if (line.getSizeProduct() != null && AppLocal.LABEL_SIZE_FIRST) {
            name.append(line.getSizeProduct()).append(" - ");
        }
        name.append(line.printName());
        if (line.getSizeProduct() != null && !AppLocal.LABEL_SIZE_FIRST) {
            name.append(" - ").append(line.getSizeProduct());
        }
        String itemName = this.formatMax(org.apache.commons.lang.StringUtils.rightPad((String)unit, (int)4) + name.toString());
        ++this.nombreLignesInCammande;
        String tax_line = line.getTaxInfo() != null && line.getTaxInfo().getId() != null ? org.apache.commons.lang.StringUtils.leftPad((String)("" + Integer.valueOf(line.getTaxInfo().getId())), (int)4) : "";
        int taxe_id = line.getTaxInfo() != null && line.getTaxInfo().getId() != null ? Integer.valueOf(line.getTaxInfo().getId()) : 0;
        String price_item = Formats.CURRENCY_PRINTED.formatValue(line.getPriceProductMinusPriceIncluded()) + org.apache.commons.lang.StringUtils.leftPad((String)Formats.CURRENCY_PRINTED.formatValue(line.getPriceProductMinusPriceIncluded() * line.getMultiply()), (int)7) + tax_line;
        this.addParagraph(document, writer, itemName, price_item, 10, 1, false, true);
        for (OptionItemOrder supplement : line.getListSupplements()) {
            if (supplement.getIdProduct() != -1 && supplement.getIdProduct() != 0 || supplement.getFull_price() == 0.0 && !supplement.isDisplay_free()) continue;
            int tax_id_option = supplement.getTax() != null ? Integer.valueOf(supplement.getTax().getId()) : taxe_id;
            this.appendSupplement(supplement, document, writer, tax_id_option, line.getMultiply() >= 0.0, line);
        }
        for (ProductTicket product : line.getListProducts()) {
            this.appendItem(product, document, writer, Integer.valueOf(line.getTaxInfo().getId()), line.getMultiply() >= 0.0, line);
            for (OptionItemOrder supplementItem : line.getListSupplements()) {
                if (supplementItem.getIdProduct() != product.getIdProduct() || supplementItem.getIdCarte() != product.getIdCarte() || supplementItem.getIndex_carte() != product.getIndex_carte() || supplementItem.getPrice() == 0.0 && !supplementItem.isDisplay_free()) continue;
                this.appendSupplement(supplementItem, document, writer, taxe_id, line.getMultiply() >= 0.0, line);
            }
        }
        if (line.getValueDiscount() > 0.0) {
            String labelDiscount = line.printLabelDiscount();
            this.addParagraph(document, " " + labelDiscount + "  -" + Formats.CURRENCY_PRINTED.formatValue(Math.abs(line.getDiscount())), 0, 10);
            ++this.nombreLignesInCammande;
        }
    }

    private String getName_product(String name_product, String unit, Document document, int sizeDesignation) {
        Object itemName;
        if (name_product.length() > sizeDesignation) {
            List<String> chaines = this.getLines_separate(name_product, sizeDesignation, 0);
            for (int j = 0; j < chaines.size() - 1; ++j) {
                String ligne = chaines.get(j);
                itemName = j == 0 ? this.formatMax(org.apache.commons.lang.StringUtils.rightPad((String)unit, (int)4) + ligne) : org.apache.commons.lang.StringUtils.rightPad((String)"", (int)4) + ligne;
                ++this.nombreLignesInCammande;
                this.addParagraph(document, ((String)itemName).toUpperCase(), 0, 10, 1);
            }
            String ligne = chaines.get(chaines.size() - 1);
            itemName = org.apache.commons.lang.StringUtils.rightPad((String)"", (int)4) + ligne;
        } else {
            itemName = this.formatMax(org.apache.commons.lang.StringUtils.rightPad((String)unit, (int)4) + name_product);
        }
        return itemName;
    }

    private List<String> getLines_separate(String name_product, int sizeDesignation, int prefix) {
        return this.getLines_separate(name_product, sizeDesignation, prefix, 1);
    }

    private List<String> getLines_separate(String name_product, int sizeDesignation, int prefix, int width_by_char) {
        String[] tab_chaines = name_product.split(" ");
        ArrayList<String> chaines = new ArrayList<String>();
        Object chaine_tmp = "";
        for (String chaine : tab_chaines) {
            if (chaine.length() * width_by_char + ((String)chaine_tmp).length() * width_by_char + 1 + prefix <= sizeDesignation) {
                chaine_tmp = (String)chaine_tmp + chaine + " ";
                continue;
            }
            String string_to_add = chaine_tmp;
            string_to_add = string_to_add.substring(0, string_to_add.length() - 1);
            chaines.add(string_to_add);
            chaine_tmp = chaine + " ";
        }
        String string_to_add = chaine_tmp;
        string_to_add = string_to_add.substring(0, string_to_add.length() - 1);
        chaines.add(string_to_add);
        return chaines;
    }

    private void appendSupplement(OptionItemOrder option, Document document, PdfWriter writer, int taxeId, boolean isPositive, TicketLineInfo ticketLine) {
        int numberOption = option.getNumberOption() - option.getNumber_free();
        if (option.getNumberOption() == option.getNumber_free()) {
            numberOption = option.getNumberOption();
        }
        String prefix = "";
        if (AppLocal.MODULE_MULTI_TVA) {
            prefix = option.addTaxeToOption() && option.getPrice_already_included() > 0.0 ? (option.getFull_price() == option.getPrice_already_included() ? "(OI) " : "(OPI)") : (option.getFull_price() > 0.0 ? "(OP) " : "(OG) ");
        }
        Object numberOptions = option.isDisplay_free() && option.getFull_price() == 0.0 ? "" : "" + (int)((double)numberOption * ticketLine.getMultiply());
        String nameOption = prefix + option.getNameSupplement();
        String itemName = this.formatMax(org.apache.commons.lang.StringUtils.rightPad((String)numberOptions, (int)4) + nameOption);
        ++this.nombreLignesInCammande;
        if (option.getFull_price() != 0.0) {
            String price_supplement = (isPositive ? Formats.CURRENCY_PRINTED.formatValue(option.getFull_price() / (double)numberOption) : Formats.CURRENCY_PRINTED.formatValue(option.getFull_price() / (double)numberOption)) + org.apache.commons.lang.StringUtils.leftPad((String)Formats.CURRENCY_PRINTED.formatValue(option.getFull_price() * ticketLine.getMultiply()), (int)7) + org.apache.commons.lang.StringUtils.leftPad((String)("" + taxeId), (int)4);
            this.addParagraph(document, writer, itemName, price_supplement, 10, 0, false, true);
        } else {
            this.addParagraph(document, itemName, 0, 10);
        }
    }

    private void appendItem(ProductTicket item, Document document, PdfWriter writer, int taxeId, boolean isPositive, TicketLineInfo line) {
        String numberItems = String.valueOf((int)((double)item.getNumberProduct() * line.getMultiply()));
        String itemName = this.formatMax(org.apache.commons.lang.StringUtils.rightPad((String)numberItems, (int)4) + "--" + item.getNameProduct());
        ++this.nombreLignesInCammande;
        if (item.getPriceProduct() != 0.0) {
            String price_item = item.printPrice() + org.apache.commons.lang.StringUtils.leftPad((String)Formats.CURRENCY_PRINTED.formatValue(item.getPriceProduct() * (double)item.getNumberProduct() * line.getMultiply()), (int)7) + org.apache.commons.lang.StringUtils.leftPad((String)("" + taxeId), (int)4);
            this.addParagraph(document, writer, itemName.toUpperCase(), price_item, 10, 0, false, true);
        } else {
            this.addParagraph(document, itemName.toUpperCase(), 0, 10);
        }
    }

    public String formatMax(String message) {
        return message;
    }
}

