/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.util;

import com.openbravo.AppConstants;
import com.openbravo.basic.BasicException;
import com.openbravo.beans.TicketAvoir;
import com.openbravo.dao.DataLogicOrder;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.payment.PaymentInfo;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.util.LogToFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PaymentUtils {
    public static List<PaymentInfo> getPaymentToSave(List<PaymentInfo> m_aPaymentInfo, TicketInfo newTicket) {
        ArrayList<PaymentInfo> paymentsToSave = new ArrayList<PaymentInfo>();
        ArrayList<PaymentInfo> paymentsToRemove = new ArrayList<PaymentInfo>();
        PaymentInfo paymentCash = new PaymentInfo();
        paymentCash.setNamePayment("Espece");
        for (PaymentInfo paymentInfo : m_aPaymentInfo) {
            if (paymentInfo.getName() == null || !paymentInfo.getName().equals("Espece")) continue;
            paymentCash.setTotal(paymentCash.getTotal() + paymentInfo.getTotal());
            paymentCash.setPaid(paymentCash.getPaid() + paymentInfo.getPaid());
            paymentsToRemove.add(paymentInfo);
        }
        m_aPaymentInfo.removeAll(paymentsToRemove);
        for (PaymentInfo paymentInfo : m_aPaymentInfo) {
            if ((paymentInfo.getName().equals(AppConstants.PAYMENT_MODE.TICKET_RESTO.getName()) || paymentInfo.getName().equalsIgnoreCase("avoir")) && paymentInfo.getPaid() > paymentInfo.getTotal()) {
                double totalPayment = paymentInfo.getTotal();
                double paidAvoir = paymentInfo.getPaid() - totalPayment;
                if (!AppLocal.print_avoir.booleanValue()) {
                    paymentInfo.setPaid(paymentInfo.getTotal());
                } else {
                    paymentInfo.setTotal(paymentInfo.getPaid());
                    if (paymentCash.getPaid() > paidAvoir) {
                        paymentCash.setTotal(paymentCash.getTotal() - paidAvoir);
                    } else {
                        paymentsToSave.add(new PaymentInfo("Avoir", -paidAvoir, -paidAvoir, paymentInfo.getName() + ":" + newTicket.getId()));
                    }
                }
                paymentsToSave.add(paymentInfo);
                continue;
            }
            paymentsToSave.add(paymentInfo);
        }
        if (paymentCash.getTotal() > 0.0) {
            paymentsToSave.add(paymentCash);
        }
        return paymentsToSave;
    }

    public static void updateStatusAvoir(DataLogicOrder dlOrders, Map<Integer, TicketAvoir> ticketAvoirs) {
        if (ticketAvoirs != null) {
            for (Map.Entry<Integer, TicketAvoir> entry : ticketAvoirs.entrySet()) {
                Integer key = entry.getKey();
                TicketAvoir value = entry.getValue();
                value.setUsed(true);
                try {
                    dlOrders.updateTicketAvoir(value);
                }
                catch (BasicException ex) {
                    LogToFile.log("severe", null, ex);
                }
            }
        }
    }
}

