/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.util;

import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public class NumericUtils {
    public static final String FORMAT_DECIMAL = "%.2f";
    public static final String FORMAT_DECIMAL_PERCENT = "%.1f";
    public static final String FORMAT_INTEGER = "%d";
    public static final String FORMAT_INTEGER7DIGITS = "%07d";
    public static final String FORMAT_INTEGER6DIGITS = "%06d";
    public static final String FORMAT_INTEGER3DIGITS = "%03d";
    public static final String PATTERN_FORMAT_DECIMAL = "###.##";
    private static final Locale LOCALE = new Locale("fr", "FR");

    public static String formatToString(BigDecimal number) {
        number = number.setScale(2, 1);
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(LOCALE);
        decimalFormat.applyPattern(PATTERN_FORMAT_DECIMAL);
        return decimalFormat.format(number);
    }

    public static String formatToString(Double number) {
        return String.format(FORMAT_DECIMAL, number);
    }

    public static Double getPercent(Integer total, Integer value) {
        return total > 0 ? new Double(value * 100 / total) : 0.0;
    }

    public static Double getPercent(Double total, Double value) {
        return total > 0.0 ? value * 100.0 / total : 0.0;
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(value *= (double)factor);
        return (double)tmp / (double)factor;
    }

    public static double round(double value) {
        return NumericUtils.round(value, AppLocal.FORMAT_DOUBLE_PLACES);
    }

    public static String formatToStringPercent(Double number) {
        if (number - (double)number.intValue() != 0.0) {
            return String.format(FORMAT_DECIMAL_PERCENT, number) + " %";
        }
        return String.format(FORMAT_INTEGER, number.intValue()) + " %";
    }

    public static String formatToStringPercent(Integer number) {
        return String.format(FORMAT_INTEGER, number) + " %";
    }

    public static String formatToStringInteger7Digits(Integer number) {
        return String.format(FORMAT_INTEGER7DIGITS, number);
    }

    public static String formatToStringInteger6Digits(Integer number) {
        return String.format(FORMAT_INTEGER6DIGITS, number);
    }

    public static String formatToStringInteger3Digits(Integer number) {
        return String.format(FORMAT_INTEGER3DIGITS, number);
    }

    public static String encodeAppVersionNumber(Integer number) {
        if (number == null) {
            return null;
        }
        String s = number.toString();
        Object out = "";
        int index = 0;
        for (int x = s.length() - 1; x >= 0; --x) {
            if (++index == 2 && x > 0) {
                index = 0;
                out = (String)out + s.charAt(x);
                out = (String)out + ".";
                continue;
            }
            out = (String)out + s.charAt(x);
        }
        return new StringBuilder((String)out).reverse().toString();
    }

    public static Integer decodeAppVersionNumber(String value) {
        return value != null ? new Integer(value.replaceAll("[.]", "")) : null;
    }

    public static String numberToString(double number) {
        if (number == (double)Math.round(number)) {
            return Formats.INT.formatValue(number);
        }
        return Formats.DOUBLE.formatValue(number);
    }
}

