/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.util;

import com.openbravo.pos.util.LogToFile;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class NetWorkUtils {
    public static List<String> getMacAddresses() {
        ArrayList<String> macAddress = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> networks = NetworkInterface.getNetworkInterfaces();
            while (networks.hasMoreElements()) {
                byte[] mac;
                NetworkInterface network = networks.nextElement();
                if (network.isLoopback() || (mac = network.getHardwareAddress()) == null) continue;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < mac.length; ++i) {
                    sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
                }
                macAddress.add(sb.toString());
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return macAddress;
    }

    public static String getMacAddress() {
        try {
            InetAddress ip = InetAddress.getLocalHost();
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            byte[] mac = network.getHardwareAddress();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < mac.length; ++i) {
                sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
            }
            return sb.toString();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            return null;
        }
    }
}

