/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.util;

import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.util.StringUtils;
import com.openbravo.pos.util.SystemUtils;
import com.profesorfalken.jpowershell.PowerShell;
import com.profesorfalken.jpowershell.PowerShellResponse;
import fr.protactile.procaisse.log.SentryLogger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogToFile {
    protected static final Logger logger = Logger.getLogger("PROCAISSE_LOG : 10.0.1.27");
    public static String logFile = (AppLocal.IS_APP_PORTABLE != false ? Paths.get(".", new String[0]).toAbsolutePath().normalize().toString() : SystemUtils.SYS_USER_HOME) + File.separator + "procaisse-properties" + File.separator + "procaisse_log.xml";
    public static final String LEVEL_SEVERE = "severe";
    private static SentryLogger mSentryLogger = SentryLogger.getInstance();
    public static final String LEVEL_WARNING = "LEVEL_WARNING";
    public static final String LEVEL_INFO = "LEVEL_INFO";
    public static final String LEVEL_CONFIG = "config";
    public static final String LEVEL_FINE = "fine";
    public static final String LEVEL_FINER = "finer";
    public static final String LEVEL_FINEST = "finest";

    public static void log(String level, String msg, Exception ex) {
        FileHandler fh = null;
        try {
            if (fh == null) {
                fh = new FileHandler(logFile, true);
            }
            logger.addHandler(fh);
            switch (level) {
                case "severe": {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    mSentryLogger.log(ex);
                    break;
                }
                case "LEVEL_WARNING": {
                    logger.log(Level.WARNING, msg, ex);
                    break;
                }
                case "LEVEL_INFO": {
                    if (AppLocal.user != null && AppLocal.user.getRole().equals("0")) {
                        System.out.println(msg);
                    }
                }
                case "config": {
                    logger.log(Level.OFF, msg, ex);
                    break;
                }
                case "fine": 
                case "finer": 
                case "finest": {
                    logger.log(Level.OFF, msg, ex);
                    break;
                }
                default: {
                    logger.log(Level.OFF, msg, ex);
                    break;
                }
            }
        }
        catch (SecurityException ex1) {
            logger.log(Level.SEVERE, ex.getMessage(), ex1);
        }
        catch (IOException ex1) {
            Logger.getLogger(LogToFile.class.getName()).log(Level.SEVERE, null, ex1);
        }
    }

    public static String getTeamViewerId() {
        try {
            if (AppLocal.TEAMVIEWER_ID == null) {
                PowerShellResponse response = PowerShell.executeSingleCommand((String)"if(Test-Path -Path HKLM:\\SOFTWARE\\TeamViewer) {(Get-ItemProperty -Path HKLM:\\SOFTWARE\\TeamViewer).ClientID} if(Test-Path -Path HKLM:\\SOFTWARE\\Wow6432Node\\TeamViewer){(Get-ItemProperty -Path HKLM:\\SOFTWARE\\Wow6432Node\\TeamViewer).ClientID}");
                if (response != null && response.getCommandOutput() != null && !response.getCommandOutput().isEmpty()) {
                    System.out.println("++++++++++++ response.getCommandOutput() : " + response.getCommandOutput());
                    String temviewer_id = response.getCommandOutput();
                    String[] result = temviewer_id.split("(?=\\D)");
                    AppLocal.TEAMVIEWER_ID = result.length > 0 && StringUtils.isNumber(result[0].trim()) ? result[0].trim() : "NON DEFINI";
                } else {
                    AppLocal.TEAMVIEWER_ID = "NON DEFINI";
                }
            }
        }
        catch (Exception e) {
            AppLocal.TEAMVIEWER_ID = "NON DEFINI";
        }
        return AppLocal.TEAMVIEWER_ID;
    }

    public static void log(String message) {
        mSentryLogger.log(message);
    }
}

