/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.util;

import com.openbravo.dao.DataLogicSales;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.util.Event;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.DeletionDetecter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.CompressionLevel;
import net.lingala.zip4j.model.enums.EncryptionMethod;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.input.ReversedLinesFileReader;

public class Journal {
    public static File FILE = new File(AppLocal.JOURNAL_FILE);
    public static int id = 0;
    public static int MEGRATION_JET = 4176;
    public static int CURRENT_VERSION = 0;
    public static String JET_EDITOR_FUNCTION = "Fonction \u00e9diteur";
    public static String JET_DESCRIPTION = "Description";
    public static String JET_DESC_MODIF_ALL_PARAMS = "Modification des Param\u00e8tres";

    public static synchronized void writeToJET(Event evnt) throws IOException {
        ArrayList<String> l = new ArrayList<String>();
        DeletionDetecter detecter = new DeletionDetecter();
        if (!FILE.exists() || FILE.length() == 0L) {
            Journal.extarctProtectedfile();
        }
        if (!FILE.exists() || FILE.length() == 0L) {
            l.add("ID,Code evenement,Descriptif,Code Operateur,Horodatage,Informations,Signature,code caisse");
            if (detecter.isDefautDetcted("jet", "")) {
                Journal.writeDeletionDetected(detecter, l, evnt);
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                id = 1;
                evnt.setId(1);
                stringBuilder.append(evnt.getEmprinte()).append(",N,");
                String signature = DataLogicSales.signer(stringBuilder.toString());
                String eString = evnt.getLineJETFile(signature);
                l.add(eString);
            }
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            ReversedLinesFileReader fileReader = new ReversedLinesFileReader(FILE);
            String previousEvent = fileReader.readLine();
            if (detecter.isDefautDetcted("jet", previousEvent)) {
                Journal.writeDeletionDetected(detecter, l, evnt);
            } else if (previousEvent.split(",").length >= 7) {
                id = Integer.valueOf(previousEvent.split(",")[0]);
                evnt.setId(++id);
                String previousSignature = previousEvent.split(",")[6];
                stringBuilder.append(evnt.getEmprinte()).append(",O,").append(previousSignature);
                String signature = DataLogicSales.signer(stringBuilder.toString());
                String eString = evnt.getLineJETFile(signature);
                l.add(eString);
            }
            fileReader.close();
        }
        if (l.size() > 0) {
            FileUtils.writeLines((File)FILE, (String)"ISO-8859-15", l, (boolean)true);
            detecter.pushToRegistre("jet", (String)l.get(l.size() - 1));
        }
        Journal.protectFile(2);
    }

    public static void writeDeletionDetected(DeletionDetecter detecter, List<String> l, Event evnt) throws NumberFormatException {
        String lastLineReg = detecter.getLastLine("jet");
        l.add(lastLineReg);
        Event eSuppression = new Event(90, "D\u00e9tection d'un d\u00e9faut d'int\u00e9grit\u00e9", "", "Description", new Date().getTime(), "D\u00e9tection de supression ou modification des lignes du Journal");
        StringBuilder stringBuilder = new StringBuilder();
        if (lastLineReg.split(",").length >= 7) {
            id = Integer.valueOf(lastLineReg.split(",")[0]);
            eSuppression.setId(++id);
            String previousSignature = lastLineReg.split(",")[6];
            stringBuilder.append(eSuppression.getEmprinte()).append(",O,").append(previousSignature);
            String lastSignature = DataLogicSales.signer(stringBuilder.toString());
            String eString = eSuppression.getLineJETFile(lastSignature);
            l.add(eString);
            evnt.setId(++id);
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append(evnt.getEmprinte()).append(",O,").append(lastSignature);
            String signature = DataLogicSales.signer(stringBuilder2.toString());
            eString = evnt.getLineJETFile(signature);
            l.add(eString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int countLinesInFile(File f) throws FileNotFoundException, IOException {
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));){
            byte[] c = new byte[1024];
            int count = 0;
            int readChars = 0;
            boolean empty = true;
            while ((readChars = ((InputStream)is).read(c)) != -1) {
                empty = false;
                for (int i = 0; i < readChars; ++i) {
                    if (c[i] != 10) continue;
                    ++count;
                }
            }
            int n = count == 0 && !empty ? 1 : count;
            return n;
        }
    }

    public static void protectFile(int NumberCall, String nameFolder, File file) {
        try {
            ZipParameters zipParameters = new ZipParameters();
            zipParameters.setEncryptFiles(true);
            zipParameters.setCompressionLevel(CompressionLevel.NORMAL);
            zipParameters.setEncryptionMethod(EncryptionMethod.ZIP_STANDARD);
            ZipFile zipFile = new ZipFile(file.getParent() + File.separator + nameFolder, "protactilepa42".toCharArray());
            zipFile.addFile(file, zipParameters);
            zipFile.close();
            Files.deleteIfExists(file.toPath());
        }
        catch (Exception ex) {
            if (NumberCall > 0) {
                try {
                    File fileZIP = new File(file.getParent() + File.separator + nameFolder);
                    Files.deleteIfExists(fileZIP.toPath());
                    Journal.protectFile(--NumberCall);
                }
                catch (IOException ex1) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public static void protectFile(int NumberCall) {
        Journal.protectFile(NumberCall, "JET.zip", FILE);
    }

    public static void extarctProtectedfile() {
        try {
            ZipFile zipFile = new ZipFile(FILE.getParent() + File.separator + "JET.zip", "protactilepa42".toCharArray());
            zipFile.extractAll(FILE.getParent());
        }
        catch (ZipException ex) {
            Logger.getLogger(Journal.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

