/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.util;

import com.openbravo.pos.ticket.CategoryInfo;
import com.openbravo.pos.ticket.ItemOrderInfo;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.ProductTicket;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.util.FilerUtils;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javafx.scene.image.Image;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;

public class ImagesUtils {
    private FilerUtils m_FilerUtils = FilerUtils.getInstance();

    public Image getImageProduct(ProductInfoExt product, HashMap<Integer, SoftReference> refItems, String size, boolean add_default_image) {
        String resized_path = null;
        String image_product = product.getImageProduct();
        if (image_product != null && !image_product.isEmpty()) {
            String name = image_product.replaceFirst("[.][^.]+$", "");
            String ext = image_product.substring(image_product.lastIndexOf(".") + 1);
            resized_path = name + size + "." + ext;
        }
        return this.getImageItems(product.getID(), image_product, "products", refItems, resized_path, add_default_image);
    }

    public Image getImageOption(SupplementItemInfo option, HashMap<Integer, SoftReference> refItems, String size, boolean add_default_image) {
        String resized_path = null;
        if (option.getPath() != null && !option.getPath().isEmpty()) {
            String name = option.getPath().replaceFirst("[.][^.]+$", "");
            String ext = option.getPath().substring(option.getPath().lastIndexOf(".") + 1);
            resized_path = name + size + "." + ext;
        }
        return this.getImageItems(option.getiD(), option.getPath(), "supplements", refItems, resized_path, add_default_image);
    }

    public Image getImageCategory(CategoryInfo catgory, HashMap<Integer, SoftReference> refItems, String size, boolean add_default_image) {
        String resized_path = null;
        if (catgory.getPath() != null && !catgory.getPath().isEmpty() && size != null && !size.isEmpty()) {
            String name = catgory.getPath().replaceFirst("[.][^.]+$", "");
            String ext = catgory.getPath().substring(catgory.getPath().lastIndexOf(".") + 1);
            resized_path = name + size + "." + ext;
        }
        return this.getImageItems(catgory.getID(), catgory.getPath(), "catagories", refItems, resized_path, add_default_image);
    }

    public Image getImageItems(int id_option, String path, String folder, HashMap<Integer, SoftReference> refItems, String resized_path, boolean add_default_image) {
        Image image_option = null;
        if (refItems.containsKey(id_option) && refItems.get(id_option) != null) {
            image_option = (Image)refItems.get(id_option).get();
        }
        if (image_option == null) {
            File image = null;
            if (resized_path != null) {
                image = this.m_FilerUtils.getFileFullPath("images/" + folder + "/" + resized_path);
            }
            if (!(image != null && image.exists() || path == null)) {
                image = this.m_FilerUtils.getFileFullPath("images/" + folder + "/" + path);
            }
            if (image != null && image.exists()) {
                image_option = new Image(image.toURI().toString());
            } else if (add_default_image && List.of("products", "ingredients", "options").contains(folder)) {
                image_option = folder.equalsIgnoreCase("ingredients") ? new Image("/images/no-ingredient-img.png") : new Image("/images/no-product-or-option-img.png");
            }
            if (image_option != null) {
                if (!refItems.containsKey(id_option)) {
                    refItems.put(id_option, new SoftReference<Image>(image_option));
                } else if (refItems.get(id_option) == null) {
                    refItems.replace(id_option, new SoftReference<Image>(image_option));
                }
            }
        }
        return image_option;
    }

    public BufferedImage createThumbNail(BufferedImage img, int m_width, int m_height) {
        int targeth;
        int targetw;
        double scaley;
        double scalex = (double)m_width / (double)img.getWidth(null);
        if (scalex < (scaley = (double)m_height / (double)img.getHeight(null))) {
            targetw = m_width;
            targeth = (int)((double)img.getHeight(null) * scalex);
        } else {
            targetw = (int)((double)img.getWidth(null) * scaley);
            targeth = m_height;
        }
        int midw = img.getWidth(null);
        int midh = img.getHeight(null);
        BufferedImage midimg = null;
        Graphics2D g2d = null;
        BufferedImage previmg = img;
        int prevw = img.getWidth(null);
        int prevh = img.getHeight(null);
        do {
            if (midw > targetw) {
                if ((midw /= 2) < targetw) {
                    midw = targetw;
                }
            } else {
                midw = targetw;
            }
            if (midh > targeth) {
                if ((midh /= 2) < targeth) {
                    midh = targeth;
                }
            } else {
                midh = targeth;
            }
            midimg = new BufferedImage(midw, midh, 2);
            g2d = midimg.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2d.drawImage(previmg, 0, 0, midw, midh, 0, 0, prevw, prevh, null);
            prevw = midw;
            prevh = midh;
            previmg = midimg;
        } while (midw != targetw || midh != targeth);
        g2d.dispose();
        if (m_width != midimg.getWidth() || m_height != midimg.getHeight()) {
            midimg = new BufferedImage(m_width, m_height, 2);
            int x = m_width > targetw ? (m_width - targetw) / 2 : 0;
            int y = m_height > targeth ? (m_height - targeth) / 2 : 0;
            g2d = midimg.createGraphics();
            g2d.drawImage(previmg, x, y, x + targetw, y + targeth, 0, 0, targetw, targeth, null);
            g2d.dispose();
            previmg = midimg;
        }
        return midimg;
    }

    public void resizeImage(File sourceFile, String qualite) throws IOException {
        String sourceFileName = sourceFile.getName();
        BufferedImage image = ImageIO.read(sourceFile);
        String name = sourceFileName.replaceFirst("[.][^.]+$", "");
        String ext = sourceFileName.substring(sourceFileName.lastIndexOf(".") + 1);
        if (image != null) {
            File resizedFile = Paths.get(sourceFile.getParent(), name + "_" + qualite + "px." + ext).toFile();
            ImageIO.write((RenderedImage)this.createThumbNail(image, Integer.parseInt(qualite), Integer.parseInt(qualite)), "png", resizedFile);
        }
    }

    public Image getImageItems(int id_option, String path, String folder, HashMap<Integer, SoftReference> refItems, boolean add_default_image) {
        return this.getImageItems(id_option, path, folder, refItems, null, add_default_image);
    }

    public void resizeImageUber(File sourceFile, int m_width, int m_height) throws IOException {
        String sourceFileName = sourceFile.getName();
        BufferedImage image = ImageIO.read(sourceFile);
        String name = sourceFileName.replaceFirst("[.][^.]+$", "");
        if (Pattern.matches(".*[\u00ea\u00e9\u00e8\u00e0\u00f9\u00f4\u00e7\u00ee\u00ef].*", name)) {
            name = StringUtils.stripAccents((String)name);
        }
        String ext = sourceFileName.substring(sourceFileName.lastIndexOf(".") + 1);
        if (image != null && !name.endsWith("_Uber")) {
            File resizedFile = Paths.get(sourceFile.getParent(), name + "_Uber." + ext).toFile();
            ImageIO.write((RenderedImage)this.createThumbNail(image, m_width, m_height), "png", resizedFile);
        }
    }

    public Image getImageIngredients(SupplementItemInfo ingredient, HashMap<Integer, SoftReference> refIngredients, String size, boolean add_default_image) {
        String resized_path = null;
        if (ingredient.getPath() != null && !ingredient.getPath().isEmpty()) {
            String name = ingredient.getPath().replaceFirst("[.][^.]+$", "");
            String ext = ingredient.getPath().substring(ingredient.getPath().lastIndexOf(".") + 1);
            resized_path = name + size + "." + ext;
        }
        return this.getImageItems(ingredient.getiD(), ingredient.getPath(), "ingredients", refIngredients, resized_path, add_default_image);
    }

    public Image getImageOption(OptionItemOrder optionItemOrder, HashMap<Integer, SoftReference> refItems, String size, boolean add_default_image) {
        String resized_path = null;
        if (optionItemOrder.getPath() != null && !optionItemOrder.getPath().isEmpty()) {
            String name = optionItemOrder.getPath().replaceFirst("[.][^.]+$", "");
            String ext = optionItemOrder.getPath().substring(optionItemOrder.getPath().lastIndexOf(".") + 1);
            resized_path = name + size + "." + ext;
        }
        return this.getImageItems(optionItemOrder.getSupplement(), optionItemOrder.getPath(), "supplements", refItems, resized_path, add_default_image);
    }

    public Image getImageIngredients(ItemOrderInfo itemOrderInfo, HashMap<Integer, SoftReference> refIngredients, String size, boolean add_default_image) {
        String resized_path = null;
        if (itemOrderInfo.getPath() != null && !itemOrderInfo.getPath().isEmpty()) {
            String name = itemOrderInfo.getPath().replaceFirst("[.][^.]+$", "");
            String ext = itemOrderInfo.getPath().substring(itemOrderInfo.getPath().lastIndexOf(".") + 1);
            resized_path = name + size + "." + ext;
        }
        return this.getImageItems(itemOrderInfo.getSupplement(), itemOrderInfo.getPath(), "ingredients", refIngredients, resized_path, add_default_image);
    }

    public Image getImageProduct(ProductTicket product, HashMap<Integer, SoftReference> refItems, String size, boolean add_default_image) {
        String resized_path = null;
        String image_product = product.getPath();
        if (image_product != null && !image_product.isEmpty()) {
            String name = image_product.replaceFirst("[.][^.]+$", "");
            String ext = image_product.substring(image_product.lastIndexOf(".") + 1);
            resized_path = name + size + "." + ext;
        }
        return this.getImageItems(product.getIdCarte(), image_product, "products", refItems, resized_path, add_default_image);
    }
}

