/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureRandom;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IOHelper {
    private static Log logger = LogFactory.getFactory().getInstance(IOHelper.class);

    public static String getExtension(String fileName) {
        String extension = "";
        int i = fileName.lastIndexOf(46);
        if (i > 0) {
            extension = fileName.substring(i + 1);
        }
        return extension;
    }

    public static void deleteFile(String filePath) {
        File file = new File(filePath);
        if (file != null && file.exists()) {
            file.delete();
        }
    }

    public static File createTempDirectory() throws IOException {
        File temp = File.createTempFile("temp", Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File downloadFileFromServer(String urlPath) {
        File file = null;
        FileOutputStream fileOutput = null;
        try {
            URL url = new URL(urlPath);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestMethod("GET");
            urlConnection.setDoOutput(true);
            urlConnection.connect();
            File dirUpload = IOHelper.createTempDirectory();
            if (!dirUpload.exists()) {
                dirUpload.mkdirs();
            }
            String name = SessionIdentifierGenerator.nextSessionId() + "." + IOHelper.getExtension(urlPath);
            file = new File(dirUpload, name);
            fileOutput = new FileOutputStream(file);
            InputStream inputStream = urlConnection.getInputStream();
            byte[] buffer = new byte[1024];
            int bufferLength = 0;
            while ((bufferLength = inputStream.read(buffer)) > 0) {
                fileOutput.write(buffer, 0, bufferLength);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            file = null;
        }
        catch (IOException e) {
            e.printStackTrace();
            file = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            file = null;
        }
        finally {
            try {
                if (fileOutput != null) {
                    fileOutput.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (file != null) {
            logger.info((Object)("URL Path file " + urlPath + " was downloaded with success"));
        }
        return file;
    }

    static class SessionIdentifierGenerator {
        private static SecureRandom random = new SecureRandom();

        SessionIdentifierGenerator() {
        }

        public static String nextSessionId() {
            return new BigInteger(130, random).toString(32);
        }
    }
}

