/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.util;

import com.openbravo.beans.JPasswordDialog;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.StringUtils;
import java.awt.Component;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class Hashcypher {
    public static boolean authenticate(String sPassword, String sHashPassword) {
        if (sHashPassword == null || sHashPassword.equals("") || sHashPassword.startsWith("empty:")) {
            return sPassword == null || sPassword.equals("");
        }
        if (sHashPassword.startsWith("sha1:")) {
            return sHashPassword.equals(Hashcypher.hashString(sPassword));
        }
        if (sHashPassword.startsWith("plain:")) {
            return sHashPassword.equals("plain:" + sPassword);
        }
        return sHashPassword.equals(sPassword);
    }

    public static String hashString(String sPassword) {
        if (sPassword == null || sPassword.equals("")) {
            return "";
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(sPassword.getBytes("UTF-8"));
            byte[] res = md.digest();
            return "sha1:" + StringUtils.byte2hex(res);
        }
        catch (NoSuchAlgorithmException e) {
            return "plain:" + sPassword;
        }
        catch (UnsupportedEncodingException e) {
            return "plain:" + sPassword;
        }
    }

    public static String changePassword(Component parent) {
        String sPassword2;
        String sPassword = JPasswordDialog.showEditPassword(parent, AppLocal.getIntString("Label.Password"), AppLocal.getIntString("label.passwordnew"), new ImageIcon(Hashcypher.class.getResource("/com/openbravo/images/password.png")));
        if (sPassword != null && (sPassword2 = JPasswordDialog.showEditPassword(parent, AppLocal.getIntString("Label.Password"), AppLocal.getIntString("label.passwordrepeat"), new ImageIcon(Hashcypher.class.getResource("/com/openbravo/images/password.png")))) != null) {
            if (sPassword.equals(sPassword2)) {
                return Hashcypher.hashString(sPassword);
            }
            JOptionPane.showMessageDialog(parent, AppLocal.getIntString("message.changepassworddistinct"), AppLocal.getIntString("message.title"), 2);
        }
        return null;
    }

    public static String changePassword(Component parent, String sOldPassword) {
        String sPassword = JPasswordDialog.showEditPassword(parent, AppLocal.getIntString("Label.Password"), AppLocal.getIntString("label.passwordold"), new ImageIcon(Hashcypher.class.getResource("/com/openbravo/images/password.png")));
        if (sPassword != null) {
            if (Hashcypher.authenticate(sPassword, sOldPassword)) {
                return Hashcypher.changePassword(parent);
            }
            JOptionPane.showMessageDialog(parent, AppLocal.getIntString("message.BadPassword"), AppLocal.getIntString("message.title"), 2);
        }
        return null;
    }

    public static String hashAccessBackUp(String value) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] hashBytes = md5.digest(value.getBytes(StandardCharsets.UTF_8));
            String code = Hashcypher.bytesToHex(hashBytes).substring(0, 5) + Hashcypher.bytesToHex(hashBytes).substring(Hashcypher.bytesToHex(hashBytes).length() - 5);
            return code;
        }
        catch (NoSuchAlgorithmException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            return null;
        }
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        for (byte b : bytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }
}

