/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.util;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.printer.Decreaser;
import com.openbravo.pos.ticket.PrinterInfo;
import com.openbravo.pos.util.Event;
import com.openbravo.pos.util.Journal;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.PrinterUtils;
import java.awt.print.Pageable;
import java.awt.print.PrinterJob;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.PrinterResolution;
import javax.print.attribute.standard.Sides;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.printing.PDFPageable;

public class GenPDF {
    private String labelPdfTemplate = "/pdf/label-template.pdf";
    private String printerNameCourant = "";

    public void generateLabelPdf(PrinterInfo printer, String ip, String printername, String type, String numero, String product, String nbrPerTicket, String options, String dateCommande, String etat, boolean doCut, String bipper, Decreaser decreaser, int index) throws FileNotFoundException, IOException, DocumentException {
        FileOutputStream os = new FileOutputStream(System.getProperty("java.io.tmpdir") + "generated.pdf");
        if (ip == null) {
            PdfReader pdfReader = new PdfReader(this.labelPdfTemplate);
            PdfStamper pdfStamper = new PdfStamper(pdfReader, (OutputStream)os);
            AcroFields acroFields = pdfStamper.getAcroFields();
            HashMap fields = (HashMap)acroFields.getFields();
            acroFields.setField("type", type);
            acroFields.setField("numero", numero);
            acroFields.setField("product", product);
            acroFields.setField("nbrPerTicket", nbrPerTicket);
            acroFields.setField("options", options);
            acroFields.setField("dateCommande", dateCommande);
            acroFields.setField("etat", etat);
            pdfStamper.setFormFlattening(true);
            pdfStamper.close();
        }
        this.print(printer, new File(System.getProperty("java.io.tmpdir") + "generated.pdf"), printername, bipper, ip, type, numero, product, nbrPerTicket, options, dateCommande, etat, doCut, decreaser);
    }

    /*
     * WARNING - void declaration
     */
    private void print(PrinterInfo printer, File file, String printerName, String bip, String ip, String type, String numero, String product, String nbrPerTicket, String options, String dateCommande, String etat, boolean doCut, Decreaser decreaser) {
        block27: {
            System.out.println("++++++++++++++ print label");
            try {
                if (ip != null) {
                    byte[] newBytes;
                    System.out.println("++++++++++ print here");
                    StringBuilder sb = new StringBuilder("");
                    if (printer.getModel() != null && printer.getModel().contains("EPL")) {
                        sb.append("\nN\nX20,0,3,812,312\nX20,0,35,200,63\nX200,0,3,610,63\nX590,0,35,812,63\nX20,250,3,570,312\nX570,250,3,812,312\n");
                        sb.append("A35,10,0,5,1,1,R,\"");
                        sb.append(numero).append("\"\n");
                        sb.append("A220,10,0,4,1,1,N,\"");
                        sb.append(type).append("\"\n");
                        sb.append("A600,10,0,4,2,2,R,\"");
                        sb.append(bip).append("\"\n");
                        sb.append("A40,260,0,4,1,1,N,\"");
                        sb.append(dateCommande).append(", Ticket: ").append(nbrPerTicket).append("\"\n");
                        sb.append("A590,260,0,4,1,1,N,\"");
                        sb.append(etat).append("\"\n");
                        sb.append("A35,70,0,4,1,1,N,\"");
                        sb.append(product.toUpperCase()).append("\"\n");
                        int optionsLength = options.length();
                        if (optionsLength > 56) {
                            int nbrLignofProduct = optionsLength / 56;
                            int j = 125;
                            int currentviewed = 0;
                            for (int i = 0; i <= nbrLignofProduct; ++i) {
                                void var22_36;
                                if (optionsLength == currentviewed) continue;
                                if (i != nbrLignofProduct) {
                                    String string = options.substring(56 * i, 56 * (i + 1));
                                } else {
                                    String string = options.substring(56 * i);
                                }
                                currentviewed += var22_36.length();
                                sb.append("A25,").append(j).append(",0,3,1,1,N,\"");
                                sb.append((String)var22_36).append("\"\n");
                                j += 25;
                            }
                        } else {
                            sb.append("A28,120,0,3,1,1,N,\"");
                            sb.append(options).append("\"\n");
                        }
                        sb.append("P1\n");
                    } else {
                        sb.append("BD25,15,810,312,B,3\nBD25,15,200,63,B,120\nBD200,15,610,63,B,3\nBD610,15,810,63,B,120\nBD25,250,570,312,B,3\nBD570,250,810,312,B,3\n");
                        sb.append("T35,20,7,1,1,0,0,R,B,'");
                        sb.append(numero).append("'\n");
                        sb.append("T210,20,3,1,1,0,0,N,N,'");
                        sb.append(type).append("'\n");
                        sb.append("T620,20,3,1,1,0,0,R,B,'");
                        sb.append(bip).append("'\n");
                        sb.append("T40,260,2,1,1,0,0,N,B,'");
                        sb.append(dateCommande).append(" , Ticket : ").append("'\n");
                        sb.append("T580,260,3,1,1,0,0,N,B,'");
                        sb.append(etat).append("'\n");
                        sb.append("T35,80,4,1,1,0,0,N,B,'");
                        sb.append(product.toUpperCase()).append("'\n");
                        sb.append("T35,130,2,1,1,0,0,N,B,'");
                        sb.append(options).append("'\n");
                        if (!this.printerNameCourant.equals(printerName) && !this.printerNameCourant.equals(printerName)) {
                            if (doCut && AppLocal.autoCutter.booleanValue()) {
                                sb.append("CUTy\n");
                            } else {
                                sb.append("CUTn\n");
                            }
                        }
                        sb.append("P1\n");
                    }
                    ArrayList<Integer> bytes = new ArrayList<Integer>();
                    for (byte by : newBytes = sb.toString().getBytes()) {
                        bytes.add(Integer.valueOf(by));
                    }
                    this.printConsole(bytes);
                    try (Socket socket = new Socket();){
                        socket.connect(new InetSocketAddress(ip, 9100), 5000);
                        DataOutputStream os = new DataOutputStream(socket.getOutputStream());
                        os.flush();
                        for (Object e : bytes) {
                            os.write((Integer)e);
                        }
                        os.close();
                        break block27;
                    }
                    catch (Exception ex) {
                        if (decreaser != null) {
                            decreaser.addToQueue(bytes, printer);
                        }
                        LogToFile.log("severe", ex.getMessage(), ex);
                        Journal.writeToJET(new Event(150, "Imprimante indisponible ", "", "identifiant d'imprimante - message", new Date().getTime(), printer.getName() + " - Echec d'impression d'\u00e9tiquette "));
                        new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "L'impression de l'etiquette a \u00e9chou\u00e9.", 1500, NPosition.CENTER);
                    }
                    break block27;
                }
                System.out.println("+++++++++++ print hare 2");
                FileInputStream fin = new FileInputStream(file);
                HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
                aset.add(new Copies(1));
                aset.add(Sides.ONE_SIDED);
                aset.add(new PrinterResolution(40, 40, 254));
                PrintService service = PrinterUtils.getPrinter(printerName);
                if (service != null) {
                    try {
                        PDDocument document = PDDocument.load((File)file);
                        DocPrintJob job = service.createPrintJob();
                        PrinterJob pjob = PrinterJob.getPrinterJob();
                        pjob.setPrintService(job.getPrintService());
                        pjob.setJobName(file.getName());
                        pjob.setPageable((Pageable)new PDFPageable(document));
                        pjob.print(aset);
                        System.out.println("******* Document Content *******" + file.getAbsolutePath());
                        document.close();
                        fin.close();
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                        new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "L'impression de l'etiquette a \u00e9chou\u00e9.", 1500, NPosition.CENTER);
                    }
                } else {
                    new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "L'impression de l'etiquette a \u00e9chou\u00e9.\nIl se peut que le cable de l'imprimante est d\u00e9branch\u00e9.", 1500, NPosition.CENTER);
                    Journal.writeToJET(new Event(150, "Imprimante indisponible ", "", "identifiant d'imprimante - message", new Date().getTime(), printer.getName() + " - Echec d'impression d'\u00e9tiquette "));
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "L'impression de l'etiquette a \u00e9chou\u00e9.", 1500, NPosition.CENTER);
            }
        }
    }

    public void printConsole(List<Integer> bytes) {
        byte[] mesBytes = new byte[bytes.size()];
        int j = 0;
        for (Integer b : bytes) {
            mesBytes[j++] = b.byteValue();
        }
        System.out.println("+++++++++++ " + new String(mesBytes));
    }
}

