/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.util;

import com.openbravo.pos.config.JPanelConfigBack;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.SystemUtils;
import com.openbravo.pos.util.ZipUtils;
import com.procaisse.compress.CompressImages;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class FilerUtils
implements Serializable {
    private static int MAX_SIZE_FILE = 0x200000;
    private static int MAX_SIZE = 500000;
    private CompressImages mCompressImages = new CompressImages();
    public static String IMAGES_CATEGORIES = "images/catagories";
    public static String IMAGES_PRODUCTS = "images/products";
    public static String IMAGES_GOPTIONS = "images/options";
    public static String IMAGES_SUPPLEMENTS = "images/supplements";
    public static String IMAGES_INGREDIENTS = "images/ingredients";
    public static String IMAGES_TAGS = "images/tags";
    public static String IMAGES_LOGOS = "images/logos";
    public static String IMAGES_BORNE = "images/photosBorne";
    public static String IMAGES_DISPLAY = "images/photosDisplay";
    public static String IMAGES_PUB = "images/photosPub";
    public static final String SIZE_32px = "_32px";
    public static final String SIZE_64px = "_64px";
    public static final String SIZE_128px = "_128px";
    public static final String SIZE_256px = "_256px";
    public static final String SIZE_512px = "_512px";
    private final String LOGO_DELIVEROO = "logo_deliveroo";
    public static final List<String> listsizes = new ArrayList<String>();
    public static final FileFilter PICTURE_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName().toLowerCase();
            return (name.endsWith(".png") || name.endsWith(".jpg") || name.endsWith(".gif") || name.endsWith(".bmp") || name.endsWith(".jpeg")) && f.length() < (long)MAX_SIZE_FILE;
        }

        @Override
        public String getDescription() {
            return "Images";
        }
    };
    private static FilerUtils m_instance = null;

    private FilerUtils() {
        listsizes.add(SIZE_32px);
        listsizes.add(SIZE_64px);
        listsizes.add(SIZE_128px);
        listsizes.add(SIZE_256px);
        listsizes.add(SIZE_512px);
    }

    public static FilerUtils getInstance() {
        if (m_instance == null) {
            m_instance = new FilerUtils();
        }
        return m_instance;
    }

    public static File getFile(String name_file) {
        FilerUtils m_FilerUtils = FilerUtils.getInstance();
        String FILE_PATH = SystemUtils.SYS_USER_HOME + File.separator + "images" + File.separator + name_file + ".zip";
        File SRC_DIRECTORY = m_FilerUtils.getFileFullPath("images/" + name_file);
        if (SRC_DIRECTORY.exists()) {
            try {
                ZipUtils.zipFolder(SRC_DIRECTORY.getAbsolutePath(), FILE_PATH);
            }
            catch (Exception ex) {
                LogToFile.log("sever", ex.getMessage(), ex);
                return null;
            }
            File file = new File(FILE_PATH);
            return file;
        }
        return null;
    }

    public String getCurrentPath() {
        return Paths.get(".", new String[0]).toAbsolutePath().normalize().toString();
    }

    public File getFileFullPath(String path) {
        if (AppLocal.IS_APP_PORTABLE.booleanValue()) {
            return new File(new File(this.getCurrentPath()), path);
        }
        return new File(new File(SystemUtils.SYS_USER_HOME), path);
    }

    public File getFileProperties() {
        if (AppLocal.IS_APP_PORTABLE.booleanValue()) {
            return new File(this.getCurrentPath(), "procaisse.properties");
        }
        return new File(SystemUtils.SYS_USER_HOME, "procaisse.properties");
    }

    public File getFileFondGloryProperties() {
        if (AppLocal.IS_APP_PORTABLE.booleanValue()) {
            return new File(this.getCurrentPath(), "fond_glory.properties");
        }
        return new File(SystemUtils.SYS_USER_HOME, "fond_glory.properties");
    }

    public static File getFileImages() {
        FilerUtils m_FilerUtils = FilerUtils.getInstance();
        String FILE_PATH = SystemUtils.SYS_USER_HOME + File.separator + "images.zip";
        File SRC_DIRECTORY = m_FilerUtils.getFileFullPath("images");
        if (SRC_DIRECTORY.exists()) {
            try {
                ZipUtils.zipFolder(SRC_DIRECTORY.getAbsolutePath(), FILE_PATH);
            }
            catch (Exception ex) {
                LogToFile.log("sever", ex.getMessage(), ex);
                return null;
            }
            File file = new File(FILE_PATH);
            return file;
        }
        return null;
    }

    public File getFileImagesToUpload() {
        try {
            FilerUtils m_FilerUtils = FilerUtils.getInstance();
            String SRC_DIRCTORY_PATH = SystemUtils.SYS_USER_HOME + File.separator + "procaisse-properties" + File.separator + "images";
            String FILE_PATH = SystemUtils.SYS_USER_HOME + File.separator + "procaisse-properties" + File.separator + "images.zip";
            File SRC_DIRECTORY_OLD = new File(SRC_DIRCTORY_PATH);
            File old_file = new File(FILE_PATH);
            if (old_file.exists()) {
                old_file.delete();
            }
            if (SRC_DIRECTORY_OLD.exists()) {
                if (SRC_DIRECTORY_OLD.isDirectory()) {
                    for (String path_directory : SRC_DIRECTORY_OLD.list()) {
                        File directory_to_delete = new File(SRC_DIRECTORY_OLD.getPath(), path_directory);
                        if (!directory_to_delete.exists()) continue;
                        if (directory_to_delete.isDirectory()) {
                            for (String path_file : directory_to_delete.list()) {
                                File file_to_delete = new File(directory_to_delete.getPath(), path_file);
                                if (!file_to_delete.exists()) continue;
                                file_to_delete.delete();
                            }
                            continue;
                        }
                        directory_to_delete.delete();
                    }
                }
                SRC_DIRECTORY_OLD.delete();
            }
            File SRC_DIRECTORY = new File(SRC_DIRCTORY_PATH);
            File DEST_PRODUCTS_DIRECTORY = new File(SRC_DIRCTORY_PATH + File.separator + "products");
            File DEST_CATEGORIES_DIRECTORY = new File(SRC_DIRCTORY_PATH + File.separator + "catagories");
            File DEST_OPTIONS_DIRECTORY = new File(SRC_DIRCTORY_PATH + File.separator + "options");
            File DEST_SUPPLEMENTS_DIRECTORY = new File(SRC_DIRCTORY_PATH + File.separator + "supplements");
            File DEST_INGREDIENTS_DIRECTORY = new File(SRC_DIRCTORY_PATH + File.separator + "ingredients");
            File DEST_LOGOS_DIRECTORY = new File(SRC_DIRCTORY_PATH + File.separator + "logos");
            File DEST_TAGS_DIRECTORY = new File(SRC_DIRCTORY_PATH + File.separator + "tags");
            File OPTIONS_DIRECTORY = m_FilerUtils.getFileFullPath(IMAGES_GOPTIONS);
            File CATEGORIES_DIRECTORY = m_FilerUtils.getFileFullPath(IMAGES_CATEGORIES);
            File PRODUCTS_DIRECTORY = m_FilerUtils.getFileFullPath(IMAGES_PRODUCTS);
            File SUPPLEMENTS_DIRECTORY = m_FilerUtils.getFileFullPath(IMAGES_SUPPLEMENTS);
            File INGREDIENTS_DIRECTORY = m_FilerUtils.getFileFullPath(IMAGES_INGREDIENTS);
            File LOGOS_DIRECTORY = m_FilerUtils.getFileFullPath(IMAGES_LOGOS);
            File TAGS_DIRECTORY = m_FilerUtils.getFileFullPath(IMAGES_TAGS);
            if (!SRC_DIRECTORY.exists()) {
                FileUtils.forceMkdir((File)SRC_DIRECTORY);
            }
            if (!DEST_PRODUCTS_DIRECTORY.exists()) {
                FileUtils.forceMkdir((File)DEST_PRODUCTS_DIRECTORY);
            }
            if (!DEST_CATEGORIES_DIRECTORY.exists()) {
                FileUtils.forceMkdir((File)DEST_CATEGORIES_DIRECTORY);
            }
            if (!DEST_OPTIONS_DIRECTORY.exists()) {
                FileUtils.forceMkdir((File)DEST_OPTIONS_DIRECTORY);
            }
            if (!DEST_SUPPLEMENTS_DIRECTORY.exists()) {
                FileUtils.forceMkdir((File)DEST_SUPPLEMENTS_DIRECTORY);
            }
            if (!DEST_INGREDIENTS_DIRECTORY.exists()) {
                FileUtils.forceMkdir((File)DEST_INGREDIENTS_DIRECTORY);
            }
            if (!DEST_LOGOS_DIRECTORY.exists()) {
                FileUtils.forceMkdir((File)DEST_LOGOS_DIRECTORY);
            }
            if (!DEST_TAGS_DIRECTORY.exists()) {
                FileUtils.forceMkdir((File)DEST_TAGS_DIRECTORY);
            }
            if (SRC_DIRECTORY.exists()) {
                this.copyFiles(PRODUCTS_DIRECTORY, DEST_PRODUCTS_DIRECTORY);
                this.copyFiles(CATEGORIES_DIRECTORY, DEST_CATEGORIES_DIRECTORY);
                this.copyFiles(OPTIONS_DIRECTORY, DEST_OPTIONS_DIRECTORY);
                this.copyFiles(SUPPLEMENTS_DIRECTORY, DEST_SUPPLEMENTS_DIRECTORY);
                this.copyFiles(INGREDIENTS_DIRECTORY, DEST_INGREDIENTS_DIRECTORY);
                this.copyFiles(TAGS_DIRECTORY, DEST_TAGS_DIRECTORY);
                if (LOGOS_DIRECTORY.exists() && DEST_LOGOS_DIRECTORY.exists()) {
                    for (File file : LOGOS_DIRECTORY.listFiles()) {
                        if (file.isDirectory()) continue;
                        String name = FilenameUtils.removeExtension((String)file.getName());
                        System.out.println("+++++++++++++ name LOGOS_DIRECTORY: " + name);
                        if (name == null || !name.equals("logo_deliveroo")) continue;
                        File filedest = new File(DEST_LOGOS_DIRECTORY + File.separator + file.getName());
                        FileUtils.copyFile((File)file, (File)filedest);
                    }
                }
                ZipUtils.zipFolder(SRC_DIRECTORY.getAbsolutePath(), FILE_PATH);
                File file = new File(FILE_PATH);
                return file;
            }
        }
        catch (Exception ex) {
            LogToFile.log("sever", ex.getMessage(), ex);
            return null;
        }
        return null;
    }

    public void deleteFolder(File folder) {
        String[] entries = folder.list();
        if (entries != null) {
            for (String s : entries) {
                File currentFile = new File(folder.getPath(), s);
                currentFile.delete();
            }
        }
    }

    public static File getImage(String name_folder, String name_file) {
        FilerUtils m_FilerUtils = FilerUtils.getInstance();
        String FILE_PATH = SystemUtils.SYS_USER_HOME + File.separator + "images" + File.separator + name_folder + File.separator + name_file;
        System.out.println("++++++++++ FILE_PATH : " + FILE_PATH);
        File SRC_DIRECTORY = m_FilerUtils.getFileFullPath("images/" + name_folder);
        if (SRC_DIRECTORY.exists()) {
            File file = new File(FILE_PATH);
            return file;
        }
        return null;
    }

    public void renameImage(File image) {
        System.out.println(image.getAbsolutePath());
        String newName = image.getAbsolutePath().replace(" ", "");
        this.renameImage(image, newName);
    }

    public File getLastFileProperties() {
        block7: {
            try {
                File backup_directory = new File(SystemUtils.SYS_USER_HOME, "backup");
                if (!backup_directory.exists()) break block7;
                System.out.println("++++++++++++ backup_directory****************** " + backup_directory.getAbsolutePath());
                File daily_directory = new File(backup_directory, "daily");
                if (!daily_directory.exists() || !daily_directory.isDirectory() || daily_directory.listFiles().length <= 0) break block7;
                File[] files = daily_directory.listFiles();
                ArrayList<File> listFiles = new ArrayList<File>();
                for (File file : files) {
                    if (!file.exists() || !file.isFile() || !file.getName().endsWith(".zip")) continue;
                    listFiles.add(file);
                }
                Collections.sort(listFiles, new Comparator<File>(){

                    @Override
                    public int compare(File file1, File file2) {
                        return (int)(file2.lastModified() - file1.lastModified());
                    }
                });
                for (File last_backUp_file : listFiles) {
                    File last_backUp_properties;
                    File last_backUp_directory;
                    File file;
                    String name_file = last_backUp_file.getName();
                    System.out.println("+++++++++++++++++ name_file : " + name_file);
                    file = new File(daily_directory, name_file);
                    if (!file.exists()) continue;
                    File old_backUp_directory = new File(daily_directory, "procaisse-database");
                    if (old_backUp_directory.exists()) {
                        try {
                            FileUtils.forceDelete((File)old_backUp_directory);
                        }
                        catch (IOException ex) {
                            LogToFile.log("sever", ex.getMessage(), ex);
                        }
                    }
                    if ((last_backUp_directory = this.getUnzippedFile(file.getAbsolutePath(), daily_directory)) == null || !last_backUp_directory.exists() || !last_backUp_directory.isDirectory() || !(last_backUp_properties = new File(last_backUp_directory, "procaisse.properties")).exists()) continue;
                    return last_backUp_properties;
                }
            }
            catch (Exception ex) {
                LogToFile.log("sever", ex.getMessage(), ex);
            }
        }
        return null;
    }

    public File getUnzippedFile(String filePath, File directory) {
        File last_backUp_directory = null;
        try {
            JPanelConfigBack.unZipIt(filePath, directory.getAbsolutePath());
            last_backUp_directory = new File(directory, "procaisse-database");
        }
        catch (Exception ex) {
            LogToFile.log("sever", ex.getMessage(), ex);
        }
        return last_backUp_directory;
    }

    public void renameImage(File image, String newName) {
        try {
            boolean isRenamed = image.renameTo(new File(newName));
            if (isRenamed) {
                System.out.println(String.format("Renamed this file %s to  %s", image.getName(), newName));
            } else {
                System.out.println(String.format("%s file is not renamed to %s", image.getName(), newName));
            }
        }
        catch (Exception ex) {
            LogToFile.log("sever", ex.getMessage(), ex);
        }
    }

    public boolean isThumbnail(File file) {
        String name = FilenameUtils.removeExtension((String)file.getName());
        for (String size : listsizes) {
            if (!name.endsWith(size)) continue;
            return true;
        }
        return false;
    }

    public void removeAccent(File image) {
        System.out.println(image.getAbsolutePath());
        String newName = StringUtils.stripAccents((String)image.getAbsolutePath());
        this.renameImage(image, newName);
    }

    private void copyFiles(File directory, File dest_directory) throws IOException {
        if (directory.exists() && dest_directory.exists()) {
            for (File file : directory.listFiles()) {
                boolean thumbnail;
                if (file.isDirectory() || (thumbnail = this.isThumbnail(file))) continue;
                File filedest = new File(dest_directory + File.separator + file.getName());
                FileUtils.copyFile((File)file, (File)filedest);
            }
        }
    }
}

