/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.util;

import com.openbravo.pos.util.LogToFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;

public class FileLoaderUtils {
    public File loadFile(String path) {
        try {
            InputStream in = ClassLoader.getSystemClassLoader().getResourceAsStream(path);
            if (in == null) {
                return null;
            }
            File tempFile = File.createTempFile(String.valueOf(in.hashCode()), ".tmp");
            tempFile.deleteOnExit();
            try (FileOutputStream out = new FileOutputStream(tempFile);){
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
            return tempFile;
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            return null;
        }
    }
}

