/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.util;

import com.openbravo.pos.util.DateUtils;
import java.text.ParseException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Event {
    private int id;
    private int codeEvent;
    private String descriptif;
    private String codeOperator;
    private String typeDonnes;
    private long horodatage;
    private String informations;
    private String signature;
    private String codeCaisse;

    public Event(int codeEvent, String descriptif, String codeOperator, String typeDonnes, long horodatage, String informations) {
        this.codeEvent = codeEvent;
        this.descriptif = descriptif;
        this.codeOperator = codeOperator;
        this.horodatage = horodatage;
        this.informations = (String)(typeDonnes != null && !typeDonnes.isEmpty() ? typeDonnes + ": " : "") + (!informations.isEmpty() ? informations : "");
        this.codeCaisse = "1";
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("");
        builder.append(this.id);
        builder.append(",");
        builder.append(this.codeEvent);
        builder.append(",");
        builder.append(this.descriptif);
        builder.append(",");
        builder.append(this.codeOperator);
        builder.append(",");
        builder.append(DateUtils.SDF_DATE_SIGNATURE.format(new Date(this.horodatage)));
        builder.append(",");
        builder.append(this.informations);
        if (this.codeCaisse != null) {
            builder.append(",");
            builder.append(this.codeCaisse);
        }
        return builder.toString();
    }

    public String getEmprinte() {
        StringBuilder builder = new StringBuilder("");
        builder.append(this.id);
        builder.append(",");
        builder.append(this.codeEvent);
        builder.append(",");
        builder.append(this.informations);
        builder.append(",");
        builder.append(DateUtils.SDF_DATE_SIGNATURE.format(new Date(this.horodatage)));
        builder.append(",");
        builder.append(this.codeOperator);
        if (this.codeCaisse != null) {
            builder.append(",");
            builder.append(this.codeCaisse);
        }
        return builder.toString();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Event(String event) {
        try {
            if (event != null && !event.isEmpty()) {
                String[] tab = event.split(",");
                this.id = Integer.valueOf(tab[0]);
                this.codeEvent = Integer.valueOf(tab[1]);
                this.descriptif = tab[2];
                this.codeOperator = tab[3];
                this.horodatage = DateUtils.SDF_DATE_SIGNATURE.parse(tab[4]).getTime();
                this.informations = tab[5];
                if (tab.length > 6) {
                    this.signature = tab[6];
                }
                if (tab.length > 7) {
                    this.codeCaisse = tab[7];
                }
            }
        }
        catch (ParseException ex) {
            Logger.getLogger(Event.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getMsgIntegrityError() {
        StringBuilder builder = new StringBuilder("\u00e9v\u00e9nement du Journal :{ID :");
        builder.append(this.id);
        builder.append(", Code: ");
        builder.append(this.codeEvent);
        builder.append(", Descriptif: ");
        builder.append(this.descriptif);
        builder.append(",Horodatage: ");
        builder.append(DateUtils.SDF_ID_DAY_PERIOD.format(new Date(this.horodatage)));
        builder.append(", Operateur: ");
        builder.append(this.codeOperator + " }");
        return builder.toString();
    }

    public String getDescriptif() {
        return this.descriptif;
    }

    public void setDescriptif(String descriptif) {
        this.descriptif = descriptif;
    }

    public long getHorodatage() {
        return this.horodatage;
    }

    public void setHorodatage(long horodatage) {
        this.horodatage = horodatage;
    }

    public String getCodeCaisse() {
        return this.codeCaisse;
    }

    public void setCodeCaisse(String codeCaisse) {
        this.codeCaisse = codeCaisse;
    }

    public String getLineJETFile(String signature) {
        StringBuilder builder = new StringBuilder("");
        builder.append(this.id);
        builder.append(",");
        builder.append(this.codeEvent);
        builder.append(",");
        builder.append(this.descriptif);
        builder.append(",");
        builder.append(this.codeOperator);
        builder.append(",");
        builder.append(DateUtils.SDF_DATE_SIGNATURE.format(new Date(this.horodatage)));
        builder.append(",");
        builder.append(this.informations);
        builder.append(",");
        builder.append(signature);
        if (this.codeCaisse != null) {
            builder.append(",");
            builder.append(this.codeCaisse);
        }
        return builder.toString();
    }
}

