/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.util;

import com.openbravo.pos.util.LogToFile;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DateUtils {
    public static final String FORMAT_HOUR_24 = "HH";
    public static final String FORMAT_DAY_7 = "EEEE";
    public static final String FORMAT_DAY_31 = "dd";
    public static final String FORMAT_MONTH = "MMMM";
    public static final String FORMAT_YEAR = "yyyy";
    public static final String FORMAT_YEAR2 = "yy";
    public static final int CLOTURE_HOUR = 6;
    public static final int CLOTURE_MINUTES = 0;
    public static final int CLOTURE_SECONDES = 0;
    public static final SimpleDateFormat formatterDayMonthYearForBar = new SimpleDateFormat("ddMMYY");
    public static final SimpleDateFormat FORMATTER_DATE_TIME_T = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    public static final SimpleDateFormat FORMATTER_DATE_TIME_ZONE = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    public static final SimpleDateFormat FORMATTER_DATE_TIME_ZONE_SSS = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    public static final SimpleDateFormat FORMATTER_DATE_TIME = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    public static final SimpleDateFormat FORMATTER_DATE_HOUR = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    public static final String FORMAT_DATE_FRENCH = "dd-MM-yyyy";
    public static final SimpleDateFormat formatterDayMonthYear = new SimpleDateFormat("dd-MM-yyyy");
    public static final SimpleDateFormat formatterDAY_MONTH_YEAR_SLASHES = new SimpleDateFormat("dd/MM/yyyy");
    public static final SimpleDateFormat formatterYEAR_MONTH_DAY_TIRETS6 = new SimpleDateFormat("YYYY-MM-dd");
    public static final String FORMAT_SIGNATURE_DATE = "yyyyMMddHHmmss";
    public static final String FORMAT_DAY_PERIOD = "yyyyMMdd";
    public static final String FORMAT_MONTH_PERIOD = "yyyyMM";
    public static final String FORMAT_YEAR_PERIOD = "yyyy";
    public static final SimpleDateFormat timeFormatter = new SimpleDateFormat("HH:mm");
    public static final SimpleDateFormat SDF_FULL_DATE_TIME = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final SimpleDateFormat SDF_DATE_SIGNATURE = new SimpleDateFormat("yyyyMMddHHmmss");
    public static final SimpleDateFormat SDF_YYYYMMDD;
    public static final SimpleDateFormat SDF_ID_DAY_PERIOD;
    public static final SimpleDateFormat SDF_ID_MONTH_PERIOD;
    public static final SimpleDateFormat SDF_ID_YEAR_PERIOD;
    public static final SimpleDateFormat timeFormatterWithoutSep;
    public static Date START_DATE;
    public static final String FORMAT_YEAR_MONTH_DAY = "YYYY-MM-dd";
    public static final String FORMAT_YEAR_MONTH = "MM-yyyy";
    public static final SimpleDateFormat formatterMonthYear;

    public static Date asDate(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date asDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate asLocalDate(Date date) {
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDateTime asLocalDateTime(Date date) {
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static void setTimeToBeginningOfDay(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    public static void setTimeToBeginningOfDay(Date date) {
        date.setHours(0);
        date.setMinutes(0);
        date.setSeconds(0);
    }

    public static void setTimeToEndofDay(Calendar calendar) {
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
    }

    public static void setTimeToEndofDay(Date date) {
        date.setHours(23);
        date.setMinutes(59);
        date.setSeconds(59);
    }

    public static String formatHour(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_HOUR_24);
        return sdf.format(date);
    }

    public static String formatDay(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_DAY_7);
        return sdf.format(date);
    }

    public static String formatDay(Date date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static String formatMonth(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_MONTH);
        return sdf.format(date);
    }

    public static String formatYear(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        return sdf.format(date);
    }

    public static String formatYear2(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_YEAR2);
        return sdf.format(date);
    }

    public static void fillHours(Map<String, Long> m_data, Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        for (int i = 0; i <= 23; ++i) {
            calendar.set(11, i);
            m_data.put(DateUtils.formatHour(calendar.getTime()), calendar.getTimeInMillis());
        }
    }

    public static void fillHoursBetweenTwoDates(Map<String, Long> m_data, Date dateStart, Date dateEnd) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateStart);
        while (calendar.getTime().before(dateEnd)) {
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            Object key = DateUtils.formatHour(calendar.getTime());
            if (m_data.containsKey(key)) {
                key = "(" + calendar.getTime().getDate() + ")" + (String)key;
            }
            m_data.put((String)key, calendar.getTimeInMillis());
            calendar.add(11, 1);
        }
    }

    public static void fillDaysOfWeek(Map<String, Long> m_data, Date date_start, Date date_end) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date_start);
        while (calendar.getTime().before(date_end)) {
            Date day = calendar.getTime();
            m_data.put(DateUtils.formatDay(day, FORMAT_DAY_7), calendar.getTimeInMillis());
            calendar.add(5, 1);
        }
    }

    public static void fillDaysOfMonth(Map<String, Long> m_data, Date date_start, Date date_end) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date_start);
        while (calendar.getTime().before(date_end)) {
            Date day = calendar.getTime();
            m_data.put(DateUtils.formatDay(day, FORMAT_DAY_31), calendar.getTimeInMillis());
            calendar.add(5, 1);
        }
    }

    public static void fillMonthsOfYear(Map<String, Long> m_data, Date date_start, Date date_end) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date_start);
        while (calendar.getTime().before(date_end)) {
            Date day = calendar.getTime();
            m_data.put(DateUtils.formatMonth(day), calendar.getTimeInMillis());
            calendar.add(2, 1);
        }
    }

    public static String getDayOfWeek(Date d) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        int day = calendar.get(7);
        switch (day) {
            case 1: {
                return "dimanche";
            }
            case 2: {
                return "lundi";
            }
            case 3: {
                return "mardi";
            }
            case 4: {
                return "mercredi";
            }
            case 5: {
                return "jeudi";
            }
            case 6: {
                return "vendredi";
            }
            case 7: {
                return "samedi";
            }
        }
        return "dimanche";
    }

    public static String getNameOfMonth(int month) {
        switch (month) {
            case 1: {
                return "Janvier";
            }
            case 2: {
                return "F\u00e9vrier";
            }
            case 3: {
                return "Mars";
            }
            case 4: {
                return "Avril";
            }
            case 5: {
                return "Mai";
            }
            case 6: {
                return "Juin";
            }
            case 7: {
                return "Juillet";
            }
            case 8: {
                return "Aout";
            }
            case 9: {
                return "Septembre";
            }
            case 10: {
                return "Octobre";
            }
            case 11: {
                return "Novembre";
            }
            case 12: {
                return "D\u00e9cembre";
            }
        }
        return "";
    }

    public static String now() {
        return "" + new Date().getTime();
    }

    public static boolean isAfterHour(Date date, int hour) {
        return date.getHours() >= hour;
    }

    public static String formatDateForBarCode(Date date) {
        return formatterDayMonthYearForBar.format(date);
    }

    public static String formatDate(Date date) {
        return formatterDayMonthYear.format(date);
    }

    public static Date getDateFromString(String dateString) {
        Date date = new Date();
        try {
            SimpleDateFormat formatter = dateString.length() == 8 ? new SimpleDateFormat(FORMAT_DAY_PERIOD) : (dateString.length() == 6 ? new SimpleDateFormat(FORMAT_MONTH_PERIOD) : new SimpleDateFormat("yyyy"));
            date = formatter.parse(dateString);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return date;
    }

    public static boolean isToday(Date d) {
        Date today = new Date();
        return today.getYear() == d.getYear() && today.getMonth() == d.getMonth() && today.getDate() == d.getDate();
    }

    public static Date validateDateFormat(String dateToValdate, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        formatter.setLenient(false);
        Date parsedDate = null;
        try {
            parsedDate = formatter.parse(dateToValdate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return parsedDate;
    }

    public static Date asDateFromString(String mDate, String mFromatString) {
        Date date = null;
        SimpleDateFormat formatter = new SimpleDateFormat(mFromatString);
        try {
            date = formatter.parse(mDate);
        }
        catch (ParseException ex) {
            Logger.getLogger(DateUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
        return date;
    }

    public static Date asDateFromString(String mDate) {
        return DateUtils.asDateFromString(mDate, FORMAT_DATE_FRENCH);
    }

    public static void setDateHours(Date dateStart, Date dateEnd) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateStart);
        calendar.set(11, 6);
        calendar.set(12, 0);
        calendar.set(13, 0);
        dateStart.setTime(calendar.getTime().getTime());
        calendar.add(5, 1);
        calendar.set(11, 6);
        calendar.set(12, 0);
        calendar.set(13, 0);
        dateEnd.setTime(calendar.getTime().getTime());
    }

    public static String fromCalendar(Calendar calendar) {
        Date date = calendar.getTime();
        String formatted = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").format(date);
        return formatted.substring(0, 22) + ":" + formatted.substring(22);
    }

    public static Calendar toCalendar(String iso8601string) throws ParseException {
        Calendar calendar = GregorianCalendar.getInstance();
        Date date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(iso8601string);
        calendar.setTime(date);
        return calendar;
    }

    public static void setValidDate(Date date) {
    }

    public static String formatMonth(String month) {
        return month.length() == 1 ? "0" + month : month;
    }

    public static int getTimeElapsed(long time_order) {
        long diff = new Date().getTime() - time_order;
        long minutes = TimeUnit.MILLISECONDS.toMinutes(diff);
        return (int)minutes;
    }

    public static Date getDateByText(String text_date) throws ParseException {
        Date date = null;
        if (text_date.length() > 20) {
            int index_plus_zone = text_date.indexOf("+");
            if (index_plus_zone != -1) {
                String taxt_date_extract = text_date.substring(0, index_plus_zone);
                date = FORMATTER_DATE_TIME_T.parse(taxt_date_extract);
            } else {
                int index_minus_zone = text_date.lastIndexOf("-");
                if (index_minus_zone != -1) {
                    String taxt_date_extract = text_date.substring(0, index_minus_zone);
                    date = FORMATTER_DATE_TIME_T.parse(taxt_date_extract);
                } else {
                    date = FORMATTER_DATE_TIME_ZONE_SSS.parse(text_date);
                }
            }
        } else {
            date = FORMATTER_DATE_TIME_ZONE.parse(text_date);
        }
        return date;
    }

    public static void addHours(Date date, int hours) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(10, hours);
        date.setTime(calendar.getTime().getTime());
    }

    public static Date addDays(Date date, int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, days);
        date.setTime(calendar.getTime().getTime());
        return date;
    }

    public static int getDiffTime(long time1, long time2) {
        long diff = time2 - time1;
        long seconds = TimeUnit.MILLISECONDS.toSeconds(diff);
        return (int)seconds;
    }

    public static void addMinutes(Date date, int min) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(12, min);
        date.setTime(calendar.getTime().getTime());
    }

    public static boolean isDateValid(int year, int month, int day) {
        boolean dateIsValid = true;
        try {
            LocalDate.of(year, month, day);
        }
        catch (DateTimeException e) {
            dateIsValid = false;
        }
        return dateIsValid;
    }

    public static int getAgeFromDate(int year, int month, int day) {
        LocalDate l = LocalDate.of(year, month, day);
        LocalDate now = LocalDate.now();
        Period diff = Period.between(l, now);
        System.out.println("++++++++++++++++ diff.getYears() : " + diff.getYears());
        return diff.getYears();
    }

    public static void setDateMonths(Date dateStart, Date dateEnd) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateStart);
        calendar.set(11, 6);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(5, 1);
        dateStart.setTime(calendar.getTime().getTime());
        calendar.add(2, 1);
        calendar.set(11, 6);
        calendar.set(12, 0);
        calendar.set(13, 0);
        dateEnd.setTime(calendar.getTime().getTime());
    }

    public static void setDateYears(Date dateStart, Date dateEnd) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateStart);
        calendar.set(11, 6);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(5, 1);
        calendar.set(2, 0);
        dateStart.setTime(calendar.getTime().getTime());
        calendar.add(1, 1);
        calendar.set(11, 6);
        calendar.set(12, 0);
        calendar.set(13, 0);
        dateEnd.setTime(calendar.getTime().getTime());
    }

    public static void setDateWeek(Date dateStart, Date dateEnd) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateStart);
        calendar.set(11, 6);
        calendar.set(12, 0);
        calendar.set(13, 0);
        dateStart.setTime(calendar.getTime().getTime());
        calendar.add(5, 7);
        calendar.set(11, 6);
        calendar.set(12, 0);
        calendar.set(13, 0);
        dateEnd.setTime(calendar.getTime().getTime());
    }

    public static void setDateStart(Date dateStart) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateStart);
        calendar.set(11, 6);
        calendar.set(12, 0);
        calendar.set(13, 0);
        dateStart.setTime(calendar.getTime().getTime());
    }

    public static int getDayOfWeek() {
        LocalDate localDate = LocalDate.now();
        DayOfWeek dayOfWeek = DayOfWeek.from(localDate);
        if (DayOfWeek.SUNDAY.getValue() == dayOfWeek.getValue()) {
            return 0;
        }
        if (DayOfWeek.MONDAY.getValue() == dayOfWeek.getValue()) {
            return 1;
        }
        if (DayOfWeek.TUESDAY.getValue() == dayOfWeek.getValue()) {
            return 2;
        }
        if (DayOfWeek.WEDNESDAY.getValue() == dayOfWeek.getValue()) {
            return 3;
        }
        if (DayOfWeek.THURSDAY.getValue() == dayOfWeek.getValue()) {
            return 4;
        }
        if (DayOfWeek.FRIDAY.getValue() == dayOfWeek.getValue()) {
            return 5;
        }
        if (DayOfWeek.SATURDAY.getValue() == dayOfWeek.getValue()) {
            return 6;
        }
        return 0;
    }

    public static Date parseDateTime(String dateString) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
        LocalDateTime dateTime = LocalDateTime.parse(dateString, formatter);
        ZoneId zoneId = ZoneId.systemDefault();
        Instant instant = dateTime.atZone(zoneId).toInstant();
        Date date = Date.from(instant);
        return date;
    }

    public static boolean isCurrentTimeBetween(String startTimeStr, String endTimeStr) {
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm");
            LocalTime startTime = LocalTime.parse(startTimeStr, formatter);
            LocalTime endTime = LocalTime.parse(endTimeStr, formatter);
            LocalTime now = LocalTime.now();
            if (startTime.isBefore(endTime)) {
                return !now.isBefore(startTime) && !now.isAfter(endTime);
            }
            return !now.isBefore(startTime) || !now.isAfter(endTime);
        }
        catch (Exception ex) {
            return false;
        }
    }

    static {
        SDF_ID_DAY_PERIOD = SDF_YYYYMMDD = new SimpleDateFormat(FORMAT_DAY_PERIOD);
        SDF_ID_MONTH_PERIOD = new SimpleDateFormat(FORMAT_MONTH_PERIOD);
        SDF_ID_YEAR_PERIOD = new SimpleDateFormat("yyyy");
        timeFormatterWithoutSep = new SimpleDateFormat("HHmm");
        formatterMonthYear = new SimpleDateFormat(FORMAT_YEAR_MONTH);
    }
}

