/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.util;

import javafx.scene.paint.Color;

public class ColorUtils {
    public static String getColor(String valColor) {
        if (valColor != null && !valColor.isEmpty()) {
            String[] tabColor = valColor.split(",");
            java.awt.Color color = new java.awt.Color(Integer.parseInt(tabColor[0].trim()), Integer.parseInt(tabColor[1].trim()), Integer.parseInt(tabColor[2].trim()));
            Object hex = Integer.toHexString(color.getRGB() & 0xFFFFFF);
            if (((String)hex).length() < 6) {
                int length = 6 - ((String)hex).length();
                for (int h = 0; h < length; ++h) {
                    hex = "0" + (String)hex;
                }
            }
            hex = "#" + (String)hex;
            return hex;
        }
        return null;
    }

    public static java.awt.Color ColorLuminance(java.awt.Color originalColour) {
        float[] hsbVals = java.awt.Color.RGBtoHSB(originalColour.getRed(), originalColour.getGreen(), originalColour.getBlue(), null);
        java.awt.Color highlight = java.awt.Color.getHSBColor(hsbVals[0], hsbVals[1], 0.5f * (1.0f + hsbVals[2]));
        return highlight;
    }

    public static java.awt.Color getColorByString(String color) {
        String[] tabColor = color.split(",");
        return new java.awt.Color(Integer.parseInt(tabColor[0].trim()), Integer.parseInt(tabColor[1].trim()), Integer.parseInt(tabColor[2].trim()));
    }

    public static String getColorText(java.awt.Color color) {
        return color.getRed() + "," + color.getGreen() + "," + color.getBlue();
    }

    public static String getColorLight(String valColor, double alpha) {
        if (valColor != null && !valColor.isEmpty()) {
            String[] tabColor = valColor.split(",");
            Color color = new Color(Double.parseDouble(tabColor[0].trim()) / 255.0, Double.parseDouble(tabColor[1].trim()) / 255.0, Double.parseDouble(tabColor[2].trim()) / 255.0, alpha);
            return color.toString().replace("0x", "#");
        }
        return null;
    }

    public static String getHexadecimal(java.awt.Color color) {
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    public static java.awt.Color increaseSaturation(java.awt.Color originalColour) {
        float[] hsbVals = java.awt.Color.RGBtoHSB(originalColour.getRed(), originalColour.getGreen(), originalColour.getBlue(), null);
        float hue = hsbVals[0];
        float saturation = hsbVals[1];
        float brightness = hsbVals[2];
        hue = Math.max(0.0f, hue - 0.043f);
        return java.awt.Color.getHSBColor(hue, saturation *= 0.9f, brightness *= 0.9f);
    }
}

