/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.util;

import com.openbravo.beans.DateUtils;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import java.util.Calendar;
import java.util.Date;
import javafx.scene.control.Button;
import javafx.scene.control.Label;

public class CalendarUtils {
    private Date date;
    Button btn_next_date;
    Button btn_previous_date;
    Label jdate;

    public CalendarUtils(Date date, Button btn_next_date, Button btn_previous_date, Label jdate, Date dateStart, Date dateEnd) {
        this.date = date;
        this.btn_next_date = btn_next_date;
        this.btn_previous_date = btn_previous_date;
        this.jdate = jdate;
        this.init(dateStart, dateEnd);
    }

    public void init(Date dateStart, Date dateEnd) {
        Calendar calToday = Calendar.getInstance();
        if (calToday.getTime().getHours() >= 0 && calToday.getTime().getHours() <= AppLocal.dateEnd) {
            calToday.setTime(this.date);
            calToday.add(6, -1);
            this.date = calToday.getTime();
        }
        this.jdate.setText("Aujourd'hui");
        this.setTime(this.date, dateStart, dateEnd);
    }

    public void next(Date dateStart, Date dateEnd) {
        Calendar cal = Calendar.getInstance();
        Calendar today = Calendar.getInstance();
        cal.setTime(this.date);
        cal.add(5, 1);
        Calendar yesterday = Calendar.getInstance();
        yesterday.setTime(DateUtils.getToday());
        yesterday.add(5, -1);
        this.jdate.setText(Formats.DATE.formatValue(cal.getTime()));
        if (today.getTime().getHours() >= 0 && today.getTime().getHours() <= AppLocal.dateEnd) {
            yesterday.add(6, -1);
            today.add(6, -1);
        }
        if (today.getTime().getYear() == cal.getTime().getYear() && today.getTime().getMonth() == cal.getTime().getMonth() && today.getTime().getDate() == cal.getTime().getDate()) {
            this.btn_next_date.setVisible(false);
            this.jdate.setText("Aujourd'hui");
        } else {
            this.btn_next_date.setVisible(true);
        }
        if (yesterday.getTime().getYear() == cal.getTime().getYear() && yesterday.getTime().getMonth() == cal.getTime().getMonth() && yesterday.getTime().getDate() == cal.getTime().getDate()) {
            this.jdate.setText("Hier");
        }
        this.date = cal.getTime();
        this.setTime(this.date, dateStart, dateEnd);
    }

    public void previous(Date dateStart, Date dateEnd) {
        Calendar cal = Calendar.getInstance();
        Calendar today = Calendar.getInstance();
        cal.setTime(this.date);
        cal.add(5, -1);
        Calendar yesterday = Calendar.getInstance();
        yesterday.setTime(DateUtils.getToday());
        yesterday.add(5, -1);
        if (today.getTime().getHours() >= 0 && today.getTime().getHours() <= AppLocal.dateEnd) {
            yesterday.add(6, -1);
            today.add(6, -1);
        }
        this.jdate.setText(Formats.DATE.formatValue(cal.getTime()));
        if (today.getTime().getYear() == cal.getTime().getYear() && today.getTime().getMonth() == cal.getTime().getMonth() && today.getTime().getDate() == cal.getTime().getDate()) {
            this.btn_next_date.setVisible(false);
            this.jdate.setText("Aujourd'hui");
        } else {
            this.btn_next_date.setVisible(true);
        }
        if (yesterday.getTime().getYear() == cal.getTime().getYear() && yesterday.getTime().getMonth() == cal.getTime().getMonth() && yesterday.getTime().getDate() == cal.getTime().getDate()) {
            this.jdate.setText("Hier");
        }
        this.date = cal.getTime();
        this.setTime(this.date, dateStart, dateEnd);
    }

    public void setTime(Date date, Date dateStart, Date dateEnd) {
        Calendar calStart = Calendar.getInstance();
        calStart.setTime(date);
        calStart.add(11, AppLocal.dateStart);
        calStart.getTime();
        dateStart = calStart.getTime();
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(date);
        if (AppLocal.dateStart >= AppLocal.dateEnd) {
            calEnd.add(11, AppLocal.dateEnd + 24);
        } else {
            calEnd.add(11, AppLocal.dateEnd);
        }
        calEnd.getTime();
        dateEnd = calEnd.getTime();
        System.out.println("++++++++++ dateEnd setTime ********************* : " + dateEnd);
        System.out.println("++++++++++ dateStart  setTime********************* : " + dateStart);
    }
}

