/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.util;

import com.openbravo.pos.util.Event;
import com.openbravo.pos.util.Journal;
import com.openbravo.pos.util.SignatureGenerator;
import com.openbravo.service.ArchivageService;
import fr.protactile.norm.beans.EnteteInfo;
import fr.protactile.norm.beans.GrandTotalTicket;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;

public class CSVUtil {
    private static void writeLineToCSVFile(File file, List lignes, boolean append) throws IOException {
        ArrayList<String> l = new ArrayList<String>();
        for (Object ligne : lignes) {
            l.add(ligne.toString());
        }
        FileUtils.writeLines((File)file, (String)"UTF-8", l, (boolean)append);
    }

    public static void writeStringsToCSVFile(File file, List lignes, boolean append) throws IOException {
        CSVUtil.writeLineToCSVFile(file, lignes, append);
    }

    public static void writeStringsToCSVFile(File file, List lignes) throws IOException {
        CSVUtil.writeLineToCSVFile(file, lignes, true);
    }

    public static void writeStringsToCSVFile(File file, List lignes, String entete) throws IOException {
        CSVUtil.writeStringsToCSVFile(file, lignes, entete, false);
    }

    public static void writeSignedStringsToCSVFile(File file, List<GrandTotalTicket> lignes, String entete, String idUser, List<String> errors) throws IOException {
        ArrayList<String> l = new ArrayList<String>();
        l.add(entete);
        boolean isFirst = true;
        if (lignes.size() > 0) {
            GrandTotalTicket previousSigned = lignes.get(0);
            for (GrandTotalTicket ligne : lignes) {
                String emprinte;
                boolean verify;
                l.add(ligne.toString());
                if (!isFirst && !(verify = CSVUtil.verifySignature(emprinte = ligne.getEmprinteWithoutPreviousSignature() + ",O," + previousSigned.getSignature(), ligne.getSignature(), ligne.getTimestampGDH()))) {
                    Journal.writeToJET(new Event(90, "D\u00e9tection d'un d\u00e9faut d'int\u00e9grit\u00e9", idUser, "Table contenant le d\u00e9faut", new Date().getTime(), ligne.getIdAndTable()));
                    errors.add("GRAND_TOTAL_TICKET :{" + ligne.toString() + "}");
                }
                isFirst = false;
                previousSigned = ligne;
            }
        }
        if (file.exists()) {
            FileUtils.writeLines((File)file, l);
        }
    }

    public static void writeStringsToCSVFile(File file, List lignes, String entete, boolean enteteNote) throws IOException {
        ArrayList<String> l = new ArrayList<String>();
        l.add(entete);
        for (Object ligne : lignes) {
            if (enteteNote && ligne instanceof EnteteInfo) {
                l.add(((EnteteInfo)ligne).toStringNote());
                continue;
            }
            l.add(ligne.toString());
        }
        try {
            if (file != null && file.exists()) {
                FileUtils.writeLines((File)file, (String)"UTF-16", l);
            }
            FileUtils.writeLines((File)file, (String)"UTF-16", l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean verifySignature(String data, String signature, Date dateSignature) {
        try {
            SignatureGenerator generator = SignatureGenerator.getGenerator();
            return generator.verifySignature(data, signature, dateSignature);
        }
        catch (Exception ex) {
            Logger.getLogger(ArchivageService.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }
}

