/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class BarCodeValidator {
    static Pattern pattern_digit = Pattern.compile("\\d+");

    private static int parseCharToInt(String s) {
        return Integer.parseInt(s);
    }

    private static String reverseString(String str) {
        return new StringBuilder(str).reverse().toString();
    }

    private static String[] reverseString(String[] strs) {
        List<String> list = Arrays.asList(strs);
        Collections.reverse(list);
        return (String[])list.toArray();
    }

    public static boolean isValidBarcode(String barcode) {
        if (barcode.length() < 8 || barcode.length() > 18 || barcode.length() != 8 && barcode.length() != 12 && barcode.length() != 13 && barcode.length() != 14 && barcode.length() != 18) {
            return false;
        }
        int lastDigit = BarCodeValidator.parseCharToInt(barcode.substring(barcode.length() - 1));
        int checkSum = 0;
        if (!pattern_digit.matcher("" + lastDigit).matches()) {
            return false;
        }
        String[] arr = BarCodeValidator.reverseString(barcode.substring(0, barcode.length() - 1).split(""));
        int oddTotal = 0;
        int evenTotal = 0;
        for (int i = 0; i < arr.length; ++i) {
            String string = arr[i];
            if (!pattern_digit.matcher(string).matches()) {
                return false;
            }
            if (i % 2 == 0) {
                oddTotal += BarCodeValidator.parseCharToInt(arr[i]) * 3;
                continue;
            }
            evenTotal += BarCodeValidator.parseCharToInt(arr[i]);
        }
        checkSum = (10 - (evenTotal + oddTotal) % 10) % 10;
        return checkSum == lastDigit;
    }

    public static boolean isFulled(String barcode) {
        return barcode != null && !barcode.equals("") && barcode.length() > 1;
    }
}

