/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.util;

import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortEvent;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.util.LogToFile;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import javafx.application.Platform;
import javafx.scene.control.Button;

public class BalanceListener
extends Thread
implements SerialPortDataListener {
    private SerialPort serialPort;
    private BufferedReader fluxLecture;
    private boolean running;
    private Button destination;
    private Double weight;

    public BalanceListener(String port, Button destination, Double weight) {
        this.destination = destination;
        this.weight = weight;
        this.serialPort = SerialPort.getCommPort((String)port);
        if (this.serialPort != null) {
            this.serialPort.openPort();
            InputStream input = this.serialPort.getInputStream();
            if (input != null) {
                try {
                    this.fluxLecture = new BufferedReader(new InputStreamReader(input));
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
                try {
                    boolean ex = this.serialPort.addDataListener((SerialPortDataListener)this);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
                try {
                    this.serialPort.setComPortParameters(9600, 7, 1, 2);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            } else {
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Erreur de connexion \u00e0 la balance.", 4000, NPosition.BOTTOM_RIGHT);
            }
        }
    }

    @Override
    public void run() {
        this.running = true;
        while (this.running) {
            try {
                Thread.sleep(3000L);
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                BalanceListener.this.destination.setText("");
                BalanceListener.this.weight = 0.0;
            }
        });
        try {
            if (this.fluxLecture != null) {
                this.fluxLecture.close();
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        if (this.serialPort != null) {
            this.serialPort.closePort();
        }
    }

    public void stopThread() {
        this.running = false;
    }

    public int getListeningEvents() {
        return 1;
    }

    public void serialEvent(SerialPortEvent event) {
        if (event.getEventType() != 1) {
            return;
        }
        try {
            byte[] newData = new byte[this.serialPort.bytesAvailable()];
            int numRead = this.serialPort.readBytes(newData, (long)newData.length);
            if (numRead > 0) {
                String poids = new String(newData);
                System.out.println("++++++++ poids : " + poids);
                if (poids.contains("kg") || poids.contains("Kg")) {
                    String poidsWithUnit = poids.trim();
                    String poidsWithoutUnit = poidsWithUnit.replace("kg", "").replace("Kg", "").trim();
                    System.out.println("++++++++ poidsWithoutUnit : " + poidsWithoutUnit);
                    final String poidsAsDigit = poidsWithoutUnit.replaceAll("[^0-9?!\\.]", "");
                    System.out.println("++++++++ poidsAsDigit : " + poidsAsDigit);
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Double d = Double.valueOf(poidsAsDigit);
                                BalanceListener.this.destination.setText(d + " Kg");
                                BalanceListener.this.weight = d;
                            }
                            catch (NumberFormatException ex) {
                                LogToFile.log("severe", ex.getMessage(), ex);
                            }
                        }
                    });
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }
}

