/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.util;

import com.openbravo.pos.util.LogToFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.net.ftp.FTPClient;
import org.json.JSONObject;

public class BackupUtils {
    private String url_create_usee_ftp = "http://78.141.221.251:5000/create_ftp_user";
    private String url_directory_backup = "C:\\Program Files\\Biborne Tools\\FTP Backup";
    private String server = "ftpbackup6.biborne.com";
    private int port = 21;

    public boolean createUserFTP(String userName, String userPassword) {
        Response response = null;
        try {
            JSONObject jsonBody = new JSONObject();
            jsonBody.put("username", (Object)userName);
            jsonBody.put("password", (Object)userPassword);
            OkHttpClient client = new OkHttpClient();
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonBody.toString());
            Request request = new Request.Builder().url(this.url_create_usee_ftp).post(requestBody).addHeader("Content-Type", "application/json").build();
            response = client.newCall(request).execute();
            System.out.println("response createUserFTP************* : " + response);
            if (response.code() == 201) {
                response.close();
                return true;
            }
        }
        catch (IOException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        if (response != null) {
            response.close();
        }
        boolean checkAccount = this.checkFTPAccount(userName, userPassword);
        return checkAccount;
    }

    public void addInfosAccessToConfig(String userName, String userPassword) {
        try {
            String setup_path = this.url_directory_backup + File.separator + "setup.bat";
            String[] batch_params = new String[]{"-username", userName, "-password", userPassword};
            ArrayList<String> command = new ArrayList<String>();
            command.add(setup_path);
            command.addAll(Arrays.asList(batch_params));
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.command(command);
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            System.out.println("exitCode : " + exitCode);
            System.out.println("++++ end addInfosAccessToConfig");
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void createBackupTask() {
        try {
            System.out.println("++++ start createBackupTask");
            String batch_file_path = this.url_directory_backup + File.separator + "schedule_task.bat";
            String[] batch_params = new String[]{"-silent", "-at", "2:00am"};
            ArrayList<String> command = new ArrayList<String>();
            command.add(batch_file_path);
            command.addAll(Arrays.asList(batch_params));
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.command(command);
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            System.out.println("exitCode : " + exitCode);
            System.out.println("++++ end createBackupTask");
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkFTPAccount(String userName, String password) {
        FTPClient ftpClient = new FTPClient();
        boolean success = false;
        try {
            ftpClient.connect(this.server, this.port);
            success = ftpClient.login(userName, password);
            System.out.println("success checkFTPAccount : " + success);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                ftpClient.disconnect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return success;
    }

    public void createBackup() {
        try {
            System.out.println("++++ start createBackupTask at MAJ");
            String batch_file_path = this.url_directory_backup + File.separator + "ftpbackup.bat";
            String[] batch_params = new String[]{"-silent"};
            ArrayList<String> command = new ArrayList<String>();
            command.add(batch_file_path);
            command.addAll(Arrays.asList(batch_params));
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.command(command);
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            System.out.println("exitCode : " + exitCode);
            System.out.println("++++ end createBackup At MAJ");
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }
}

