/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.util;

import com.openbravo.pos.util.SuggestionLabel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AutoSuggestor {
    private final JTextField textField;
    private final Window container;
    private JPanel suggestionsPanel;
    private JWindow autoSuggestionPopUpWindow;
    private String typedWord;
    private final ArrayList<String> dictionary = new ArrayList();
    private int currentIndexOfSpace;
    private int tW;
    private int tH;
    private DocumentListener documentListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent de) {
            AutoSuggestor.this.checkForAndShowSuggestions();
        }

        @Override
        public void removeUpdate(DocumentEvent de) {
            AutoSuggestor.this.checkForAndShowSuggestions();
        }

        @Override
        public void changedUpdate(DocumentEvent de) {
            AutoSuggestor.this.checkForAndShowSuggestions();
        }
    };
    private final Color suggestionsTextColor;
    private final Color suggestionFocusedColor;

    public AutoSuggestor(JTextField textField, Window mainWindow, ArrayList<String> words, Color popUpBackground, Color textColor, Color suggestionFocusedColor, float opacity) {
        this.textField = textField;
        this.suggestionsTextColor = textColor;
        this.container = mainWindow;
        this.suggestionFocusedColor = suggestionFocusedColor;
        this.textField.getDocument().addDocumentListener(this.documentListener);
        this.setDictionary(words);
        this.typedWord = "";
        this.currentIndexOfSpace = 0;
        this.tW = 0;
        this.tH = 0;
        this.autoSuggestionPopUpWindow = new JWindow(mainWindow);
        this.autoSuggestionPopUpWindow.setOpacity(opacity);
        this.suggestionsPanel = new JPanel();
        this.suggestionsPanel.setLayout(new GridLayout(0, 1));
        this.suggestionsPanel.setBackground(popUpBackground);
        this.addKeyBindingToRequestFocusInPopUpWindow();
    }

    private void addKeyBindingToRequestFocusInPopUpWindow() {
        this.textField.getInputMap(0).put(KeyStroke.getKeyStroke(40, 0, true), "Down released");
        this.textField.getActionMap().put("Down released", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                for (int i = 0; i < AutoSuggestor.this.suggestionsPanel.getComponentCount(); ++i) {
                    if (!(AutoSuggestor.this.suggestionsPanel.getComponent(i) instanceof SuggestionLabel)) continue;
                    ((SuggestionLabel)AutoSuggestor.this.suggestionsPanel.getComponent(i)).setFocused(true);
                    AutoSuggestor.this.autoSuggestionPopUpWindow.toFront();
                    AutoSuggestor.this.autoSuggestionPopUpWindow.requestFocusInWindow();
                    AutoSuggestor.this.suggestionsPanel.requestFocusInWindow();
                    AutoSuggestor.this.suggestionsPanel.getComponent(i).requestFocusInWindow();
                    break;
                }
            }
        });
        this.suggestionsPanel.getInputMap(1).put(KeyStroke.getKeyStroke(40, 0, true), "Down released");
        this.suggestionsPanel.getActionMap().put("Down released", new AbstractAction(){
            int lastFocusableIndex = 0;

            @Override
            public void actionPerformed(ActionEvent ae) {
                ArrayList<SuggestionLabel> sls = AutoSuggestor.this.getAddedSuggestionLabels();
                int max = sls.size();
                if (max > 1) {
                    for (int i = 0; i < max; ++i) {
                        SuggestionLabel sl = sls.get(i);
                        if (sl.isFocused()) {
                            if (this.lastFocusableIndex == max - 1) {
                                this.lastFocusableIndex = 0;
                                sl.setFocused(false);
                                AutoSuggestor.this.autoSuggestionPopUpWindow.setVisible(false);
                                AutoSuggestor.this.setFocusToTextField();
                                AutoSuggestor.this.checkForAndShowSuggestions();
                                continue;
                            }
                            sl.setFocused(false);
                            this.lastFocusableIndex = i;
                            continue;
                        }
                        if (this.lastFocusableIndex > i || i >= max) continue;
                        sl.setFocused(true);
                        AutoSuggestor.this.autoSuggestionPopUpWindow.toFront();
                        AutoSuggestor.this.autoSuggestionPopUpWindow.requestFocusInWindow();
                        AutoSuggestor.this.suggestionsPanel.requestFocusInWindow();
                        AutoSuggestor.this.suggestionsPanel.getComponent(i).requestFocusInWindow();
                        this.lastFocusableIndex = i;
                        break;
                    }
                } else {
                    AutoSuggestor.this.autoSuggestionPopUpWindow.setVisible(false);
                    AutoSuggestor.this.setFocusToTextField();
                    AutoSuggestor.this.checkForAndShowSuggestions();
                }
            }
        });
    }

    private void setFocusToTextField() {
        this.container.toFront();
        this.container.requestFocusInWindow();
        this.textField.requestFocusInWindow();
    }

    public ArrayList<SuggestionLabel> getAddedSuggestionLabels() {
        ArrayList<SuggestionLabel> sls = new ArrayList<SuggestionLabel>();
        for (int i = 0; i < this.suggestionsPanel.getComponentCount(); ++i) {
            if (!(this.suggestionsPanel.getComponent(i) instanceof SuggestionLabel)) continue;
            SuggestionLabel sl = (SuggestionLabel)this.suggestionsPanel.getComponent(i);
            sls.add(sl);
        }
        return sls;
    }

    private void checkForAndShowSuggestions() {
        this.typedWord = this.getCurrentlyTypedWord();
        this.suggestionsPanel.removeAll();
        this.tW = 0;
        this.tH = 0;
        boolean added = this.wordTyped(this.typedWord);
        if (!added) {
            if (this.autoSuggestionPopUpWindow.isVisible()) {
                this.autoSuggestionPopUpWindow.setVisible(false);
            }
        } else {
            this.showPopUpWindow();
            this.setFocusToTextField();
        }
    }

    protected void addWordToSuggestions(String word) {
        SuggestionLabel suggestionLabel = new SuggestionLabel(word, this.suggestionFocusedColor, this.suggestionsTextColor, this);
        this.calculatePopUpWindowSize(suggestionLabel);
        this.suggestionsPanel.add(suggestionLabel);
    }

    public String getCurrentlyTypedWord() {
        String text = this.textField.getText();
        String wordBeingTyped = "";
        if (text.contains(" ")) {
            int tmp = text.lastIndexOf(" ");
            if (tmp >= this.currentIndexOfSpace) {
                this.currentIndexOfSpace = tmp;
                wordBeingTyped = text.substring(text.lastIndexOf(" "));
            }
        } else {
            wordBeingTyped = text;
        }
        return wordBeingTyped.trim();
    }

    private void calculatePopUpWindowSize(JLabel label) {
        if (this.tW < label.getPreferredSize().width) {
            this.tW = label.getPreferredSize().width;
        }
        this.tH += label.getPreferredSize().height;
    }

    private void showPopUpWindow() {
        this.autoSuggestionPopUpWindow.getContentPane().add(this.suggestionsPanel);
        this.autoSuggestionPopUpWindow.setMinimumSize(new Dimension(this.textField.getWidth(), 30));
        this.autoSuggestionPopUpWindow.setSize(this.tW, this.tH);
        this.autoSuggestionPopUpWindow.setVisible(true);
        int windowX = 0;
        int windowY = 0;
        windowX = this.container.getX() + this.textField.getX() + 5;
        windowY = this.suggestionsPanel.getHeight() > this.autoSuggestionPopUpWindow.getMinimumSize().height ? this.container.getY() + this.textField.getY() + this.textField.getHeight() + this.autoSuggestionPopUpWindow.getMinimumSize().height : this.container.getY() + this.textField.getY() + this.textField.getHeight() + this.autoSuggestionPopUpWindow.getHeight();
        this.autoSuggestionPopUpWindow.setLocation(windowX, windowY);
        this.autoSuggestionPopUpWindow.setMinimumSize(new Dimension(this.textField.getWidth(), 30));
        this.autoSuggestionPopUpWindow.revalidate();
        this.autoSuggestionPopUpWindow.repaint();
    }

    public void setDictionary(ArrayList<String> words) {
        this.dictionary.clear();
        if (words == null) {
            return;
        }
        for (String word : words) {
            this.dictionary.add(word);
        }
    }

    public JWindow getAutoSuggestionPopUpWindow() {
        return this.autoSuggestionPopUpWindow;
    }

    public Window getContainer() {
        return this.container;
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public void addToDictionary(String word) {
        this.dictionary.add(word);
    }

    public boolean wordTyped(String typedWord) {
        if (typedWord.isEmpty()) {
            return false;
        }
        boolean suggestionAdded = false;
        for (String word : this.dictionary) {
            boolean fullymatches = true;
            for (int i = 0; i < typedWord.length(); ++i) {
                if (typedWord.toLowerCase().startsWith(String.valueOf(word.toLowerCase().charAt(i)), i)) continue;
                fullymatches = false;
                break;
            }
            if (!fullymatches) continue;
            this.addWordToSuggestions(word);
            suggestionAdded = true;
        }
        return suggestionAdded;
    }
}

