/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.ticket;

import com.openbravo.basic.BasicException;
import com.openbravo.basic.BasicStorage;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.data.loader.SerializerRead;
import com.openbravo.pos.forms.AppUser;
import com.procaisse.db.metadata.DataRead;
import java.io.Serializable;

public class UserInfo
implements Serializable {
    private static final long serialVersionUID = 7537578737839L;
    private final String m_sId;
    private final String m_sName;
    private int counter;

    public UserInfo(String id, String name, int counter) {
        this.m_sId = id;
        this.m_sName = name;
        this.counter = counter;
    }

    public UserInfo(String id) {
        this.m_sId = id;
        this.m_sName = "";
    }

    public UserInfo(String id, String name) {
        this.m_sId = id;
        this.m_sName = name;
    }

    public UserInfo(AppUser mAppUser) {
        this.m_sId = mAppUser.getId();
        this.m_sName = mAppUser.getName();
        this.counter = mAppUser.getCounter();
    }

    public String getId() {
        return this.m_sId;
    }

    public String getName() {
        return this.m_sName;
    }

    public int getCounter() {
        return this.counter;
    }

    public String toString() {
        return this.m_sName;
    }

    public static SerializerRead getSerializerRead() {
        return new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                return new UserInfo(dr.getString(1), dr.getString(2), dr.getInt(3));
            }
        };
    }

    public static UserInfo fetchOrStore(String idUser, DataLogicSales mDataLogicSales) throws BasicException {
        UserInfo mUserInfo = null;
        String key = "USER_INFO_" + idUser;
        if (BasicStorage.contains(key)) {
            mUserInfo = (UserInfo)BasicStorage.getObject(key);
        } else {
            mUserInfo = mDataLogicSales.getUserInfo(idUser);
            BasicStorage.pushObject(key, mUserInfo);
        }
        return mUserInfo;
    }
}

