/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.ticket;

import com.openbravo.basic.BasicException;
import com.openbravo.data.loader.SerializerRead;
import com.procaisse.db.metadata.DataRead;
import java.util.Date;

public class TicketResto {
    private int id;
    private String num;
    private int type;
    private double amount;
    private int validityYear;
    private Date dateCreated;
    private int lastCharacter;

    public TicketResto() {
    }

    public TicketResto(int id, String num, int type, double amount, int validityYear, Date dateCreated) {
        this.id = id;
        this.num = num;
        this.type = type;
        this.amount = amount;
        this.validityYear = validityYear;
        this.dateCreated = dateCreated;
    }

    public TicketResto(String num, int type, double amount, int validityYear, int lastCharacter) {
        this.num = num;
        this.type = type;
        this.amount = amount;
        this.validityYear = validityYear;
        this.lastCharacter = lastCharacter;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getNum() {
        return this.num;
    }

    public void setNum(String num) {
        this.num = num;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public int getValidityYear() {
        return this.validityYear;
    }

    public void setValidityYear(int validityYear) {
        this.validityYear = validityYear;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public static TicketResto parse(String barCode) {
        String strAmountEuros = barCode.substring(11, 14);
        String strAmountCents = barCode.substring(14, 16);
        double amount = Double.parseDouble(strAmountEuros + "." + strAmountCents);
        int type = Integer.parseInt(barCode.substring(16, 17));
        int lastChar = Integer.parseInt(barCode.substring(23, 24));
        int validityYear = 2010 + lastChar;
        return new TicketResto(barCode, type, amount, validityYear, lastChar);
    }

    public static SerializerRead getSerializerRead() {
        return new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                TicketResto ticketResto = new TicketResto();
                ticketResto.id = dr.getInt(1);
                ticketResto.num = dr.getString(2);
                ticketResto.type = dr.getInt(3);
                ticketResto.amount = dr.getDouble(4);
                ticketResto.validityYear = dr.getInt(5);
                ticketResto.dateCreated = dr.getTimestamp(6);
                return ticketResto;
            }
        };
    }

    public int getLastCharacter() {
        return this.lastCharacter;
    }

    public void setLastCharacter(int lastCharacter) {
        this.lastCharacter = lastCharacter;
    }
}

