/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.ticket;

import com.openbravo.basic.BasicException;
import com.openbravo.data.loader.SerializableRead;
import com.openbravo.data.loader.SerializableWrite;
import com.openbravo.data.loader.SerializerRead;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.printer.PrinterHelper;
import com.openbravo.pos.ticket.CarteOrder;
import com.openbravo.pos.ticket.ItemOrderInfo;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.ProductOrder;
import com.openbravo.pos.ticket.ProductTicket;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.ticket.TaxInfo;
import com.openbravo.pos.util.ColorUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.NumericUtils;
import com.openbravo.pos.util.StringUtils;
import com.procaisse.db.metadata.DataRead;
import com.procaisse.db.metadata.DataWrite;
import fr.protactile.procaisse.dao.entities.MultiLanguageProduct;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javafx.scene.image.Image;

public class TicketLineInfo
implements Cloneable,
SerializableWrite,
SerializableRead,
Serializable {
    private static final long serialVersionUID = 6608012948284450199L;
    private String m_sTicket;
    private int ID;
    private double multiply;
    private double price;
    private TaxInfo tax;
    private Properties attributes;
    private int productid;
    private List<ItemOrderInfo> listIngredients;
    private List<SupplementItemInfo> listIngredientsIN;
    private List<OptionItemOrder> listSupplements;
    private List<ProductTicket> listProducts;
    private List<ProductTicket> listNew;
    private List<ProductTicket> listUpdate;
    private List<ProductTicket> listDelete;
    private Boolean menu;
    private int printerID;
    private int printerLabel;
    private double taxAmount;
    private double htAmount;
    private double rate;
    private boolean sans;
    private boolean avec;
    private String sansString;
    private String avecString;
    private boolean next;
    private String note;
    private double discount;
    private String labelDiscount;
    private String sizeProduct;
    private String name_sizeProduct;
    private String typeUpdate;
    private String nameProduct;
    private boolean diver;
    private boolean hasLabel;
    private String nextRetourn;
    private int numLine;
    private double discountFromTicket;
    private boolean paid;
    private String ref_web;
    private double units_paid;
    private double unit_help;
    private double oldMultiply;
    private double oldPrice;
    private double oldDiscount;
    private String oldLabelDiscount;
    private String unitProduct;
    private String place_served;
    private String time_served;
    private String ingredientInclus = "";
    private int numero_line;
    private boolean label;
    private int id_dessert;
    private Image image_product;
    private String printer_kitchen;
    private double difference_quantity;
    private String alias_name_product;
    private String color_product;
    private boolean send_kitchen;
    private int id_temp;
    private int id_source;
    private double price_product;
    private boolean print_ingredients;
    private List<ProductTicket> oldProductsTicket;
    private List<ItemOrderInfo> oldIngredientsTicket;
    private List<OptionItemOrder> oldOptionsTicket;
    private int id_additional_sale;
    private boolean promo_basket;
    private String type_discount;
    private List<String> oldLabelsDiscount;
    private boolean display_image_in_kitchen;
    private String image_path;
    private String description;
    private int daily_stock;
    private boolean promo_product;
    private double points_loyalty;
    private int id_line_kitchen;
    private int index_line;
    private int index_line_parent;
    private boolean valid_caisse;
    private int order_in_ticket;
    private boolean product_platform;
    private String alias_size;
    private int offset_print_kitchen;
    private boolean product_promotion_applied;
    private boolean tva_global_no_applicable;
    private String label_promotion;
    private String id_global_product;
    private String displayedName;
    private int marque;
    private List<MultiLanguageProduct> multiLanguageTexts;
    private int idZone;
    private String nameZone;
    private boolean product_later;

    public TicketLineInfo(String productname, double dMultiply, double dPrice, TaxInfo tax, Double rate, boolean diver, List<ItemOrderInfo> listIngredients, List<OptionItemOrder> listSupplements, List<ProductTicket> listProducts, int id_temp) {
        this.init(-1, dMultiply, dPrice, tax, productname, listIngredients, listSupplements, false, rate, listProducts, null, null, 0.0, null, diver, false, null, null, null, null, null, null, null, id_temp, false, null, 0, false, null, productname, null);
    }

    public TicketLineInfo() {
        this.init(-1, 0.0, 0.0, null, null, null, null, false, 0.0, null, null, null, 0.0, null, false, false, null, null, null, null, null, null, null, -1, false, null, 0, false, null, null, null);
    }

    public TicketLineInfo(ProductInfoExt product, double dMultiply, double dPrice, TaxInfo tax, List<ItemOrderInfo> listIngredients, List<OptionItemOrder> listSupplements, Boolean menu, Double rate, List<ProductTicket> listProducts, String sizeProduct, String name_sizeProduct, double discount, String note, boolean diver, String labelDiscount, String place_served, String time_served, int id_temp) {
        int pid;
        String color = null;
        if (product == null) {
            pid = -1;
        } else {
            pid = product.getID();
            if (product.isSend_color() && product.getColor() != null) {
                color = ColorUtils.getColor(product.getColor());
            }
            this.print_ingredients = product.isPrint_ingredients();
            this.product_later = product.isLater();
        }
        boolean promo_product = false;
        this.init(pid, dMultiply, dPrice, tax, product.getName(), listIngredients, listSupplements, menu, rate, listProducts, sizeProduct, name_sizeProduct, discount, note, diver, product.isHasLabel(), labelDiscount, product.getRef_web(), place_served, time_served, product.getPrinter_kitchen(), product.getAlias_kitchen(), color, id_temp, product.isDisplay_image_in_kitchen(), product.getImageProduct(), product.getDaily_stock(), promo_product, product.getId_global(), product.getDisplayedName(), product.getMultiLanguageTexts());
        this.tva_global_no_applicable = product.isTva_global_no_applicable();
        this.idZone = product.getZoneId() != null ? product.getZoneId() : 0;
    }

    public TicketLineInfo(ProductInfoExt oProduct, double dPrice, TaxInfo tax, List<ItemOrderInfo> listIngredients, List<OptionItemOrder> listSupplements, Boolean menu, Double rate, List<ProductTicket> listProducts, String sizeProduct, String name_sizeProduct, double discount, String note, boolean diver, String labelDiscount, String place_served, String time_served, int id_temp) {
        this(oProduct, 1.0, dPrice, tax, listIngredients, listSupplements, menu, rate, listProducts, sizeProduct, name_sizeProduct, discount, note, diver, labelDiscount, place_served, time_served, id_temp);
    }

    public TicketLineInfo(TicketLineInfo line) {
        this.init(line.productid, line.multiply, line.price, line.tax, line.nameProduct, line.listIngredients, line.listSupplements, line.menu, line.rate, line.listProducts, line.sizeProduct, line.name_sizeProduct, line.discount, line.note, line.diver, line.hasLabel, line.labelDiscount, null, line.place_served, line.time_served, line.printer_kitchen, line.alias_name_product, line.color_product, line.id_temp, line.isDisplay_image_in_kitchen(), line.getImage_path(), line.daily_stock, line.promo_product, line.id_global_product, line.displayedName, line.multiLanguageTexts);
    }

    private void init(int productid, double dMultiply, double dPrice, TaxInfo tax, String nameProduct, List<ItemOrderInfo> listIngredients, List<OptionItemOrder> listSupplements, Boolean menu, Double rate, List<ProductTicket> listProducts, String sizeProduct, String name_sizeProduct, double discount, String note, boolean diver, boolean label, String labelDiscount, String ref_web, String place_served, String time_served, String printer_kitchen, String alias_name_product, String color_product, int id_temp, boolean display_image_in_kitchen, String image_path, int daily_stock, boolean promo_product, String id_global_product, String displayedName, List<MultiLanguageProduct> multiLanguageTexts) {
        this.id_dessert = -1;
        this.productid = productid;
        this.multiply = dMultiply;
        this.units_paid = 0.0;
        this.price = dPrice;
        this.tax = tax;
        this.m_sTicket = null;
        this.diver = diver;
        this.paid = false;
        this.ID = -1;
        this.discount = discount;
        this.labelDiscount = labelDiscount;
        this.listIngredients = listIngredients;
        this.listSupplements = listSupplements;
        this.listProducts = listProducts;
        this.listDelete = new ArrayList<ProductTicket>();
        this.listUpdate = new ArrayList<ProductTicket>();
        this.listNew = new ArrayList<ProductTicket>();
        this.menu = menu;
        this.rate = rate;
        this.sizeProduct = sizeProduct;
        this.name_sizeProduct = name_sizeProduct;
        this.note = note;
        this.nameProduct = nameProduct;
        this.hasLabel = label;
        this.label = label;
        this.ref_web = ref_web;
        this.place_served = place_served;
        this.time_served = time_served;
        this.label = label;
        this.printer_kitchen = printer_kitchen;
        this.difference_quantity = 0.0;
        this.alias_name_product = alias_name_product;
        this.color_product = color_product;
        this.send_kitchen = false;
        this.id_temp = id_temp;
        this.display_image_in_kitchen = display_image_in_kitchen;
        this.image_path = image_path;
        this.daily_stock = daily_stock;
        this.promo_product = promo_product;
        this.id_global_product = id_global_product;
        this.displayedName = displayedName;
        this.multiLanguageTexts = multiLanguageTexts;
        this.oldProductsTicket = new ArrayList<ProductTicket>();
        this.oldIngredientsTicket = new ArrayList<ItemOrderInfo>();
        this.oldOptionsTicket = new ArrayList<OptionItemOrder>();
        this.oldLabelsDiscount = new ArrayList<String>();
        this.oldLabelsDiscount.add("Promotion 5%");
        this.oldLabelsDiscount.add("Promotion 10%");
        this.oldLabelsDiscount.add("Promotion 15%");
        this.oldLabelsDiscount.add("Promotion 20%");
        this.oldLabelsDiscount.add("Promotion 50%");
        this.oldLabelsDiscount.add("Offert");
        this.oldLabelsDiscount.add("Offert Youfid");
        this.oldLabelsDiscount.add("Offert Employe");
    }

    public void setTicket(String ticket) {
        this.m_sTicket = ticket;
    }

    public String getM_sTicket() {
        return this.m_sTicket;
    }

    @Override
    public void writeValues(DataWrite dp) throws BasicException {
        dp.setString(1, this.m_sTicket);
        dp.setInt(2, this.productid);
        dp.setDouble(3, this.multiply);
        dp.setDouble(4, this.price);
        dp.setString(5, this.tax.getId());
        try {
            ByteArrayOutputStream o = new ByteArrayOutputStream();
            this.attributes.storeToXML((OutputStream)o, "Procaisse", "UTF-8");
            dp.setBytes(6, o.toByteArray());
        }
        catch (IOException e) {
            dp.setBytes(6, null);
        }
    }

    @Override
    public void readValues(DataRead dr) throws BasicException {
        this.ID = dr.getInt(1);
        this.m_sTicket = dr.getString(2);
        this.productid = dr.getInt(3);
        this.multiply = dr.getDouble(4);
        this.price = dr.getDouble(5);
        this.menu = dr.getBoolean(6);
        this.htAmount = dr.getDouble(7);
        this.taxAmount = dr.getDouble(8);
        this.next = dr.getBoolean(9);
        this.note = dr.getString(10);
        this.discount = dr.getDouble(11);
        this.sizeProduct = dr.getString(12);
        this.name_sizeProduct = dr.getString(13);
        this.labelDiscount = dr.getString(14);
        this.tax = new TaxInfo(dr.getString(15), dr.getString(16), dr.getDouble(17), true, false);
        this.nameProduct = dr.getString(18);
        this.paid = dr.getBoolean(19);
        this.units_paid = dr.getDouble(20);
        this.place_served = dr.getString(21);
        this.time_served = dr.getString(22);
        this.numero_line = dr.getInt(23);
        this.label = dr.getBoolean(24);
        this.printer_kitchen = dr.getString(25);
        this.promo_basket = dr.getBoolean(26);
        this.type_discount = dr.getString(27);
        this.promo_product = dr.getBoolean(28);
        this.image_path = dr.getString(29);
        this.id_line_kitchen = dr.getInt(30);
        this.points_loyalty = dr.getDouble(31);
        this.alias_name_product = dr.getString(32);
        this.alias_size = dr.getString(33);
        this.product_promotion_applied = dr.getBoolean(34);
        this.tva_global_no_applicable = dr.getBoolean(35);
        this.idZone = dr.getInt(36);
        this.diver = false;
        this.difference_quantity = 0.0;
    }

    public TicketLineInfo copyTicketLine() {
        TicketLineInfo l = new TicketLineInfo();
        l.productid = this.productid;
        l.multiply = this.multiply;
        l.price = this.price;
        l.tax = this.tax;
        l.attributes = (Properties)this.attributes.clone();
        l.listIngredients = this.listIngredients;
        l.listSupplements = this.listSupplements;
        return l;
    }

    public int getID() {
        return this.ID;
    }

    public double getPriceAfterDiscount() {
        return this.getPrice() * this.getMultiply() - this.getDiscount();
    }

    public double getPriceByUnit() {
        return this.getPrice() - this.getDiscountByUnit();
    }

    public double getDiscountByUnit() {
        return this.promo_basket || this.type_discount != null && this.type_discount.equals("somme") ? this.discount / this.multiply : this.discount * this.getPrice() / 100.0;
    }

    public double getDiscount() {
        return this.promo_basket || this.type_discount != null && this.type_discount.equals("somme") ? this.discount : this.discount * this.getPrice() / 100.0 * this.multiply;
    }

    public boolean isFree() {
        return this.discount == 100.0;
    }

    public double getValueDiscount() {
        return this.discount;
    }

    public void setDiscount(double discount) {
        this.discount = discount;
    }

    public String printDiscount() {
        if (this.getDiscount() == 0.0) {
            return "";
        }
        return "-" + Formats.DOUBLE.formatValue(this.getDiscount());
    }

    public void setID(int ID) {
        this.ID = ID;
    }

    public int getProductID() {
        return this.productid;
    }

    public void setProductID(int value) {
        this.productid = value;
    }

    public String getProductName() {
        return this.nameProduct;
    }

    public String getProductAttSetId() {
        return this.attributes.getProperty("product.attsetid");
    }

    public String getProductAttSetInstDesc() {
        return this.attributes.getProperty("product.attsetdesc", "");
    }

    public void setProductAttSetInstDesc(String value) {
        if (value == null) {
            this.attributes.remove(value);
        } else {
            this.attributes.setProperty("product.attsetdesc", value);
        }
    }

    public boolean isMenu() {
        return this.menu;
    }

    public boolean isProductCom() {
        return false;
    }

    public String getProductTaxCategoryID() {
        return this.attributes.getProperty("product.taxcategoryid");
    }

    public void setProductTaxCategoryID(String taxID) {
        this.attributes.setProperty("product.taxcategoryid", taxID);
    }

    public String getProductCategoryID() {
        return this.attributes.getProperty("product.categoryid");
    }

    public double getMultiply() {
        return this.multiply;
    }

    public double getUnit_help() {
        return this.unit_help;
    }

    public void setUnit_help(double unit_help) {
        this.unit_help = unit_help;
    }

    public void setMultiply(double dValue) {
        this.multiply = dValue;
    }

    public double getUnits_paid() {
        return this.units_paid;
    }

    public void setUnits_paid(double units_paid) {
        this.units_paid = units_paid;
    }

    public double getPrice() {
        return this.price;
    }

    public double getPriceProduct() {
        double priceProduct = 0.0;
        if (!this.isDiver()) {
            if (this.listSupplements != null) {
                for (OptionItemOrder supplement : this.listSupplements) {
                    priceProduct += supplement.getPrice().doubleValue();
                }
            }
            if (this.listProducts != null) {
                for (ProductTicket item : this.listProducts) {
                    priceProduct += (double)item.getNumberProduct() * item.getPriceProduct();
                }
            }
        }
        return this.price - priceProduct;
    }

    public void setPrice(double dValue) {
        this.price = dValue;
    }

    public double getPriceTax() {
        return this.price * (1.0 + this.getTaxRate());
    }

    public void setPriceTax(double dValue) {
        this.price = dValue / (1.0 + this.getTaxRate());
    }

    public TaxInfo getTaxInfo() {
        return this.tax;
    }

    public void setTaxInfo(TaxInfo value) {
        this.tax = value;
    }

    public double getTaxAmount() {
        return this.taxAmount;
    }

    public void setTaxAmount(double taxAmount) {
        this.taxAmount = taxAmount;
    }

    public double getHtAmount() {
        return this.htAmount;
    }

    public void setHtAmount(double htAmount) {
        this.htAmount = htAmount;
    }

    public boolean isNext() {
        return this.next;
    }

    public void setNext(boolean next) {
        this.next = next;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getProperty(String key) {
        return this.attributes.getProperty(key);
    }

    public String getProperty(String key, String defaultvalue) {
        return this.attributes.getProperty(key, defaultvalue);
    }

    public void setProperty(String key, String value) {
        this.attributes.setProperty(key, value);
    }

    public Properties getProperties() {
        return this.attributes;
    }

    public List<ItemOrderInfo> getListIngredients() {
        if (this.listIngredients == null) {
            this.listIngredients = new ArrayList<ItemOrderInfo>();
        }
        return this.listIngredients;
    }

    public void setListIngredients(List<ItemOrderInfo> listIngredients) {
        this.listIngredients = listIngredients;
    }

    public List<ProductTicket> getListNew() {
        return this.listNew;
    }

    public void setListNew(List<ProductTicket> listNew) {
        this.listNew = listNew;
    }

    public List<ProductTicket> getListUpdate() {
        return this.listUpdate;
    }

    public void setListUpdate(List<ProductTicket> listUpdate) {
        this.listUpdate = listUpdate;
    }

    public List<ProductTicket> getListDelete() {
        return this.listDelete;
    }

    public void setListDelete(List<ProductTicket> listDelete) {
        this.listDelete = listDelete;
    }

    public List<OptionItemOrder> getListSupplements() {
        if (this.listSupplements == null) {
            this.listSupplements = new ArrayList<OptionItemOrder>();
        }
        return this.listSupplements;
    }

    public void setListSupplements(List<OptionItemOrder> listSupplements) {
        this.listSupplements = listSupplements;
    }

    public List<ProductTicket> getListProducts() {
        if (this.listProducts == null) {
            this.listProducts = new ArrayList<ProductTicket>();
        }
        return this.listProducts;
    }

    public void setListProducts(List<ProductTicket> listProducts) {
        this.listProducts = listProducts;
    }

    public int getPrinterID() {
        return this.printerID;
    }

    public void setPrinterID(int printerID) {
        this.printerID = printerID;
    }

    public int getPrinterLabel() {
        return this.printerLabel;
    }

    public void setPrinterLabel(int printerLabel) {
        this.printerLabel = printerLabel;
    }

    public String getUnitProduct() {
        return this.unitProduct;
    }

    public void setUnitProduct(String unitProduct) {
        this.unitProduct = unitProduct;
    }

    public String getSizeProduct() {
        return this.sizeProduct;
    }

    public String getTypeUpdate() {
        return this.typeUpdate;
    }

    public void setTypeUpdate(String typeUpdate) {
        this.typeUpdate = typeUpdate;
    }

    public void setSizeProduct(String sizeProduct) {
        this.sizeProduct = sizeProduct;
    }

    public String getLabelDiscount() {
        return this.labelDiscount;
    }

    public void setLabelDiscount(String labelDiscount) {
        this.labelDiscount = labelDiscount;
    }

    public boolean isPaid() {
        return this.paid;
    }

    public void setPaid(boolean paid) {
        this.paid = paid;
    }

    public List<CarteOrder> getSupplementsMenu() {
        ProductOrder product;
        ArrayList<String> options;
        ArrayList<ProductOrder> products;
        int found;
        ArrayList<CarteOrder> cartes = new ArrayList<CarteOrder>();
        for (ItemOrderInfo ingredient : this.listIngredients) {
            found = -1;
            for (int i = 0; i < cartes.size(); ++i) {
                if (ingredient.getIdCarte() != ((CarteOrder)cartes.get(i)).getId()) continue;
                found = i;
            }
            if (found == -1) {
                ArrayList<String> ingredients = new ArrayList<String>();
                ingredients.add(ingredient.getNameSupplement());
                ArrayList<String> options2 = new ArrayList<String>();
                ProductOrder product2 = new ProductOrder(ingredient.getIdProduct(), ingredient.getNameProduct(), ingredients, options2);
                products = new ArrayList<ProductOrder>();
                products.add(product2);
                cartes.add(new CarteOrder(ingredient.getIdCarte(), ingredient.getNameCarte(), products));
                continue;
            }
            int j = found;
            int foundP = -1;
            for (int i = 0; i < ((CarteOrder)cartes.get(j)).getListProducts().size(); ++i) {
                if (ingredient.getIdProduct() != ((CarteOrder)cartes.get(j)).getListProducts().get(i).getId()) continue;
                foundP = i;
            }
            if (foundP == -1) {
                ArrayList<String> ingredients = new ArrayList<String>();
                ingredients.add(ingredient.getNameSupplement());
                options = new ArrayList<String>();
                product = new ProductOrder(ingredient.getIdProduct(), ingredient.getNameProduct(), ingredients, options);
                ((CarteOrder)cartes.get(j)).getListProducts().add(product);
                continue;
            }
            ((CarteOrder)cartes.get(j)).getListProducts().get(foundP).getListIngredient().add(ingredient.getNameSupplement());
        }
        for (OptionItemOrder supplement : this.listSupplements) {
            found = -1;
            for (int i = 0; i < cartes.size(); ++i) {
                if (supplement.getIdCarte() != ((CarteOrder)cartes.get(i)).getId()) continue;
                found = i;
            }
            if (found == -1) {
                ArrayList<String> ingredients = new ArrayList<String>();
                ArrayList<String> options3 = new ArrayList<String>();
                options3.add(supplement.getNameSupplement());
                ProductOrder product3 = new ProductOrder(supplement.getIdProduct(), supplement.getNameProduct(), ingredients, options3);
                products = new ArrayList();
                products.add(product3);
                cartes.add(new CarteOrder(supplement.getIdCarte(), supplement.getNameCarte(), products));
                continue;
            }
            int j = found;
            int foundP = -1;
            for (int i = 0; i < ((CarteOrder)cartes.get(j)).getListProducts().size(); ++i) {
                if (supplement.getIdProduct() != ((CarteOrder)cartes.get(j)).getListProducts().get(i).getId()) continue;
                foundP = i;
            }
            if (foundP == -1) {
                ArrayList<String> ingredients = new ArrayList<String>();
                options = new ArrayList();
                options.add(supplement.getNameSupplement());
                product = new ProductOrder(supplement.getIdProduct(), supplement.getNameProduct(), ingredients, options);
                ((CarteOrder)cartes.get(j)).getListProducts().add(product);
                continue;
            }
            ((CarteOrder)cartes.get(j)).getListProducts().get(foundP).getListOptions().add(supplement.getNameSupplement());
        }
        return cartes;
    }

    public double getTaxRate() {
        return this.tax == null ? 0.0 : this.tax.getRate();
    }

    public double getSubValue() {
        return this.price * this.multiply;
    }

    public boolean isDiver() {
        return this.diver;
    }

    public void setDiver(boolean diver) {
        this.diver = diver;
    }

    public double getTax() {
        return this.htAmount * this.getTaxRate();
    }

    public double getValue() {
        return this.price * this.multiply;
    }

    public double getValueProduct() {
        return this.getPriceProduct() * this.multiply;
    }

    public String getNameProduct() {
        return this.nameProduct;
    }

    public void setNameProduct(String nameProduct) {
        this.nameProduct = nameProduct;
    }

    public String printName() {
        return this.printName(false);
    }

    /*
     * WARNING - void declaration
     */
    public String printNamePanier() {
        void var2_9;
        if (this.next) {
            return this.getNextRetourn();
        }
        if (this.isDiver()) {
            return StringUtils.encodeXML(this.nameProduct);
        }
        this.sansString = "";
        this.avecString = "";
        for (ItemOrderInfo itemOrderInfo : this.getListIngredients()) {
            this.sansString = this.sansString + "-" + itemOrderInfo.getNameSupplement() + " ";
        }
        for (OptionItemOrder optionItemOrder : this.getListSupplements()) {
            if (optionItemOrder.getNumberOption() > 1) {
                this.avecString = this.avecString + "+" + optionItemOrder.getNumberOption() + " " + optionItemOrder.getNameSupplement() + " ";
                continue;
            }
            this.avecString = this.avecString + "+" + optionItemOrder.getNameSupplement() + " ";
        }
        if (this.sansString.length() > 0 && this.avecString.length() > 0) {
            this.sans = true;
            this.avec = true;
        } else if (this.sansString.length() > 0 && this.avecString.length() == 0) {
            this.sans = true;
            this.avec = false;
        } else if (this.sansString.length() == 0 && this.avecString.length() > 0) {
            this.sans = false;
            this.avec = true;
        } else {
            this.sans = false;
            this.avec = false;
        }
        Object str = "avec ";
        if (this.isMenu()) {
            for (ProductTicket item : this.getListProducts()) {
                str = (String)str + item.getNameProduct() + ", ";
            }
        }
        String string = this.nameProduct;
        if (this.getListProducts().size() > 0) {
            String string2 = string + "\n" + (String)str;
        }
        return StringUtils.encodeXML((String)var2_9);
    }

    public String printMultiply() {
        if (this.unitProduct != null && this.unitProduct.equals("poids")) {
            return Formats.QTT.formatValue(this.multiply) + "Kg";
        }
        if (this.next) {
            return "";
        }
        if (this.multiply == (double)Math.round(this.multiply)) {
            return Formats.INT.formatValue(this.multiply);
        }
        return Formats.DOUBLE.formatValue(this.multiply);
    }

    public String printPrice() {
        if (this.next) {
            return "";
        }
        return Formats.CURRENCY.formatValue(this.getPrice());
    }

    public String printPriceProString() {
        if (this.next) {
            return "";
        }
        return Formats.CURRENCY.formatValue(this.getPriceProduct());
    }

    public String printPriceProduct() {
        if (this.next) {
            return "";
        }
        return Formats.CURRENCY.formatValue(this.getPriceProduct());
    }

    public String printPriceTax() {
        return Formats.CURRENCY.formatValue(this.getPriceTax());
    }

    public String printTax() {
        return Formats.CURRENCY.formatValue(this.getTax());
    }

    public String printTaxRate() {
        return Formats.PERCENT.formatValue(this.getTaxRate());
    }

    public boolean isHasLabel() {
        return this.hasLabel;
    }

    public void setHasLabel(boolean hasLabel) {
        this.hasLabel = hasLabel;
    }

    public String printSubValue() {
        return Formats.CURRENCY.formatValue(this.getSubValue());
    }

    public String printValue() {
        if (this.next) {
            return "";
        }
        return this.points_loyalty > 0.0 ? Formats.INT.formatValue(this.points_loyalty * this.multiply) + " pt" : Formats.CURRENCY.formatValue(this.getValue());
    }

    public String printValueProduct() {
        if (this.next) {
            return "";
        }
        return Formats.CURRENCY.formatValue(this.getValueProduct());
    }

    public boolean isProductKitchen() {
        return "true".equals(this.attributes.getProperty("product.kitchen"));
    }

    public boolean isProductService() {
        return "true".equals(this.attributes.getProperty("product.service"));
    }

    public boolean isProductVprice() {
        return "true".equals(this.attributes.getProperty("product.vprice"));
    }

    public boolean isProductVerpatrib() {
        return false;
    }

    public String printTextTip() {
        return this.attributes.getProperty("product.texttip");
    }

    public boolean isProductWarranty() {
        return false;
    }

    public boolean isSans() {
        return this.sans;
    }

    public boolean isAvec() {
        return this.avec;
    }

    public String getName_sizeProduct() {
        return this.name_sizeProduct;
    }

    public void setName_sizeProduct(String name_sizeProduct) {
        this.name_sizeProduct = name_sizeProduct;
    }

    public String printSansString() {
        return StringUtils.encodeXML(this.sansString);
    }

    public String printAvecString() {
        return StringUtils.encodeXML(this.avecString);
    }

    public static SerializerRead getSerializerRead() {
        return new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                TicketLineInfo ticketLine = new TicketLineInfo();
                ticketLine.productid = dr.getInt(1);
                ticketLine.m_sTicket = dr.getString(2);
                ticketLine.price = dr.getDouble(3);
                ticketLine.htAmount = dr.getDouble(4);
                ticketLine.taxAmount = dr.getDouble(5);
                ticketLine.multiply = dr.getDouble(6);
                ticketLine.tax = new TaxInfo(dr.getString(7), dr.getString(8), dr.getDouble(9), true, false);
                ticketLine.nameProduct = dr.getString(10);
                ticketLine.paid = dr.getBoolean(11);
                ticketLine.units_paid = dr.getDouble(12);
                ticketLine.place_served = dr.getString(13);
                ticketLine.time_served = dr.getString(14);
                ticketLine.diver = true;
                return ticketLine;
            }
        };
    }

    public String getNextRetourn() {
        if (AppLocal.ISPLUSTARD.booleanValue()) {
            return "------- Emporter plus tard -------";
        }
        return "--------- Faire Suivre-------------";
    }

    public void setNextRetourn(String nextRetourn) {
        this.nextRetourn = nextRetourn;
    }

    public String printPanier() {
        if (this.isNext()) {
            return "";
        }
        StringBuilder name = new StringBuilder();
        name.append(this.printMultiply()).append(" x ");
        if (this.getSizeProduct() != null && !this.getSizeProduct().isEmpty() && AppLocal.LABEL_SIZE_FIRST) {
            name.append(this.getSizeProduct()).append(" - ");
        }
        name.append(this.getDisplayedName());
        if (this.getSizeProduct() != null && !this.getSizeProduct().isEmpty() && !AppLocal.LABEL_SIZE_FIRST) {
            name.append(" - ").append(this.getSizeProduct());
        }
        return name.toString();
    }

    public String printPanierSuivi() {
        if (this.isNext()) {
            return "";
        }
        String name = this.printMultiply() + " x " + this.nameProduct;
        for (ProductTicket item : this.getListProducts()) {
            name = name + "\n  " + item.getNameProduct();
        }
        for (OptionItemOrder supplement : this.listSupplements) {
            if (supplement.getNumberOption() > 1) {
                name = name + "\n +" + supplement.getNumberOption() + " " + supplement.getNameSupplement();
                continue;
            }
            name = name + "\n +" + supplement.getNameSupplement();
        }
        for (ItemOrderInfo ingredient : this.listIngredients) {
            name = name + "\n -" + ingredient.getNameSupplement();
        }
        return name;
    }

    public String toString() {
        return "TicketLineInfo{m_sTicket=" + this.m_sTicket + ", ID=" + this.ID + ", multiply=" + this.multiply + ", price=" + this.price + ", tax=" + this.tax + ", attributes=" + this.attributes + ", productid=" + this.productid + ", listIngredients=" + this.listIngredients + ", listSupplements=" + this.listSupplements + ", listProducts=" + this.listProducts + ", listNew=" + this.listNew + ", listUpdate=" + this.listUpdate + ", listDelete=" + this.listDelete + ", menu=" + this.menu + ", printerID=" + this.printerID + ", printerLabel=" + this.printerLabel + ", taxAmount=" + this.taxAmount + ", htAmount=" + this.htAmount + ", rate=" + this.rate + ", sans=" + this.sans + ", avec=" + this.avec + ", sansString=" + this.sansString + ", avecString=" + this.avecString + ", next=" + this.next + ", note=" + this.note + ", discount=" + this.discount + ", sizeProduct=" + this.sizeProduct + ", typeUpdate=" + this.typeUpdate + ", nameProduct=" + this.nameProduct + ", diver=" + this.diver + ", hasLabel=" + this.hasLabel + ", nextRetourn=" + this.nextRetourn + "}";
    }

    public int getNumLine() {
        return this.numLine;
    }

    public void setNumLine(int numLine) {
        this.numLine = numLine;
    }

    public double getDiscountFromTicket() {
        return this.discountFromTicket;
    }

    public void setDiscountFromTicket(double discountFromTicket) {
        this.discountFromTicket = discountFromTicket;
    }

    public List<SupplementItemInfo> getListIngredientsIN() {
        return this.listIngredientsIN;
    }

    public void setListIngredientsIN(List<SupplementItemInfo> listIngredientsIN) {
        this.listIngredientsIN = listIngredientsIN;
    }

    public String getRef_web() {
        return this.ref_web;
    }

    public void setRef_web(String ref_web) {
        this.ref_web = ref_web;
    }

    public double getOldMultiply() {
        return this.oldMultiply;
    }

    public void setOldMultiply(double oldMultiply) {
        this.oldMultiply = oldMultiply;
    }

    public double getOldPrice() {
        return this.oldPrice;
    }

    public void setOldPrice(double oldPrice) {
        this.oldPrice = oldPrice;
    }

    public double getOldDiscount() {
        return this.oldDiscount;
    }

    public void setOldDiscount(double oldDiscount) {
        this.oldDiscount = oldDiscount;
    }

    public String getOldLabelDiscount() {
        return this.oldLabelDiscount;
    }

    public void setOldLabelDiscount(String oldLabelDiscount) {
        this.oldLabelDiscount = oldLabelDiscount;
    }

    public String getSupplement() {
        ArrayList<CallSite> supplements = new ArrayList<CallSite>();
        for (OptionItemOrder supplement : this.listSupplements) {
            Object numberOption = "";
            if (supplement.getNumberOption() > 1) {
                numberOption = supplement.getNumberOption() + " ";
            }
            supplements.add((CallSite)((Object)((String)numberOption + supplement.getNameSupplement())));
        }
        if (supplements.isEmpty()) {
            return "";
        }
        CharSequence[] tabSupplement = new String[supplements.size()];
        tabSupplement = supplements.toArray(tabSupplement);
        return String.join((CharSequence)"+", tabSupplement);
    }

    public String getIngredients() {
        ArrayList<String> ingredients = new ArrayList<String>();
        for (ItemOrderInfo ingredient : this.listIngredients) {
            ingredients.add(ingredient.getNameSupplement());
        }
        if (ingredients.isEmpty()) {
            return "";
        }
        CharSequence[] tabSupplement = new String[ingredients.size()];
        tabSupplement = ingredients.toArray(tabSupplement);
        return String.join((CharSequence)"+", tabSupplement);
    }

    public String getItemSupplement(ProductTicket product) {
        ArrayList<String> optionsItem = new ArrayList<String>();
        for (OptionItemOrder supplement : this.listSupplements) {
            if (supplement.getIdProduct() != product.getIdProduct() || supplement.getIdCarte() != product.getIdCarte() || supplement.getIndex_carte() != product.getIndex_carte()) continue;
            optionsItem.add(supplement.getNameSupplement());
        }
        if (optionsItem.isEmpty()) {
            return "";
        }
        CharSequence[] tabSupplement = new String[optionsItem.size()];
        tabSupplement = optionsItem.toArray(tabSupplement);
        return String.join((CharSequence)"+", tabSupplement);
    }

    public String getItemIngredients(ProductTicket product) {
        ArrayList<String> ingredientsItem = new ArrayList<String>();
        for (ItemOrderInfo ingredient : this.listIngredients) {
            if (ingredient.getIdProduct() != product.getIdProduct() || ingredient.getIdCarte() != product.getIdCarte() || ingredient.getIndex_carte() != product.getIndex_carte()) continue;
            ingredientsItem.add(ingredient.getNameSupplement());
        }
        if (ingredientsItem.isEmpty()) {
            return "";
        }
        CharSequence[] tabIngredient = new String[ingredientsItem.size()];
        tabIngredient = ingredientsItem.toArray(tabIngredient);
        return String.join((CharSequence)"+", tabIngredient);
    }

    public Object clone() {
        try {
            int i;
            TicketLineInfo o = null;
            o = (TicketLineInfo)super.clone();
            if (this.listIngredients != null) {
                o.listIngredients = new ArrayList<ItemOrderInfo>();
                for (i = 0; i < this.listIngredients.size(); ++i) {
                    o.listIngredients.add((ItemOrderInfo)this.listIngredients.get(i).clone());
                }
            } else {
                o.listIngredients = null;
            }
            if (this.listIngredientsIN != null) {
                o.listIngredientsIN = new ArrayList<SupplementItemInfo>();
                for (i = 0; i < this.listIngredientsIN.size(); ++i) {
                    o.listIngredientsIN.add((SupplementItemInfo)this.listIngredientsIN.get(i).clone());
                }
            } else {
                o.listIngredientsIN = null;
            }
            if (this.listSupplements != null) {
                o.listSupplements = new ArrayList<OptionItemOrder>();
                for (i = 0; i < this.listSupplements.size(); ++i) {
                    o.listSupplements.add((OptionItemOrder)this.listSupplements.get(i).clone());
                }
            } else {
                o.listSupplements = null;
            }
            if (this.listProducts != null) {
                o.listProducts = new ArrayList<ProductTicket>();
                for (i = 0; i < this.listProducts.size(); ++i) {
                    o.listProducts.add((ProductTicket)this.listProducts.get(i).clone());
                }
            } else {
                o.listProducts = null;
            }
            if (this.multiLanguageTexts != null) {
                o.multiLanguageTexts = new ArrayList<MultiLanguageProduct>();
                for (i = 0; i < this.multiLanguageTexts.size(); ++i) {
                    o.multiLanguageTexts.add((MultiLanguageProduct)this.multiLanguageTexts.get(i).clone());
                }
            } else {
                o.multiLanguageTexts = null;
            }
            return o;
        }
        catch (CloneNotSupportedException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            return null;
        }
    }

    public String getPlace_served() {
        return this.place_served;
    }

    public void setPlace_served(String place_served) {
        this.place_served = place_served;
    }

    public String getTime_served() {
        return this.time_served;
    }

    public void setTime_served(String time_served) {
        this.time_served = time_served;
    }

    public int getNumero_line() {
        return this.numero_line;
    }

    public void setNumero_line(int numero_line) {
        this.numero_line = numero_line;
    }

    public boolean isLabel() {
        return this.label;
    }

    public void setLabel(boolean label) {
        this.label = label;
    }

    public String getIngredientsInclus() {
        if (!this.ingredientInclus.equals("")) {
            return this.ingredientInclus;
        }
        StringBuilder ingredientBuilder = new StringBuilder();
        for (SupplementItemInfo ingredient : this.getListIngredientsIN()) {
            boolean exist = false;
            for (ItemOrderInfo SansIngredient : this.getListIngredients()) {
                if (ingredient.getName() == null || !ingredient.getName().equals(SansIngredient.getNameSupplement())) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            ingredientBuilder.append(PrinterHelper.formatMax(" + " + ingredient.getName()));
        }
        this.ingredientInclus = ingredientBuilder.toString() + " ";
        return this.ingredientInclus;
    }

    public int getId_dessert() {
        return this.id_dessert;
    }

    public void setId_dessert(int id_dessert) {
        this.id_dessert = id_dessert;
    }

    public Image getImage_product() {
        return this.image_product;
    }

    public void setImage_product(Image image_product) {
        this.image_product = image_product;
    }

    public String getPrinter_kitchen() {
        return this.printer_kitchen;
    }

    public void setPrinter_kitchen(String printer_kitchen) {
        this.printer_kitchen = printer_kitchen;
    }

    public double getDifference_quantity() {
        return this.difference_quantity;
    }

    public void setDifference_quantity(double difference_quantity) {
        this.difference_quantity = difference_quantity;
    }

    public String printDifference_quantity() {
        String prefix = "";
        if (this.difference_quantity > 0.0) {
            prefix = "+";
        }
        if (this.difference_quantity == (double)Math.round(this.difference_quantity)) {
            return prefix + Formats.INT.formatValue(this.difference_quantity);
        }
        return prefix + Formats.DOUBLE.formatValue(this.difference_quantity);
    }

    public String getAlias_name_product() {
        return this.alias_name_product;
    }

    public void setAlias_name_product(String alias_name_product) {
        this.alias_name_product = alias_name_product;
    }

    public String getColor_product() {
        return this.color_product;
    }

    public void setColor_product(String color_product) {
        this.color_product = color_product;
    }

    public boolean isSend_kitchen() {
        return this.send_kitchen;
    }

    public void setSend_kitchen(boolean send_kitchen) {
        this.send_kitchen = send_kitchen;
    }

    public int getId_temp() {
        return this.id_temp;
    }

    public void setId_temp(int id_temp) {
        this.id_temp = id_temp;
    }

    public int getId_source() {
        return this.id_source;
    }

    public void setId_source(int id_source) {
        this.id_source = id_source;
    }

    public double getPrice_product() {
        return this.price_product;
    }

    public void setPrice_product(double price_product) {
        this.price_product = price_product;
    }

    public boolean isPrint_ingredients() {
        return this.print_ingredients;
    }

    public void setPrint_ingredients(boolean print_ingredients) {
        this.print_ingredients = print_ingredients;
    }

    public List<ProductTicket> getOldProductsTicket() {
        return this.oldProductsTicket;
    }

    public void setOldProductsTicket(List<ProductTicket> oldProductsTicket) {
        this.oldProductsTicket = oldProductsTicket;
    }

    public List<ItemOrderInfo> getOldIngredientsTicket() {
        return this.oldIngredientsTicket;
    }

    public void setOldIngredientsTicket(List<ItemOrderInfo> oldIngredientsTicket) {
        this.oldIngredientsTicket = oldIngredientsTicket;
    }

    public List<OptionItemOrder> getOldOptionsTicket() {
        return this.oldOptionsTicket;
    }

    public void setOldOptionsTicket(List<OptionItemOrder> oldOptionsTicket) {
        this.oldOptionsTicket = oldOptionsTicket;
    }

    public int getId_additional_sale() {
        return this.id_additional_sale;
    }

    public void setId_additional_sale(int id_additional_sale) {
        this.id_additional_sale = id_additional_sale;
    }

    public boolean isPromo_basket() {
        return this.promo_basket;
    }

    public void setPromo_basket(boolean promo_basket) {
        this.promo_basket = promo_basket;
    }

    public String getType_discount() {
        return this.type_discount;
    }

    public void setType_discount(String type_discount) {
        this.type_discount = type_discount;
    }

    public boolean isDisplay_image_in_kitchen() {
        return this.display_image_in_kitchen;
    }

    public void setDisplay_image_in_kitchen(boolean display_image_in_kitchen) {
        this.display_image_in_kitchen = display_image_in_kitchen;
    }

    public String getImage_path() {
        return this.image_path;
    }

    public void setImage_path(String image_path) {
        this.image_path = image_path;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getDaily_stock() {
        return this.daily_stock;
    }

    public void setDaily_stock(int daily_stock) {
        this.daily_stock = daily_stock;
    }

    public String printLabelDiscount() {
        if (this.labelDiscount != null) {
            if (this.oldLabelsDiscount.contains(this.labelDiscount) || this.promo_product) {
                return this.labelDiscount.startsWith("R\u00e9duction Avomark ") ? "Programme de fid\u00e9lit\u00e9 " : this.labelDiscount;
            }
            StringBuilder text_discount = new StringBuilder();
            text_discount.append(this.labelDiscount);
            text_discount.append(" ");
            text_discount.append("-");
            text_discount.append(NumericUtils.numberToString(this.discount));
            text_discount.append(" ");
            text_discount.append(this.type_discount != null && this.type_discount.equals("pourcentage") ? "%" : Formats.getCurrency());
            return text_discount.toString().startsWith("R\u00e9duction Avomark ") ? "Programme de fid\u00e9lit\u00e9 " : text_discount.toString();
        }
        if (this.getValueDiscount() == 100.0) {
            return "Offert";
        }
        return this.type_discount != null && this.type_discount.equals("somme") ? "promotion " : "promotion " + (int)this.discount + "%";
    }

    public void setMenu(boolean menu) {
        this.menu = menu;
    }

    public boolean isPromo_product() {
        return this.promo_product;
    }

    public void setPromo_product(boolean promo_product) {
        this.promo_product = promo_product;
    }

    public double getPoints_loyalty() {
        return this.points_loyalty;
    }

    public void setPoints_loyalty(double points_loyalty) {
        this.points_loyalty = points_loyalty;
    }

    public int getId_line_kitchen() {
        return this.id_line_kitchen;
    }

    public void setId_line_kitchen(int id_line_kitchen) {
        this.id_line_kitchen = id_line_kitchen;
    }

    public int getIndex_line() {
        return this.index_line;
    }

    public void setIndex_line(int index_line) {
        this.index_line = index_line;
    }

    public int getIndex_line_parent() {
        return this.index_line_parent;
    }

    public void setIndex_line_parent(int index_line_parent) {
        this.index_line_parent = index_line_parent;
    }

    public String printName(boolean showAlias) {
        String text_name = showAlias && this.alias_name_product != null && !this.alias_name_product.trim().isEmpty() ? this.alias_name_product : this.nameProduct;
        return text_name;
    }

    public boolean isValid_caisse() {
        return this.valid_caisse;
    }

    public void setValid_caisse(boolean valid_caisse) {
        this.valid_caisse = valid_caisse;
    }

    public boolean hasExcludedIngredients() {
        return this.listIngredients.stream().anyMatch(ingredient -> ingredient.getIdProduct() == -1 || ingredient.getIdProduct() == 0);
    }

    public String printValueMinusDiscount() {
        if (this.next) {
            return "";
        }
        return this.points_loyalty > 0.0 ? Formats.INT.formatValue(this.points_loyalty * this.multiply) + " pt" : Formats.CURRENCY.formatValue(this.getPriceAfterDiscount());
    }

    public boolean isProduct_platform() {
        return this.product_platform;
    }

    public void setProduct_platform(boolean product_platform) {
        this.product_platform = product_platform;
    }

    public static SerializerRead getSerializerReadPlatform() {
        return new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                TicketLineInfo ticketLine = new TicketLineInfo();
                ticketLine.ID = dr.getInt(1);
                ticketLine.m_sTicket = dr.getString(2);
                ticketLine.multiply = dr.getDouble(3);
                ticketLine.price = dr.getDouble(4);
                ticketLine.menu = dr.getBoolean(5);
                ticketLine.htAmount = dr.getDouble(6);
                ticketLine.taxAmount = dr.getDouble(7);
                ticketLine.next = dr.getBoolean(8);
                ticketLine.note = dr.getString(9);
                ticketLine.discount = dr.getDouble(10);
                ticketLine.sizeProduct = dr.getString(11);
                ticketLine.name_sizeProduct = dr.getString(12);
                ticketLine.labelDiscount = dr.getString(13);
                ticketLine.nameProduct = dr.getString(14);
                ticketLine.paid = dr.getBoolean(15);
                ticketLine.units_paid = dr.getDouble(16);
                ticketLine.place_served = dr.getString(17);
                ticketLine.time_served = dr.getString(18);
                ticketLine.numero_line = dr.getInt(19);
                ticketLine.label = dr.getBoolean(20);
                ticketLine.printer_kitchen = dr.getString(21);
                ticketLine.promo_basket = dr.getBoolean(22);
                ticketLine.type_discount = dr.getString(23);
                ticketLine.promo_product = dr.getBoolean(24);
                ticketLine.id_line_kitchen = dr.getInt(25);
                ticketLine.points_loyalty = dr.getDouble(26);
                ticketLine.diver = false;
                ticketLine.difference_quantity = 0.0;
                ticketLine.tax = new TaxInfo(dr.getString(27), dr.getString(28), dr.getDouble(29));
                return ticketLine;
            }
        };
    }

    public String getAlias_size() {
        return this.alias_size;
    }

    public void setAlias_size(String alias_size) {
        this.alias_size = alias_size;
    }

    public int getOffset_print_kitchen() {
        return this.offset_print_kitchen;
    }

    public void setOffset_print_kitchen(int offset_print_kitchen) {
        this.offset_print_kitchen = offset_print_kitchen;
    }

    public boolean isProduct_promotion_applied() {
        return this.product_promotion_applied;
    }

    public void setProduct_promotion_applied(boolean product_promotion_applied) {
        this.product_promotion_applied = product_promotion_applied;
    }

    public boolean isTva_global_no_applicable() {
        return this.tva_global_no_applicable;
    }

    public void setTva_global_no_applicable(boolean tva_global_no_applicable) {
        this.tva_global_no_applicable = tva_global_no_applicable;
    }

    public String getLabel_promotion() {
        return this.label_promotion;
    }

    public void setLabel_promotion(String label_promotion) {
        this.label_promotion = label_promotion;
    }

    public double getPriceWithoutTaxedOptions() {
        double priceOption = 0.0;
        if (AppLocal.MODULE_MULTI_TVA && !this.isDiver() && this.listSupplements != null) {
            for (OptionItemOrder supplement : this.listSupplements) {
                if (!supplement.addTaxeToOption() || supplement.getTax() == null) continue;
                priceOption += supplement.getFull_price();
            }
        }
        return this.price - priceOption;
    }

    public double getDiscountPercent() {
        double discountPercent = 0.0;
        discountPercent = this.promo_basket || this.type_discount != null && this.type_discount.equals("somme") ? NumericUtils.round(100.0 * this.discount / (this.getPrice() * this.multiply)) : this.discount;
        return discountPercent;
    }

    public double getDiscountPriceWithoutTaxedOptions() {
        return NumericUtils.round(this.getDiscountPercent() * this.getPriceWithoutTaxedOptions() / 100.0 * this.multiply);
    }

    public double getPriceProductMinusPriceIncluded() {
        double priceProduct = 0.0;
        if (!this.isDiver()) {
            if (this.listSupplements != null) {
                for (OptionItemOrder supplement : this.listSupplements) {
                    priceProduct += supplement.getFull_price();
                }
            }
            if (this.listProducts != null) {
                for (ProductTicket item : this.listProducts) {
                    priceProduct += (double)item.getNumberProduct() * item.getPriceProduct();
                }
            }
        }
        return this.price - priceProduct;
    }

    public String getId_global_product() {
        return this.id_global_product;
    }

    public void setId_global_product(String id_global_product) {
        this.id_global_product = id_global_product;
    }

    public String getDisplayedName() {
        return this.displayedName != null && !this.displayedName.isEmpty() ? this.displayedName : this.nameProduct;
    }

    public void setDisplayedName(String displayedName) {
        this.displayedName = displayedName;
    }

    public int getMarque() {
        return this.marque;
    }

    public void setMarque(int marque) {
        this.marque = marque;
    }

    public List<MultiLanguageProduct> getMultiLanguageTexts() {
        return this.multiLanguageTexts;
    }

    public void setMultiLanguageTexts(List<MultiLanguageProduct> multiLanguageTexts) {
        this.multiLanguageTexts = multiLanguageTexts;
    }

    public String getNameByLanguage(String code_language) {
        String nameByLanguage = "";
        if (this.multiLanguageTexts != null && this.multiLanguageTexts.size() > 0 && code_language != null && !code_language.isEmpty()) {
            for (MultiLanguageProduct multiLanguageText : this.multiLanguageTexts) {
                if (!code_language.equalsIgnoreCase(multiLanguageText.getLanguage())) continue;
                nameByLanguage = multiLanguageText.getName();
                break;
            }
        }
        return nameByLanguage;
    }

    public int getIdZone() {
        return this.idZone;
    }

    public void setIdZone(int idZone) {
        this.idZone = idZone;
    }

    public String getNameZone() {
        return this.nameZone;
    }

    public void setNameZone(String nameZone) {
        this.nameZone = nameZone;
    }

    public boolean isProduct_later() {
        return this.product_later;
    }

    public void setProduct_later(boolean product_later) {
        this.product_later = product_later;
    }
}

