/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.ticket;

import com.openbravo.basic.BasicException;
import com.openbravo.basic.BasicStorage;
import com.openbravo.dao.DataLogicItems;
import com.openbravo.dao.DataLogicProduct;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.dao.DataLogicSynchronisation;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.ticket.CarteInfo;
import com.openbravo.pos.ticket.ItemOrderInfo;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.ProductTicket;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.ticket.SupplementProduct;
import com.openbravo.pos.ticket.TaxInfo;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.ticket.UberEatPromotion;
import com.openbravo.pos.ticket.UserInfo;
import com.openbravo.pos.util.ColorUtils;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.NumericUtils;
import com.openbravo.service.ItemService;
import fr.protactile.kitchen.dao.entities.Itemsticket;
import fr.protactile.kitchen.dao.entities.Optionsticket;
import fr.protactile.kitchen.dao.entities.Ticketlines;
import fr.protactile.kitchen.dao.entities.Tickets;
import fr.protactile.procaisse.dao.entities.AddressInfo;
import fr.protactile.procaisse.dao.entities.CustomerInfo;
import fr.protactile.procaisse.services.AddressService;
import fr.protactile.procaisse.services.CustomerService;
import fr.protactile.procaisse.services.LoyaltyCardService;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class TicketInfoBuilder {
    private TicketInfo m_ticketInfo;
    private DataLogicProduct m_DataLogicProduct;
    private DataLogicSynchronisation dlSync;
    private DataLogicSales dlSales;
    private boolean slave;
    private HashMap<Integer, String> sizes_product = new HashMap();
    private HashMap<Integer, String> label_sizes_product = new HashMap();
    private CustomerService mCustomerService;
    private AddressService mAddressService;
    private LoyaltyCardService mLoyaltyCardService;
    private DataLogicItems dlItems;
    private AppView m_appView = (AppView)BasicStorage.getObject("APP_ROOT_INSTANCE");
    private Tickets order;
    private JSONObject objectOrder;
    private ItemService mItemService;
    private String BORNE = "borne";
    private String PREFIX_PRODUCT = "product_";
    private String PREFIX_OPTION = "option_";
    private final String PLATFORM_UBEREATS = "ubereats";
    private final String PLATFORM_JUSTEAT = "justeat";
    private final String PLATFORM_DELIVEROO_WEB = "deliveroo_web";
    private final String PLATFORM_DELIVEROO_TABLET = "deliveroo_tablet";
    private String PERCENTAGE_OFF_ON_BASKET = "percentage_off_on_basket";
    private String PERCENTAGE_OFF_ON_ITEMS = "percentage_off_on_items";
    private final String BOGO = "BOGO";
    private final String FLATOFF = "FLATOFF";
    private final String FREEITEM_MINBASKET = "FREEITEM_MINBASKET";
    private final String MENU_ITEM_DISCOUNT = "MENU_ITEM_DISCOUNT";
    private final String CATEGORY_DISCOUNT = "CATEGORY_DISCOUNT";
    private final String FREEDELIVERY = "FREEDELIVERY";
    private String PREFIX_PRODUCT_PLATFORM = "P_";
    private String PREFIX_OPTION_PLATFORM = "O_";
    private List<UberEatPromotion> uber_promotions;
    private HashMap<String, String> map_type_promo;

    private TicketInfoBuilder(DataLogicSales dlSales) {
        this.dlSales = dlSales;
        this.m_DataLogicProduct = AppLocal.dlProduct;
        if (dlSales == null) {
            this.dlSales = AppLocal.dlSales;
        }
        this.dlSync = (DataLogicSynchronisation)this.m_appView.getBean("com.openbravo.dao.DataLogicSynchronisation");
        this.dlItems = (DataLogicItems)this.m_appView.getBean("com.openbravo.dao.DataLogicItems");
        this.m_ticketInfo = new TicketInfo();
        this.slave = AppLocal.modeCaisse != null && AppLocal.modelCaisse.equals("Esclave");
        this.sizes_product.put(0, null);
        this.sizes_product.put(1, "junior");
        this.sizes_product.put(2, "senior");
        this.sizes_product.put(3, "mega");
        this.sizes_product.put(4, "size1");
        this.sizes_product.put(5, "size2");
        this.sizes_product.put(6, "size3");
        this.label_sizes_product.put(0, null);
        this.label_sizes_product.put(1, AppLocal.PRODUCT_SIZE_JUNIOR);
        this.label_sizes_product.put(2, AppLocal.PRODUCT_SIZE_SENIOR);
        this.label_sizes_product.put(3, AppLocal.PRODUCT_SIZE_MEGA);
        this.label_sizes_product.put(4, AppLocal.PRODUCT_SIZE1);
        this.label_sizes_product.put(5, AppLocal.PRODUCT_SIZE2);
        this.label_sizes_product.put(6, AppLocal.PRODUCT_SIZE3);
        this.mCustomerService = CustomerService.getInstance();
        this.mAddressService = AddressService.getInstance();
        this.mLoyaltyCardService = LoyaltyCardService.getInstance();
        this.mItemService = ItemService.getInstance();
        this.uber_promotions = new ArrayList<UberEatPromotion>();
        this.map_type_promo = new HashMap();
        this.map_type_promo.put("BOGO", "Un achet\u00e9, un offert");
        this.map_type_promo.put("FLATOFF", "R\u00e9duction sur la commande");
        this.map_type_promo.put("FREEITEM_MINBASKET", "Article gratuit");
        this.map_type_promo.put("MENU_ITEM_DISCOUNT", "R\u00e9duction sur un plat du menu");
        this.map_type_promo.put("CATEGORY_DISCOUNT", "R\u00e9duction sur une cat\u00e9gorie");
    }

    public static TicketInfoBuilder create(DataLogicSales dlSales) {
        return new TicketInfoBuilder(dlSales);
    }

    private double getLinePrice(TicketLineInfo line) {
        double price = line.getPrice();
        for (OptionItemOrder optionItemOrder : line.getListSupplements()) {
            price += optionItemOrder.getPrice().doubleValue();
        }
        for (ProductTicket item : line.getListProducts()) {
            price += item.getPriceProduct();
        }
        return price;
    }

    public TicketInfoBuilder build(List<String> inputs) {
        TicketLineInfo last_line = null;
        for (String next : inputs) {
            String[] substract = new String[]{};
            if (next.startsWith("S")) {
                substract = next.split(" ");
                String source_borne = substract[1].equals("1") ? "borne" : "caisse";
                this.m_ticketInfo.setSent_from(source_borne);
            }
            if (next.startsWith("N")) {
                substract = next.split(" ");
                this.m_ticketInfo.setNumero_order(new Integer(substract[1].trim()));
                this.m_ticketInfo.setNum_order_borne(substract[2].trim());
            }
            if (next.startsWith("T")) {
                substract = next.split(" ");
                if (substract[1].equals("2")) {
                    this.m_ticketInfo.setType("A Emporter");
                } else {
                    this.m_ticketInfo.setType("Sur Place");
                }
            }
            if (next.startsWith("L")) {
                try {
                    boolean promo_basket;
                    if (last_line != null) {
                        last_line.setPrice(this.getLinePrice(last_line));
                        this.m_ticketInfo.getLines().add(last_line);
                        last_line = null;
                    }
                    substract = next.split(" ");
                    int id_product = this.slave ? this.getProductID(substract[1]) : Integer.parseInt(substract[1]);
                    double price_line = Double.parseDouble(substract[3]);
                    ProductInfoExt pInfo = this.m_DataLogicProduct.getProductInfo(id_product, false);
                    String time_served = Integer.parseInt(substract[5]) == 0 ? null : "later";
                    String size_product = this.sizes_product.get(Integer.parseInt(substract[4]));
                    String label_size_product = this.label_sizes_product.get(Integer.parseInt(substract[4]));
                    boolean valid_caisse = pInfo.isValid_caisse();
                    boolean bl = substract.length >= 7 ? Integer.parseInt(substract[6]) == 1 : (promo_basket = false);
                    if (pInfo != null) {
                        pInfo.setListSizes(this.dlItems.getProductSizes(pInfo.getID(), true));
                        pInfo.setPrices(this.dlItems.getProductPrices(pInfo.getID(), true));
                        pInfo.setPriceOrder(this.m_ticketInfo.getType(), size_product, false);
                        TaxInfo tax = this.dlSales.getTaxById(pInfo.getTaxCategoryID());
                        last_line = new TicketLineInfo(pInfo, new Double(substract[2]), pInfo.getPriceSell(), tax, new ArrayList<ItemOrderInfo>(), new ArrayList<OptionItemOrder>(), pInfo.isMenu(), tax.getRate(), new ArrayList<ProductTicket>(), label_size_product, size_product, 0.0, null, false, null, null, time_served, -1);
                        last_line.setPromo_basket(promo_basket);
                        if (last_line.isPromo_basket()) {
                            last_line.setDiscount(pInfo.getPriceSell() - AppLocal.PRICE_PROMO_BASKET);
                            last_line.setType_discount("somme");
                        }
                    }
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
            if (next.startsWith("I")) {
                try {
                    substract = next.split(" ");
                    int id_ingredient = this.slave ? this.dlSync.getOption(substract[1]) : Integer.parseInt(substract[1]);
                    SupplementItemInfo ingredientItem = this.m_DataLogicProduct.getSuppelementById(id_ingredient);
                    if (ingredientItem != null) {
                        ItemOrderInfo ingredient = new ItemOrderInfo(ingredientItem, -1, -1, null, null, -1, null, null, null, null);
                        if (last_line != null) {
                            if (last_line.getListIngredients() == null) {
                                last_line.setListIngredients(new ArrayList<ItemOrderInfo>());
                            }
                            last_line.getListIngredients().add(ingredient);
                        }
                    }
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
            if (next.startsWith("O")) {
                try {
                    substract = next.split(" ");
                    int id_option = this.slave ? this.dlSync.getOption(substract[1]) : Integer.parseInt(substract[1]);
                    SupplementItemInfo optionItem = this.dlItems.getFullInfoSupplementById(id_option);
                    if (optionItem != null) {
                        int number_option = new Integer(substract[2]);
                        int number_free = new Integer(substract[3]);
                        if (last_line != null) {
                            double price_option = optionItem.getPriceOption(last_line.getName_sizeProduct(), this.m_ticketInfo.getType());
                            double price_option_order = (double)(number_option - number_free) * price_option;
                            OptionItemOrder option = new OptionItemOrder(-1, -1, null, null, number_option, optionItem.isBold(), price_option_order, -1, number_free, optionItem.isSeparate(), false, null, optionItem.getId_supplement(), optionItem.getPrinter(), optionItem.getShift_option(), optionItem.isDisplay_screen_sorti(), ColorUtils.getColor(optionItem.getColor()), optionItem, optionItem.isNo_printable(), null, null, optionItem.getName_groupe_option(), false, null, null);
                            if (last_line.getListSupplements() == null) {
                                last_line.setListSupplements(new ArrayList<OptionItemOrder>());
                            }
                            last_line.getListSupplements().add(option);
                        }
                    }
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
            if (!next.startsWith("P")) continue;
            try {
                substract = next.split(" ");
                ProductInfoExt item = null;
                String name_carte = null;
                String name_sizeProduct = null;
                int id_carte = -1;
                int idProduct = this.slave ? this.getProductID(substract[2]) : Integer.parseInt(substract[2]);
                int quantity = new Integer(substract[3]);
                if (substract[1] != null && !substract[1].isEmpty() && !substract[1].equals("-1")) {
                    int idCarte = this.slave ? this.dlSync.getCarte(substract[1]) : Integer.parseInt(substract[1]);
                    CarteInfo carte = this.m_DataLogicProduct.getCarteById(idCarte);
                    item = this.m_DataLogicProduct.getProductPlatById(idCarte, idProduct, false);
                    String string = name_sizeProduct = carte != null ? carte.getSizeCarte() : null;
                    if (carte != null) {
                        name_carte = carte.getName();
                        id_carte = carte.getId();
                    }
                } else {
                    item = this.m_DataLogicProduct.getProductInfo(idProduct, false);
                    item.setPriceSell(0.0);
                }
                if (last_line == null || item == null) continue;
                ProductTicket product = new ProductTicket(item, id_carte, name_carte, quantity, 1, name_sizeProduct, null, null, null);
                if (last_line.getListProducts() == null) {
                    last_line.setListProducts(new ArrayList<ProductTicket>());
                }
                last_line.getListProducts().add(product);
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        if (last_line != null) {
            last_line.setPrice(this.getLinePrice(last_line));
            this.m_ticketInfo.getLines().add(last_line);
        }
        return this;
    }

    public TicketInfoBuilder build() {
        return this.build(this.order, this.m_ticketInfo, false);
    }

    public TicketInfoBuilder build(boolean default_value) {
        return this.build(this.order, this.m_ticketInfo, default_value);
    }

    public TicketInfoBuilder build(Tickets order, TicketInfo m_ticketInfo, boolean default_value) {
        m_ticketInfo.setSent_from(order.getSourceOrder());
        m_ticketInfo.setNumero_order(order.getNumero());
        m_ticketInfo.setType(order.getType());
        m_ticketInfo.setNum_order_borne(order.getNumOrderBorne() != null ? order.getNumOrderBorne().trim() : null);
        m_ticketInfo.setId_shared_order(order.getId());
        m_ticketInfo.setDate(order.getCreated());
        m_ticketInfo.setTypeDiscount(order.getType_discount() != null ? order.getType_discount() : "pourcentage");
        m_ticketInfo.setBipper(order.getBipper());
        m_ticketInfo.setDiscount(order.getDiscount());
        m_ticketInfo.setNum_order_kitchen(order.getNum_order_kitchen());
        m_ticketInfo.setId_order_kitchen(order.getId_order_kitchen());
        m_ticketInfo.setModePayment(order.getTypePayment());
        m_ticketInfo.setError_print_kitchen(order.isError_print_kitchen());
        m_ticketInfo.setCaisse(order.getHostName());
        m_ticketInfo.setCouverts(order.getCouvert());
        m_ticketInfo.setNum_table(order.getNum_table());
        m_ticketInfo.setIdSourceSharedOrder(order.getId_ticket_source());
        m_ticketInfo.setAddress_ip_borne(order.getAddress_ip_borne());
        m_ticketInfo.setOrder_id_base(order.getOrder_id_base());
        m_ticketInfo.setKeenio_base(order.getKeenio_base());
        m_ticketInfo.setTotal(order.getTotal());
        m_ticketInfo.setPaid(order.getPaid());
        m_ticketInfo.setShared_order(order.isExterior_order());
        m_ticketInfo.setLabel_discount(order.getLabel_discount());
        m_ticketInfo.setEasel_number(order.getEasel_number());
        m_ticketInfo.setValue_in_base(order.getValuse_in_base());
        m_ticketInfo.setValue_out_base(order.getValue_out_base());
        if (order.getUser() != null && !order.getUser().isEmpty()) {
            UserInfo user = new UserInfo(order.getUser(), order.getName_user());
            m_ticketInfo.setUser(user);
        }
        if (order.getCustomer_phone() != null && !order.getCustomer_phone().isEmpty()) {
            Object mCustomerInfo;
            if (this.mCustomerService == null) {
                this.mCustomerService = CustomerService.getInstance();
            }
            if ((mCustomerInfo = this.mCustomerService.findOneByPhone(order.getCustomer_phone())) == null) {
                try {
                    mCustomerInfo = new CustomerInfo();
                    ((CustomerInfo)mCustomerInfo).setName(order.getCustomer_name());
                    ((CustomerInfo)mCustomerInfo).setPhone(order.getCustomer_phone());
                    this.mCustomerService.save((CustomerInfo)mCustomerInfo);
                }
                catch (BasicException ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
            if (mCustomerInfo != null) {
                ((CustomerInfo)mCustomerInfo).setLoyaltyCardCollection(this.mLoyaltyCardService.findByCustomer(((CustomerInfo)mCustomerInfo).getId()));
            }
            m_ticketInfo.setCustomer((CustomerInfo)mCustomerInfo);
            if (order.getLicence_id_machine() != null && !order.getLicence_id_machine().isEmpty()) {
                m_ticketInfo.setCustomer_loyalty_id(order.getLicence_id_machine());
            }
        } else if (order.getCustomer_name() != null && !order.getCustomer_name().isEmpty()) {
            m_ticketInfo.setName_customer(order.getCustomer_name());
        }
        try {
            for (Ticketlines ticketLine : order.getTicketlinesCollection()) {
                if (ticketLine.isNext_line()) {
                    TicketLineInfo ticketNext = new TicketLineInfo();
                    ticketNext.setNext(true);
                    ticketNext.setNextRetourn("---------Faire Suivre-------------");
                    m_ticketInfo.getLines().add(ticketNext);
                    continue;
                }
                if (!(ticketLine.getUnit_paid() < ticketLine.getQuantity())) continue;
                TicketLineInfo line = null;
                ProductInfoExt pInfo = null;
                String idGlobalProduct = ticketLine.getId_global_product();
                if (idGlobalProduct != null && !idGlobalProduct.isEmpty()) {
                    pInfo = this.m_DataLogicProduct.getProductByIdGlobal(idGlobalProduct);
                } else {
                    int id_product = this.slave ? this.getProductID(ticketLine.getRefProduct()) : Integer.parseInt(ticketLine.getRefProduct());
                    pInfo = this.m_DataLogicProduct.getProductInfo(id_product, true);
                }
                if (pInfo != null) {
                    pInfo.setListSizes(this.dlItems.getProductSizes(pInfo.getID(), true));
                    pInfo.setPrices(this.dlItems.getProductPrices(pInfo.getID(), true));
                    pInfo.setPriceOrder(m_ticketInfo.getType(), ticketLine.getName_size_product(), false);
                    TaxInfo tax = this.dlSales.getTaxById(pInfo.getTaxCategoryID());
                    line = new TicketLineInfo(pInfo, ticketLine.getQuantity() - ticketLine.getUnit_paid(), pInfo.getPriceSell(), tax, new ArrayList<ItemOrderInfo>(), new ArrayList<OptionItemOrder>(), pInfo.isMenu(), tax.getRate(), new ArrayList<ProductTicket>(), ticketLine.getSize_product(), ticketLine.getName_size_product(), ticketLine.getDiscount(), ticketLine.getNote(), false, ticketLine.getLabel_discount(), ticketLine.getPlace_served(), ticketLine.getTime_served(), -1);
                    line.setAlias_size(ticketLine.getAlias_size());
                    line.setPromo_basket(ticketLine.isPromo_basket());
                    line.setPoints_loyalty(ticketLine.getPoints_loyalty());
                    if (line.isPromo_basket()) {
                        line.setDiscount(pInfo.getPriceSell() - AppLocal.PRICE_PROMO_BASKET);
                        line.setType_discount("somme");
                    } else if (line.getPoints_loyalty() != 0.0 || ticketLine.getDiscount() != 0.0) {
                        if (ticketLine.getType_discount() == null || ticketLine.getType_discount().isEmpty()) {
                            line.setType_discount("pourcentage");
                        } else {
                            line.setType_discount(ticketLine.getType_discount());
                        }
                    }
                    line.setPromo_product(ticketLine.isPromo_product());
                    line.setPoints_loyalty(ticketLine.getPoints_loyalty());
                    line.setId_source(ticketLine.getId());
                    line.setId_line_kitchen(ticketLine.getId_line_kitchen());
                    if (ticketLine.getId_line_source() != -1 && ticketLine.getId_line_source() != 0) {
                        line.setID(ticketLine.getId_line_source());
                    }
                }
                for (Optionsticket optionTicket : ticketLine.getOptionsticketCollection()) {
                    SupplementItemInfo optionParent;
                    int id_option = this.slave ? this.dlSync.getOption(optionTicket.getRefOption()) : Integer.parseInt(optionTicket.getRefOption());
                    int idCarte = 0;
                    idCarte = optionTicket.getId_global_carte() != null && !optionTicket.getId_global_carte().isEmpty() ? this.m_DataLogicProduct.getIdCarteByIdGlobal(optionTicket.getId_global_carte()) : (optionTicket.getRef_carte() != null ? (this.slave ? this.dlSync.getCarte(optionTicket.getRef_carte()) : Integer.parseInt(optionTicket.getRef_carte())) : (this.slave && optionTicket.getId_carte() != -1 ? this.dlSync.getCarte(String.valueOf(optionTicket.getId_carte())) : optionTicket.getId_carte()));
                    int idProduct = 0;
                    idProduct = optionTicket.getId_global_product() != null && !optionTicket.getId_global_product().isEmpty() ? this.m_DataLogicProduct.getIdProductByIdGlobal(optionTicket.getId_global_product()) : (optionTicket.getRef_product() != null ? (this.slave ? this.getProductID(optionTicket.getRef_product()) : Integer.parseInt(optionTicket.getRef_product())) : (this.slave && optionTicket.getId_product() != -1 ? this.getProductID(String.valueOf(optionTicket.getId_product())) : optionTicket.getId_product()));
                    SupplementItemInfo optionItem = null;
                    optionItem = optionTicket.getId_global_supplement() != null && !optionTicket.getId_global_supplement().isEmpty() ? this.dlItems.getFullInfoSupplementByIdGlobal(optionTicket.getId_global_supplement()) : this.dlItems.getFullInfoSupplementById(id_option);
                    if (optionItem == null) continue;
                    if (optionTicket.getIsIngredient()) {
                        ItemOrderInfo ingredient = new ItemOrderInfo(optionItem, idCarte, idProduct, optionTicket.getName_product(), optionTicket.getName_carte(), optionTicket.getIndex_carte(), optionTicket.getRef_product(), optionTicket.getRef_carte(), optionTicket.getId_global_product(), optionTicket.getId_global_carte());
                        ingredient.setId_ingredient_kitchen(optionTicket.getId_supplement_kitchen());
                        if (line == null) continue;
                        if (line.getListIngredients() == null) {
                            line.setListIngredients(new ArrayList<ItemOrderInfo>());
                        }
                        line.getListIngredients().add(ingredient);
                        line.getOldIngredientsTicket().add((ItemOrderInfo)ingredient.clone());
                        continue;
                    }
                    int number_option = optionTicket.getQuantity();
                    int number_free = optionTicket.getNumberFree();
                    int parent_supplement_id = 0;
                    if (optionTicket.getId_global_parent_supplement() != null && !optionTicket.getId_global_parent_supplement().isEmpty() && (optionParent = this.dlItems.getSupplementByIdGlobal(optionTicket.getId_global_parent_supplement())) != null) {
                        parent_supplement_id = optionParent.getiD();
                    }
                    if (line == null) continue;
                    double price_option = optionItem.getPriceOption(line.getName_sizeProduct(), m_ticketInfo.getType());
                    double price_option_order = (double)(number_option - number_free) * price_option;
                    OptionItemOrder option = new OptionItemOrder(idCarte, idProduct, optionTicket.getName_product(), optionTicket.getName_carte(), number_option, optionItem.isBold(), price_option_order, optionTicket.getIndex_carte(), number_free, optionItem.isSeparate(), false, optionTicket.getRefOption(), optionItem.getId_supplement(), optionItem.getPrinter(), optionItem.getShift_option(), optionItem.isDisplay_screen_sorti(), ColorUtils.getColor(optionItem.getColor()), optionItem, optionItem.isNo_printable(), optionTicket.getRef_product(), optionTicket.getRef_carte(), optionItem.getName_groupe_option(), false, optionTicket.getId_global_product(), optionTicket.getId_global_carte());
                    option.setId_supplement_kitchen(optionTicket.getId_supplement_kitchen());
                    option.setTime_served(optionTicket.getTime_served());
                    option.setParent_supplement_id(parent_supplement_id);
                    if (line.getListSupplements() == null) {
                        line.setListSupplements(new ArrayList<OptionItemOrder>());
                    }
                    line.getListSupplements().add(option);
                    line.getOldOptionsTicket().add((OptionItemOrder)option.clone());
                }
                for (Itemsticket itemTicket : ticketLine.getItemsticketCollection()) {
                    ProductInfoExt item = null;
                    CarteInfo carte = null;
                    String name_carte = null;
                    int id_carte = -1;
                    String ref_carte = null;
                    String id_global_carte = null;
                    String size_nameProduct = null;
                    if (itemTicket.getId_global_product() != null && !itemTicket.getId_global_product().isEmpty()) {
                        if (itemTicket.getId_global_carte() != null && !itemTicket.getId_global_carte().isEmpty()) {
                            item = this.m_DataLogicProduct.getProductPlatByIdGlobal(itemTicket.getId_global_carte(), itemTicket.getId_global_product());
                            carte = this.m_DataLogicProduct.getCarteByIdGlobal(itemTicket.getId_global_carte());
                        } else {
                            item = this.m_DataLogicProduct.getProductByIdGlobal(itemTicket.getId_global_product());
                            if (item != null) {
                                item.setPriceSell(0.0);
                            }
                        }
                    } else {
                        int idProduct;
                        int n = idProduct = this.slave ? this.getProductID(itemTicket.getRefProduct()) : Integer.parseInt(itemTicket.getRefProduct());
                        if (itemTicket.getRefCarte() != null && !itemTicket.getRefCarte().isEmpty() && !itemTicket.getRefCarte().equals("-1")) {
                            int idCarte = this.slave ? this.dlSync.getCarte(itemTicket.getRefCarte()) : Integer.parseInt(itemTicket.getRefCarte());
                            item = this.m_DataLogicProduct.getProductPlatById(idCarte, idProduct, true);
                            carte = this.m_DataLogicProduct.getCarteById(idCarte);
                        } else {
                            item = this.m_DataLogicProduct.getProductInfo(idProduct, true);
                            if (item != null) {
                                item.setPriceSell(0.0);
                            }
                        }
                    }
                    String string = size_nameProduct = carte != null ? carte.getSizeCarte() : null;
                    if (carte != null) {
                        name_carte = carte.getName();
                        id_carte = carte.getId();
                        ref_carte = carte.getRef_web();
                        id_global_carte = carte.getId_global();
                    }
                    if (line == null || item == null) continue;
                    ProductTicket product = new ProductTicket(item, id_carte, name_carte, itemTicket.getQuantity(), itemTicket.getIndex_item(), size_nameProduct, item.getRef_web(), ref_carte, id_global_carte);
                    product.setId_item_kitchen(itemTicket.getId_item_kitchen());
                    if (line.getListProducts() == null) {
                        line.setListProducts(new ArrayList<ProductTicket>());
                    }
                    line.getListProducts().add(product);
                    line.getOldProductsTicket().add((ProductTicket)product.clone());
                }
                if (line == null) continue;
                line.setPrice(ticketLine.getPrice() != 0.0 ? ticketLine.getPrice() : this.getLinePrice(line));
                m_ticketInfo.getLines().add(line);
            }
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        if (default_value) {
            for (TicketLineInfo line : m_ticketInfo.getLines()) {
                if (line.isNext()) continue;
                if (line.getPlace_served() == null) {
                    line.setPlace_served(m_ticketInfo.getType());
                }
                if (line.getTime_served() != null) continue;
                line.setTime_served("now");
            }
        }
        return this;
    }

    public TicketInfo toTicketInfo() {
        return this.m_ticketInfo;
    }

    public TicketInfo toTicketInfo(Tickets order) {
        return this.m_ticketInfo;
    }

    public void toTicketInfo(Tickets order, TicketInfo ticketInfo, boolean setDefaultValues) {
        this.build(order, ticketInfo, setDefaultValues);
    }

    public List<TicketInfo> toTickets(List<Tickets> orders) {
        ArrayList<TicketInfo> tickets = new ArrayList<TicketInfo>();
        for (Tickets order : orders) {
            TicketInfo ticketInfo = new TicketInfo();
            ticketInfo.setOrdered_from("outside");
            this.toTicketInfo(order, ticketInfo, false);
            tickets.add(ticketInfo);
        }
        return tickets;
    }

    public List<TicketInfo> toTickets(JSONArray jsonOrders, Date dateStart, Date dateEnd, boolean new_orders) {
        ArrayList<TicketInfo> tickets = new ArrayList<TicketInfo>();
        for (int i = 0; i < jsonOrders.length(); ++i) {
            JSONObject order = jsonOrders.getJSONObject(i);
            TicketInfo ticketInfo = this.toTicketInfo(order, dateStart, dateEnd, new_orders);
            if (ticketInfo == null) continue;
            tickets.add(ticketInfo);
        }
        return tickets;
    }

    public TicketInfo toTicketInfo(JSONObject order, Date dateStart, Date dateEnd, boolean new_orders) {
        return this.build(order, dateStart, dateEnd, new_orders);
    }

    public TicketInfo build(JSONObject order, Date dateStart, Date dateEnd, boolean new_orders) {
        boolean is_caisse_slave = this.slave;
        TicketInfo m_ticketInfo = null;
        try {
            String status;
            Date date_created;
            Date created;
            String num_order = order.isNull("num_order") ? "" : String.valueOf(order.getInt("num_order"));
            Date delivered = created = (date_created = order.isNull("created") ? null : DateUtils.FORMATTER_DATE_TIME_ZONE_SSS.parse(order.getString("created")));
            if (!order.isNull("order_time")) {
                JSONObject orderTimeObject = order.getJSONObject("order_time");
                if (!orderTimeObject.isNull("dateTime")) {
                    Date date_delivery;
                    String text_date_delivery = orderTimeObject.getString("dateTime");
                    delivered = date_delivery = DateUtils.getDateByText(text_date_delivery);
                }
                if (!orderTimeObject.isNull("created")) {
                    Date date_Created2;
                    String text_date_created = orderTimeObject.getString("created");
                    created = date_Created2 = DateUtils.getDateByText(text_date_created);
                }
            }
            String string = status = order.isNull("status") ? "" : order.getString("status");
            if (!new_orders || status.equals("sent")) {
                double fraisGestion;
                TicketLineInfo line;
                TaxInfo taxe;
                double deliveryTax;
                TaxInfo tax;
                double deliveryFee;
                String code_promo;
                double sub_total;
                m_ticketInfo = new TicketInfo();
                m_ticketInfo.setSent_from("web");
                m_ticketInfo.setOrdered_from("outside");
                m_ticketInfo.setType(order.getString("type"));
                m_ticketInfo.setDate(created);
                m_ticketInfo.setTotal(order.isNull("total") ? 0.0 : order.getDouble("total"));
                m_ticketInfo.setModePayment(order.isNull("payment_type") || order.get("payment_type") == null ? "" : order.getString("payment_type"));
                m_ticketInfo.setPaid(order.getBoolean("paid"));
                m_ticketInfo.setDelivered(delivered);
                m_ticketInfo.setRecover_date(delivered);
                m_ticketInfo.setStatus(status);
                m_ticketInfo.setNumero_online_order(order.isNull("num_order") ? "" : String.valueOf(order.getInt("num_order")));
                m_ticketInfo.setId_online_order(order.isNull("_id") ? "" : order.getString("_id"));
                double val_discount = order.isNull("discount") ? 0.0 : order.getDouble("discount");
                double d = sub_total = order.isNull("sub_total") ? 0.0 : order.getDouble("sub_total");
                if (val_discount != 0.0) {
                    if (!order.isNull("sub_total")) {
                        m_ticketInfo.setTotal(order.getDouble("sub_total"));
                    }
                    m_ticketInfo.setDiscount(val_discount);
                    m_ticketInfo.setTypeDiscount("somme");
                } else {
                    double discount;
                    double d2 = discount = order.isNull("reduction") ? 0.0 : order.getDouble("reduction");
                    if (discount != 0.0) {
                        m_ticketInfo.setDiscount(discount);
                        m_ticketInfo.setTypeDiscount("somme");
                    }
                }
                String string2 = code_promo = order.isNull("code_promo") ? null : order.getString("code_promo");
                if (code_promo != null && !code_promo.isEmpty()) {
                    m_ticketInfo.setLabel_discount("Code promo " + code_promo);
                }
                if (!order.isNull("id_commande_local") && !order.getString("id_commande_local").isEmpty()) {
                    m_ticketInfo.setId(order.getString("id_commande_local"));
                }
                m_ticketInfo.setComment(order.isNull("comment") ? "" : order.getString("comment"));
                if (!order.isNull("client")) {
                    JSONObject customerObject = order.getJSONObject("client");
                    String phone_customer = customerObject.isNull("phone") ? "" : customerObject.getString("phone");
                    String first_name = customerObject.isNull("first_name") ? "" : customerObject.getString("first_name");
                    String last_name = customerObject.isNull("last_name") ? "" : customerObject.getString("last_name");
                    String address = customerObject.isNull("address") ? "" : customerObject.getString("address");
                    String city = customerObject.isNull("city") ? "" : customerObject.getString("city");
                    String zip_code = customerObject.isNull("zipCode") ? "" : customerObject.getString("zipCode");
                    String building = customerObject.isNull("building") ? "" : customerObject.getString("building");
                    String entryCode = customerObject.isNull("entryCode") ? "" : customerObject.getString("entryCode");
                    String level = customerObject.isNull("level") ? "" : customerObject.getString("level");
                    String flatNumber = customerObject.isNull("flatNumber") ? "" : customerObject.getString("flatNumber");
                    String intercom = customerObject.isNull("intercom") ? "" : customerObject.getString("intercom");
                    String extra = customerObject.isNull("extra") ? "" : customerObject.getString("extra");
                    AddressInfo mAddressInfo = new AddressInfo(address, zip_code, city, entryCode, intercom, building, level, flatNumber, extra);
                    CustomerInfo mCustomerInfo = new CustomerInfo();
                    mCustomerInfo.setName(first_name + " " + last_name);
                    mCustomerInfo.setPhone(phone_customer);
                    m_ticketInfo.setCustomer(mCustomerInfo);
                    m_ticketInfo.setAddressInfo(mAddressInfo);
                }
                if (!order.isNull("items")) {
                    JSONArray lines = order.getJSONArray("items");
                    for (int i = 0; i < lines.length(); ++i) {
                        String str_ref_product;
                        int j;
                        double productPrice;
                        JSONObject objectLine = lines.getJSONObject(i);
                        if (objectLine.isNull("ref_product")) continue;
                        TicketLineInfo line2 = null;
                        double price = !objectLine.isNull("priceTotal") ? objectLine.getDouble("priceTotal") : 1.0;
                        double quantity = !objectLine.isNull("quantity") ? objectLine.getDouble("quantity") : 1.0;
                        String size_product = !objectLine.isNull("size") ? objectLine.getString("size") : null;
                        double discount = !objectLine.isNull("discount") ? objectLine.getDouble("discount") : 0.0;
                        String label_discount = !objectLine.isNull("label_discount") ? objectLine.getString("label_discount") : null;
                        String note = !objectLine.isNull("note") ? objectLine.getString("note") : null;
                        String place_served = !objectLine.isNull("place_served") ? objectLine.getString("place_served") : null;
                        String time_served = !objectLine.isNull("time_served") ? objectLine.getString("time_served") : null;
                        boolean isUsePoint = !objectLine.isNull("isFidProduct") ? objectLine.getBoolean("isFidProduct") : false;
                        int id_product = is_caisse_slave ? this.getProductID(String.valueOf(objectLine.getInt("ref_product"))) : objectLine.getInt("ref_product");
                        ProductInfoExt pInfo = this.m_DataLogicProduct.getProductInfo(id_product, false);
                        double d3 = productPrice = !objectLine.isNull("productPrice") ? objectLine.getDouble("productPrice") : 0.0;
                        if (pInfo != null) {
                            if (productPrice != 0.0) {
                                pInfo.setPriceSell(productPrice);
                            } else {
                                pInfo.setListSizes(this.dlItems.getProductSizes(pInfo.getID(), true));
                                pInfo.setPrices(this.dlItems.getProductPrices(pInfo.getID(), true));
                                pInfo.setPriceOrder(m_ticketInfo.getType(), size_product, true);
                            }
                            TaxInfo tax2 = this.dlSales.getTaxById(pInfo.getTaxCategoryID());
                            line2 = new TicketLineInfo(pInfo, quantity, pInfo.getPriceSell(), tax2, new ArrayList<ItemOrderInfo>(), new ArrayList<OptionItemOrder>(), pInfo.isMenu(), tax2.getRate(), new ArrayList<ProductTicket>(), size_product, size_product, discount, note, false, label_discount, place_served, time_served, -1);
                            if (discount != 0.0) {
                                line2.setType_discount("somme");
                                line2.setPromo_product(true);
                            }
                            if (isUsePoint) {
                                line2.setPoints_loyalty(pInfo.getPrice_point());
                                line2.setLabelDiscount("Carte de fid\u00e9lit\u00e9");
                            }
                            line2.setNote(objectLine.isNull("comment") ? "" : objectLine.getString("comment"));
                        }
                        if (!objectLine.isNull("supplements")) {
                            JSONArray supplements = objectLine.getJSONArray("supplements");
                            for (j = 0; j < supplements.length(); ++j) {
                                double price_option_order;
                                JSONObject objectSupplement = supplements.getJSONObject(j);
                                int ref_option = !objectSupplement.isNull("ref_option") ? objectSupplement.getInt("ref_option") : -1;
                                int ref_product = !objectSupplement.isNull("ref_product") ? objectSupplement.getInt("ref_product") : -1;
                                int ref_carte = !objectSupplement.isNull("ref_carte") ? objectSupplement.getInt("ref_carte") : -1;
                                int id_option = is_caisse_slave ? this.dlSync.getOption(String.valueOf(ref_option)) : ref_option;
                                int idCarte = is_caisse_slave && ref_carte != -1 ? this.dlSync.getCarte(String.valueOf(ref_carte)) : ref_carte;
                                int idProduct = is_caisse_slave && ref_product != -1 ? this.getProductID(String.valueOf(ref_product)) : ref_product;
                                boolean is_ingredient = !objectSupplement.isNull("is_ingredient") ? objectSupplement.getBoolean("is_ingredient") : false;
                                int number_option = !objectSupplement.isNull("number_option") ? objectSupplement.getInt("number_option") : 0;
                                int number_free = !objectSupplement.isNull("number_free") ? objectSupplement.getInt("number_free") : 0;
                                String name_product = !objectSupplement.isNull("name_product") ? objectSupplement.getString("name_product") : null;
                                String name_carte = !objectSupplement.isNull("name_carte") ? objectSupplement.getString("name_carte") : null;
                                SupplementItemInfo optionItem = this.dlItems.getFullInfoSupplementById(id_option);
                                int index_carte = !objectSupplement.isNull("index_carte") ? objectSupplement.getInt("index_carte") : -1;
                                String str_ref_option = !objectSupplement.isNull("ref_option") ? String.valueOf(objectSupplement.getInt("ref_option")) : null;
                                str_ref_product = !objectSupplement.isNull("ref_product") ? String.valueOf(objectSupplement.getInt("ref_product")) : null;
                                String str_ref_carte = !objectSupplement.isNull("ref_carte") ? String.valueOf(objectSupplement.getInt("ref_carte")) : null;
                                String id_global_carte = !objectSupplement.isNull("id_global_carte") ? String.valueOf(objectSupplement.getInt("id_global_carte")) : null;
                                String id_global_product = !objectSupplement.isNull("id_global_product") ? String.valueOf(objectSupplement.getInt("id_global_product")) : null;
                                String id_global_supplement = !objectSupplement.isNull("id_global_supplement") ? String.valueOf(objectSupplement.getInt("id_global_supplement")) : null;
                                double d4 = price_option_order = !objectSupplement.isNull("price") ? objectSupplement.getDouble("price") : 0.0;
                                if (optionItem == null) continue;
                                if (is_ingredient) {
                                    ItemOrderInfo ingredient = new ItemOrderInfo(optionItem, idCarte, idProduct, name_product, name_carte, index_carte, str_ref_product, str_ref_carte, id_global_product, id_global_carte);
                                    if (line2 == null) continue;
                                    if (line2.getListIngredients() == null) {
                                        line2.setListIngredients(new ArrayList<ItemOrderInfo>());
                                    }
                                    line2.getListIngredients().add(ingredient);
                                    continue;
                                }
                                if (line2 == null) continue;
                                OptionItemOrder option = new OptionItemOrder(idCarte, idProduct, name_product, name_carte, number_option, optionItem.isBold(), price_option_order, index_carte, number_free, optionItem.isSeparate(), false, str_ref_option, optionItem.getId_supplement(), optionItem.getPrinter(), optionItem.getShift_option(), optionItem.isDisplay_screen_sorti(), ColorUtils.getColor(optionItem.getColor()), optionItem, optionItem.isNo_printable(), str_ref_product, str_ref_carte, optionItem.getName_groupe_option(), false, id_global_product, id_global_carte);
                                if (line2.getListSupplements() == null) {
                                    line2.setListSupplements(new ArrayList<OptionItemOrder>());
                                }
                                line2.getListSupplements().add(option);
                            }
                        }
                        if (!objectLine.isNull("items")) {
                            JSONArray products = objectLine.getJSONArray("items");
                            for (j = 0; j < products.length(); ++j) {
                                JSONObject objectItem = products.getJSONObject(j);
                                int ref_product = !objectItem.isNull("ref_product") ? objectItem.getInt("ref_product") : -1;
                                int ref_carte = !objectItem.isNull("ref_carte") ? objectItem.getInt("ref_carte") : -1;
                                int idCarte = is_caisse_slave && ref_carte != -1 ? this.dlSync.getCarte(String.valueOf(ref_carte)) : ref_carte;
                                int idProduct = is_caisse_slave ? this.getProductID(String.valueOf(ref_product)) : ref_product;
                                int number_item = !objectItem.isNull("quantity") ? objectItem.getInt("quantity") : 0;
                                int index_carte = !objectItem.isNull("exemplary") ? objectItem.getInt("exemplary") : -1;
                                double price_item = !objectItem.isNull("price") ? objectItem.getDouble("price") : 0.0;
                                String id_global_product = !objectItem.isNull("id_global_product") ? objectItem.getString("id_global_product") : null;
                                String id_global_carte = !objectItem.isNull("id_global_carte") ? objectItem.getString("id_global_carte") : null;
                                ProductInfoExt item = null;
                                String name_carte = null;
                                int id_carte = -1;
                                if (ref_carte != -1) {
                                    item = this.m_DataLogicProduct.getProductPlatById(idCarte, idProduct, true);
                                    CarteInfo carte = this.m_DataLogicProduct.getCarteById(idCarte);
                                    name_carte = carte.getName();
                                    id_carte = carte.getId();
                                } else {
                                    item = this.m_DataLogicProduct.getProductInfo(idProduct, true);
                                    if (item != null) {
                                        item.setPriceSell(price_item);
                                    }
                                }
                                if (line2 == null || item == null) continue;
                                String name_product = item.getName();
                                str_ref_product = item.getRef_web();
                                ProductTicket product = new ProductTicket(item, id_carte, name_carte, number_item, index_carte, null, String.valueOf(ref_product), String.valueOf(ref_carte), id_global_carte);
                                if (line2.getListProducts() == null) {
                                    line2.setListProducts(new ArrayList<ProductTicket>());
                                }
                                line2.getListProducts().add(product);
                                if (objectItem.isNull("supplements")) continue;
                                JSONArray supplements_items = objectItem.getJSONArray("supplements");
                                for (int k = 0; k < supplements_items.length(); ++k) {
                                    double price_option_order;
                                    JSONObject objectSupplement = supplements_items.getJSONObject(k);
                                    int ref_option = !objectSupplement.isNull("ref_option") ? objectSupplement.getInt("ref_option") : -1;
                                    int id_option = is_caisse_slave ? this.dlSync.getOption(String.valueOf(ref_option)) : ref_option;
                                    boolean is_ingredient = !objectSupplement.isNull("is_ingredient") ? objectSupplement.getBoolean("is_ingredient") : false;
                                    int number_option = !objectSupplement.isNull("number_option") ? objectSupplement.getInt("number_option") : 0;
                                    int number_free = !objectSupplement.isNull("number_free") ? objectSupplement.getInt("number_free") : 0;
                                    SupplementItemInfo optionItem = this.dlItems.getFullInfoSupplementById(id_option);
                                    String str_ref_option = !objectSupplement.isNull("ref_option") ? String.valueOf(objectSupplement.getInt("ref_option")) : null;
                                    String str_ref_carte = !objectSupplement.isNull("ref_carte") ? String.valueOf(objectSupplement.getInt("ref_carte")) : null;
                                    String id_global_carte_supplement = !objectItem.isNull("id_global_carte") ? objectItem.getString("id_global_carte") : null;
                                    String id_global_supplement = !objectItem.isNull("id_global_supplement") ? objectItem.getString("id_global_supplement") : null;
                                    double d5 = price_option_order = !objectSupplement.isNull("price") ? objectSupplement.getDouble("price") : 0.0;
                                    if (optionItem == null) continue;
                                    if (is_ingredient) {
                                        ItemOrderInfo ingredient = new ItemOrderInfo(optionItem, idCarte, idProduct, name_product, name_carte, index_carte, str_ref_product, str_ref_carte, id_global_product, id_global_carte_supplement);
                                        if (line2 == null) continue;
                                        if (line2.getListIngredients() == null) {
                                            line2.setListIngredients(new ArrayList<ItemOrderInfo>());
                                        }
                                        line2.getListIngredients().add(ingredient);
                                        continue;
                                    }
                                    if (line2 == null) continue;
                                    OptionItemOrder option = new OptionItemOrder(idCarte, idProduct, name_product, name_carte, number_option, optionItem.isBold(), price_option_order, index_carte, number_free, optionItem.isSeparate(), false, str_ref_option, optionItem.getId_supplement(), optionItem.getPrinter(), optionItem.getShift_option(), optionItem.isDisplay_screen_sorti(), ColorUtils.getColor(optionItem.getColor()), optionItem, optionItem.isNo_printable(), str_ref_product, str_ref_carte, optionItem.getName_groupe_option(), false, id_global_product, id_global_carte_supplement);
                                    if (line2.getListSupplements() == null) {
                                        line2.setListSupplements(new ArrayList<OptionItemOrder>());
                                    }
                                    line2.getListSupplements().add(option);
                                }
                            }
                        }
                        if (line2 == null) continue;
                        line2.setPrice(this.getLinePrice(line2));
                        m_ticketInfo.getLines().add(line2);
                    }
                }
                boolean delivery_added = false;
                if (!order.isNull("deliveryFee") && !order.isNull("deliveryTax") && (deliveryFee = order.getDouble("deliveryFee")) > 0.0 && (tax = this.dlSales.getTaxByRate(deliveryTax = order.getDouble("deliveryTax"))) != null) {
                    delivery_added = true;
                    TicketLineInfo line3 = new TicketLineInfo("Frais de livraison", 1.0, deliveryFee, tax, tax.getRate(), true, new ArrayList<ItemOrderInfo>(), new ArrayList<OptionItemOrder>(), new ArrayList<ProductTicket>(), -1);
                    m_ticketInfo.getLines().add(line3);
                }
                if (!delivery_added && !order.isNull("frais_livraison") && (deliveryFee = order.getDouble("frais_livraison")) > 0.0) {
                    taxe = new TaxInfo("003", "20%", 0.2, true, false);
                    line = new TicketLineInfo("Frais de livraison", 1.0, deliveryFee, taxe, taxe.getRate(), true, new ArrayList<ItemOrderInfo>(), new ArrayList<OptionItemOrder>(), new ArrayList<ProductTicket>(), -1);
                    m_ticketInfo.getLines().add(line);
                }
                if (!order.isNull("frais_gestion") && (fraisGestion = order.getDouble("frais_gestion")) > 0.0) {
                    taxe = new TaxInfo("003", "20%", 0.2, true, false);
                    line = new TicketLineInfo("Frais de gestion", 1.0, fraisGestion, taxe, taxe.getRate(), true, new ArrayList<ItemOrderInfo>(), new ArrayList<OptionItemOrder>(), new ArrayList<ProductTicket>(), -1);
                    m_ticketInfo.getLines().add(line);
                }
            }
        }
        catch (BasicException | ParseException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return m_ticketInfo;
    }

    public TicketInfoBuilder order(Tickets order) {
        this.order = order;
        return this;
    }

    public TicketInfoBuilder objectOrder(JSONObject objectOrder) {
        this.objectOrder = objectOrder;
        return this;
    }

    public TicketInfoBuilder buildOrder() {
        try {
            LocalDateTime localTime;
            ZonedDateTime gmtTime;
            this.m_ticketInfo = new TicketInfo();
            this.m_ticketInfo.setSent_from("Uber Eats Platform");
            this.m_ticketInfo.setOrdered_from("outside");
            this.m_ticketInfo.setType("Uber Eats");
            this.m_ticketInfo.setPlatform_order(true);
            if (!this.objectOrder.isNull("current_state")) {
                this.m_ticketInfo.setPlatform_current_state(this.objectOrder.getString("current_state"));
            }
            if (!this.objectOrder.isNull("display_id")) {
                this.m_ticketInfo.setNumero_platform_order(this.objectOrder.getString("display_id"));
            }
            if (!this.objectOrder.isNull("store")) {
                JSONObject store = this.objectOrder.getJSONObject("store");
                this.m_ticketInfo.setStore_uber_eat(store.isNull("name") ? null : store.getString("name"));
            }
            if (!this.objectOrder.isNull("placed_at")) {
                String placed_at = this.objectOrder.getString("placed_at");
                gmtTime = LocalDateTime.parse(placed_at, DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'")).atZone(ZoneId.of("GMT"));
                localTime = gmtTime.withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
                Date dateOrder = DateUtils.asDate(localTime);
                this.m_ticketInfo.setDate(dateOrder);
            }
            if (!this.objectOrder.isNull("estimated_ready_for_pickup_at")) {
                String delivered_at = this.objectOrder.getString("estimated_ready_for_pickup_at");
                gmtTime = LocalDateTime.parse(delivered_at, DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'")).atZone(ZoneId.of("GMT"));
                localTime = gmtTime.withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
                Date dateDelivery = DateUtils.asDate(localTime);
                this.m_ticketInfo.setDelivered(dateDelivery);
            }
            if (!this.objectOrder.isNull("id")) {
                this.m_ticketInfo.setId_online_order(this.objectOrder.getString("id"));
            }
            if (!this.objectOrder.isNull("eater")) {
                String last_name;
                JSONObject eater = this.objectOrder.getJSONObject("eater");
                String phone_customer = eater.isNull("phone") ? null : eater.getString("phone");
                String first_name = eater.isNull("first_name") ? null : eater.getString("first_name");
                String string = last_name = eater.isNull("last_name") ? null : eater.getString("last_name");
                if (phone_customer != null || first_name != null || last_name != null) {
                    StringBuilder name_customer = new StringBuilder();
                    if (first_name != null && !first_name.isEmpty()) {
                        name_customer.append(first_name);
                        name_customer.append(" ");
                    }
                    if (last_name != null && !last_name.isEmpty()) {
                        name_customer.append(last_name);
                    }
                    if (!name_customer.toString().isEmpty()) {
                        if (phone_customer != null && !phone_customer.isEmpty()) {
                            CustomerInfo mCustomerInfo = this.mCustomerService.findOneByPhoneName(phone_customer, name_customer.toString());
                            if (mCustomerInfo == null) {
                                mCustomerInfo = new CustomerInfo();
                                mCustomerInfo.setName(name_customer.toString());
                                mCustomerInfo.setPhone(phone_customer);
                                this.mCustomerService.save(mCustomerInfo);
                            }
                            mCustomerInfo.setLoyaltyCardCollection(this.mLoyaltyCardService.findByCustomer(mCustomerInfo.getId()));
                            this.m_ticketInfo.setCustomer(mCustomerInfo);
                        } else {
                            this.m_ticketInfo.setName_customer(name_customer.toString());
                        }
                    }
                }
            }
            double sub_total_amount = 0.0;
            double tax_amount = 0.0;
            double total_fee_amount = 0.0;
            if (!this.objectOrder.isNull("payment")) {
                JSONObject promotionsObject;
                JSONObject payment = this.objectOrder.getJSONObject("payment");
                if (!payment.isNull("charges")) {
                    JSONObject tax;
                    JSONObject sub_total;
                    JSONObject total_fee;
                    JSONObject charges = payment.getJSONObject("charges");
                    if (!charges.isNull("total_fee") && !(total_fee = charges.getJSONObject("total_fee")).isNull("amount")) {
                        total_fee_amount = total_fee.getDouble("amount");
                    }
                    if (!charges.isNull("sub_total") && !(sub_total = charges.getJSONObject("sub_total")).isNull("amount")) {
                        sub_total_amount = sub_total.getDouble("amount");
                    }
                    if (!charges.isNull("tax") && !(tax = charges.getJSONObject("tax")).isNull("amount")) {
                        tax_amount = tax.getDouble("amount");
                    }
                }
                this.uber_promotions.clear();
                if (!payment.isNull("promotions") && !(promotionsObject = payment.getJSONObject("promotions")).isNull("promotions")) {
                    JSONArray promotionsArray = promotionsObject.getJSONArray("promotions");
                    for (int i = 0; i < promotionsArray.length(); ++i) {
                        JSONObject promotion = promotionsArray.getJSONObject(i);
                        if (promotion.isNull("promo_type")) continue;
                        String promo_type = promotion.getString("promo_type");
                        System.out.println("+++++++++++ promo_type : " + promo_type);
                        if (promo_type == null) continue;
                        if (promo_type.equalsIgnoreCase("BOGO") || promo_type.equalsIgnoreCase("FREEITEM_MINBASKET")) {
                            if (promotion.isNull("discount_items")) continue;
                            JSONArray discountItemsArray = promotion.getJSONArray("discount_items");
                            for (int j = 0; j < discountItemsArray.length(); ++j) {
                                JSONObject discountItemObject = discountItemsArray.getJSONObject(j);
                                int discounted_quantity = discountItemObject.isNull("discounted_quantity") ? 1 : discountItemObject.getInt("discounted_quantity");
                                String external_id = discountItemObject.isNull("external_id") ? "" : discountItemObject.getString("external_id");
                                this.uber_promotions.add(new UberEatPromotion(promo_type, -1.0, discounted_quantity, external_id));
                            }
                            continue;
                        }
                        if (promo_type.equalsIgnoreCase("FREEDELIVERY")) continue;
                        this.m_ticketInfo.setTypeDiscount("somme");
                        if (promotion.isNull("promo_discount_value")) continue;
                        double promo_discount_value = promotion.getInt("promo_discount_value");
                        this.m_ticketInfo.setLabel_discount(this.getPromoLabel(promo_type));
                        this.m_ticketInfo.setDiscount(Math.abs(promo_discount_value /= 100.0));
                    }
                }
            }
            if (!this.objectOrder.isNull("cart")) {
                JSONObject cart = this.objectOrder.getJSONObject("cart");
                if (!cart.isNull("items")) {
                    JSONArray items = cart.getJSONArray("items");
                    for (int i = 0; i < items.length(); ++i) {
                        JSONObject total_price;
                        JSONObject price;
                        String name_product;
                        JSONObject item = items.getJSONObject(i);
                        String item_id = item.isNull("id") ? "" : item.getString("id");
                        ProductInfoExt pInfo = null;
                        String external_data = null;
                        if (!item.isNull("external_data")) {
                            external_data = item.getString("external_data");
                        }
                        if (external_data != null && !external_data.isEmpty()) {
                            if (external_data.startsWith(this.PREFIX_PRODUCT_PLATFORM)) {
                                String id_global_product = external_data.substring(2);
                                pInfo = this.m_DataLogicProduct.getProductByIdGlobal(id_global_product);
                            } else {
                                pInfo = this.slave ? this.dlItems.getProductInfo(external_data, false) : this.m_DataLogicProduct.getProductInfo(Integer.parseInt(external_data), false);
                            }
                        } else if (AppLocal.RESEACH_UBER_PRODUCT_BY_NAME && !item.isNull("title") && (name_product = item.getString("title")) != null && !name_product.isEmpty()) {
                            pInfo = this.dlItems.getProductInfoByName(name_product.toUpperCase(), false);
                        }
                        if (pInfo == null) continue;
                        int quantity = 1;
                        if (!item.isNull("quantity")) {
                            quantity = item.getInt("quantity");
                        }
                        TicketLineInfo line = null;
                        if (!(item.isNull("price") || (price = item.getJSONObject("price")).isNull("base_unit_price") || (total_price = price.getJSONObject("base_unit_price")).isNull("amount"))) {
                            double amount_item = total_price.getInt("amount");
                            pInfo.setPriceSell(amount_item /= 100.0);
                        }
                        TaxInfo tax = this.dlSales.getTaxById(pInfo.getTaxCategoryID());
                        line = new TicketLineInfo(pInfo, quantity, pInfo.getPriceSell(), tax, new ArrayList<ItemOrderInfo>(), new ArrayList<OptionItemOrder>(), pInfo.isMenu(), tax.getRate(), new ArrayList<ProductTicket>(), null, null, 0.0, null, false, null, null, null, -1);
                        UberEatPromotion mUberEatPromotion = this.getUberPromotion(item_id);
                        System.out.println("+++++++++ mUberEatPromotion : " + mUberEatPromotion);
                        if (mUberEatPromotion != null) {
                            line.setType_discount("somme");
                            line.setDiscount(pInfo.getPriceSell() * (double)mUberEatPromotion.getDiscounted_quantity());
                            line.setLabelDiscount(this.getPromoLabel(mUberEatPromotion.getPromo_type()));
                            mUberEatPromotion.setUsed(true);
                        }
                        if (!item.isNull("selected_modifier_groups")) {
                            JSONArray selected_modifier_groups_array = item.getJSONArray("selected_modifier_groups");
                            for (int j = 0; j < selected_modifier_groups_array.length(); ++j) {
                                JSONObject objectModifierGroup = selected_modifier_groups_array.getJSONObject(j);
                                if (objectModifierGroup.isNull("selected_items")) continue;
                                JSONArray selected_items_array = objectModifierGroup.getJSONArray("selected_items");
                                for (int h = 0; h < selected_items_array.length(); ++h) {
                                    JSONObject total_price_option;
                                    JSONObject price_option;
                                    JSONObject objectSelectedItem = selected_items_array.getJSONObject(h);
                                    if (objectSelectedItem.isNull("external_data")) continue;
                                    SupplementItemInfo optionItem = null;
                                    String external_data_option = objectSelectedItem.getString("external_data");
                                    if (external_data_option.startsWith(this.PREFIX_OPTION_PLATFORM)) {
                                        String id_global_option = external_data_option.substring(2);
                                        optionItem = this.dlItems.getFullInfoSupplementByIdGlobal(id_global_option);
                                    } else {
                                        optionItem = this.slave ? this.dlItems.getSuppelementByRefSynchro(external_data_option) : this.dlItems.getSuppelementById(Integer.parseInt(external_data_option));
                                    }
                                    if (optionItem == null) continue;
                                    double price2 = optionItem.getPrice();
                                    if (!(objectSelectedItem.isNull("price") || (price_option = objectSelectedItem.getJSONObject("price")).isNull("base_total_price") || (total_price_option = price_option.getJSONObject("base_total_price")).isNull("amount"))) {
                                        double amount_option = total_price_option.getInt("amount");
                                        price2 = amount_option / 100.0;
                                    }
                                    int number_option = 1;
                                    if (!objectSelectedItem.isNull("quantity")) {
                                        number_option = objectSelectedItem.getInt("quantity");
                                    }
                                    SupplementProduct gOption = this.dlItems.getSupplementByID(optionItem.getId_supplement());
                                    if (line == null || gOption == null) continue;
                                    optionItem.setDisplay_free(gOption.isDisplay_free());
                                    optionItem.setPrint_black_background(gOption.isPrint_black_background());
                                    optionItem.setPrice_already_included(0.0);
                                    OptionItemOrder option = new OptionItemOrder(-1, -1, null, null, number_option, gOption.getIsBold(), price2, -1, 0, gOption.isSeparate(), false, null, gOption.getiD(), gOption.getPrinter(), gOption.getShift_option(), gOption.isDisplay_screen_sorti(), ColorUtils.getColor(gOption.getColor()), optionItem, gOption.isNo_printable(), null, null, gOption.getName(), true, null, null);
                                    if (line.getListSupplements() == null) {
                                        line.setListSupplements(new ArrayList<OptionItemOrder>());
                                    }
                                    option.setId_sub_product(optionItem.getId_product());
                                    line.getListSupplements().add(option);
                                }
                            }
                        }
                        if (!item.isNull("special_instructions")) {
                            String special_instructions = item.getString("special_instructions");
                            line.setNote(special_instructions);
                        }
                        if (line == null) continue;
                        if (pInfo.getSub_products() != null && !pInfo.getSub_products().isEmpty()) {
                            this.addSubProducts(pInfo, line);
                        }
                        line.setPrice(this.getLinePrice(line));
                        this.m_ticketInfo.getLines().add(line);
                    }
                }
                if (!cart.isNull("special_instructions")) {
                    String special_instructions = cart.getString("special_instructions");
                    this.m_ticketInfo.setComment(special_instructions);
                }
            }
            this.m_ticketInfo.setTotal_fee_ubereat(total_fee_amount / 100.0);
            this.m_ticketInfo.setTax_ubereat(tax_amount / 100.0);
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return this;
    }

    private void addSubProducts(ProductInfoExt product, TicketLineInfo line) {
        if (line.getListProducts() == null) {
            line.setListProducts(new ArrayList<ProductTicket>());
        }
        this.mItemService.setSubProducts(product);
        for (ProductInfoExt sub_product : product.getSub_products()) {
            ProductInfoExt item = (ProductInfoExt)sub_product.clone();
            item.setPriceSell(0.0);
            line.getListProducts().add(new ProductTicket(item, -1, null, 1, item.getIndex_sub_product(), null, null, null, null));
        }
    }

    public TicketInfoBuilder buildOrderDeliveroo() {
        try {
            JSONObject totalObject;
            String pickup_at;
            LocalDateTime localTime;
            ZonedDateTime gmtTime;
            String prepared_for;
            this.m_ticketInfo = new TicketInfo();
            this.m_ticketInfo.setSent_from("Deliveroo");
            this.m_ticketInfo.setOrdered_from("outside");
            this.m_ticketInfo.setType("Deliveroo");
            this.m_ticketInfo.setPlatform_order(true);
            Date dateDeliveryOrder = null;
            Date dateOrder = null;
            if (!this.objectOrder.isNull("order_number")) {
                this.m_ticketInfo.setNumero_platform_order(this.objectOrder.getString("order_number"));
            } else {
                this.m_ticketInfo.setNumero_platform_order("");
            }
            if (!this.objectOrder.isNull("start_preparing_at") && (prepared_for = this.objectOrder.getString("start_preparing_at")) != null && !prepared_for.isEmpty()) {
                gmtTime = LocalDateTime.parse(prepared_for, DateTimeFormatter.ISO_DATE_TIME).atZone(ZoneId.of("GMT"));
                localTime = gmtTime.withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
                dateOrder = DateUtils.asDate(localTime);
            }
            if (!this.objectOrder.isNull("prepare_for") && (prepared_for = this.objectOrder.getString("prepare_for")) != null && !prepared_for.isEmpty()) {
                gmtTime = LocalDateTime.parse(prepared_for, DateTimeFormatter.ISO_DATE_TIME).atZone(ZoneId.of("GMT"));
                localTime = gmtTime.withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
                dateDeliveryOrder = DateUtils.asDate(localTime);
            }
            if (dateDeliveryOrder == null && !this.objectOrder.isNull("pickup_at") && (pickup_at = this.objectOrder.getString("pickup_at")) != null && !pickup_at.isEmpty()) {
                gmtTime = LocalDateTime.parse(pickup_at, DateTimeFormatter.ISO_DATE_TIME).atZone(ZoneId.of("GMT"));
                localTime = gmtTime.withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
                dateDeliveryOrder = DateUtils.asDate(localTime);
            }
            if (dateOrder != null) {
                this.m_ticketInfo.setDate(dateOrder);
            } else if (dateDeliveryOrder != null) {
                this.m_ticketInfo.setDate(dateDeliveryOrder);
            }
            if (dateDeliveryOrder != null) {
                this.m_ticketInfo.setDelivered(dateDeliveryOrder);
            }
            if (!this.objectOrder.isNull("id")) {
                this.m_ticketInfo.setId_online_order(this.objectOrder.getString("id"));
            }
            if (!this.objectOrder.isNull("total_price") && !(totalObject = this.objectOrder.getJSONObject("total_price")).isNull("fractional")) {
                double total = totalObject.getDouble("fractional");
                this.m_ticketInfo.setTotal(total / 100.0);
            }
            if (!this.objectOrder.isNull("order_notes")) {
                this.m_ticketInfo.setComment(this.objectOrder.getString("order_notes"));
            }
            if (!this.objectOrder.isNull("delivery")) {
                double deliveryFee;
                JSONObject deliveryFeeObject;
                JSONObject deliveryObject = this.objectOrder.getJSONObject("delivery");
                if (!deliveryObject.isNull("delivery_fee") && !(deliveryFeeObject = deliveryObject.getJSONObject("delivery_fee")).isNull("fractional") && (deliveryFee = deliveryFeeObject.getDouble("fractional")) > 0.0) {
                    TicketLineInfo line = new TicketLineInfo("Frais de livraison", 1.0, deliveryFee / 100.0, null, 0.0, true, new ArrayList<ItemOrderInfo>(), new ArrayList<OptionItemOrder>(), new ArrayList<ProductTicket>(), -1);
                    this.m_ticketInfo.getLines().add(line);
                }
                String phone_customer = deliveryObject.isNull("contact_number") ? "" : deliveryObject.getString("contact_number");
                String name_customer = deliveryObject.isNull("customer_name") ? "" : deliveryObject.getString("customer_name");
                String address = deliveryObject.isNull("line1") ? "" : deliveryObject.getString("line1");
                String city = deliveryObject.isNull("city") ? "" : deliveryObject.getString("city");
                String zip_code = deliveryObject.isNull("postalCode") ? "" : deliveryObject.getString("postalCode");
                double latitude = 0.0;
                double longitude = 0.0;
                if (deliveryObject.isNull("location")) {
                    JSONObject locationObject = deliveryObject.getJSONObject("locationObject");
                    latitude = locationObject.isNull("latitude") ? 0.0 : locationObject.getDouble("latitude");
                    double d = longitude = locationObject.isNull("longitude") ? 0.0 : locationObject.getDouble("longitude");
                }
                if (phone_customer != null && phone_customer.isEmpty() || name_customer != null && !name_customer.isEmpty()) {
                    AddressInfo mAddressInfo = new AddressInfo(address, zip_code, city, "", "", "", "", "", "");
                    mAddressInfo.setLat(latitude);
                    mAddressInfo.setLon(longitude);
                    this.m_ticketInfo.setAddressInfo(mAddressInfo);
                    CustomerInfo mCustomerInfo = this.mCustomerService.findOneByPhone(phone_customer);
                    if (mCustomerInfo == null) {
                        mCustomerInfo = new CustomerInfo();
                        mCustomerInfo.setName(name_customer);
                        mCustomerInfo.setPhone(phone_customer);
                        this.mCustomerService.saveWithAddress(mCustomerInfo, mAddressInfo);
                    } else {
                        mAddressInfo.setCustomer(mCustomerInfo);
                        this.mAddressService.saveAddress(mAddressInfo);
                    }
                    mCustomerInfo.setLoyaltyCardCollection(this.mLoyaltyCardService.findByCustomer(mCustomerInfo.getId()));
                    this.m_ticketInfo.setCustomer(mCustomerInfo);
                    if (mAddressInfo != null) {
                        this.m_ticketInfo.setAddress(mAddressInfo.getId());
                    }
                }
            }
            HashMap promotionsItems = new HashMap();
            String typePromotion = null;
            if (!this.objectOrder.isNull("promotions")) {
                JSONArray promotions = this.objectOrder.getJSONArray("promotions");
                for (int i = 0; i < promotions.length(); ++i) {
                    String type_promotion;
                    JSONObject promotion = promotions.getJSONObject(i);
                    if (promotion.isNull("type") || (type_promotion = promotion.getString("type")) == null || type_promotion.isEmpty() || !type_promotion.equals(this.PERCENTAGE_OFF_ON_BASKET)) continue;
                    typePromotion = promotions.length() == 1 ? this.PERCENTAGE_OFF_ON_BASKET : null;
                    this.m_ticketInfo.setTypeDiscount("pourcentage");
                    if (promotion.isNull("value")) continue;
                    double value_discount = promotion.getDouble("value");
                    System.out.println("+++++ value_discount : " + value_discount);
                    this.m_ticketInfo.setDiscount(value_discount);
                }
            }
            if (!this.objectOrder.isNull("items")) {
                JSONArray items = this.objectOrder.getJSONArray("items");
                for (int i = 0; i < items.length(); ++i) {
                    JSONObject discountObject;
                    JSONObject priceObject;
                    JSONObject item = items.getJSONObject(i);
                    ProductInfoExt pInfo = null;
                    String ref_synchro = null;
                    String pos_item_id = null;
                    if (!item.isNull("pos_item_id")) {
                        pos_item_id = item.getString("pos_item_id");
                    }
                    if (pos_item_id != null && !pos_item_id.isEmpty()) {
                        if (pos_item_id.startsWith(this.PREFIX_PRODUCT_PLATFORM)) {
                            String id_global_product = pos_item_id.substring(2);
                            pInfo = this.m_DataLogicProduct.getProductByIdGlobal(id_global_product);
                        } else {
                            if (pos_item_id.startsWith(this.PREFIX_PRODUCT)) {
                                ref_synchro = pos_item_id.substring(8);
                            }
                            if (ref_synchro != null) {
                                pInfo = this.slave ? this.dlItems.getProductInfo(ref_synchro, false) : this.m_DataLogicProduct.getProductInfo(Integer.parseInt(ref_synchro), false);
                            }
                        }
                    } else {
                        String name_product = item.getString("name");
                        if (name_product != null) {
                            pInfo = this.dlItems.getProductInfoByName(name_product.toUpperCase(), false);
                            System.out.println("+++++ pInfo : " + pInfo);
                        }
                    }
                    int quantity = 1;
                    if (!item.isNull("quantity")) {
                        quantity = item.getInt("quantity");
                    }
                    if (pInfo == null) continue;
                    TicketLineInfo line = null;
                    if (!item.isNull("unit_price") && !(priceObject = item.getJSONObject("unit_price")).isNull("fractional")) {
                        double price = priceObject.getDouble("fractional");
                        pInfo.setPriceSell(price / 100.0);
                    }
                    line = new TicketLineInfo(pInfo, quantity, pInfo.getPriceSell(), null, new ArrayList<ItemOrderInfo>(), new ArrayList<OptionItemOrder>(), pInfo.isMenu(), 0.0, new ArrayList<ProductTicket>(), null, null, 0.0, null, false, null, null, null, -1);
                    if (!item.isNull("discount_amount") && !(discountObject = item.getJSONObject("discount_amount")).isNull("fractional")) {
                        double discount_item = discountObject.getDouble("fractional");
                        line.setDiscount(discount_item / 100.0);
                        line.setType_discount("somme");
                    }
                    if (!item.isNull("modifiers")) {
                        JSONArray selected_modifier_groups_array = item.getJSONArray("modifiers");
                        for (int j = 0; j < selected_modifier_groups_array.length(); ++j) {
                            JSONObject priceOptionObject;
                            JSONObject objectModifierGroup = selected_modifier_groups_array.getJSONObject(j);
                            SupplementItemInfo optionItem = null;
                            String ref_synchro_option = null;
                            String pos_item_id_option = null;
                            if (!objectModifierGroup.isNull("pos_item_id")) {
                                pos_item_id_option = objectModifierGroup.getString("pos_item_id");
                            }
                            if (pos_item_id_option != null && !pos_item_id_option.isEmpty()) {
                                if (pos_item_id_option.startsWith(this.PREFIX_OPTION_PLATFORM)) {
                                    String id_global_option = pos_item_id_option.substring(2);
                                    optionItem = this.dlItems.getFullInfoSupplementByIdGlobal(id_global_option);
                                } else {
                                    if (pos_item_id_option.startsWith(this.PREFIX_OPTION)) {
                                        ref_synchro_option = pos_item_id_option.substring(7);
                                    }
                                    if (ref_synchro_option != null) {
                                        optionItem = this.slave ? this.dlItems.getSuppelementByRefSynchro(ref_synchro_option) : this.dlItems.getSuppelementById(Integer.parseInt(ref_synchro_option));
                                    }
                                }
                            } else if (!objectModifierGroup.isNull("name")) {
                                String name_option = objectModifierGroup.getString("name");
                                System.out.println("++++++ name_option : " + name_option);
                                optionItem = this.dlItems.getSuppelementByName(name_option);
                            }
                            System.out.println("+++++++++ optionItem : " + optionItem);
                            if (optionItem == null) continue;
                            double price = 0.0;
                            if (!objectModifierGroup.isNull("total_price") && !(priceOptionObject = objectModifierGroup.getJSONObject("total_price")).isNull("fractional")) {
                                double priceOption = priceOptionObject.getDouble("fractional");
                                price = priceOption / 100.0;
                            }
                            System.out.println("+++++++++ price : " + price);
                            int number_option = 1;
                            if (!objectModifierGroup.isNull("quantity")) {
                                number_option = objectModifierGroup.getInt("quantity");
                            }
                            SupplementProduct gOption = this.dlItems.getSupplementByID(optionItem.getId_supplement());
                            if (line == null || gOption == null) continue;
                            optionItem.setDisplay_free(gOption.isDisplay_free());
                            OptionItemOrder option = new OptionItemOrder(-1, -1, null, null, number_option, gOption.getIsBold(), price, -1, 0, gOption.isSeparate(), false, null, gOption.getiD(), gOption.getPrinter(), gOption.getShift_option(), gOption.isDisplay_screen_sorti(), ColorUtils.getColor(gOption.getColor()), optionItem, gOption.isNo_printable(), null, null, gOption.getName(), true, null, null);
                            if (line.getListSupplements() == null) {
                                line.setListSupplements(new ArrayList<OptionItemOrder>());
                            }
                            option.setId_sub_product(optionItem.getId_product());
                            line.getListSupplements().add(option);
                        }
                    }
                    if (line == null) continue;
                    if (pInfo.getSub_products() != null && !pInfo.getSub_products().isEmpty()) {
                        this.addSubProducts(pInfo, line);
                    }
                    line.setPrice(this.getLinePrice(line));
                    this.m_ticketInfo.getLines().add(line);
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(TicketInfoBuilder.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this;
    }

    public TicketInfoBuilder buildOrderRushour() {
        try {
            String delivered_at;
            ZonedDateTime gmtTime;
            this.m_ticketInfo = new TicketInfo();
            this.m_ticketInfo.setSent_from("RusHour Platform");
            this.m_ticketInfo.setOrdered_from("outside");
            this.m_ticketInfo.setType("RusHour");
            this.m_ticketInfo.setPlatform_order(true);
            if (!this.objectOrder.isNull("platform_source")) {
                String platform_source;
                switch (platform_source = this.objectOrder.getString("platform_source")) {
                    case "ubereats": {
                        this.m_ticketInfo.setSent_from("Uber Eats Platform");
                        this.m_ticketInfo.setType("Uber Eats");
                        break;
                    }
                    case "justeat": {
                        this.m_ticketInfo.setSent_from("Just Eat Platform");
                        this.m_ticketInfo.setType("Just Eat");
                        break;
                    }
                    case "deliveroo_tablet": {
                        this.m_ticketInfo.setSent_from("Deliveroo Platform");
                        this.m_ticketInfo.setType("Deliveroo");
                        break;
                    }
                    case "deliveroo_web": {
                        this.m_ticketInfo.setSent_from("Deliveroo Platform");
                        this.m_ticketInfo.setType("Deliveroo");
                    }
                }
            }
            if (!this.objectOrder.isNull("displayId")) {
                this.m_ticketInfo.setNumero_platform_order(this.objectOrder.getString("displayId"));
            }
            if (!this.objectOrder.isNull("orderedAt")) {
                String placed_at = this.objectOrder.getString("orderedAt");
                gmtTime = LocalDateTime.parse(placed_at, DateTimeFormatter.ISO_DATE_TIME).atZone(ZoneId.of("GMT"));
                LocalDateTime localTime = gmtTime.withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
                Date dateOrder = DateUtils.asDate(localTime);
                System.out.println("++++++++++++ dateOrder : " + dateOrder);
                this.m_ticketInfo.setDate(dateOrder);
            }
            if (!this.objectOrder.isNull("pickedUpAt") && (delivered_at = this.objectOrder.getString("pickedUpAt")) != null) {
                gmtTime = LocalDateTime.parse(delivered_at, DateTimeFormatter.ISO_DATE_TIME).atZone(ZoneId.of("GMT"));
                LocalDateTime localTime = gmtTime.withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
                Date dateDelivery = DateUtils.asDate(localTime);
                System.out.println("++++++++++++ dateOrder : " + dateDelivery);
                this.m_ticketInfo.setDelivered(dateDelivery);
            }
            if (!this.objectOrder.isNull("id")) {
                this.m_ticketInfo.setId_online_order(this.objectOrder.getString("id"));
            }
            if (!this.objectOrder.isNull("customer")) {
                String name;
                JSONObject objectCustomer = this.objectOrder.getJSONObject("customer");
                String phone_customer = objectCustomer.isNull("phone") ? null : objectCustomer.getString("phone");
                String string = name = objectCustomer.isNull("name") ? null : objectCustomer.getString("name");
                if (!(phone_customer == null && name == null || name == null || name.isEmpty())) {
                    if (phone_customer != null && !phone_customer.isEmpty()) {
                        AddressInfo mAddressInfo;
                        JSONObject objectAddress = objectCustomer.isNull("address") ? null : objectCustomer.getJSONObject("address");
                        String address = objectAddress != null && !objectAddress.isNull("address") ? objectAddress.getString("address") : null;
                        CustomerInfo mCustomerInfo = this.mCustomerService.findOneByPhoneName(phone_customer, name);
                        AddressInfo addressInfo = mAddressInfo = address != null ? new AddressInfo(address) : null;
                        if (mCustomerInfo == null) {
                            mCustomerInfo = new CustomerInfo();
                            mCustomerInfo.setName(name);
                            mCustomerInfo.setPhone(phone_customer);
                            if (mAddressInfo != null) {
                                this.mCustomerService.saveWithAddress(mCustomerInfo, mAddressInfo);
                            } else {
                                this.mCustomerService.save(mCustomerInfo);
                            }
                        } else if (mAddressInfo != null) {
                            mAddressInfo.setCustomer(mCustomerInfo);
                            this.mAddressService.saveAddress(mAddressInfo);
                        }
                        mCustomerInfo.setLoyaltyCardCollection(this.mLoyaltyCardService.findByCustomer(mCustomerInfo.getId()));
                        this.m_ticketInfo.setCustomer(mCustomerInfo);
                    } else {
                        this.m_ticketInfo.setName_customer(name);
                    }
                }
            }
            if (!this.objectOrder.isNull("items")) {
                JSONArray items = this.objectOrder.getJSONArray("items");
                for (int i = 0; i < items.length(); ++i) {
                    String ref_synchro_value;
                    JSONObject item = items.getJSONObject(i);
                    ProductInfoExt pInfo = null;
                    String ref_synchro = null;
                    if (!item.isNull("id") && (ref_synchro_value = item.getString("id")) != null && ref_synchro_value.startsWith(this.PREFIX_PRODUCT)) {
                        ref_synchro = ref_synchro_value.substring(8);
                    }
                    if (ref_synchro != null) {
                        pInfo = this.slave ? this.dlItems.getProductInfo(ref_synchro, false) : this.m_DataLogicProduct.getProductInfo(Integer.parseInt(ref_synchro), false);
                    } else {
                        String name_product = item.getString("name");
                        if (name_product != null) {
                            pInfo = this.dlItems.getProductInfoByName(name_product.toUpperCase(), false);
                        }
                    }
                    int quantity = 1;
                    if (!item.isNull("quantity")) {
                        quantity = item.getInt("quantity");
                    }
                    if (pInfo == null) continue;
                    TicketLineInfo line = null;
                    if (!item.isNull("price")) {
                        double price = item.getDouble("price");
                        pInfo.setPriceSell(price / 100.0);
                    }
                    TaxInfo tax = this.dlSales.getTaxById(pInfo.getTaxCategoryID());
                    line = new TicketLineInfo(pInfo, quantity, pInfo.getPriceSell(), tax, new ArrayList<ItemOrderInfo>(), new ArrayList<OptionItemOrder>(), pInfo.isMenu(), tax.getRate(), new ArrayList<ProductTicket>(), null, null, 0.0, null, false, null, null, null, -1);
                    if (!item.isNull("modifiers")) {
                        JSONArray selected_modifier_groups_array = item.getJSONArray("modifiers");
                        for (int j = 0; j < selected_modifier_groups_array.length(); ++j) {
                            String ref_synchro_option_value;
                            JSONObject objectModifierGroup = selected_modifier_groups_array.getJSONObject(j);
                            SupplementItemInfo optionItem = null;
                            String ref_synchro_option = null;
                            if (!objectModifierGroup.isNull("id") && (ref_synchro_option_value = objectModifierGroup.getString("id")) != null && ref_synchro_option_value.startsWith(this.PREFIX_OPTION)) {
                                ref_synchro_option = ref_synchro_option_value.substring(7);
                            }
                            if (ref_synchro_option != null) {
                                optionItem = this.slave ? this.dlItems.getSuppelementByRefSynchro(ref_synchro_option) : this.dlItems.getSuppelementById(Integer.parseInt(ref_synchro_option));
                            } else if (!objectModifierGroup.isNull("name")) {
                                String name_option = objectModifierGroup.getString("name");
                                optionItem = this.dlItems.getSuppelementByName(name_option);
                            }
                            if (optionItem == null) continue;
                            double price = objectModifierGroup.getDouble("price");
                            price /= 100.0;
                            int number_option = 1;
                            if (!objectModifierGroup.isNull("quantity")) {
                                number_option = objectModifierGroup.getInt("quantity");
                            }
                            SupplementProduct gOption = this.dlItems.getSupplementByID(optionItem.getId_supplement());
                            if (line == null || gOption == null) continue;
                            optionItem.setDisplay_free(gOption.isDisplay_free());
                            OptionItemOrder option = new OptionItemOrder(-1, -1, null, null, number_option, gOption.getIsBold(), price, -1, 0, gOption.isSeparate(), false, null, gOption.getiD(), gOption.getPrinter(), gOption.getShift_option(), gOption.isDisplay_screen_sorti(), ColorUtils.getColor(gOption.getColor()), optionItem, gOption.isNo_printable(), null, null, gOption.getName(), true, null, null);
                            if (line.getListSupplements() == null) {
                                line.setListSupplements(new ArrayList<OptionItemOrder>());
                            }
                            option.setId_sub_product(optionItem.getId_product());
                            line.getListSupplements().add(option);
                        }
                    }
                    if (line == null) continue;
                    if (pInfo.getSub_products() != null && !pInfo.getSub_products().isEmpty()) {
                        this.addSubProducts(pInfo, line);
                    }
                    line.setPrice(this.getLinePrice(line));
                    this.m_ticketInfo.getLines().add(line);
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(TicketInfoBuilder.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this;
    }

    public TicketInfoBuilder buildOtterOrder() {
        try {
            double discount;
            double deliveryFee;
            this.m_ticketInfo = new TicketInfo();
            this.m_ticketInfo.setOrdered_from("outside");
            this.m_ticketInfo.setPlatform_order(true);
            if (!this.objectOrder.isNull("externalIdentifiers")) {
                String source;
                JSONObject externalIdentifierObject = this.objectOrder.getJSONObject("externalIdentifiers");
                if (!externalIdentifierObject.isNull("friendlyId")) {
                    this.m_ticketInfo.setNumero_platform_order(externalIdentifierObject.getString("friendlyId"));
                }
                if (!externalIdentifierObject.isNull("id")) {
                    this.m_ticketInfo.setId_online_order(externalIdentifierObject.getString("id"));
                }
                if (!externalIdentifierObject.isNull("source") && (source = externalIdentifierObject.getString("source")) != null && !source.isEmpty()) {
                    this.m_ticketInfo.setSent_from(source + "Platform");
                    if (source.equalsIgnoreCase("ubereats-api")) {
                        this.m_ticketInfo.setType("Uber Eats Platform");
                    } else if (source.equalsIgnoreCase("deliveroo-web")) {
                        this.m_ticketInfo.setType("Deliveroo");
                    } else {
                        this.m_ticketInfo.setType(source);
                    }
                }
            }
            if (this.m_ticketInfo.getSent_from() == null || this.m_ticketInfo.getSent_from().isEmpty()) {
                this.m_ticketInfo.setSent_from("otter");
                this.m_ticketInfo.setType("otter");
            }
            if (!this.objectOrder.isNull("orderedAt")) {
                String placed_at = this.objectOrder.getString("orderedAt");
                ZonedDateTime gmtTime = LocalDateTime.parse(placed_at, DateTimeFormatter.ISO_DATE_TIME).atZone(ZoneId.of("GMT"));
                LocalDateTime localTime = gmtTime.withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
                Date dateOrder = DateUtils.asDate(localTime);
                this.m_ticketInfo.setDate(dateOrder);
            }
            if (!this.objectOrder.isNull("fulfillmentInfo")) {
                LocalDateTime localTime;
                ZonedDateTime gmtTime;
                JSONObject fulfillmentInfoObject = this.objectOrder.getJSONObject("fulfillmentInfo");
                if (!fulfillmentInfoObject.isNull("pickupTime")) {
                    String pickup_at = fulfillmentInfoObject.getString("pickupTime");
                    gmtTime = LocalDateTime.parse(pickup_at, DateTimeFormatter.ISO_DATE_TIME).atZone(ZoneId.of("GMT"));
                    localTime = gmtTime.withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
                    Date datePickup = DateUtils.asDate(localTime);
                    this.m_ticketInfo.setDelivered(datePickup);
                }
                if (this.m_ticketInfo.getDelivered() == null && !fulfillmentInfoObject.isNull("deliveryTime")) {
                    String delivered_at = fulfillmentInfoObject.getString("deliveryTime");
                    gmtTime = LocalDateTime.parse(delivered_at, DateTimeFormatter.ISO_DATE_TIME).atZone(ZoneId.of("GMT"));
                    localTime = gmtTime.withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
                    Date dateDelivery = DateUtils.asDate(localTime);
                    this.m_ticketInfo.setDelivered(dateDelivery);
                }
            }
            if (!this.objectOrder.isNull("customer")) {
                String name_customer;
                JSONObject customerObject = this.objectOrder.getJSONObject("customer");
                String phone_customer = customerObject.isNull("phone") ? null : customerObject.getString("phone");
                String string = name_customer = customerObject.isNull("name") ? null : customerObject.getString("name");
                if (!(phone_customer == null && name_customer == null || name_customer == null || name_customer.isEmpty())) {
                    if (phone_customer != null && !phone_customer.isEmpty()) {
                        CustomerInfo mCustomerInfo = this.mCustomerService.findOneByPhoneName(phone_customer, name_customer);
                        if (mCustomerInfo == null) {
                            mCustomerInfo = new CustomerInfo();
                            mCustomerInfo.setName(name_customer);
                            mCustomerInfo.setPhone(phone_customer);
                            this.mCustomerService.save(mCustomerInfo);
                        }
                        mCustomerInfo.setLoyaltyCardCollection(this.mLoyaltyCardService.findByCustomer(mCustomerInfo.getId()));
                        this.m_ticketInfo.setCustomer(mCustomerInfo);
                    } else {
                        this.m_ticketInfo.setName_customer(name_customer);
                    }
                }
            }
            if (!this.objectOrder.isNull("items")) {
                JSONArray items = this.objectOrder.getJSONArray("items");
                System.out.println("+++++++++ items : " + items);
                for (int i = 0; i < items.length(); ++i) {
                    JSONObject item = items.getJSONObject(i);
                    if (item.isNull("id")) continue;
                    String external_data = item.getString("id");
                    String ref_synchro = null;
                    int quantity = 1;
                    if (!item.isNull("quantity")) {
                        quantity = item.getInt("quantity");
                    }
                    ProductInfoExt pInfo = null;
                    if (external_data != null && !external_data.isEmpty()) {
                        if (external_data.startsWith(this.PREFIX_PRODUCT_PLATFORM)) {
                            String id_global_product = external_data.substring(2);
                            pInfo = this.m_DataLogicProduct.getProductByIdGlobal(id_global_product);
                        } else if (external_data.startsWith(this.PREFIX_PRODUCT) && (ref_synchro = external_data.substring(8)) != null) {
                            pInfo = this.slave ? this.dlItems.getProductInfo(ref_synchro, false) : this.m_DataLogicProduct.getProductInfo(Integer.parseInt(ref_synchro), false);
                        }
                    }
                    if (pInfo == null) continue;
                    TicketLineInfo line = null;
                    if (!item.isNull("price")) {
                        double price = item.getDouble("price");
                        pInfo.setPriceSell(price);
                    }
                    TaxInfo tax = this.dlSales.getTaxById(pInfo.getTaxCategoryID());
                    line = new TicketLineInfo(pInfo, quantity, pInfo.getPriceSell(), tax, new ArrayList<ItemOrderInfo>(), new ArrayList<OptionItemOrder>(), pInfo.isMenu(), tax.getRate(), new ArrayList<ProductTicket>(), null, null, 0.0, null, false, null, null, null, -1);
                    if (!item.isNull("modifiers")) {
                        JSONArray selected_modifier_array = item.getJSONArray("modifiers");
                        for (int j = 0; j < selected_modifier_array.length(); ++j) {
                            JSONObject objectModifier = selected_modifier_array.getJSONObject(j);
                            if (objectModifier.isNull("id")) continue;
                            String external_data_option = objectModifier.getString("id");
                            String ref_synchro_option = null;
                            SupplementItemInfo optionItem = null;
                            if (external_data != null && !external_data.isEmpty()) {
                                if (external_data.startsWith(this.PREFIX_OPTION_PLATFORM)) {
                                    String id_global_option = external_data_option.substring(2);
                                    optionItem = this.dlItems.getFullInfoSupplementByIdGlobal(id_global_option);
                                } else if (external_data.startsWith(this.PREFIX_OPTION)) {
                                    ref_synchro_option = external_data_option.substring(7);
                                    optionItem = this.slave ? this.dlItems.getSuppelementByRefSynchro(ref_synchro_option) : this.dlItems.getSuppelementById(Integer.parseInt(ref_synchro_option));
                                }
                            }
                            if (optionItem == null) continue;
                            double price = optionItem.getPrice();
                            if (!objectModifier.isNull("price")) {
                                price = objectModifier.getDouble("price");
                            }
                            int number_option = 1;
                            if (!objectModifier.isNull("quantity")) {
                                number_option = objectModifier.getInt("quantity");
                            }
                            SupplementProduct gOption = this.dlItems.getSupplementByID(optionItem.getId_supplement());
                            if (line == null || gOption == null) continue;
                            optionItem.setDisplay_free(gOption.isDisplay_free());
                            OptionItemOrder option = new OptionItemOrder(-1, -1, null, null, number_option, gOption.getIsBold(), price, -1, 0, gOption.isSeparate(), false, null, gOption.getiD(), gOption.getPrinter(), gOption.getShift_option(), gOption.isDisplay_screen_sorti(), ColorUtils.getColor(gOption.getColor()), optionItem, gOption.isNo_printable(), null, null, gOption.getName(), true, null, null);
                            if (line.getListSupplements() == null) {
                                line.setListSupplements(new ArrayList<OptionItemOrder>());
                            }
                            option.setId_sub_product(optionItem.getId_product());
                            line.getListSupplements().add(option);
                        }
                    }
                    if (line == null) continue;
                    if (pInfo.getSub_products() != null && !pInfo.getSub_products().isEmpty()) {
                        this.addSubProducts(pInfo, line);
                    }
                    line.setPrice(this.getLinePrice(line));
                    this.m_ticketInfo.getLines().add(line);
                }
            }
            if (!this.objectOrder.isNull("deliveryFee") && (deliveryFee = this.objectOrder.getDouble("deliveryFee")) > 0.0) {
                TaxInfo taxe = new TaxInfo("003", "20%", 0.2, true, false);
                TicketLineInfo line = new TicketLineInfo("Frais de livraison", 1.0, deliveryFee, taxe, taxe.getRate(), true, new ArrayList<ItemOrderInfo>(), new ArrayList<OptionItemOrder>(), new ArrayList<ProductTicket>(), -1);
                this.m_ticketInfo.getLines().add(line);
            }
            if (!this.objectOrder.isNull("discount") && (discount = this.objectOrder.getDouble("discount")) > 0.0) {
                this.m_ticketInfo.setDiscount(discount);
                this.m_ticketInfo.setTypeDiscount("somme");
            }
            if (!this.objectOrder.isNull("customerNote")) {
                String note = this.objectOrder.getString("customerNote");
                this.m_ticketInfo.setComment(note);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(TicketInfoBuilder.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this;
    }

    public TicketInfoBuilder buildOrderDishop() {
        try {
            double managementFee;
            JSONObject managementFeeObject;
            JSONObject deliveryFeeObject;
            JSONObject totalObject;
            String pickup_at;
            LocalDateTime localTime;
            ZonedDateTime gmtTime;
            String prepared_for;
            String start_preparing_at;
            String type;
            this.m_ticketInfo = new TicketInfo();
            this.m_ticketInfo.setSent_from("Dishop");
            this.m_ticketInfo.setOrdered_from("outside");
            this.m_ticketInfo.setModePayment(this.objectOrder.isNull("paymentType") ? null : this.objectOrder.getString("paymentType"));
            if (AppLocal.DISHOP_INTEGRATION != null && AppLocal.DISHOP_INTEGRATION.equalsIgnoreCase("dishop full")) {
                this.m_ticketInfo.setType("Dishop");
            } else {
                this.m_ticketInfo.setPlatform_order(true);
                this.m_ticketInfo.setType("Commande en ligne");
            }
            if (!this.objectOrder.isNull("type") && (type = this.objectOrder.getString("type")) != null && !type.isEmpty()) {
                switch (type) {
                    case "delivery": {
                        this.m_ticketInfo.setType("En Livraison");
                        break;
                    }
                    case "click_and_collect": {
                        this.m_ticketInfo.setType("A Emporter");
                        break;
                    }
                    case "click_and_seat": {
                        this.m_ticketInfo.setType("Sur Place");
                    }
                }
            }
            if (!this.objectOrder.isNull("order_number")) {
                this.m_ticketInfo.setNumero_platform_order(this.objectOrder.getString("order_number"));
            } else {
                this.m_ticketInfo.setNumero_platform_order("");
            }
            Date dateOrder = null;
            if (!this.objectOrder.isNull("start_preparing_at") && (start_preparing_at = this.objectOrder.getString("start_preparing_at")) != null && !start_preparing_at.isEmpty()) {
                ZonedDateTime gmtTime2 = LocalDateTime.parse(start_preparing_at, DateTimeFormatter.ISO_DATE_TIME).atZone(ZoneId.systemDefault());
                LocalDateTime localTime2 = gmtTime2.withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
                dateOrder = DateUtils.asDate(localTime2);
            }
            Date dateDeliveryOrder = null;
            if (!this.objectOrder.isNull("prepare_for") && (prepared_for = this.objectOrder.getString("prepare_for")) != null && !prepared_for.isEmpty()) {
                gmtTime = LocalDateTime.parse(prepared_for, DateTimeFormatter.ISO_DATE_TIME).atZone(ZoneId.systemDefault());
                localTime = gmtTime.withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
                dateDeliveryOrder = DateUtils.asDate(localTime);
            }
            if (dateDeliveryOrder == null && !this.objectOrder.isNull("pickup_at") && (pickup_at = this.objectOrder.getString("pickup_at")) != null && !pickup_at.isEmpty()) {
                gmtTime = LocalDateTime.parse(pickup_at, DateTimeFormatter.ISO_DATE_TIME).atZone(ZoneId.systemDefault());
                localTime = gmtTime.withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
                dateDeliveryOrder = DateUtils.asDate(localTime);
            }
            if (dateOrder != null) {
                this.m_ticketInfo.setDate(dateOrder);
            } else if (dateDeliveryOrder != null) {
                this.m_ticketInfo.setDate(dateDeliveryOrder);
            }
            if (dateDeliveryOrder != null) {
                this.m_ticketInfo.setDelivered(dateDeliveryOrder);
            }
            if (!this.objectOrder.isNull("id")) {
                this.m_ticketInfo.setId_online_order(String.valueOf(this.objectOrder.getString("id")));
            }
            if (!this.objectOrder.isNull("display_id")) {
                this.m_ticketInfo.setNumero_platform_order(String.valueOf(this.objectOrder.getInt("display_id")));
                if (this.m_ticketInfo.getId_online_order() == null) {
                    this.m_ticketInfo.setId_online_order(String.valueOf(this.objectOrder.getInt("display_id")));
                }
            }
            if (!this.objectOrder.isNull("total_price") && !(totalObject = this.objectOrder.getJSONObject("total_price")).isNull("fractional")) {
                double total = totalObject.getDouble("fractional");
                this.m_ticketInfo.setTotal(NumericUtils.round(total / 100.0));
            }
            if (!this.objectOrder.isNull("order_notes")) {
                this.m_ticketInfo.setComment(this.objectOrder.getString("order_notes"));
            }
            if (!this.objectOrder.isNull("delivery")) {
                JSONObject deliveryObject = this.objectOrder.getJSONObject("delivery");
                String phone_customer = deliveryObject.isNull("contact_number") ? "" : deliveryObject.getString("contact_number");
                String name_customer = deliveryObject.isNull("customer_name") ? "" : deliveryObject.getString("customer_name");
                String address_line_1 = deliveryObject.isNull("line1") ? "" : deliveryObject.getString("line1");
                String city = deliveryObject.isNull("city") ? "" : deliveryObject.getString("city");
                String zip_code = deliveryObject.isNull("postalCode") ? "" : deliveryObject.getString("postalCode");
                String note = deliveryObject.isNull("note") ? "" : deliveryObject.getString("note");
                String address_line_2 = deliveryObject.isNull("line2") ? "" : deliveryObject.getString("line2");
                Object address = address_line_1 + "\n" + address_line_2;
                address = ((String)address).trim();
                double latitude = 0.0;
                double longitude = 0.0;
                if (!deliveryObject.isNull("location")) {
                    JSONObject locationObject = deliveryObject.getJSONObject("location");
                    latitude = locationObject.isNull("latitude") ? 0.0 : locationObject.getDouble("latitude");
                    double d = longitude = locationObject.isNull("longitude") ? 0.0 : locationObject.getDouble("longitude");
                }
                if (phone_customer != null && phone_customer.isEmpty() || name_customer != null && !name_customer.isEmpty()) {
                    CustomerInfo mCustomerInfo = this.mCustomerService.findOneByPhoneName(phone_customer, name_customer);
                    AddressInfo mAddressInfo = new AddressInfo((String)address, zip_code, city, "", "", "", "", "", note);
                    mAddressInfo.setLat(latitude);
                    mAddressInfo.setLon(longitude);
                    mAddressInfo.setIsSynchro(false);
                    if (mCustomerInfo == null) {
                        mCustomerInfo = new CustomerInfo();
                        mCustomerInfo.setName(name_customer);
                        mCustomerInfo.setPhone(phone_customer);
                        if (mAddressInfo != null) {
                            this.mCustomerService.saveWithAddress(mCustomerInfo, mAddressInfo);
                        } else {
                            this.mCustomerService.save(mCustomerInfo);
                        }
                    } else if (mAddressInfo != null) {
                        mAddressInfo.setCustomer(mCustomerInfo);
                        this.mAddressService.saveAddress(mAddressInfo);
                    }
                    mCustomerInfo.setLoyaltyCardCollection(this.mLoyaltyCardService.findByCustomer(mCustomerInfo.getId()));
                    this.m_ticketInfo.setCustomer(mCustomerInfo);
                    this.m_ticketInfo.setAddressInfo(mAddressInfo);
                    if (mAddressInfo != null) {
                        this.m_ticketInfo.setAddress(mAddressInfo.getId());
                    }
                }
            }
            if (!this.objectOrder.isNull("items")) {
                JSONArray items = this.objectOrder.getJSONArray("items");
                for (int i = 0; i < items.length(); ++i) {
                    JSONObject discountObject;
                    JSONObject priceObject;
                    String name_product;
                    JSONObject itemObject = items.getJSONObject(i);
                    ProductInfoExt pInfo = null;
                    if (AppLocal.DISHOP_INTEGRATION != null && AppLocal.DISHOP_INTEGRATION.equalsIgnoreCase("dishop full")) {
                        String pos_item_id;
                        String string = pos_item_id = itemObject.isNull("pos_item_id") ? "" : itemObject.getString("pos_item_id");
                        if (pos_item_id != null) {
                            String product_plu = pos_item_id.startsWith("P_") ? pos_item_id.substring(2) : pos_item_id;
                            pInfo = this.m_DataLogicProduct.getProductInfoByPLU(product_plu, false);
                        }
                    }
                    if (pInfo == null && (pInfo = this.m_DataLogicProduct.getProductInfoByName(name_product = itemObject.getString("name"))) == null) {
                        pInfo = new ProductInfoExt();
                        pInfo.setName(name_product);
                        pInfo.setID(-1);
                    }
                    int quantity = 1;
                    if (!itemObject.isNull("quantity")) {
                        quantity = itemObject.getInt("quantity");
                    }
                    if (pInfo == null) continue;
                    TicketLineInfo line = null;
                    if (!itemObject.isNull("unit_price") && !(priceObject = itemObject.getJSONObject("unit_price")).isNull("fractional")) {
                        double price = priceObject.getDouble("fractional");
                        pInfo.setPriceSell(price / 100.0);
                    }
                    TaxInfo tax = pInfo.getID() != 0 && pInfo.getID() != -1 ? this.dlSales.getTaxById(pInfo.getTaxCategoryID()) : new TaxInfo("002", "10%", 0.1);
                    line = new TicketLineInfo(pInfo, quantity, pInfo.getPriceSell(), tax, new ArrayList<ItemOrderInfo>(), new ArrayList<OptionItemOrder>(), pInfo.isMenu(), 0.0, new ArrayList<ProductTicket>(), null, null, 0.0, null, false, null, null, null, -1);
                    line.setProduct_platform(true);
                    if (!itemObject.isNull("discount_amount") && !(discountObject = itemObject.getJSONObject("discount_amount")).isNull("fractional")) {
                        double discount_item = discountObject.getDouble("fractional");
                        line.setDiscount(discount_item / 100.0);
                        line.setType_discount("somme");
                    }
                    line.setNote(itemObject.isNull("instructions") ? "" : itemObject.getString("instructions"));
                    if (!itemObject.isNull("modifiers")) {
                        JSONArray selected_modifier_groups_array = itemObject.getJSONArray("modifiers");
                        for (int j = 0; j < selected_modifier_groups_array.length(); ++j) {
                            JSONObject objectModifierGroup = selected_modifier_groups_array.getJSONObject(j);
                            this.setOption(objectModifierGroup, null, null, -1, line);
                        }
                    }
                    int index_sub_item = 1;
                    int index_carte = 1;
                    if (!itemObject.isNull("sub_items")) {
                        JSONArray selected_sub_items_groups_array = itemObject.getJSONArray("sub_items");
                        for (int j = 0; j < selected_sub_items_groups_array.length(); ++j) {
                            JSONObject priceOptionObject;
                            String name_product2;
                            JSONObject objectSubItems = selected_sub_items_groups_array.getJSONObject(j);
                            ProductInfoExt subItem = null;
                            String name_carte = null;
                            int idCarte = -1;
                            String ref_carte = null;
                            String id_global_carte = null;
                            CarteInfo carte = null;
                            if (AppLocal.DISHOP_INTEGRATION != null && AppLocal.DISHOP_INTEGRATION.equalsIgnoreCase("dishop full")) {
                                String idExternalCarte;
                                String idExternalSubItem = !objectSubItems.isNull("pos_item_id") ? objectSubItems.getString("pos_item_id") : "";
                                String string = idExternalCarte = !objectSubItems.isNull("pos_carte_id") ? objectSubItems.getString("pos_carte_id") : "";
                                if (idExternalCarte != null && !idExternalCarte.isEmpty() && idExternalSubItem != null && !idExternalSubItem.isEmpty()) {
                                    subItem = this.m_DataLogicProduct.getProductPlatByIdExternal(idExternalCarte, idExternalSubItem, true);
                                    carte = this.m_DataLogicProduct.getCarteByIdGlobal(idExternalCarte);
                                    name_carte = carte != null ? carte.getName() : null;
                                    idCarte = carte != null ? carte.getId() : -1;
                                    ref_carte = carte != null ? carte.getRef_web() : null;
                                    id_global_carte = carte != null ? carte.getId_global() : null;
                                } else if (idExternalSubItem != null && !idExternalSubItem.isEmpty()) {
                                    subItem = this.m_DataLogicProduct.getProductInfoByPLU(idExternalSubItem, false);
                                }
                            }
                            if (subItem == null && (subItem = this.m_DataLogicProduct.getProductInfoByName(name_product2 = objectSubItems.getString("name"))) == null) {
                                subItem = new ProductInfoExt();
                                subItem.setName(name_product2);
                                if (AppLocal.DISHOP_INTEGRATION != null && AppLocal.DISHOP_INTEGRATION.equalsIgnoreCase("dishop light")) {
                                    subItem.setID(index_sub_item++);
                                } else {
                                    subItem.setID(-1);
                                }
                            }
                            if (subItem == null) continue;
                            double price = 0.0;
                            if (!objectSubItems.isNull("total_unit_price") && !(priceOptionObject = objectSubItems.getJSONObject("total_unit_price")).isNull("fractional")) {
                                double priceSubItem = priceOptionObject.getDouble("fractional");
                                price = priceSubItem / 100.0;
                            }
                            subItem.setPriceSell(price);
                            int numberSubItem = 1;
                            if (!objectSubItems.isNull("quantity")) {
                                numberSubItem = objectSubItems.getInt("quantity");
                            }
                            String name_product3 = subItem.getName();
                            String str_ref_product = subItem.getRef_web();
                            ProductTicket product = new ProductTicket(subItem, idCarte, name_carte, numberSubItem, index_carte, null, str_ref_product, String.valueOf(ref_carte), id_global_carte);
                            if (line.getListProducts() == null) {
                                line.setListProducts(new ArrayList<ProductTicket>());
                            }
                            line.getListProducts().add(product);
                            if (objectSubItems.isNull("modifiers")) continue;
                            JSONArray sub_item_modifier_groups_array = objectSubItems.getJSONArray("modifiers");
                            for (int h = 0; h < sub_item_modifier_groups_array.length(); ++h) {
                                JSONObject objectSubitemModifierGroup = sub_item_modifier_groups_array.getJSONObject(h);
                                this.setOption(objectSubitemModifierGroup, carte, subItem, index_carte, line);
                            }
                        }
                        ++index_carte;
                    } else if (line != null && pInfo != null && pInfo.getSub_products() != null && !pInfo.getSub_products().isEmpty()) {
                        this.addSubProducts(pInfo, line);
                    }
                    if (line == null) continue;
                    line.setPrice(this.getLinePrice(line));
                    this.m_ticketInfo.getLines().add(line);
                }
            }
            if (AppLocal.DISHOP_INTEGRATION != null && AppLocal.DISHOP_INTEGRATION.equalsIgnoreCase("dishop full")) {
                String modePayment = !this.objectOrder.isNull("paymentType") ? this.objectOrder.getString("paymentType") : null;
                this.m_ticketInfo.setModePayment(modePayment);
                if (modePayment == null || modePayment.equals("stripe")) {
                    this.m_ticketInfo.setPlatform_order(true);
                }
            }
            double deliveryFee = 0.0;
            if (!this.objectOrder.isNull("delivery_fee") && !(deliveryFeeObject = this.objectOrder.getJSONObject("delivery_fee")).isNull("fractional") && (deliveryFee = deliveryFeeObject.getDouble("fractional")) > 0.0) {
                TaxInfo taxe = new TaxInfo("003", "20%", 0.2, true, false);
                TicketLineInfo line = new TicketLineInfo("Frais de livraison", 1.0, deliveryFee /= 100.0, taxe, 0.0, true, new ArrayList<ItemOrderInfo>(), new ArrayList<OptionItemOrder>(), new ArrayList<ProductTicket>(), -1);
                this.m_ticketInfo.getLines().add(line);
            }
            if (!this.objectOrder.isNull("management_fee") && !(managementFeeObject = this.objectOrder.getJSONObject("management_fee")).isNull("fractional") && (managementFee = managementFeeObject.getDouble("fractional")) > 0.0) {
                TaxInfo taxe = new TaxInfo("003", "20%", 0.2, true, false);
                TicketLineInfo line = new TicketLineInfo("Frais de gestion", 1.0, managementFee /= 100.0, taxe, 0.0, true, new ArrayList<ItemOrderInfo>(), new ArrayList<OptionItemOrder>(), new ArrayList<ProductTicket>(), -1);
                this.m_ticketInfo.getLines().add(line);
            }
            if (!this.objectOrder.isNull("promotions")) {
                JSONArray promotions = this.objectOrder.getJSONArray("promotions");
                block26: for (int i = 0; i < promotions.length(); ++i) {
                    JSONObject promotion = promotions.getJSONObject(i);
                    if (promotion.isNull("type")) continue;
                    String type_promotion = promotion.getString("type");
                    double value_discount = 0.0;
                    switch (type_promotion) {
                        case "percentage": {
                            this.m_ticketInfo.setTypeDiscount("pourcentage");
                            value_discount = !promotion.isNull("value") ? promotion.getDouble("value") : 0.0;
                            this.m_ticketInfo.setDiscount(value_discount);
                            continue block26;
                        }
                        case "euro": {
                            this.m_ticketInfo.setTypeDiscount("somme");
                            value_discount = !promotion.isNull("value") ? promotion.getDouble("value") : 0.0;
                            this.m_ticketInfo.setDiscount(value_discount);
                            continue block26;
                        }
                        case "delivery_free": {
                            this.m_ticketInfo.setTypeDiscount("somme");
                            this.m_ticketInfo.setLabel_discount("Livraison gratuite");
                            this.m_ticketInfo.setDiscount(deliveryFee);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(TicketInfoBuilder.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this;
    }

    private UberEatPromotion getUberPromotion(String item_id) {
        for (UberEatPromotion uber_promotion : this.uber_promotions) {
            if (uber_promotion.isUsed() || uber_promotion.getItem_id() == null || !uber_promotion.getItem_id().equalsIgnoreCase(item_id)) continue;
            return uber_promotion;
        }
        return null;
    }

    private String getPromoLabel(String promo_type) {
        if (this.map_type_promo.get(promo_type) != null) {
            return this.map_type_promo.get(promo_type);
        }
        return promo_type;
    }

    private int getProductID(String ref_synchro) throws BasicException {
        ProductInfoExt product = this.dlItems.getProduct(ref_synchro);
        return product != null ? product.getID() : -1;
    }

    private void setOption(JSONObject objectModifierGroup, CarteInfo carte, ProductInfoExt product, int index_carte, TicketLineInfo line) throws BasicException {
        String pos_item_id_option;
        SupplementItemInfo optionItem = null;
        if (AppLocal.DISHOP_INTEGRATION != null && AppLocal.DISHOP_INTEGRATION.equalsIgnoreCase("dishop full") && !objectModifierGroup.isNull("pos_item_id") && (pos_item_id_option = objectModifierGroup.getString("pos_item_id")) != null) {
            String item_plu = pos_item_id_option.startsWith("O_") ? pos_item_id_option.substring(2) : pos_item_id_option;
            optionItem = this.dlItems.getSuppelementByPlu(item_plu);
        }
        if (optionItem == null) {
            optionItem = new SupplementItemInfo();
            if (!objectModifierGroup.isNull("name")) {
                String name_option = objectModifierGroup.getString("name");
                optionItem.setName(name_option);
            }
        }
        if (optionItem != null) {
            JSONObject priceOptionObject;
            double price = 0.0;
            if (!objectModifierGroup.isNull("total_unit_price") && !(priceOptionObject = objectModifierGroup.getJSONObject("total_unit_price")).isNull("fractional")) {
                double priceOption = priceOptionObject.getDouble("fractional");
                price = priceOption / 100.0;
            }
            int number_option = 1;
            if (!objectModifierGroup.isNull("quantity")) {
                number_option = objectModifierGroup.getInt("quantity");
            }
            SupplementProduct gOption = null;
            if (optionItem.getId_supplement() != 0) {
                gOption = this.dlItems.getSupplementByID(optionItem.getId_supplement());
            }
            if (line != null) {
                boolean display_free = gOption != null ? gOption.isDisplay_free() : true;
                boolean option_bold = gOption != null ? gOption.getIsBold() : false;
                boolean option_separate = gOption != null ? gOption.isSeparate() : false;
                int gOption_id = gOption != null ? gOption.getiD() : 0;
                int gOption_printer = gOption != null ? gOption.getPrinter() : 0;
                int gOption_shift = gOption != null ? gOption.getShift_option() : 0;
                boolean gOption_isDisplay_screen_sorti = gOption != null ? gOption.isDisplay_screen_sorti() : false;
                String color_option = gOption != null ? ColorUtils.getColor(gOption.getColor()) : null;
                boolean gOption_no_printable = gOption != null ? gOption.isNo_printable() : false;
                String gOption_name = gOption != null ? gOption.getName() : null;
                optionItem.setDisplay_free(display_free);
                int idCarte = carte != null ? carte.getId() : -1;
                String nameCarte = carte != null ? carte.getName() : null;
                int idProduct = product != null ? product.getID() : -1;
                String nameProduct = product != null ? product.getName() : null;
                OptionItemOrder option = new OptionItemOrder(idCarte, idProduct, nameProduct, nameCarte, number_option, option_bold, price, index_carte, 0, option_separate, false, null, gOption_id, gOption_printer, gOption_shift, gOption_isDisplay_screen_sorti, color_option, optionItem, gOption_no_printable, null, null, gOption_name, false, null, null);
                if (line.getListSupplements() == null) {
                    line.setListSupplements(new ArrayList<OptionItemOrder>());
                }
                option.setId_sub_product(optionItem.getId_product());
                line.getListSupplements().add(option);
            }
        }
    }
}

