/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.ticket;

import com.openbravo.basic.BasicException;
import com.openbravo.data.loader.SerializableRead;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppConfig;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.payment.PaymentInfo;
import com.openbravo.pos.ticket.CustomerLoyalty;
import com.openbravo.pos.ticket.LivreurInfo;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.TableInfo;
import com.openbravo.pos.ticket.TaxInfo;
import com.openbravo.pos.ticket.TaxLineInfo;
import com.openbravo.pos.ticket.TaxeHelper;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.ticket.TicketTaxInfo;
import com.openbravo.pos.ticket.TotaleEncaissement;
import com.openbravo.pos.ticket.UserInfo;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.NumericUtils;
import com.openbravo.pos.util.StringUtils;
import com.procaisse.db.metadata.DataRead;
import fr.protactile.procaisse.dao.entities.AddressInfo;
import fr.protactile.procaisse.dao.entities.CustomerInfo;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public final class TicketInfo
implements Serializable,
SerializableRead,
Cloneable {
    private static final long serialVersionUID = 2765650092387265178L;
    public static final int RECEIPT_NORMAL = 0;
    public static final int RECEIPT_REFUND = 1;
    public static final int RECEIPT_PAYMENT = 2;
    public static final int RECEIPT_NOSALE = 3;
    private final DateFormat m_dateformat = DateUtils.timeFormatter;
    private String m_sId;
    private int tickettype = 0;
    private int m_iTicketId = 0;
    private int m_iPickupId;
    private Date m_dDate;
    private Date lastUpdate;
    private Date datePaid;
    private Properties attributes;
    private UserInfo m_User = null;
    private LivreurInfo m_livreur = null;
    private CustomerInfo m_Customer = null;
    private int customerId = -1;
    private String m_sActiveCash = null;
    private List<TicketLineInfo> m_aLines;
    private List<PaymentInfo> payments;
    private String loyaltyCardNumber;
    private Boolean oldTicket = false;
    private double total;
    private String type;
    private String modePayment;
    private String tempsLv;
    private String status;
    private int idTable;
    private TableInfo table;
    private int numero_order;
    private double discount = 0.0;
    private String typeDiscount = "pourcentage";
    private Integer bipper = 0;
    private boolean transferred;
    private String reason_cancel;
    private int invoice;
    private int address;
    private AddressInfo addressInfo;
    private int origineCanceledTicket;
    private String origineCanceledTicketString;
    private boolean accepted;
    private boolean paid;
    private int oldTable = -1;
    private int couverts = 0;
    private FilerUtils m_FilerUtils = FilerUtils.getInstance();
    private boolean hasNext = false;
    private String caisse;
    private String name_customer;
    private String source_order;
    private Boolean closed = false;
    private String num_order_borne;
    private int numberline2;
    private int num_order_kitchen = -1;
    private String sent_from;
    private static String Hostname;
    private int id_shared_order;
    private String ordered_from = "inside";
    private int id_order_kitchen;
    private boolean error_print_kitchen;
    private boolean print_after_update;
    private String numero_online_order;
    private String id_online_order;
    private Date delivered;
    private int num_table;
    private String numero_platform_order;
    private String label_discount;
    private List<TicketLineInfo> oldLines;
    private Date recover_date;
    private String comment;
    private String idSourceSharedOrder;
    private String address_ip_borne;
    private double total_fee_ubereat;
    private double tax_ubereat;
    private String SENT_FROM_WEB = "web";
    private String SENT_FROM_UBER_EAT = "Uber Eats";
    private boolean delayed;
    private String store_uber_eat;
    private String customer_loyalty_id;
    private boolean customer_loyalty_verified;
    private CustomerLoyalty mCustomerLoyalty;
    private boolean shared_order;
    private Integer easel_number = 0;
    private boolean platform_order;
    private boolean take_away_phone;
    private String platform_current_state;
    private TaxeHelper taxeHelper;
    private String keenio_base;
    private String order_id_base;
    private double value_in_base;
    private double value_out_base;
    private String tag_erc_stan;
    private String last_digit;
    private String eft_stan;
    private String EcrDateTime;
    private double discountOrderAndLines;
    private String session_id;
    private String holder;
    public static Comparator<TicketLineInfo> infoComparator;
    public static final String POURCENTAGE = "pourcentage";

    public int getOrigineCanceledTicket() {
        return this.origineCanceledTicket;
    }

    void setOrigineCanceledTicket(int origineCanceledTicket) {
        this.origineCanceledTicket = origineCanceledTicket;
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public static void setHostname(String name) {
        Hostname = name;
    }

    public static String getHostname() {
        return Hostname;
    }

    public TicketInfo() {
        this.m_sId = "CMD" + new Date().getTime();
        this.lastUpdate = this.m_dDate = new Date();
        this.attributes = new Properties();
        this.m_aLines = new ArrayList<TicketLineInfo>();
        this.payments = new ArrayList<PaymentInfo>();
        this.caisse = AppLocal.ADD_ID_CAISSE ? AppLocal.host_name : null;
        this.oldLines = new ArrayList<TicketLineInfo>();
    }

    @Override
    public void readValues(DataRead dr) throws BasicException {
        this.m_sId = dr.getString(1);
        this.tickettype = dr.getInt(2);
        this.m_iTicketId = dr.getInt(3);
        this.type = dr.getString(4);
        this.modePayment = dr.getString(5);
        this.tempsLv = dr.getString(6);
        this.m_dDate = dr.getTimestamp(7);
        this.m_sActiveCash = dr.getString(8);
        try {
            byte[] img = dr.getBytes(9);
            if (img != null) {
                this.attributes.loadFromXML(new ByteArrayInputStream(img));
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        this.m_User = new UserInfo(dr.getString(10), dr.getString(11), dr.getInt(37));
        this.customerId = dr.getInt(12);
        this.status = dr.getString(13);
        this.total = dr.getDouble(14);
        this.address = dr.getInt(15);
        this.numero_order = dr.getInt(16);
        this.idTable = dr.getInt(17);
        this.discount = dr.getDouble(18);
        this.typeDiscount = dr.getString(19);
        this.bipper = dr.getInt(20);
        this.transferred = dr.getBoolean(21);
        this.reason_cancel = dr.getString(22);
        this.invoice = dr.getInt(23);
        this.m_aLines = new ArrayList<TicketLineInfo>();
        this.payments = new ArrayList<PaymentInfo>();
        this.m_livreur = new LivreurInfo(dr.getString(24), dr.getString(25), "");
        this.origineCanceledTicket = dr.getInt(26);
        this.accepted = dr.getBoolean(27);
        this.paid = dr.getBoolean(28);
        this.lastUpdate = dr.getTimestamp(29);
        this.couverts = dr.getInt(30);
        this.source_order = dr.getString(31);
        this.name_customer = dr.getString(32);
        this.datePaid = dr.getTimestamp(33);
        this.closed = dr.getBoolean(34);
        this.origineCanceledTicketString = dr.getString(35);
        this.num_order_kitchen = dr.getInt(36);
        this.ordered_from = dr.getString(38);
        this.id_order_kitchen = dr.getInt(39);
        this.sent_from = dr.getString(40);
        this.numero_online_order = dr.getString(41);
        this.print_after_update = dr.getBoolean(42);
        this.num_table = dr.getInt(43);
        this.numero_platform_order = dr.getString(44);
        this.label_discount = dr.getString(45);
        this.id_shared_order = dr.getInt(46);
        this.delivered = dr.getTimestamp(47);
        this.customer_loyalty_id = dr.getString(48);
        this.customer_loyalty_verified = dr.getBoolean(49);
        this.easel_number = dr.getInt(50);
        this.platform_order = dr.getBoolean(51);
        this.shared_order = dr.getBoolean(52);
        this.caisse = AppLocal.ADD_ID_CAISSE ? AppLocal.host_name : null;
        this.order_id_base = dr.getString(53);
        this.keenio_base = dr.getString(54);
        this.take_away_phone = dr.getBoolean(55);
        this.session_id = dr.getString(58);
        this.tag_erc_stan = dr.getString(59);
        this.eft_stan = dr.getString(60);
        this.last_digit = dr.getString(61);
        this.EcrDateTime = dr.getString(62);
        this.holder = dr.getString(63);
    }

    public String getId() {
        return this.m_sId;
    }

    public int getOldTable() {
        return this.oldTable;
    }

    public void setOldTable(int oldTable) {
        this.oldTable = oldTable;
    }

    public String getTypeDiscount() {
        return this.typeDiscount;
    }

    public void setTypeDiscount(String typeDiscount) {
        this.typeDiscount = typeDiscount;
    }

    public String getReason_cancel() {
        return this.reason_cancel;
    }

    public void setReason_cancel(String reason_cancel) {
        this.reason_cancel = reason_cancel;
    }

    public Integer getBipper() {
        return this.bipper;
    }

    public void setBipper(Integer bipper) {
        this.bipper = bipper;
    }

    public double getDiscount() {
        return this.discount;
    }

    public void setDiscount(double discount) {
        this.discount = discount;
    }

    public double getSumTotal() {
        return this.getRealTotal();
    }

    public int getTicketType() {
        return this.tickettype;
    }

    public void setTicketType(int tickettype) {
        this.tickettype = tickettype;
    }

    public int getInvoice() {
        return this.invoice;
    }

    public void setInvoice(int invoice) {
        this.invoice = invoice;
    }

    public int getTicketId() {
        return this.m_iTicketId;
    }

    public void setTicketId(int iTicketId) {
        this.m_iTicketId = iTicketId;
    }

    void setPickupId(int iTicketId) {
        this.m_iPickupId = iTicketId;
    }

    public int getPickupId() {
        return this.m_iPickupId;
    }

    public int getIdTable() {
        return this.idTable;
    }

    public void setIdTable(int idTable) {
        this.idTable = idTable;
    }

    public TableInfo getTable() {
        return this.table;
    }

    public void setTable(TableInfo table) {
        this.table = table;
    }

    public String getName(Object info) {
        StringBuilder name = new StringBuilder();
        if (this.m_User != null) {
            name.append(this.m_User.getName());
            name.append(" - ");
        }
        if (info == null) {
            if (this.m_iTicketId == 0) {
                name.append("(").append(this.m_dateformat.format(this.m_dDate)).append(" ").append(this.m_dDate.getTime() % 1000L).append(")");
            } else {
                name.append(this.m_iTicketId);
            }
        } else {
            name.append(info.toString());
        }
        if (this.getCustomerId() != -1) {
            name.append(" - ");
            name.append(this.m_Customer.toString());
        }
        return name.toString();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getModePayment() {
        return this.modePayment;
    }

    public void setModePayment(String modePayment) {
        this.modePayment = modePayment;
    }

    public String getTempsLv() {
        return this.tempsLv;
    }

    public void setTempsLv(String tempsLv) {
        this.tempsLv = tempsLv;
    }

    public String getName() {
        return this.getName(null);
    }

    public Date getDate() {
        return this.m_dDate;
    }

    public void setDate(Date dDate) {
        this.m_dDate = dDate;
    }

    public UserInfo getUser() {
        return this.m_User;
    }

    public void setUser(UserInfo value) {
        this.m_User = value;
    }

    public CustomerInfo getCustomer() {
        return this.m_Customer;
    }

    public void setCustomer(CustomerInfo value) {
        this.m_Customer = value;
    }

    public int getCustomerId() {
        if (this.m_Customer == null) {
            return this.customerId;
        }
        return this.m_Customer.getId();
    }

    public int getNumero_order() {
        return this.numero_order;
    }

    public void setNumero_order(int numero_order) {
        this.numero_order = numero_order;
    }

    public String getTransactionID() {
        return this.getPayments().size() > 0 ? this.getPayments().get(this.getPayments().size() - 1).getTransactionID() : StringUtils.getCardNumber();
    }

    public String getReturnMessage() {
        return "";
    }

    public void setActiveCash(String value) {
        this.m_sActiveCash = value;
    }

    public String getActiveCash() {
        return this.m_sActiveCash;
    }

    public String getProperty(String key) {
        return this.attributes.getProperty(key);
    }

    public String getProperty(String key, String defaultvalue) {
        return this.attributes.getProperty(key, defaultvalue);
    }

    public void setProperty(String key, String value) {
        this.attributes.setProperty(key, value);
    }

    public Properties getProperties() {
        return this.attributes;
    }

    public TicketLineInfo getLine(int index) {
        return this.m_aLines.get(index);
    }

    public void addLine(TicketLineInfo oLine) {
        oLine.setTicket(this.m_sId);
        this.m_aLines.add(oLine);
    }

    public void insertLine(int index, TicketLineInfo oLine) {
        this.m_aLines.add(index, oLine);
        this.refreshLines();
    }

    public void setLine(int index, TicketLineInfo oLine) {
        oLine.setTicket(this.m_sId);
        this.m_aLines.set(index, oLine);
    }

    public void setId() {
        this.m_sId = "CMD" + new Date().getTime();
    }

    public void removeLine(int index) {
        this.m_aLines.remove(index);
        this.refreshLines();
    }

    private void refreshLines() {
        for (int i = 0; i < this.m_aLines.size(); ++i) {
            this.getLine(i).setTicket(this.m_sId);
        }
    }

    public int getLinesCount() {
        return (int)this.m_aLines.stream().filter(line -> !line.isNext()).count();
    }

    public int getLineSize() {
        int size = 0;
        for (TicketLineInfo m_aLine : this.m_aLines) {
            if (m_aLine.isNext() || m_aLine.isFree() || m_aLine.isPaid()) continue;
            double diff = m_aLine.getMultiply() - m_aLine.getUnits_paid();
            size = (int)((double)size + diff);
        }
        return size;
    }

    int getLinesNoPaidCount() {
        int size = 0;
        for (TicketLineInfo m_aLine : this.m_aLines) {
            if (m_aLine.isNext() || m_aLine.isPaid()) continue;
            ++size;
        }
        return size;
    }

    public int getLinesNotPaidCount() {
        int countLine = 0;
        for (TicketLineInfo m_aLine : this.m_aLines) {
            if (m_aLine.isNext() || m_aLine.isPaid() || m_aLine.isFree()) continue;
            ++countLine;
        }
        return countLine;
    }

    double getArticlesCount() {
        double dArticles = 0.0;
        Iterator<TicketLineInfo> iterator = this.m_aLines.iterator();
        while (iterator.hasNext()) {
            TicketLineInfo m_aLine;
            TicketLineInfo oLine = m_aLine = iterator.next();
            dArticles += oLine.getMultiply();
        }
        return dArticles;
    }

    public int getCouverts() {
        return this.couverts;
    }

    public void setCouverts(int couverts) {
        this.couverts = couverts;
    }

    double getSubTotal() {
        double sum = 0.0;
        for (TicketLineInfo line : this.m_aLines) {
            sum += line.getHtAmount();
        }
        return sum;
    }

    public double getTax() {
        double sum = 0.0;
        for (TicketLineInfo line : this.m_aLines) {
            sum += line.getTaxAmount();
        }
        return sum;
    }

    public double getTotal() {
        double totalCalculated = 0.0;
        if (AppLocal.MODULE_MEV || AppLocal.MODULE_TVA_GLOBAL) {
            totalCalculated = this.getTotalHT();
            double total_ht = this.getTotalHTTaxable();
            List<TaxInfo> globalTaxes = AppLocal.getGlobalTaxes();
            for (TaxInfo globalTaxe : globalTaxes) {
                totalCalculated += NumericUtils.round(total_ht * globalTaxe.getRate());
            }
        } else {
            totalCalculated = TicketInfo.computeTotal(this.m_aLines, this.typeDiscount, this.discount);
            return totalCalculated;
        }
        return totalCalculated;
    }

    public static double computeTotal(List<TicketLineInfo> lineInfos, String typeDiscount, double discount) {
        double sum = 0.0;
        for (TicketLineInfo line : lineInfos) {
            sum += line.getPrice() * line.getMultiply() - line.getDiscount();
        }
        sum = NumericUtils.round(sum);
        sum = POURCENTAGE.equals(typeDiscount) ? (sum -= discount * sum / 100.0) : (sum -= discount);
        return sum;
    }

    public double getRealTotal() {
        double sum = 0.0;
        for (TicketLineInfo line : this.m_aLines) {
            sum += line.getPrice() * line.getMultiply() - line.getDiscount();
        }
        return sum;
    }

    public String printDiscount() {
        if (POURCENTAGE.equals(this.typeDiscount)) {
            double sum = 0.0;
            for (TicketLineInfo line : this.m_aLines) {
                sum += line.getPrice() * line.getMultiply() - line.getDiscount();
            }
            System.out.println("+++++++++  sum : " + sum);
            return Formats.CURRENCY.formatValue(this.discount * sum / 100.0);
        }
        return Formats.CURRENCY.formatValue(this.discount);
    }

    public double getTotalOrder() {
        return this.total;
    }

    public void setTotal(double total) {
        this.total = total;
    }

    double getTotalPaid() {
        double sum = 0.0;
        for (PaymentInfo p : this.payments) {
            if ("debtpaid".equals(p.getName())) continue;
            sum += p.getTotal();
        }
        return sum;
    }

    public double getTendered() {
        return this.getTotalPaid();
    }

    public List<TicketLineInfo> getLines() {
        return this.m_aLines;
    }

    public void setLines(List<TicketLineInfo> l) {
        this.m_aLines = l;
    }

    public List<PaymentInfo> getPayments() {
        return this.payments;
    }

    public void setPayments(List<PaymentInfo> l) {
        this.payments = l;
    }

    public void resetPayments() {
        this.payments = new ArrayList<PaymentInfo>();
    }

    public List<TaxLineInfo> getTaxes() {
        if (this.taxeHelper == null) {
            this.taxeHelper = new TaxeHelper();
        }
        return this.taxeHelper.getTaxes(this);
    }

    TicketTaxInfo[] getTaxLines() {
        HashMap<String, TicketTaxInfo> m = new HashMap<String, TicketTaxInfo>();
        for (TicketLineInfo m_aLine : this.m_aLines) {
            TicketLineInfo oLine = m_aLine;
            TicketTaxInfo t = (TicketTaxInfo)m.get(oLine.getTaxInfo().getId());
            if (t == null) {
                t = new TicketTaxInfo(oLine.getTaxInfo());
                m.put(t.getTaxInfo().getId(), t);
            }
            t.add(oLine.getSubValue());
        }
        Collection avalues = m.values();
        return avalues.toArray(new TicketTaxInfo[avalues.size()]);
    }

    public String printId() {
        AppConfig m_config = AppConfig.getInstance(true, this.m_FilerUtils.getFileProperties());
        String receiptSize = m_config.getStringProperty("till.receiptsize");
        String receiptPrefix = m_config.getStringProperty("till.receiptprefix");
        m_config = null;
        if (this.m_iTicketId > 0) {
            Object tmpTicketId = Integer.toString(this.m_iTicketId);
            if (receiptSize == null || Integer.parseInt(receiptSize) <= ((String)tmpTicketId).length()) {
                if (receiptPrefix != null) {
                    tmpTicketId = receiptPrefix + (String)tmpTicketId;
                }
                return tmpTicketId;
            }
            while (((String)tmpTicketId).length() < Integer.parseInt(receiptSize)) {
                tmpTicketId = "0" + (String)tmpTicketId;
            }
            if (receiptPrefix != null) {
                tmpTicketId = receiptPrefix + (String)tmpTicketId;
            }
            return tmpTicketId;
        }
        return "";
    }

    public String printDate() {
        return Formats.TIMESTAMP.formatValue(this.m_dDate);
    }

    public String printUser() {
        return this.m_User == null ? "" : this.m_User.getName();
    }

    void clearCardNumber() {
        this.loyaltyCardNumber = null;
    }

    void setLoyaltyCardNumber(String cardNumber) {
        this.loyaltyCardNumber = cardNumber;
    }

    String getLoyaltyCardNumber() {
        return this.loyaltyCardNumber;
    }

    String printCustomer() {
        return this.m_Customer == null ? "" : this.m_Customer.getName();
    }

    public String printArticlesCount() {
        return Formats.DOUBLE.formatValue(this.getArticlesCount());
    }

    public String printSubTotal() {
        return Formats.CURRENCY.formatValue(this.getSubTotal());
    }

    public String printTax() {
        return Formats.CURRENCY.formatValue(this.getTax());
    }

    public String printTotal() {
        return Formats.CURRENCY.formatValue(this.getTotal());
    }

    public String printTotalOrder() {
        return Formats.CURRENCY.formatValue(this.getTotalOrder());
    }

    String printTotalPaid() {
        return Formats.CURRENCY.formatValue(this.getTotalPaid());
    }

    public String printTendered() {
        return Formats.CURRENCY.formatValue(this.getTendered());
    }

    String VoucherReturned() {
        return Formats.CURRENCY.formatValue(this.getTotalPaid() - this.getTotal());
    }

    boolean getOldTicket() {
        return this.oldTicket;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public void setAccepted(boolean accepted) {
        this.accepted = accepted;
    }

    void setOldTicket(Boolean otState) {
        this.oldTicket = otState;
    }

    public boolean isTransferred() {
        return this.transferred;
    }

    public void setTransferred(boolean transferred) {
        this.transferred = transferred;
    }

    public String printRetourMonnaie() {
        return Formats.CURRENCY.formatValue(this.getRetourMonnaie());
    }

    public double getRetourMonnaie() {
        double totalPaid = 0.0;
        for (PaymentInfo payment : this.getPayments()) {
            totalPaid += payment.getPaid();
        }
        return totalPaid - this.getTotal();
    }

    public LivreurInfo getLivreur() {
        return this.m_livreur;
    }

    public void setLivreur(LivreurInfo m_livreur) {
        this.m_livreur = m_livreur;
    }

    public int getAddress() {
        return this.address;
    }

    public void setAddress(int address) {
        this.address = address;
    }

    public Date getM_dDate() {
        return this.m_dDate;
    }

    UserInfo getM_User() {
        return this.m_User;
    }

    List<TicketLineInfo> getM_aLines() {
        return this.m_aLines;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.m_sId);
        builder.append(",");
        builder.append(this.type);
        builder.append(",");
        builder.append(this.modePayment);
        builder.append(",");
        builder.append(DateUtils.SDF_FULL_DATE_TIME.format(this.m_dDate));
        builder.append(",");
        builder.append(this.m_sActiveCash);
        builder.append(",");
        builder.append(",");
        builder.append(this.m_Customer == null ? -1 : this.m_Customer.getId());
        builder.append(",");
        builder.append(this.status);
        builder.append(",");
        builder.append(this.total);
        builder.append(",");
        builder.append(this.address);
        builder.append(",");
        builder.append(this.numero_order);
        builder.append(",");
        builder.append(this.idTable);
        builder.append(",");
        builder.append(this.discount);
        builder.append(",");
        builder.append(this.typeDiscount);
        builder.append(",");
        builder.append(this.bipper);
        builder.append(",");
        builder.append(this.transferred);
        builder.append(",");
        builder.append(this.reason_cancel);
        builder.append(",");
        builder.append(this.invoice);
        builder.append(",");
        builder.append(this.lastUpdate);
        builder.append(",");
        builder.append(this.easel_number);
        return builder.toString();
    }

    public String getEntete() {
        StringBuilder builder = new StringBuilder();
        builder.append("ID");
        builder.append(",");
        builder.append("type");
        builder.append(",");
        builder.append("mode de Payment");
        builder.append(",");
        builder.append("Date de Commande");
        builder.append(",");
        builder.append("Active Espece");
        builder.append(",");
        builder.append("CodeOperator");
        builder.append(",");
        builder.append("Code CLient");
        builder.append(",");
        builder.append("Statut ");
        builder.append(",");
        builder.append("Total ");
        builder.append(",");
        builder.append("Adresse");
        builder.append(",");
        builder.append("N commande");
        builder.append(",");
        builder.append("N table");
        builder.append(",");
        builder.append("Remise");
        builder.append(",");
        builder.append("Type de remise");
        builder.append(",");
        builder.append("Bipper ");
        builder.append(",");
        builder.append("Transfert");
        builder.append(",");
        builder.append("Raison d'annulation(statut=cancel)");
        builder.append(",");
        builder.append("Id Facture");
        builder.append(",");
        builder.append("Derniere modification");
        builder.append(",");
        builder.append("N Chevalet");
        return builder.toString();
    }

    public Object clone() {
        TicketInfo o = null;
        try {
            int i;
            o = (TicketInfo)super.clone();
            if (this.m_aLines != null) {
                o.m_aLines = new ArrayList<TicketLineInfo>();
                for (i = 0; i < this.m_aLines.size(); ++i) {
                    o.m_aLines.add((TicketLineInfo)this.m_aLines.get(i).clone());
                }
            } else {
                o.m_aLines = null;
            }
            if (this.payments != null) {
                o.payments = new ArrayList<PaymentInfo>();
                for (i = 0; i < this.payments.size(); ++i) {
                    o.payments.add((PaymentInfo)this.payments.get(i).clone());
                }
            } else {
                o.payments = null;
            }
            if (this.m_Customer != null) {
                o.m_Customer = (CustomerInfo)this.m_Customer.clone();
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return o;
    }

    Object cloneSuper() {
        TicketInfo o = null;
        try {
            o = (TicketInfo)super.clone();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return o;
    }

    public boolean isPaid() {
        return this.paid;
    }

    public void setPaid(boolean paid) {
        this.paid = paid;
    }

    public boolean isHasNext() {
        if (this.hasNext) {
            return this.hasNext;
        }
        for (TicketLineInfo m_aLine : this.m_aLines) {
            if (!m_aLine.isNext()) continue;
            this.hasNext = true;
            return this.hasNext;
        }
        return this.hasNext;
    }

    public void setHasNext(boolean hasNext) {
        this.hasNext = hasNext;
    }

    public String getCaisse() {
        return this.caisse;
    }

    public void setCaisse(String caisse) {
        this.caisse = caisse;
    }

    public int getNumTable() {
        return this.table == null ? this.num_table : this.table.getNumber();
    }

    public AddressInfo getAddressInfo() {
        return this.addressInfo;
    }

    public void setAddressInfo(AddressInfo addressInfo) {
        this.addressInfo = addressInfo;
    }

    public String getName_customer() {
        return this.name_customer;
    }

    public void setName_customer(String name_customer) {
        this.name_customer = name_customer;
    }

    public String getSource_order() {
        return this.source_order;
    }

    public void setSource_order(String source_order) {
        this.source_order = source_order;
    }

    public Date getDatePaid() {
        return this.datePaid;
    }

    public void setDatePaid(Date datePaid) {
        this.datePaid = datePaid;
    }

    int getNumberLine() {
        int count = 0;
        for (TicketLineInfo line : this.m_aLines) {
            if (line.isNext()) continue;
            ++count;
        }
        return count;
    }

    public int getNumberLine2() {
        return this.numberline2;
    }

    public void setNumberline2(int i) {
        this.numberline2 = i;
    }

    public String getNum_order_borne() {
        return this.num_order_borne;
    }

    public Boolean getClosed() {
        return this.closed;
    }

    public void setClosed(Boolean closed) {
        this.closed = closed;
    }

    public String getOrigineCanceledTicketString() {
        return this.origineCanceledTicketString;
    }

    void setOrigineCanceledTicketString(String origineCanceledTicketString) {
        this.origineCanceledTicketString = origineCanceledTicketString;
    }

    public void setNum_order_borne(String num_order_borne) {
        this.num_order_borne = num_order_borne;
    }

    public void setNowAsDate() {
        this.lastUpdate = this.m_dDate = new Date();
    }

    public int getNum_order_kitchen() {
        return this.num_order_kitchen;
    }

    public void setNum_order_kitchen(int num_order_kitchen) {
        this.num_order_kitchen = num_order_kitchen;
    }

    public String getSent_from() {
        return this.sent_from;
    }

    public void setSent_from(String sent_from) {
        this.sent_from = sent_from;
    }

    public int getId_shared_order() {
        return this.id_shared_order;
    }

    public void setId_shared_order(int id_shared_order) {
        this.id_shared_order = id_shared_order;
    }

    public String getOrdered_from() {
        return this.ordered_from;
    }

    public void setOrdered_from(String ordered_from) {
        this.ordered_from = ordered_from;
    }

    public void duplicate(TicketInfo ticket_duplicated) {
        if (ticket_duplicated.m_aLines != null) {
            this.m_aLines = new ArrayList<TicketLineInfo>();
            for (int i = 0; i < ticket_duplicated.m_aLines.size(); ++i) {
                this.m_aLines.add((TicketLineInfo)ticket_duplicated.m_aLines.get(i).clone());
            }
        } else {
            this.m_aLines = null;
        }
        this.discount = ticket_duplicated.getDiscount();
        this.typeDiscount = ticket_duplicated.getTypeDiscount();
        this.bipper = ticket_duplicated.getBipper();
        this.type = ticket_duplicated.getType();
        this.modePayment = ticket_duplicated.getModePayment();
        this.tempsLv = ticket_duplicated.getTempsLv();
        this.easel_number = ticket_duplicated.getEasel_number();
    }

    public int getId_order_kitchen() {
        return this.id_order_kitchen;
    }

    public void setId_order_kitchen(int id_order_kitchen) {
        this.id_order_kitchen = id_order_kitchen;
    }

    public boolean isError_print_kitchen() {
        return this.error_print_kitchen;
    }

    public void setError_print_kitchen(boolean error_print_kitchen) {
        this.error_print_kitchen = error_print_kitchen;
    }

    public boolean isPrint_after_update() {
        return this.print_after_update;
    }

    public void setPrint_after_update(boolean print_after_update) {
        this.print_after_update = print_after_update;
    }

    public Date getDelivered() {
        return this.delivered;
    }

    public void setDelivered(Date delivered) {
        this.delivered = delivered;
    }

    public String getNumero_online_order() {
        return this.numero_online_order;
    }

    public void setNumero_online_order(String numero_online_order) {
        this.numero_online_order = numero_online_order;
    }

    public int getNum_table() {
        return this.num_table;
    }

    public void setNum_table(int num_table) {
        this.num_table = num_table;
    }

    public String getNumero_platform_order() {
        return this.numero_platform_order;
    }

    public void setNumero_platform_order(String numero_platform_order) {
        this.numero_platform_order = numero_platform_order;
    }

    public String getId_online_order() {
        return this.id_online_order;
    }

    public void setId_online_order(String id_online_order) {
        this.id_online_order = id_online_order;
    }

    public void setId(String id) {
        this.m_sId = id;
    }

    public String getLabel_discount() {
        return this.label_discount;
    }

    public void setLabel_discount(String label_discount) {
        this.label_discount = label_discount;
    }

    public List<TicketLineInfo> getOldLines() {
        return this.oldLines;
    }

    public void setOldLines(List<TicketLineInfo> oldLines) {
        this.oldLines = oldLines;
    }

    public Date getRecover_date() {
        return this.recover_date;
    }

    public void setRecover_date(Date recover_date) {
        this.recover_date = recover_date;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getIdSourceSharedOrder() {
        return this.idSourceSharedOrder;
    }

    public void setIdSourceSharedOrder(String idSourceSharedOrder) {
        this.idSourceSharedOrder = idSourceSharedOrder;
    }

    public String getAddress_ip_borne() {
        return this.address_ip_borne;
    }

    public void setAddress_ip_borne(String address_ip_borne) {
        this.address_ip_borne = address_ip_borne;
    }

    public String getNumberOrder() {
        return this.getNumberOrder(false, false);
    }

    public String getNumberOrder(boolean show_online_number, boolean show_borne_number) {
        System.out.println("getNum_order_kitchen() : " + this.getNum_order_kitchen());
        Object orderNum = "";
        if (show_online_number && this.numero_platform_order != null && !this.numero_platform_order.isEmpty()) {
            orderNum = this.numero_platform_order;
        } else if (show_borne_number && (this.getNum_order_kitchen() == 0 || this.getNum_order_kitchen() == -1) && AppLocal.DISPLAY_NUM_ORDER && this.getNum_order_borne() != null && !this.getNum_order_borne().isEmpty()) {
            orderNum = String.valueOf(this.getNum_order_borne());
        } else if (AppLocal.ADD_HOUR_TO_NUMBER_ORDER) {
            int orderNumber = this.getNum_order_kitchen() != -1 && this.getNum_order_kitchen() != 0 ? this.getNum_order_kitchen() : this.getNumero_order();
            orderNum = this.getNumberOrderWithHour(orderNumber);
        } else {
            orderNum = this.getNum_order_kitchen() != -1 && this.getNum_order_kitchen() != 0 ? String.valueOf(this.getNum_order_kitchen()) : (this.getCaisse() != null ? this.getCaisse() + this.getNumero_order() : String.valueOf(this.getNumero_order()));
        }
        return orderNum;
    }

    public String getNumberOrderToPrint() {
        String orderNum = "";
        int orderNumber = this.getNum_order_kitchen() != -1 && this.getNum_order_kitchen() != 0 ? this.getNum_order_kitchen() : this.getNumero_order();
        orderNum = AppLocal.ADD_HOUR_TO_NUMBER_ORDER ? this.getNumberOrderWithHour(orderNumber) : String.valueOf(orderNumber);
        return orderNum;
    }

    public String getNumberOrderWithHour(int num_order_kitchen) {
        StringBuilder numberOrderBuilder = new StringBuilder();
        int hour = this.m_dDate.getHours();
        numberOrderBuilder.append(String.valueOf(hour));
        int lastTowDigit = num_order_kitchen % 100;
        if (lastTowDigit < 10) {
            numberOrderBuilder.append("0");
        }
        numberOrderBuilder.append(lastTowDigit);
        return numberOrderBuilder.toString();
    }

    public String getNumberOrderWithHour() {
        return this.getNumberOrderWithHour(this.getNum_order_kitchen());
    }

    public String getCustomerPhone() {
        return this.getCustomer() != null ? this.getCustomer().getPhone() : null;
    }

    public boolean isDelayed() {
        return this.delayed;
    }

    public void setDelayed(boolean delayed) {
        this.delayed = delayed;
    }

    public double getTax_ubereat() {
        return this.tax_ubereat;
    }

    public void setTax_ubereat(double tax_ubereat) {
        this.tax_ubereat = tax_ubereat;
    }

    public double getTotal_fee_ubereat() {
        return this.total_fee_ubereat;
    }

    public void setTotal_fee_ubereat(double total_fee_ubereat) {
        this.total_fee_ubereat = total_fee_ubereat;
    }

    public String getStore_uber_eat() {
        return this.store_uber_eat;
    }

    public void setStore_uber_eat(String store_uber_eat) {
        this.store_uber_eat = store_uber_eat;
    }

    public String getCustomer_loyalty_id() {
        return this.customer_loyalty_id;
    }

    public void setCustomer_loyalty_id(String customer_loyalty_id) {
        this.customer_loyalty_id = customer_loyalty_id;
    }

    public boolean isCustomer_loyalty_verified() {
        return this.customer_loyalty_verified;
    }

    public void setCustomer_loyalty_verified(boolean customer_loyalty_verified) {
        this.customer_loyalty_verified = customer_loyalty_verified;
    }

    public CustomerLoyalty getmCustomerLoyalty() {
        return this.mCustomerLoyalty;
    }

    public void setmCustomerLoyalty(CustomerLoyalty mCustomerLoyalty) {
        System.out.println("+++++++++++ mCustomerLoyalty : " + mCustomerLoyalty);
        this.mCustomerLoyalty = mCustomerLoyalty;
    }

    public double getTotalPoint() {
        double total_point = 0.0;
        for (TicketLineInfo line : this.m_aLines) {
            total_point += line.getPoints_loyalty();
        }
        return total_point;
    }

    public boolean isShared_order() {
        return this.shared_order;
    }

    public void setShared_order(boolean shared_order) {
        this.shared_order = shared_order;
    }

    public boolean isValidCaisse(List<TicketLineInfo> m_aLines) {
        ArrayList<Boolean> listvalidCaisse = new ArrayList<Boolean>();
        for (TicketLineInfo m_aLine : m_aLines) {
            boolean valid = m_aLine.isValid_caisse();
            listvalidCaisse.add(valid);
        }
        boolean validcaisse = listvalidCaisse.contains(true);
        return validcaisse;
    }

    public boolean hasProductWithExludedIngredient() {
        return this.m_aLines.stream().anyMatch(m_aLine -> m_aLine.getListIngredients() != null && !m_aLine.getListIngredients().isEmpty());
    }

    public int getNumberOrderTorint() {
        if (this.getNum_order_kitchen() != -1 && this.getNum_order_kitchen() != 0) {
            return this.getNum_order_kitchen();
        }
        return this.getNumero_order();
    }

    public String getNameUser() {
        return this.m_User != null ? this.m_User.getName() : "";
    }

    public Integer getEasel_number() {
        return this.easel_number;
    }

    public void setEasel_number(Integer easel_number) {
        this.easel_number = easel_number;
    }

    public String getCustomerName() {
        return this.getCustomer() != null ? this.getCustomer().getName() : this.getName_customer();
    }

    public double getTotalHT() {
        return TicketInfo.computeTotal(this.m_aLines, this.typeDiscount, this.discount);
    }

    public double getTotalHTBeforeDiscount() {
        double sum = 0.0;
        for (TicketLineInfo line : this.m_aLines) {
            sum += line.getPrice() * line.getMultiply() - line.getDiscount();
        }
        sum = NumericUtils.round(sum);
        return sum;
    }

    public boolean isPlatform_order() {
        return this.platform_order;
    }

    public void setPlatform_order(boolean platform_order) {
        this.platform_order = platform_order;
    }

    public String printDiscountPlatform() {
        if (POURCENTAGE.equals(this.typeDiscount)) {
            return Formats.CURRENCY.formatValue(this.discount * this.total / 100.0);
        }
        return Formats.CURRENCY.formatValue(this.discount);
    }

    public boolean isTake_away_phone() {
        return this.take_away_phone;
    }

    public void setTake_away_phone(boolean take_away_phone) {
        this.take_away_phone = take_away_phone;
    }

    public TicketLineInfo getLastLine() {
        return this.m_aLines != null && !this.m_aLines.isEmpty() ? this.m_aLines.get(this.m_aLines.size() - 1) : null;
    }

    public double getTotalHTTaxable() {
        double sum = 0.0;
        for (TicketLineInfo line : this.m_aLines) {
            if (line.isTva_global_no_applicable()) continue;
            sum += line.getPrice() * line.getMultiply() - line.getDiscount();
        }
        sum = NumericUtils.round(sum);
        sum = POURCENTAGE.equals(this.typeDiscount) ? (sum -= this.discount * sum / 100.0) : (sum -= this.discount);
        return sum;
    }

    public double getGlobalDiscount() {
        double discount_global = 0.0;
        for (TicketLineInfo m_aLine : this.m_aLines) {
            discount_global += m_aLine.getDiscount();
        }
        return discount_global;
    }

    public double getGlobalDiscountLinesAndOrder() {
        double discount_global = 0.0;
        double sum = 0.0;
        for (TicketLineInfo m_aLine : this.m_aLines) {
            discount_global += m_aLine.getDiscount();
            sum += m_aLine.getPrice() * m_aLine.getMultiply() - m_aLine.getDiscount();
        }
        sum = NumericUtils.round(sum);
        discount_global = POURCENTAGE.equals(this.typeDiscount) ? (discount_global += this.discount * sum / 100.0) : (discount_global += this.discount);
        return discount_global;
    }

    public double getTotalHTNoTaxable() {
        double sum = 0.0;
        for (TicketLineInfo line : this.m_aLines) {
            if (!line.isTva_global_no_applicable()) continue;
            sum += line.getPrice() * line.getMultiply() - line.getDiscount();
        }
        sum = NumericUtils.round(sum);
        sum = POURCENTAGE.equals(this.typeDiscount) ? (sum -= this.discount * sum / 100.0) : (sum -= this.discount);
        return sum;
    }

    public String getPlatform_current_state() {
        return this.platform_current_state;
    }

    public void setPlatform_current_state(String platform_current_state) {
        this.platform_current_state = platform_current_state;
    }

    public TotaleEncaissement getTolalEncaissment() {
        if (this.taxeHelper == null) {
            this.taxeHelper = new TaxeHelper();
        }
        return this.taxeHelper.getTolalEncaissment(this);
    }

    public String getKeenio_base() {
        return this.keenio_base;
    }

    public void setKeenio_base(String keenio_base) {
        this.keenio_base = keenio_base;
    }

    public String getOrder_id_base() {
        return this.order_id_base;
    }

    public void setOrder_id_base(String order_id_base) {
        this.order_id_base = order_id_base;
    }

    public double getValue_in_base() {
        return this.value_in_base;
    }

    public void setValue_in_base(double value_in_base) {
        this.value_in_base = value_in_base;
    }

    public double getValue_out_base() {
        return this.value_out_base;
    }

    public void setValue_out_base(double value_out_base) {
        this.value_out_base = value_out_base;
    }

    public int getNbrArticles() {
        int i = 0;
        for (TicketLineInfo m_aLine : this.m_aLines) {
            if (m_aLine.isNext()) continue;
            ++i;
            if (!AppLocal.MODULE_MULTI_TVA) continue;
            for (OptionItemOrder supplement : m_aLine.getListSupplements()) {
                if (!supplement.addTaxeToOption() || supplement.getTax() == null) continue;
                ++i;
            }
        }
        return i;
    }

    public String getSession_id() {
        return this.session_id;
    }

    public void setSession_id(String session_id) {
        this.session_id = session_id;
    }

    public String getTag_erc_stan() {
        return this.tag_erc_stan;
    }

    public void setTag_erc_stan(String tag_erc_stan) {
        this.tag_erc_stan = tag_erc_stan;
    }

    public String getLast_digit() {
        return this.last_digit;
    }

    public void setLast_digit(String last_digit) {
        this.last_digit = last_digit;
    }

    public String getEft_stan() {
        return this.eft_stan;
    }

    public void setEft_stan(String eft_stan) {
        this.eft_stan = eft_stan;
    }

    public String getEcrDateTime() {
        return this.EcrDateTime;
    }

    public void setEcrDateTime(String EcrDateTime) {
        this.EcrDateTime = EcrDateTime;
    }

    public double getValueDiscount() {
        if (POURCENTAGE.equals(this.typeDiscount)) {
            double sum = 0.0;
            for (TicketLineInfo line : this.m_aLines) {
                System.out.println((sum += line.getPrice() * line.getMultiply() - line.getDiscount()) + " += " + line.getPrice() + " * " + line.getMultiply() + " - " + line.getDiscount());
            }
            System.out.println("+++++++++  sum : " + sum);
            return NumericUtils.round(this.discount * sum / 100.0);
        }
        return this.discount;
    }

    public double getDiscountOrderAndLines() {
        return this.discountOrderAndLines;
    }

    public void setDiscountOrderAndLines(double discountOrderAndLines) {
        this.discountOrderAndLines = discountOrderAndLines;
    }

    public String getNumberOrderBorne() {
        if (this.getNum_order_kitchen() != -1 && this.getNum_order_kitchen() != 0) {
            if (AppLocal.ADD_HOUR_TO_NUMBER_ORDER) {
                return this.getNumberOrderWithHour(this.getNum_order_kitchen());
            }
            return String.valueOf(this.getNum_order_kitchen());
        }
        return this.getNum_order_borne();
    }

    public String getHolder() {
        return this.holder;
    }

    public void setHolder(String holder) {
        this.holder = holder;
    }

    static {
        infoComparator = (l1, l2) -> {
            if (l1.isNext() || l2.isNext() || l1.getTaxInfo() == null || l2.getTaxInfo() == null) {
                return -1;
            }
            return (int)(l2.getTaxInfo().getRate() * 100.0 - l1.getTaxInfo().getRate() * 100.0);
        };
    }
}

