/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.ticket;

import com.openbravo.basic.BasicException;
import com.openbravo.data.loader.SerializerRead;
import com.openbravo.format.Formats;
import com.procaisse.db.metadata.DataRead;

public class TaxeLine {
    private String id;
    private String name;
    private double rate;
    private double total;
    private double ht;
    private double tax;

    public TaxeLine() {
    }

    public TaxeLine(String id, String name, double rate, double total, double ht, double tax) {
        this.id = id;
        this.name = name;
        this.rate = rate;
        this.total = total;
        this.ht = ht;
        this.tax = tax;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getTotal() {
        return this.total;
    }

    public void setTotal(double total) {
        this.total = total;
    }

    public double getHt() {
        return this.ht;
    }

    public void setHt(double ht) {
        this.ht = ht;
    }

    public double getTax() {
        return this.tax;
    }

    public void setTax(double tax) {
        this.tax = tax;
    }

    public double getRate() {
        return this.rate;
    }

    public void setRate(double rate) {
        this.rate = rate;
    }

    public static SerializerRead getSerializerRead() {
        return new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                return new TaxeLine(dr.getString(1), dr.getString(2), dr.getDouble(3), dr.getDouble(4), dr.getDouble(5), dr.getDouble(6));
            }
        };
    }

    public String toString() {
        return "TaxeLine{id=" + this.id + ", name=" + this.name + ", rate=" + this.rate + ", total=" + this.total + ", ht=" + this.ht + ", tax=" + this.tax + "}";
    }

    public String printTaxe() {
        return Formats.CURRENCY.formatValue(this.getTax());
    }

    public String printHT() {
        return Formats.CURRENCY.formatValue(this.getHt());
    }

    public String printTTC() {
        return Formats.CURRENCY.formatValue(this.getTotal());
    }
}

