/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.ticket;

import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.ITaxeHelper;
import com.openbravo.pos.ticket.TaxInfo;
import com.openbravo.pos.ticket.TaxLineInfo;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TotaleEncaissement;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.NumericUtils;
import java.util.ArrayList;
import java.util.List;

public class TaxeGlobal
implements ITaxeHelper {
    @Override
    public List<TaxLineInfo> getTaxes(TicketInfo ticket) {
        ArrayList<TaxLineInfo> taxes = new ArrayList<TaxLineInfo>();
        try {
            double total_ht = ticket.getTotalHTTaxable();
            List<TaxInfo> globalTaxes = AppLocal.getGlobalTaxes();
            for (TaxInfo globalTaxe : globalTaxes) {
                taxes.add(new TaxLineInfo(globalTaxe.getId(), globalTaxe.getName(), NumericUtils.round(total_ht * globalTaxe.getRate()), globalTaxe.getRate(), 0.0, 0.0, true));
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return taxes;
    }

    @Override
    public TotaleEncaissement getTolalEncaissment(TicketInfo ticket) {
        TotaleEncaissement totaleEncaissement = new TotaleEncaissement();
        try {
            double total_ht_no_taxable = NumericUtils.round(ticket.getTotalHTNoTaxable());
            double total_ht_taxable = NumericUtils.round(ticket.getTotalHTTaxable());
            double totalTax = 0.0;
            List<TaxInfo> globalTaxes = AppLocal.getGlobalTaxes();
            for (TaxInfo globalTaxe : globalTaxes) {
                totalTax += NumericUtils.round(total_ht_taxable * globalTaxe.getRate());
            }
            double totalHt = total_ht_no_taxable + total_ht_taxable;
            double totalTTC = totalHt + NumericUtils.round(totalTax);
            totaleEncaissement.setTotal_ht(totalHt);
            totaleEncaissement.setTotal_tax(totalTax);
            totaleEncaissement.setTotal_ttc(totalTTC);
            totaleEncaissement.setTotal_ht_taxable(total_ht_taxable);
            totaleEncaissement.setTotal_ht_no_taxable(total_ht_no_taxable);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return totaleEncaissement;
    }
}

