/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.ticket;

import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.ITaxeHelper;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.TaxLineInfo;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.ticket.TicketLineTaxInfo;
import com.openbravo.pos.ticket.TotaleEncaissement;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.NumericUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class TaxeByLine
implements ITaxeHelper {
    public static Comparator<TicketLineInfo> infoComparator = (l1, l2) -> {
        if (l1.isNext() || l2.isNext() || l1.getTaxInfo() == null || l2.getTaxInfo() == null) {
            return -1;
        }
        return (int)(l2.getTaxInfo().getRate() * 100.0 - l1.getTaxInfo().getRate() * 100.0);
    };
    public static Comparator<TicketLineTaxInfo> comparatorTaxes = (t1, t2) -> {
        if (t1.getTax() == null || t2.getTax() == null) {
            return -1;
        }
        return (int)(t2.getTax().getRate() * 100.0 - t1.getTax().getRate() * 100.0);
    };

    @Override
    public List<TaxLineInfo> getTaxes(TicketInfo ticket) {
        ArrayList<TaxLineInfo> taxes = new ArrayList<TaxLineInfo>();
        try {
            ArrayList<TicketLineInfo> orderedLines = new ArrayList<TicketLineInfo>(ticket.getLines());
            ArrayList<TicketLineTaxInfo> linesTaxes = new ArrayList<TicketLineTaxInfo>();
            double restReduction = ticket.getTypeDiscount().equals("pourcentage") ? ticket.getDiscount() * ticket.getTotal() / (100.0 - ticket.getDiscount()) : ticket.getDiscount();
            TaxLineInfo taxOfPreviousLine = new TaxLineInfo("", "", 0.0, 0.0, 0.0, 0.0, false);
            for (TicketLineInfo line : orderedLines) {
                if (line.isNext()) continue;
                if (line.getTaxInfo() != null) {
                    linesTaxes.add(new TicketLineTaxInfo(line.getTaxInfo(), line.getHtAmount(), line.getTaxAmount()));
                }
                if (!AppLocal.MODULE_MULTI_TVA) continue;
                for (OptionItemOrder supplement : line.getListSupplements()) {
                    if (!supplement.addTaxeToOption() || supplement.getTax() == null) continue;
                    linesTaxes.add(new TicketLineTaxInfo(supplement.getTax(), supplement.getHtAmount(), supplement.getTaxAmount()));
                }
            }
            linesTaxes.sort(comparatorTaxes);
            for (TicketLineTaxInfo lineTaxInfo : linesTaxes) {
                double ttc = Math.abs(NumericUtils.round(lineTaxInfo.getHtAmount()) + NumericUtils.round(lineTaxInfo.getTaxAmount()));
                if (ttc - restReduction >= 0.0) {
                    double ttcWithDiscount = ttc - restReduction;
                    restReduction = 0.0;
                    double sum = ttcWithDiscount;
                    double sumHT = ttcWithDiscount / (1.0 + lineTaxInfo.getTax().getRate());
                    double sumTAX = ttcWithDiscount - sumHT;
                    if (lineTaxInfo.getHtAmount() + lineTaxInfo.getTaxAmount() <= 0.0) {
                        sum = -sum;
                        sumHT = -sumHT;
                        sumTAX = -sumTAX;
                    }
                    if (lineTaxInfo.getTax().getName().equals(taxOfPreviousLine.getName())) {
                        taxOfPreviousLine.setAmount(taxOfPreviousLine.getAmount() + sumTAX);
                        taxOfPreviousLine.setSumHT(taxOfPreviousLine.getSumHT() + sumHT);
                        taxOfPreviousLine.setSumTTC(taxOfPreviousLine.getSumTTC() + sum);
                        continue;
                    }
                    if (!taxOfPreviousLine.getId().equals("")) {
                        taxes.add(taxOfPreviousLine);
                    }
                    taxOfPreviousLine = new TaxLineInfo(lineTaxInfo.getTax().getId(), lineTaxInfo.getTax().getName(), sumTAX, lineTaxInfo.getTax().getRate(), sumHT, sum, false);
                    continue;
                }
                restReduction -= ttc;
            }
            if (!taxOfPreviousLine.getId().equals("")) {
                taxes.add(taxOfPreviousLine);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return taxes;
    }

    @Override
    public TotaleEncaissement getTolalEncaissment(TicketInfo ticket) {
        TotaleEncaissement totaleEncaissement = new TotaleEncaissement();
        try {
            ArrayList<TicketLineInfo> orderedLines = new ArrayList<TicketLineInfo>(ticket.getLines());
            orderedLines.sort(infoComparator);
            double restReduction = ticket.getTypeDiscount().equals("pourcentage") ? ticket.getDiscount() * ticket.getTotal() / (100.0 - ticket.getDiscount()) : ticket.getDiscount();
            double totalHT = 0.0;
            for (TicketLineInfo line : orderedLines) {
                if (line.isNext() || line.getTaxInfo() == null) continue;
                double ttc = Math.abs(NumericUtils.round(line.getHtAmount()) + NumericUtils.round(line.getTaxAmount()));
                if (ttc - restReduction >= 0.0) {
                    double ttcWithDiscount = ttc - restReduction;
                    restReduction = 0.0;
                    totalHT = ttcWithDiscount / (1.0 + line.getTaxInfo().getRate());
                    if (!(line.getHtAmount() + line.getTaxAmount() <= 0.0)) continue;
                    totalHT = -totalHT;
                    continue;
                }
                restReduction -= ttc;
            }
            double total = NumericUtils.round(ticket.getTotal());
            double total_tax = total - NumericUtils.round(Math.abs(totalHT));
            totaleEncaissement.setTotal_ht(totalHT);
            totaleEncaissement.setTotal_tax(total_tax);
            totaleEncaissement.setTotal_ttc(total);
            totaleEncaissement.setTotal_ht_taxable(totalHT);
            totaleEncaissement.setTotal_ht_no_taxable(0.0);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return totaleEncaissement;
    }
}

