/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.ticket;

import com.openbravo.basic.BasicException;
import com.openbravo.data.loader.SerializerRead;
import com.openbravo.format.Formats;
import com.procaisse.db.metadata.DataRead;

public class TaxLineTicket {
    private String id;
    private String name;
    private double amount;
    private double rate;
    private double sumHT;
    private double sumTTC;
    private boolean taxe_global;

    public TaxLineTicket() {
    }

    public TaxLineTicket(String id, String name, double sumHT, double rate, double amount, double sumTTC) {
        this.id = id;
        this.name = name;
        this.amount = amount;
        this.rate = rate;
        this.sumHT = sumHT;
        this.sumTTC = sumTTC;
    }

    public TaxLineTicket(double sumTTC, double amount, double sumHT, double rate) {
        this.sumTTC = sumTTC;
        this.amount = amount;
        this.sumHT = sumHT;
        this.rate = rate;
    }

    public TaxLineTicket(String name, double amount) {
        this.name = name;
        this.amount = amount;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public String printAmount() {
        return Formats.CURRENCY.formatValue(this.getAmount());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public double getRate() {
        return this.rate;
    }

    public void setRate(double rate) {
        this.rate = rate;
    }

    public double getSumHT() {
        return this.sumHT;
    }

    public void setSumHT(double sumHT) {
        this.sumHT = sumHT;
    }

    public double getSumTTC() {
        return this.sumTTC;
    }

    public void setSumTTC(double sumTTC) {
        this.sumTTC = sumTTC;
    }

    public String printHT() {
        return Formats.CURRENCY.formatValue(this.getSumHT());
    }

    public String printTTC() {
        return Formats.CURRENCY.formatValue(this.getSumTTC());
    }

    public boolean isTaxe_global() {
        return this.taxe_global;
    }

    public void setTaxe_global(boolean taxe_global) {
        this.taxe_global = taxe_global;
    }

    public static SerializerRead getSerializerReadTaxeInfo() {
        return new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                TaxLineTicket taxLineTicket = new TaxLineTicket();
                taxLineTicket.amount = dr.getDouble(1);
                taxLineTicket.id = dr.getString(2);
                taxLineTicket.name = dr.getString(3);
                taxLineTicket.rate = dr.getDouble(4);
                taxLineTicket.taxe_global = true;
                return taxLineTicket;
            }
        };
    }

    public static SerializerRead getSerializerRead() {
        return new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                return new TaxLineTicket(dr.getString(1), dr.getString(2), dr.getDouble(3), dr.getDouble(4), dr.getDouble(5), dr.getDouble(6));
            }
        };
    }

    public static SerializerRead getSerializerReadTikcet() {
        return new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                return new TaxLineTicket(dr.getDouble(1), dr.getDouble(2), dr.getDouble(3), dr.getDouble(4));
            }
        };
    }
}

