/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.ticket;

import com.openbravo.basic.BasicException;
import com.openbravo.data.loader.SerializerRead;
import com.openbravo.format.Formats;
import com.openbravo.pos.util.NumericUtils;
import com.procaisse.db.metadata.DataRead;

public class TaxLineInfo {
    private String id;
    private String name;
    private double amount;
    private double rate;
    private double sumHT;
    private double sumTTC;
    private boolean taxe_global;

    public TaxLineInfo(String id, String name, double amount, double rate, double sumHT, double sumTTC, boolean taxe_global) {
        this.id = id;
        this.name = name;
        this.amount = amount;
        this.rate = rate;
        this.sumHT = sumHT;
        this.sumTTC = sumTTC;
        this.taxe_global = taxe_global;
    }

    public TaxLineInfo(String name, double amount) {
        this.name = name;
        this.amount = amount;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public String printAmount() {
        return Formats.CURRENCY.formatValue(this.getAmount());
    }

    public static String printThisDoubleAsAmount(double myDouble) {
        return Formats.CURRENCY.formatValue(NumericUtils.round(myDouble));
    }

    public String printSumHT() {
        return Formats.CURRENCY.formatValue(this.getSumHT());
    }

    public String printSumTTC() {
        return Formats.CURRENCY.formatValue(this.getSumTTC());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public double getRate() {
        return this.rate;
    }

    public void setRate(double rate) {
        this.rate = rate;
    }

    public double getSumHT() {
        return this.sumHT;
    }

    public void setSumHT(double sumHT) {
        this.sumHT = sumHT;
    }

    public double getSumTTC() {
        return this.sumTTC;
    }

    public void setSumTTC(double sumTTC) {
        this.sumTTC = sumTTC;
    }

    public static SerializerRead getSerializerRead() {
        return new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                return new TaxLineInfo(dr.getString(1), dr.getDouble(2));
            }
        };
    }

    public String toString() {
        return "TaxLineInfo{id='" + this.id + "', name='" + this.name + "', amount=" + this.amount + ", rate=" + this.rate + ", sumHT=" + this.sumHT + ", sumTTC=" + this.sumTTC + "}";
    }

    public boolean isTaxe_global() {
        return this.taxe_global;
    }

    public void setTaxe_global(boolean taxe_global) {
        this.taxe_global = taxe_global;
    }
}

