/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.ticket;

import com.openbravo.basic.BasicException;
import com.openbravo.data.loader.IKeyed;
import com.openbravo.data.loader.SerializerRead;
import com.openbravo.pos.ticket.ScreenSupplementInfo;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.util.LogToFile;
import com.procaisse.db.metadata.DataRead;
import fr.protactile.procaisse.dao.entities.AllergeneSupplement;
import fr.protactile.procaisse.dao.entities.MultiLanguageSupplement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SupplementInfo
implements IKeyed,
Cloneable {
    private static final long serialVersionUID = 8612449444103L;
    private int importedID;
    private int iD;
    private String name;
    private Boolean has_options;
    private int min_options;
    private int max_options;
    private Boolean is_ingredient;
    private Boolean isBold;
    private int orderSupplement;
    private String color;
    private int number_click;
    private String path;
    private boolean order_name;
    private boolean multiple_category;
    private List<SupplementItemInfo> items;
    private boolean removed;
    private boolean display_free;
    private boolean prepared;
    private int printer;
    private int shift_option;
    private boolean display_screen_sorti;
    private List<ScreenSupplementInfo> screens;
    private boolean hidden_borne;
    private String ref_web;
    private boolean removed_by_admin;
    private boolean no_printable;
    private boolean hidden_ubereat;
    private boolean supplement_ubereat;
    private boolean hidden_online;
    private boolean print_black_background;
    private String id_global;
    private Date dateStartDisplay;
    private Date dateEndDisplay;
    private List<MultiLanguageSupplement> multiLanguageTexts;
    private List<AllergeneSupplement> Allergenes;
    private boolean sold_out;

    public SupplementInfo(int iD, String name, Boolean has_options, int min_options, int max_options, Boolean is_ingredient, Boolean isBold, String color, int number_click, String path, boolean order_name, boolean multiple_category, boolean removed, int order_supplement, boolean display_free) {
        this.iD = iD;
        this.name = name;
        this.has_options = has_options;
        this.min_options = min_options;
        this.max_options = max_options;
        this.is_ingredient = is_ingredient;
        this.isBold = isBold;
        this.color = color;
        this.number_click = number_click;
        this.path = path;
        this.order_name = order_name;
        this.multiple_category = multiple_category;
        this.removed = removed;
        this.orderSupplement = order_supplement;
        this.display_free = display_free;
        this.items = new ArrayList<SupplementItemInfo>();
        this.screens = new ArrayList<ScreenSupplementInfo>();
        this.multiLanguageTexts = new ArrayList<MultiLanguageSupplement>();
        this.Allergenes = new ArrayList<AllergeneSupplement>();
    }

    public SupplementInfo(int iD, String name, Boolean has_options, int min_options, int max_options, Boolean is_ingredient, List<SupplementItemInfo> items) {
        this.iD = iD;
        this.name = name;
        this.has_options = has_options;
        this.min_options = min_options;
        this.max_options = max_options;
        this.is_ingredient = is_ingredient;
        this.items = items;
        this.screens = new ArrayList<ScreenSupplementInfo>();
        this.multiLanguageTexts = new ArrayList<MultiLanguageSupplement>();
        this.Allergenes = new ArrayList<AllergeneSupplement>();
    }

    public SupplementInfo(int iD, String name, Boolean has_options, int min_options, int max_options, Boolean is_ingredient, int orderSupplement, String color, int number_click, boolean multiple_category, List<SupplementItemInfo> items, boolean removed) {
        this.iD = iD;
        this.name = name;
        this.has_options = has_options;
        this.min_options = min_options;
        this.max_options = max_options;
        this.is_ingredient = is_ingredient;
        this.orderSupplement = orderSupplement;
        this.color = color;
        this.number_click = number_click;
        this.multiple_category = multiple_category;
        this.items = items;
        this.removed = removed;
        this.screens = new ArrayList<ScreenSupplementInfo>();
        this.multiLanguageTexts = new ArrayList<MultiLanguageSupplement>();
        this.Allergenes = new ArrayList<AllergeneSupplement>();
    }

    public SupplementInfo() {
        this.items = new ArrayList<SupplementItemInfo>();
        this.screens = new ArrayList<ScreenSupplementInfo>();
        this.multiLanguageTexts = new ArrayList<MultiLanguageSupplement>();
        this.Allergenes = new ArrayList<AllergeneSupplement>();
    }

    public SupplementInfo(String supplementLine) {
        String[] columns = supplementLine.replace(",null,", ",,").replace("null,", ",").replace(",null", ",").split(",");
        this.importedID = Integer.valueOf(columns[0]);
        this.name = columns[1];
        this.has_options = Boolean.valueOf(columns[2]);
        this.min_options = Integer.valueOf(columns[3]);
        this.max_options = Integer.valueOf(columns[4]);
        this.is_ingredient = Boolean.valueOf(columns[5]);
        this.isBold = Boolean.valueOf(columns[6]);
        this.orderSupplement = Integer.valueOf(columns[7]);
        this.color = !columns[8].isEmpty() ? com.openbravo.pos.util.StringUtils.hex2Rgb(columns[8]) : null;
        this.number_click = Integer.valueOf(columns[9]);
        this.path = columns[10].isEmpty() ? null : columns[10];
        this.order_name = Boolean.valueOf(columns[11]);
        this.items = new ArrayList<SupplementItemInfo>();
        this.screens = new ArrayList<ScreenSupplementInfo>();
        this.multiLanguageTexts = new ArrayList<MultiLanguageSupplement>();
        this.Allergenes = new ArrayList<AllergeneSupplement>();
    }

    public Boolean getIsBold() {
        return this.isBold;
    }

    public void setIsBold(Boolean isBold) {
        this.isBold = isBold;
    }

    @Override
    public Object getKey() {
        return this.iD;
    }

    public int getiD() {
        return this.iD;
    }

    public void setiD(int iD) {
        this.iD = iD;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getHas_options() {
        return this.has_options;
    }

    public void setHas_options(Boolean has_options) {
        this.has_options = has_options;
    }

    public int getMin_options() {
        return this.min_options;
    }

    public void setMin_options(int min_options) {
        this.min_options = min_options;
    }

    public int getMax_options() {
        return this.max_options;
    }

    public void setMax_options(int max_options) {
        this.max_options = max_options;
    }

    public Boolean getIs_ingredient() {
        return this.is_ingredient;
    }

    public void setIs_ingredient(Boolean is_ingredient) {
        this.is_ingredient = is_ingredient;
    }

    public int getOrderSupplement() {
        return this.orderSupplement;
    }

    public void setOrderSupplement(int orderSupplement) {
        this.orderSupplement = orderSupplement;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public int getNumber_click() {
        return this.number_click;
    }

    public void setNumber_click(int number_click) {
        this.number_click = number_click;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isOrder_name() {
        return this.order_name;
    }

    public void setOrder_name(boolean order_name) {
        this.order_name = order_name;
    }

    public boolean isMultiple_category() {
        return this.multiple_category;
    }

    public void setMultiple_category(boolean multiple_category) {
        this.multiple_category = multiple_category;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    public boolean isDisplay_free() {
        return this.display_free;
    }

    public void setDisplay_free(boolean display_free) {
        this.display_free = display_free;
    }

    public boolean isPrepared() {
        return this.prepared;
    }

    public void setPrepared(boolean prepared) {
        this.prepared = prepared;
    }

    public int getPrinter() {
        return this.printer;
    }

    public void setPrinter(int printer) {
        this.printer = printer;
    }

    public int getShift_option() {
        return this.shift_option;
    }

    public void setShift_option(int shift_option) {
        this.shift_option = shift_option;
    }

    public String toString() {
        return this.name;
    }

    public String getEntetOfCSV() {
        return "ID, name, has_options, min_options, max_options, is_ingredient, isBold, orderSupplement, color, number_click, path, order_name";
    }

    public String getSupplementAsString() {
        return this.iD + "," + this.name + "," + this.has_options + "," + this.min_options + "," + this.max_options + "," + this.is_ingredient + ", " + this.isBold + "," + this.orderSupplement + "," + (this.color == null ? null : (this.color.startsWith("#") ? this.color : com.openbravo.pos.util.StringUtils.rGB2Hex(this.color))) + "," + this.number_click + "," + (this.path == null ? "" : this.path) + "," + this.order_name;
    }

    public static SerializerRead getSerializerRead() {
        return new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                SupplementInfo supplementInfo = new SupplementInfo();
                supplementInfo.iD = dr.getInt(1);
                supplementInfo.name = dr.getString(2);
                supplementInfo.has_options = dr.getBoolean(3);
                supplementInfo.min_options = dr.getInt(4);
                supplementInfo.max_options = dr.getInt(5);
                supplementInfo.is_ingredient = dr.getBoolean(6);
                supplementInfo.isBold = dr.getBoolean(7);
                supplementInfo.color = dr.getString(8);
                supplementInfo.number_click = dr.getInt(9);
                supplementInfo.path = dr.getString(10);
                supplementInfo.order_name = dr.getBoolean(11);
                supplementInfo.multiple_category = dr.getBoolean(12);
                supplementInfo.removed = dr.getBoolean(13);
                supplementInfo.orderSupplement = dr.getInt(14);
                supplementInfo.display_free = dr.getBoolean(15);
                supplementInfo.prepared = dr.getBoolean(16);
                supplementInfo.printer = dr.getInt(17);
                supplementInfo.shift_option = dr.getInt(18);
                supplementInfo.display_screen_sorti = dr.getBoolean(19);
                supplementInfo.hidden_borne = dr.getBoolean(20);
                supplementInfo.ref_web = dr.getString(21);
                supplementInfo.removed_by_admin = dr.getBoolean(22);
                supplementInfo.no_printable = dr.getBoolean(23);
                supplementInfo.hidden_ubereat = dr.getBoolean(24);
                supplementInfo.hidden_online = dr.getBoolean(25);
                supplementInfo.supplement_ubereat = dr.getBoolean(26);
                supplementInfo.print_black_background = dr.getBoolean(27);
                supplementInfo.id_global = dr.getString(28);
                supplementInfo.dateStartDisplay = dr.getTimestamp(29);
                supplementInfo.dateEndDisplay = dr.getTimestamp(30);
                supplementInfo.name = supplementInfo.name != null && !supplementInfo.name.isEmpty() ? StringUtils.capitalize((String)supplementInfo.name.toLowerCase()) : supplementInfo.name;
                return supplementInfo;
            }
        };
    }

    public int getImportedID() {
        return this.importedID;
    }

    public void setImportedID(int importedID) {
        this.importedID = importedID;
    }

    public List<SupplementItemInfo> getItems() {
        return this.items;
    }

    public void setItems(List<SupplementItemInfo> items) {
        this.items = items;
    }

    public boolean isDisplay_screen_sorti() {
        return this.display_screen_sorti;
    }

    public void setDisplay_screen_sorti(boolean display_screen_sorti) {
        this.display_screen_sorti = display_screen_sorti;
    }

    public List<ScreenSupplementInfo> getScreens() {
        return this.screens;
    }

    public void setScreens(List<ScreenSupplementInfo> screens) {
        this.screens = screens;
    }

    public boolean isHidden_borne() {
        return this.hidden_borne;
    }

    public void setHidden_borne(boolean hidden_borne) {
        this.hidden_borne = hidden_borne;
    }

    public String getRef_web() {
        return this.ref_web;
    }

    public void setRef_web(String ref_web) {
        this.ref_web = ref_web;
    }

    public boolean isRemoved_by_admin() {
        return this.removed_by_admin;
    }

    public void setRemoved_by_admin(boolean removed_by_admin) {
        this.removed_by_admin = removed_by_admin;
    }

    public boolean isNo_printable() {
        return this.no_printable;
    }

    public void setNo_printable(boolean no_printable) {
        this.no_printable = no_printable;
    }

    public boolean isHidden_ubereat() {
        return this.hidden_ubereat;
    }

    public void setHidden_ubereat(boolean hidden_ubereat) {
        this.hidden_ubereat = hidden_ubereat;
    }

    public boolean isSupplement_ubereat() {
        return this.supplement_ubereat;
    }

    public void setSupplement_ubereat(boolean supplement_ubereat) {
        this.supplement_ubereat = supplement_ubereat;
    }

    public boolean isHidden_online() {
        return this.hidden_online;
    }

    public void setHidden_online(boolean hidden_online) {
        this.hidden_online = hidden_online;
    }

    public boolean isPrint_black_background() {
        return this.print_black_background;
    }

    public void setPrint_black_background(boolean print_black_background) {
        this.print_black_background = print_black_background;
    }

    public String getId_global() {
        return this.id_global;
    }

    public void setId_global(String id_global) {
        this.id_global = id_global;
    }

    public Date getDateStartDisplay() {
        return this.dateStartDisplay;
    }

    public void setDateStartDisplay(Date dateStartDisplay) {
        this.dateStartDisplay = dateStartDisplay;
    }

    public Date getDateEndDisplay() {
        return this.dateEndDisplay;
    }

    public void setDateEndDisplay(Date dateEndDisplay) {
        this.dateEndDisplay = dateEndDisplay;
    }

    public List<MultiLanguageSupplement> getMultiLanguageTexts() {
        return this.multiLanguageTexts;
    }

    public void setMultiLanguageTexts(List<MultiLanguageSupplement> multiLanguageTexts) {
        this.multiLanguageTexts = multiLanguageTexts;
    }

    public String getNameByLanguage(String code_language) {
        String nameByLanguage = "";
        if (this.multiLanguageTexts != null && this.multiLanguageTexts.size() > 0 && code_language != null && !code_language.isEmpty()) {
            for (MultiLanguageSupplement multiLanguageText : this.multiLanguageTexts) {
                if (!code_language.equalsIgnoreCase(multiLanguageText.getLanguage())) continue;
                nameByLanguage = multiLanguageText.getName();
                break;
            }
        }
        if (nameByLanguage == null || nameByLanguage.isEmpty()) {
            nameByLanguage = this.name;
        }
        return nameByLanguage;
    }

    public Object clone() {
        try {
            int i;
            SupplementInfo o = null;
            o = (SupplementInfo)super.clone();
            if (this.items != null) {
                o.items = new ArrayList<SupplementItemInfo>();
                for (i = 0; i < this.items.size(); ++i) {
                    o.items.add((SupplementItemInfo)this.items.get(i).clone());
                }
            } else {
                o.items = null;
            }
            if (this.screens != null) {
                o.screens = new ArrayList<ScreenSupplementInfo>();
                for (i = 0; i < this.items.size(); ++i) {
                    o.screens.add((ScreenSupplementInfo)this.screens.get(i).clone());
                }
            } else {
                o.screens = null;
            }
            if (this.multiLanguageTexts != null) {
                o.multiLanguageTexts = new ArrayList<MultiLanguageSupplement>();
                for (i = 0; i < this.multiLanguageTexts.size(); ++i) {
                    o.multiLanguageTexts.add((MultiLanguageSupplement)this.multiLanguageTexts.get(i).clone());
                }
            } else {
                o.multiLanguageTexts = null;
            }
            if (this.Allergenes != null) {
                o.Allergenes = new ArrayList<AllergeneSupplement>();
                for (i = 0; i < this.Allergenes.size(); ++i) {
                    o.Allergenes.add((AllergeneSupplement)this.Allergenes.get(i).clone());
                }
            } else {
                o.Allergenes = null;
            }
            return o;
        }
        catch (CloneNotSupportedException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            return null;
        }
    }

    public List<AllergeneSupplement> getAllergenes() {
        return this.Allergenes;
    }

    public void setAllergenes(List<AllergeneSupplement> Allergenes) {
        this.Allergenes = Allergenes;
    }

    public boolean isSold_out() {
        return this.sold_out;
    }

    public void setSold_out(boolean sold_out) {
        this.sold_out = sold_out;
    }
}

