/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.ticket;

import com.openbravo.data.loader.SerializerRead;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.ProductInfoExt;
import fr.protactile.procaisse.dao.entities.MultiLanguagePromotion;
import java.util.ArrayList;
import java.util.List;

public class PromotionInfo
implements Cloneable {
    private int id;
    private String name_promotion;
    private String type_order;
    private String size_product;
    private double quantity;
    private double discount;
    private boolean removed;
    private boolean removed_by_admin;
    private String ref_synchro;
    private String label_size_product;
    private String label_discount;
    private String id_global;
    private List<ProductInfoExt> products;
    private String description;
    private String text_promo;
    private List<MultiLanguagePromotion> multiLanguageTexts;

    public PromotionInfo() {
        this.products = new ArrayList<ProductInfoExt>();
        this.multiLanguageTexts = new ArrayList<MultiLanguagePromotion>();
    }

    public PromotionInfo(int id) {
        this.id = id;
        this.products = new ArrayList<ProductInfoExt>();
        this.multiLanguageTexts = new ArrayList<MultiLanguagePromotion>();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName_promotion() {
        return this.name_promotion;
    }

    public void setName_promotion(String name_promotion) {
        this.name_promotion = name_promotion;
    }

    public String getType_order() {
        return this.type_order;
    }

    public void setType_order(String type_order) {
        this.type_order = type_order;
    }

    public String getSize_product() {
        return this.size_product;
    }

    public void setSize_product(String size_product) {
        this.size_product = size_product;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    public double getDiscount() {
        return this.discount;
    }

    public void setDiscount(double discount) {
        this.discount = discount;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    public boolean isRemoved_by_admin() {
        return this.removed_by_admin;
    }

    public void setRemoved_by_admin(boolean removed_by_admin) {
        this.removed_by_admin = removed_by_admin;
    }

    public String getRef_synchro() {
        return this.ref_synchro;
    }

    public void setRef_synchro(String ref_synchro) {
        this.ref_synchro = ref_synchro;
    }

    public String getLabel_size_product() {
        return this.label_size_product;
    }

    public void setLabel_size_product(String label_size_product) {
        this.label_size_product = label_size_product;
    }

    public String getLabel_discount() {
        return this.label_discount;
    }

    public void setLabel_discount(String label_discount) {
        this.label_discount = label_discount;
    }

    public static SerializerRead getSerializerRead() {
        return dr -> {
            PromotionInfo mPromotionInfo = new PromotionInfo();
            mPromotionInfo.id = dr.getInt(1);
            mPromotionInfo.name_promotion = dr.getString(2);
            mPromotionInfo.type_order = dr.getString(3);
            mPromotionInfo.size_product = dr.getString(4);
            mPromotionInfo.quantity = dr.getDouble(5);
            mPromotionInfo.discount = dr.getDouble(6);
            mPromotionInfo.removed = dr.getBoolean(7);
            mPromotionInfo.removed_by_admin = dr.getBoolean(8);
            mPromotionInfo.ref_synchro = dr.getString(9);
            mPromotionInfo.label_size_product = dr.getString(10);
            mPromotionInfo.label_discount = dr.getString(11);
            mPromotionInfo.description = dr.getString(12);
            mPromotionInfo.text_promo = dr.getString(13);
            mPromotionInfo.id_global = dr.getString(14);
            return mPromotionInfo;
        };
    }

    public Object clone() {
        PromotionInfo o = null;
        try {
            o = (PromotionInfo)super.clone();
            if (this.multiLanguageTexts != null) {
                o.multiLanguageTexts = new ArrayList<MultiLanguagePromotion>();
                for (int i = 0; i < this.multiLanguageTexts.size(); ++i) {
                    o.multiLanguageTexts.add((MultiLanguagePromotion)this.multiLanguageTexts.get(i).clone());
                }
            } else {
                o.multiLanguageTexts = null;
            }
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
            cnse.printStackTrace(System.err);
        }
        return o;
    }

    public String toString() {
        return this.name_promotion;
    }

    public String getId_global() {
        return this.id_global;
    }

    public void setId_global(String id_global) {
        this.id_global = id_global;
    }

    public List<ProductInfoExt> getProducts() {
        return this.products;
    }

    public void setProducts(List<ProductInfoExt> products) {
        this.products = products;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLabelPromotion() {
        String label_promotion = "";
        switch ((int)this.discount) {
            case 10: {
                label_promotion = "-10 %";
                break;
            }
            case 20: {
                label_promotion = "-20 %";
                break;
            }
            case 50: {
                label_promotion = "-50 %";
                break;
            }
            case 100: {
                label_promotion = "OFFERT";
            }
        }
        return label_promotion;
    }

    public String getText_promo() {
        return this.text_promo != null && !this.text_promo.isEmpty() ? this.text_promo : "PROMO";
    }

    public void setText_promo(String text_promo) {
        this.text_promo = text_promo;
    }

    public List<MultiLanguagePromotion> getMultiLanguageTexts() {
        return this.multiLanguageTexts;
    }

    public void setMultiLanguageTexts(List<MultiLanguagePromotion> multiLanguageTexts) {
        this.multiLanguageTexts = multiLanguageTexts;
    }

    public String getDisplayedName() {
        return this.getNameByLanguage(AppLocal.APP_LANGUAGE);
    }

    public String getDisplayedDescription() {
        return this.getDescriptionByLanguage(AppLocal.APP_LANGUAGE);
    }

    public String getDisplayedText() {
        return this.getTextPromoByLanguage(AppLocal.APP_LANGUAGE);
    }

    public String getNameByLanguage(String code_language) {
        String nameByLanguage = "";
        if (this.multiLanguageTexts != null && this.multiLanguageTexts.size() > 0 && code_language != null && !code_language.isEmpty()) {
            for (MultiLanguagePromotion multiLanguageText : this.multiLanguageTexts) {
                if (!code_language.equalsIgnoreCase(multiLanguageText.getLanguage())) continue;
                nameByLanguage = multiLanguageText.getName();
                break;
            }
        }
        if (nameByLanguage == null || nameByLanguage.isEmpty()) {
            nameByLanguage = this.name_promotion;
        }
        return nameByLanguage;
    }

    public String getDescriptionByLanguage(String code_language) {
        String descriptionByLanguage = "";
        if (this.multiLanguageTexts != null && this.multiLanguageTexts.size() > 0 && code_language != null && !code_language.isEmpty()) {
            for (MultiLanguagePromotion multiLanguageText : this.multiLanguageTexts) {
                if (!code_language.equalsIgnoreCase(multiLanguageText.getLanguage())) continue;
                descriptionByLanguage = multiLanguageText.getDescription();
                break;
            }
        }
        if (descriptionByLanguage == null || descriptionByLanguage.isEmpty()) {
            descriptionByLanguage = this.description;
        }
        return descriptionByLanguage;
    }

    public String getTextPromoByLanguage(String code_language) {
        String textByLanguage = "";
        if (this.multiLanguageTexts != null && this.multiLanguageTexts.size() > 0 && code_language != null && !code_language.isEmpty()) {
            for (MultiLanguagePromotion multiLanguageText : this.multiLanguageTexts) {
                if (!code_language.equalsIgnoreCase(multiLanguageText.getLanguage())) continue;
                textByLanguage = multiLanguageText.getText_promo();
                break;
            }
        }
        if (textByLanguage == null || textByLanguage.isEmpty()) {
            textByLanguage = this.text_promo;
        }
        return textByLanguage;
    }
}

