/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.ticket;

import com.openbravo.basic.BasicException;
import com.openbravo.data.loader.SerializerRead;
import com.openbravo.format.Formats;
import com.openbravo.pos.ticket.ItemOrderInfo;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.SupplementProduct;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.LogToFile;
import com.procaisse.db.metadata.DataRead;
import fr.protactile.procaisse.dao.entities.MultiLanguageProduct;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.image.Image;

public class ProductTicket
implements Serializable,
Cloneable {
    private int id;
    private int idCarte;
    private String nameCarte;
    private int idProduct;
    private String nameProduct;
    private int numberProduct;
    private double priceProduct;
    private int printerID;
    private int printerLabel;
    private int index_carte;
    private String ref_web_item;
    private String ref_web_carte;
    private String path;
    private int id_item_kitchen;
    private int id_shared_item;
    private boolean printSeparatedLabel;
    private String sizeProduct;
    private String comment;
    private String id_global_product;
    private String id_global_carte;
    private String displayedName;
    private List<MultiLanguageProduct> multiLanguageTexts;
    private Image imageProduct;
    private List<SupplementProduct> options;
    private List<ItemOrderInfo> ingredients;
    private List<OptionItemOrder> supplements;
    private int idZone;
    private String nameZone;
    private String time_served;
    private TicketLineInfo ticketLineInfo;

    public ProductTicket() {
    }

    public ProductTicket(ProductInfoExt subProduct, int idCarte, String nameCarte, int numberProduct, int index_carte, String sizeProduct, String ref_web_item, String ref_web_carte, String id_global_carte) {
        this.idProduct = subProduct.getID();
        this.nameProduct = subProduct.getName();
        this.priceProduct = subProduct.getPriceSell();
        this.printerID = subProduct.getPrinterID();
        this.printerLabel = subProduct.getPrinterLabel();
        this.idCarte = idCarte;
        this.nameCarte = nameCarte;
        this.numberProduct = numberProduct;
        this.index_carte = index_carte;
        this.sizeProduct = sizeProduct;
        this.ref_web_item = ref_web_item;
        this.ref_web_carte = ref_web_carte;
        this.id_global_product = subProduct.getId_global();
        this.id_global_carte = id_global_carte;
        this.displayedName = subProduct.getDisplayedName();
        this.path = subProduct.getImageProduct();
        this.multiLanguageTexts = this.multiLanguageTexts;
        this.idZone = subProduct.getZoneId() != null ? subProduct.getZoneId() : 0;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getIdCarte() {
        return this.idCarte;
    }

    public void setIdCarte(int idCarte) {
        this.idCarte = idCarte;
    }

    public String getNameCarte() {
        return this.nameCarte;
    }

    public void setNameCarte(String nameCarte) {
        this.nameCarte = nameCarte;
    }

    public int getIdProduct() {
        return this.idProduct;
    }

    public void setIdProduct(int idProduct) {
        this.idProduct = idProduct;
    }

    public String getNameProduct() {
        return this.nameProduct;
    }

    public void setNameProduct(String nameProduct) {
        this.nameProduct = nameProduct;
    }

    public int getNumberProduct() {
        return this.numberProduct;
    }

    public void setNumberProduct(int numberProduct) {
        this.numberProduct = numberProduct;
    }

    public double getPriceProduct() {
        return this.priceProduct;
    }

    public void setPriceProduct(double priceProduct) {
        this.priceProduct = priceProduct;
    }

    public int getPrinterID() {
        return this.printerID;
    }

    public void setPrinterID(int printerID) {
        this.printerID = printerID;
    }

    public int getIndex_carte() {
        return this.index_carte;
    }

    public void setIndex_carte(int index_carte) {
        this.index_carte = index_carte;
    }

    public String getRef_web_item() {
        return this.ref_web_item;
    }

    public void setRef_web_item(String ref_web_item) {
        this.ref_web_item = ref_web_item;
    }

    public String getRef_web_carte() {
        return this.ref_web_carte;
    }

    public void setRef_web_carte(String ref_web_carte) {
        this.ref_web_carte = ref_web_carte;
    }

    public int getPrinterLabel() {
        return this.printerLabel;
    }

    public void setPrinterLabel(int printerLabel) {
        this.printerLabel = printerLabel;
    }

    public static SerializerRead getSerializerRead() {
        return new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                ProductTicket productOrder = new ProductTicket();
                productOrder.id = dr.getInt(1);
                productOrder.idCarte = dr.getInt(2);
                productOrder.nameCarte = dr.getString(3);
                productOrder.idProduct = dr.getInt(4);
                productOrder.nameProduct = dr.getString(5);
                productOrder.numberProduct = dr.getInt(6);
                productOrder.priceProduct = dr.getDouble(7);
                productOrder.printerID = dr.getInt(8);
                productOrder.index_carte = dr.getInt(9);
                productOrder.printerLabel = dr.getInt(10);
                productOrder.id_item_kitchen = dr.getInt(11);
                productOrder.sizeProduct = dr.getString(12);
                productOrder.comment = dr.getString(13);
                productOrder.idZone = dr.getInt(14);
                return productOrder;
            }
        };
    }

    public String printPrice() {
        if (this.priceProduct > 0.0) {
            return Formats.CURRENCY.formatValue(this.priceProduct);
        }
        return "";
    }

    public TicketLineInfo getTicketLineInfo() {
        return this.ticketLineInfo;
    }

    public void setTicketLineInfo(TicketLineInfo ticketLineInfo) {
        this.ticketLineInfo = ticketLineInfo;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getIDItem() {
        StringBuilder id_item = new StringBuilder();
        id_item.append(String.valueOf(this.idProduct));
        id_item.append(String.valueOf(this.index_carte));
        return id_item.toString();
    }

    public Object clone() {
        try {
            ProductTicket o = null;
            o = (ProductTicket)super.clone();
            if (this.multiLanguageTexts != null) {
                o.multiLanguageTexts = new ArrayList<MultiLanguageProduct>();
                for (int i = 0; i < this.multiLanguageTexts.size(); ++i) {
                    o.multiLanguageTexts.add((MultiLanguageProduct)this.multiLanguageTexts.get(i).clone());
                }
            } else {
                o.multiLanguageTexts = null;
            }
            return o;
        }
        catch (CloneNotSupportedException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            return null;
        }
    }

    public int getId_item_kitchen() {
        return this.id_item_kitchen;
    }

    public void setId_item_kitchen(int id_item_kitchen) {
        this.id_item_kitchen = id_item_kitchen;
    }

    public int getId_shared_item() {
        return this.id_shared_item;
    }

    public void setId_shared_item(int id_shared_item) {
        this.id_shared_item = id_shared_item;
    }

    public boolean isPrintSeparatedLabel() {
        return this.printSeparatedLabel;
    }

    public void setPrintSeparatedLabel(boolean printSeparatedLabel) {
        this.printSeparatedLabel = printSeparatedLabel;
    }

    public String toString() {
        return "ProductTicket{id=" + this.id + ", idCarte=" + this.idCarte + ", nameCarte=" + this.nameCarte + ", idProduct=" + this.idProduct + ", nameProduct=" + this.nameProduct + ", numberProduct=" + this.numberProduct + ", priceProduct=" + this.priceProduct + ", printerID=" + this.printerID + ", printerLabel=" + this.printerLabel + ", index_carte=" + this.index_carte + ", ref_web_item=" + this.ref_web_item + ", ref_web_carte=" + this.ref_web_carte + ", path=" + this.path + ", id_item_kitchen=" + this.id_item_kitchen + ", id_shared_item=" + this.id_shared_item + ", printSeparatedLabel=" + this.printSeparatedLabel + "}";
    }

    public String getSizeProduct() {
        return this.sizeProduct;
    }

    public void setSizeProduct(String sizeProduct) {
        this.sizeProduct = sizeProduct;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getId_global_product() {
        return this.id_global_product;
    }

    public void setId_global_product(String id_global_product) {
        this.id_global_product = id_global_product;
    }

    public String getId_global_carte() {
        return this.id_global_carte;
    }

    public void setId_global_carte(String id_global_carte) {
        this.id_global_carte = id_global_carte;
    }

    public String getDisplayedName() {
        return this.displayedName;
    }

    public void setDisplayedName(String displayedName) {
        this.displayedName = displayedName;
    }

    public List<MultiLanguageProduct> getMultiLanguageTexts() {
        return this.multiLanguageTexts;
    }

    public List<ItemOrderInfo> getIngredients() {
        return this.ingredients;
    }

    public void setIngredients(List<ItemOrderInfo> ingredients) {
        this.ingredients = ingredients;
    }

    public List<OptionItemOrder> getSupplements() {
        return this.supplements;
    }

    public void setSupplements(List<OptionItemOrder> supplements) {
        this.supplements = supplements;
    }

    public void setMultiLanguageTexts(List<MultiLanguageProduct> multiLanguageTexts) {
        this.multiLanguageTexts = multiLanguageTexts;
    }

    public String getNameByLanguage(String code_language) {
        String nameByLanguage = "";
        if (this.multiLanguageTexts != null && this.multiLanguageTexts.size() > 0 && code_language != null && !code_language.isEmpty()) {
            for (MultiLanguageProduct multiLanguageText : this.multiLanguageTexts) {
                if (!code_language.equalsIgnoreCase(multiLanguageText.getLanguage())) continue;
                nameByLanguage = multiLanguageText.getName();
                break;
            }
        }
        return nameByLanguage;
    }

    public Image getImageProduct() {
        return this.imageProduct;
    }

    public void setImageProduct(Image imageProduct) {
        this.imageProduct = imageProduct;
    }

    public List<SupplementProduct> getOptions() {
        return this.options;
    }

    public void setOptions(List<SupplementProduct> options) {
        this.options = options;
    }

    public int getIdZone() {
        return this.idZone;
    }

    public void setIdZone(int idZone) {
        this.idZone = idZone;
    }

    public String getNameZone() {
        return this.nameZone;
    }

    public void setNameZone(String nameZone) {
        this.nameZone = nameZone;
    }

    public String getTime_served() {
        return this.time_served;
    }

    public void setTime_served(String time_served) {
        this.time_served = time_served;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProductTicket other = (ProductTicket)obj;
        if (this.idCarte != other.idCarte) {
            return false;
        }
        if (this.idProduct != other.idProduct) {
            return false;
        }
        return this.numberProduct == other.numberProduct;
    }
}

