/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.ticket;

import com.openbravo.pos.ticket.ItemOrderInfo;
import java.util.List;

public class ProductResult {
    private int id;
    private String name;
    private double quantity;
    private int orderCategory;
    private int orderProduct;
    private List<ItemOrderInfo> ingredients;
    private String sizeProduct;
    private int id_zone;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    public int getOrderCategory() {
        return this.orderCategory;
    }

    public void setOrderCategory(int orderCategory) {
        this.orderCategory = orderCategory;
    }

    public int getId_zone() {
        return this.id_zone;
    }

    public void setId_zone(int id_zone) {
        this.id_zone = id_zone;
    }

    public ProductResult(int id, String name, double quantity, int orderCategory, List<ItemOrderInfo> ingredients, String sizeProduct, int orderProduct, int id_zone) {
        this.id = id;
        this.name = name;
        this.quantity = quantity;
        this.orderCategory = orderCategory;
        this.orderProduct = orderProduct;
        this.ingredients = ingredients;
        this.sizeProduct = sizeProduct;
        this.id_zone = id_zone;
    }

    public List<ItemOrderInfo> getIngredients() {
        return this.ingredients;
    }

    public void setIngredients(List<ItemOrderInfo> ingredients) {
        this.ingredients = ingredients;
    }

    public String getNameIngredients() {
        if (this.ingredients != null && !this.ingredients.isEmpty()) {
            StringBuilder nameIngredientsBuilder = new StringBuilder();
            nameIngredientsBuilder.append("(");
            boolean firstIngredient = true;
            for (ItemOrderInfo ingredient : this.ingredients) {
                if (!firstIngredient) {
                    nameIngredientsBuilder.append(", ");
                }
                firstIngredient = false;
                nameIngredientsBuilder.append("sans ");
                nameIngredientsBuilder.append(ingredient.printName(true));
            }
            nameIngredientsBuilder.append(")");
            return nameIngredientsBuilder.toString();
        }
        return "";
    }

    public String getSizeProduct() {
        return this.sizeProduct;
    }

    public void setSizeProduct(String sizeProduct) {
        this.sizeProduct = sizeProduct;
    }

    public String printName() {
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append(this.name);
        if (this.sizeProduct != null) {
            nameBuilder.append(" - ").append(this.sizeProduct);
        }
        return nameBuilder.toString();
    }

    public int getOrderProduct() {
        return this.orderProduct;
    }

    public void setOrderProduct(int orderProduct) {
        this.orderProduct = orderProduct;
    }

    public boolean checkIngredients(List<ItemOrderInfo> ingredientsToCheck) {
        return this.ingredients == null && ingredientsToCheck == null || this.ingredients.isEmpty() && ingredientsToCheck.isEmpty() || this.sameIngredients(this.ingredients, ingredientsToCheck);
    }

    private boolean sameIngredients(List<ItemOrderInfo> ingredients, List<ItemOrderInfo> ingredientsToCheck) {
        if (ingredients.size() == ingredientsToCheck.size()) {
            int sameIngredient = 0;
            for (ItemOrderInfo ingredient : ingredients) {
                for (ItemOrderInfo ingredientToCheck : ingredientsToCheck) {
                    if (ingredientToCheck.getSupplement() != ingredient.getSupplement()) continue;
                    ++sameIngredient;
                }
            }
            return sameIngredient == ingredients.size();
        }
        return false;
    }
}

