/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.ticket;

import com.openbravo.basic.BasicException;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.payment.PaymentInfo;
import com.openbravo.pos.ticket.ItemOrderInfo;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.ProductTicket;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.NumericUtils;
import fr.protactile.kitchen.dao.entities.Itemsticket;
import fr.protactile.kitchen.dao.entities.Optionsticket;
import fr.protactile.kitchen.dao.entities.Payments;
import fr.protactile.kitchen.dao.entities.Ticketlines;
import fr.protactile.kitchen.dao.entities.Tickets;
import java.util.ArrayList;
import java.util.Date;

public class OrderSharedBuilder {
    public static Tickets create(TicketInfo ticket, String source, String type_payment, boolean old_ticket) {
        boolean slave = AppLocal.modeCaisse != null && AppLocal.modelCaisse.equals("Esclave");
        boolean master = AppLocal.modeCaisse != null && AppLocal.modelCaisse.equals("Maitre");
        String id_user = ticket.getUser() != null ? ticket.getUser().getId() : null;
        String name_user = ticket.getUser() != null ? ticket.getUser().getName() : null;
        int id_order = ticket.getId_shared_order() != 0 && ticket.getId_shared_order() != -1 ? ticket.getId_shared_order() : -1;
        String host_name = AppLocal.source_order;
        Tickets order = new Tickets(id_order, ticket.getNumero_order(), NumericUtils.round(ticket.getTotal()), ticket.getType(), host_name, source, ticket.getNum_order_borne(), new Date(), null, id_user, ticket.getBipper(), ticket.getDiscount(), ticket.getTypeDiscount(), ticket.getNum_order_kitchen(), ticket.getId_order_kitchen(), type_payment, name_user, 0, 0);
        order.setNum_table(ticket.getNumTable());
        order.setCouvert(ticket.getCouverts());
        if (old_ticket) {
            order.setId_ticket_source(ticket.getIdSourceSharedOrder() != null && !ticket.getIdSourceSharedOrder().isEmpty() ? ticket.getIdSourceSharedOrder() : ticket.getId());
        } else {
            order.setId_ticket_source(ticket.getId());
        }
        order.setAddress_ip_borne(ticket.getAddress_ip_borne());
        if (type_payment != null && type_payment.equals("CB") && AppLocal.modeCaisse != null && AppLocal.modeCaisse.equals("Borne")) {
            order.setSaved(true);
            order.setPaid(true);
        } else {
            order.setSaved(ticket.isPaid());
            order.setPaid(ticket.isPaid());
        }
        order.setExterior_order(ticket.isShared_order());
        order.setLabel_discount(ticket.getLabel_discount());
        order.setEasel_number(ticket.getEasel_number());
        order.setOrder_id_base(ticket.getId());
        order.setKeenio_base(OrderSharedBuilder.getKeenio());
        if (AppLocal.CUSTOMER_LOYALTY && AppLocal.currentCustomerLoyalty != null) {
            order.setLicence_id_machine(AppLocal.CUSTOMER_LOYALTY_ID);
            order.setCustomer_name("");
            order.setCustomer_phone(AppLocal.currentCustomerLoyalty.getPhone());
            double total_point = 0.0;
            for (TicketLineInfo line : ticket.getLines()) {
                total_point += line.getPoints_loyalty() * line.getMultiply();
            }
            order.setValue_out_base(total_point);
            if (ticket.getTotal() > 0.0) {
                order.setValuse_in_base(ticket.getTotal());
            }
        }
        if (ticket.getCustomer() != null) {
            if (ticket.getCustomer().getName() != null && !ticket.getCustomer().getName().isEmpty()) {
                order.setCustomer_name(ticket.getCustomer().getName());
            } else {
                order.setCustomer_name("");
            }
            order.setCustomer_phone(ticket.getCustomer().getPhone());
        }
        if (ticket.getCustomer() == null && ticket.getName_customer() != null && !ticket.getName_customer().isEmpty()) {
            order.setCustomer_name(ticket.getName_customer());
        }
        ArrayList<Ticketlines> lines = new ArrayList<Ticketlines>();
        for (TicketLineInfo line : ticket.getLines()) {
            String ref_carte;
            String ref_item;
            String ref_product = slave ? (line.getRef_web() == null ? String.valueOf(line.getProductID()) : line.getRef_web()) : String.valueOf(line.getProductID());
            Ticketlines ticketLine = new Ticketlines(line.getId_source(), ref_product, line.getMultiply(), line.getPrice(), line.getValueDiscount(), line.getSizeProduct(), line.getName_sizeProduct(), line.getNote(), line.getLabelDiscount(), line.getPlace_served(), line.getTime_served(), line.isPromo_basket(), line.getId_line_kitchen());
            ticketLine.setPoints_loyalty(line.getPoints_loyalty());
            ticketLine.setId_line_source(line.getID());
            ticketLine.setType_discount(line.getType_discount());
            ticketLine.setAlias_size(line.getAlias_size());
            ticketLine.setPromo_product(line.isPromo_product());
            ticketLine.setId_global_product(line.getId_global_product());
            ArrayList<Optionsticket> options = new ArrayList<Optionsticket>();
            if (line.getListSupplements() != null) {
                for (OptionItemOrder option : line.getListSupplements()) {
                    String ref_option = slave ? (option.getRef_web() == null ? String.valueOf(option.getSupplement()) : option.getRef_web()) : String.valueOf(option.getSupplement());
                    ref_item = slave ? option.getRef_product() : String.valueOf(option.getIdProduct());
                    ref_carte = slave ? option.getRef_carte() : String.valueOf(option.getIdCarte());
                    Optionsticket optionTicket = new Optionsticket(option.getId_shared_supplement(), false, ref_option, option.getNumberOption(), option.getNumber_free(), option.getIdCarte(), option.getIdProduct(), option.getNameCarte(), option.getNameProduct(), option.getIndex_carte(), ref_item, ref_carte, option.getId_supplement_kitchen());
                    optionTicket.setId_global_supplement(option.getId_global_supplement());
                    optionTicket.setId_global_product(option.getId_global_product());
                    optionTicket.setId_global_carte(option.getId_global_carte());
                    optionTicket.setTime_served(option.getTime_served());
                    optionTicket.setId_global_parent_supplement(option.getParent_supplement_global_id());
                    options.add(optionTicket);
                }
            }
            if (line.getListIngredients() != null) {
                for (ItemOrderInfo ingredient : line.getListIngredients()) {
                    String ref_ingredient = slave ? (ingredient.getRef_web() == null ? String.valueOf(ingredient.getSupplement()) : ingredient.getRef_web()) : String.valueOf(ingredient.getSupplement());
                    ref_item = slave ? ingredient.getRef_product() : String.valueOf(ingredient.getIdProduct());
                    ref_carte = slave ? ingredient.getRef_carte() : String.valueOf(ingredient.getIdCarte());
                    Optionsticket ingredientTicket = new Optionsticket(ingredient.getId_shared_ingredient(), true, ref_ingredient, 1, 1, ingredient.getIdCarte(), ingredient.getIdProduct(), ingredient.getNameCarte(), ingredient.getNameProduct(), ingredient.getIndex_carte(), ref_item, ref_carte, ingredient.getId_ingredient_kitchen());
                    ingredientTicket.setId_global_supplement(ingredient.getId_global_supplement());
                    ingredientTicket.setId_global_product(ingredient.getId_global_product());
                    ingredientTicket.setId_global_carte(ingredient.getId_global_carte());
                    options.add(ingredientTicket);
                }
            }
            ticketLine.setOptionsticketCollection(options);
            ArrayList<Itemsticket> items = new ArrayList<Itemsticket>();
            if (line.getListProducts() != null) {
                for (ProductTicket product : line.getListProducts()) {
                    String ref_carte2;
                    String string = slave ? (product.getRef_web_carte() == null ? String.valueOf(product.getIdCarte()) : product.getRef_web_carte()) : (ref_carte2 = String.valueOf(product.getIdCarte()));
                    String ref_item2 = slave ? (product.getRef_web_item() == null ? String.valueOf(product.getIdProduct()) : product.getRef_web_item()) : String.valueOf(product.getIdProduct());
                    Itemsticket itemTicket = new Itemsticket(product.getId_shared_item(), ref_carte2, ref_item2, product.getNumberProduct(), product.getIndex_carte(), product.getId_item_kitchen());
                    itemTicket.setId_global_product(product.getId_global_product());
                    itemTicket.setId_global_carte(product.getId_global_carte());
                    items.add(itemTicket);
                }
            }
            ticketLine.setItemsticketCollection(items);
            lines.add(ticketLine);
        }
        order.setTicketlinesCollection(lines);
        return order;
    }

    public static Payments create(PaymentInfo paymentInfo) {
        return new Payments(NumericUtils.round(paymentInfo.getTotal()), paymentInfo.getName());
    }

    public static String getKeenio() {
        String keenio = null;
        if (AppLocal.dlItems != null) {
            try {
                keenio = AppLocal.dlItems.getUserKeenIo();
                if (keenio == null) {
                    keenio = "-";
                }
            }
            catch (BasicException ex) {
                LogToFile.log("severe", null, ex);
            }
        }
        return keenio;
    }
}

