/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.ticket;

import com.openbravo.basic.BasicException;
import com.openbravo.dao.DataLogicItems;
import com.openbravo.dao.DataLogicProduct;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.CategoryInfo;
import com.openbravo.pos.ticket.ItemIngredientInfo;
import com.openbravo.pos.ticket.ItemOrderInfo;
import com.openbravo.pos.ticket.MarqueNFC;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.ProductTicket;
import com.openbravo.pos.ticket.ScreenProduct;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.ColorUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.NumericUtils;
import fr.protactile.kitchen.dao.entities.Items;
import fr.protactile.kitchen.dao.entities.LinesOrder;
import fr.protactile.kitchen.dao.entities.Orders;
import fr.protactile.kitchen.dao.entities.ScreenItemNew;
import fr.protactile.kitchen.dao.entities.ScreenLineNew;
import fr.protactile.kitchen.dao.entities.ScreenNew;
import fr.protactile.kitchen.dao.entities.Supplements;
import fr.protactile.kitchen.dao.entities.TagLine;
import fr.protactile.procaisse.cache.CacheFinder;
import fr.protactile.procaisse.cache.SharedMemoryCache;
import fr.protactile.procaisse.dao.entities.TagInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class OrderKitchenBuilder {
    private DataLogicSales dlSales;
    private DataLogicProduct dlProduct;
    private List<ScreenNew> screens;
    private boolean setIdOrder;
    private TicketInfo ticket;
    private boolean after_restart;
    private Orders order;
    private int id_element = 1;
    private SharedMemoryCache mSharedMemoryCache = SharedMemoryCache.getInstance();
    private boolean slave = AppLocal.modeCaisse != null && AppLocal.modelCaisse.equals("Esclave");
    private final String UBER_EATS = "Uber Eats";
    private DataLogicItems dlItems;
    private MarqueNFC marqueNF = MarqueNFC.fetchOrStore(AppLocal.dlSales);
    private final String INSIDE = "inside";
    private final String MODE_CAISSE = "Caisse";
    private final String SOURCE_CAISSE = "caisse";
    private final String SOURCE_UBEREAT = "Uber Eats";
    private final String SOURCE_BORNE_CB = "borne cb";
    private final String SOURCE_BORNE = "borne";
    private final String SOURCE_ONLINE = "online";
    private final String SOURCE_WEB = "web";

    public OrderKitchenBuilder screens(List<ScreenNew> screens) {
        this.screens = screens;
        return this;
    }

    public OrderKitchenBuilder dlProduct(DataLogicProduct dlProduct) {
        this.dlProduct = dlProduct;
        return this;
    }

    public OrderKitchenBuilder dlSales(DataLogicSales dlSales) {
        this.dlSales = dlSales;
        return this;
    }

    public OrderKitchenBuilder ticket(TicketInfo ticket) {
        this.ticket = ticket;
        return this;
    }

    public OrderKitchenBuilder setIdOrder(boolean setIdOrder) {
        this.setIdOrder = setIdOrder;
        return this;
    }

    public OrderKitchenBuilder after_restart(boolean after_restart) {
        this.after_restart = after_restart;
        return this;
    }

    public OrderKitchenBuilder order(Orders order) {
        this.order = order;
        return this;
    }

    public OrderKitchenBuilder dlItems(DataLogicItems dlItems) {
        this.dlItems = dlItems;
        return this;
    }

    public OrderKitchenBuilder build() throws BasicException {
        this.order = new Orders(this.ticket.getId_order_kitchen());
        Date date_now = new Date();
        this.order.setNumberOrder(this.ticket.getNumero_order());
        this.order.setBipper(this.ticket.getBipper());
        this.order.setSource(this.ticket.getCaisse() != null ? this.ticket.getCaisse() : "");
        this.order.setType(this.ticket.getType());
        this.order.setStatus("pending");
        this.order.setCreated(date_now);
        this.order.setRecover_date(this.ticket.getRecover_date());
        this.order.setUpdatedAt(date_now);
        this.order.setAfterRestart(this.after_restart);
        if (this.setIdOrder) {
            this.order.setIdTicket(this.ticket.getId());
        }
        this.order.setDressageCooking(false);
        this.order.setPaid(this.ticket.isPaid());
        String num_order = this.ticket.getNumero_platform_order();
        this.order.setNumero_online_order(num_order);
        String name_customer = this.ticket.getName_customer() != null && !this.ticket.getName_customer().isEmpty() ? this.ticket.getName_customer() : (this.ticket.getCustomer() != null ? this.ticket.getCustomer().getName() : null);
        this.order.setName_customer(name_customer);
        this.order.setComment(this.ticket.getComment());
        this.order.setDelivery_date(this.ticket.getDelivered() != null ? this.ticket.getDelivered() : date_now);
        this.order.setPhone_customer(this.ticket.getCustomer() != null ? this.ticket.getCustomer().printPhone() : null);
        this.order.setUpdatable(true);
        this.order.setSent_from(this.getSourceOrder(this.ticket));
        if (this.dlItems != null) {
            String keenio = this.dlItems.getUserKeenIo();
            this.order.setKenio(keenio);
        }
        if (this.marqueNF != null && this.marqueNF.getSiret() != null && !this.marqueNF.getSiret().isEmpty()) {
            String siret = this.marqueNF.getSiret();
            this.order.setSiret(siret);
        }
        this.order.setFranchise_id(AppLocal.FRANCHISE_ID);
        this.order.setTake_away_phone(this.ticket.isTake_away_phone());
        this.order.setPlatform_order(this.ticket.isPlatform_order());
        StringBuilder address = new StringBuilder();
        if (this.ticket.getAddressInfo() != null && this.ticket.getAddressInfo().getAddress() != null && !this.ticket.getAddressInfo().getAddress().isEmpty()) {
            address.append(this.ticket.getAddressInfo().getAddress());
            address.append("\n");
            double latitude = this.ticket.getAddressInfo().getLat();
            double longitude = this.ticket.getAddressInfo().getLon();
            this.order.setLatitude(latitude);
            this.order.setLongitude(longitude);
        }
        if (this.ticket.getAddressInfo() != null && this.ticket.getAddressInfo().getCity() != null && !this.ticket.getAddressInfo().getCity().isEmpty() && this.ticket.getAddressInfo().getZipcode() != null && !this.ticket.getAddressInfo().getZipcode().isEmpty()) {
            address.append(this.ticket.getAddressInfo().getZipcode());
            address.append(" ");
            address.append(this.ticket.getAddressInfo().getCity());
        }
        this.order.setAddress_customer(address.toString());
        this.order.setEasel_number(this.ticket.getEasel_number());
        this.order.setTotalTTC(NumericUtils.round(this.ticket.getTotal()));
        int quantity = 0;
        int numline = 0;
        int number_supplement_sortie = 0;
        ArrayList<LinesOrder> lines = new ArrayList<LinesOrder>();
        boolean first_iteration = true;
        for (TicketLineInfo line : this.ticket.getLines()) {
            List<TagInfo> tags;
            number_supplement_sortie = 0;
            if (line.isNext() || line.isDiver()) continue;
            String color_line = null;
            boolean send_color = false;
            ProductInfoExt product_line = CacheFinder.findProductInfoById(this.mSharedMemoryCache, this.dlSales, line.getProductID());
            if (product_line != null) {
                if (product_line.getColor() != null) {
                    color_line = ColorUtils.getColor(product_line.getColor());
                }
                send_color = product_line.isSend_color();
            }
            ArrayList<Supplements> supplements_kitchen = new ArrayList<Supplements>();
            List<Items> items = this.addItems(line.getListProducts());
            for (Items item : items) {
                Iterator<ItemOrderInfo> itemIngredients = this.dlItems.getItemsIngredients(item.getId_product_local());
                HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
                Iterator iterator = itemIngredients.iterator();
                while (iterator.hasNext()) {
                    ItemIngredientInfo itemIngredient = (ItemIngredientInfo)iterator.next();
                    hashMap.put(itemIngredient.getId_supplement_item(), itemIngredient.getQuantity());
                }
                ArrayList<Supplements> supplements_items = new ArrayList<Supplements>();
                for (ItemOrderInfo itemOrderInfo : line.getListIngredients()) {
                    Supplements ingredient_to_add;
                    if (itemOrderInfo.getIdProduct() != item.getId_product_local() || itemOrderInfo.getIdCarte() != item.getId_carte_local() || itemOrderInfo.getIndex_carte() != item.getIndex_carte() || (ingredient_to_add = this.addIngredient(itemOrderInfo, hashMap.getOrDefault(itemOrderInfo.getId(), 1))) == null) continue;
                    supplements_items.add(ingredient_to_add);
                }
                List<SupplementItemInfo> ingredients_item = this.dlSales.getIngredientsByProducts(item.getId_product_local(), true, false);
                for (SupplementItemInfo ingredient3 : ingredients_item) {
                    Supplements ingredient_to_add;
                    boolean exist = false;
                    for (ItemOrderInfo SansIngredient : line.getListIngredients()) {
                        if (ingredient3.getiD() != SansIngredient.getSupplement()) continue;
                        exist = true;
                        break;
                    }
                    if (exist || (ingredient_to_add = this.addIngredientInclus(ingredient3, hashMap.getOrDefault(ingredient3.getiD(), 1))) == null) continue;
                    supplements_items.add(ingredient_to_add);
                }
                for (OptionItemOrder supplement2 : line.getListSupplements()) {
                    if (supplement2.isHidden_in_kitchen() && !supplement2.isDisplay_screen_sorti() || supplement2.getIdProduct() != item.getId_product_local() || supplement2.getIdCarte() != item.getId_carte_local() || supplement2.getIndex_carte() != item.getIndex_carte()) continue;
                    if (supplement2.isDisplay_screen_sorti()) {
                        String color;
                        ++number_supplement_sortie;
                        String string = color = supplement2.getColor() != null ? supplement2.getColor() : "";
                        int id_supplement = this.slave ? (supplement2.getRef_web() != null ? Integer.parseInt(supplement2.getRef_web()) : 0) : supplement2.getSupplement();
                        Supplements supplement_to_add = new Supplements(true, supplement2.getColor(), supplement2.getNameSupplement(), (double)supplement2.getNumberOption(), false, "", "start", supplement2.getWeight(), supplement2.getAlias_name_supplement(), supplement2.getShift_option(), supplement2.getPath(), id_supplement, supplement2.isCookable(), !supplement2.isHidden_in_kitchen());
                        if (this.setIdOrder) {
                            supplement_to_add.setId(supplement2.getId_supplement_kitchen());
                            supplement_to_add.setId_supplement_order(supplement2.getId());
                        } else {
                            supplement_to_add.setId_supplement_tmp(this.id_element);
                            supplement2.setId(this.id_element);
                            ++this.id_element;
                        }
                        supplement_to_add.setId_global_supplement(supplement2.getId_global_supplement());
                        supplements_items.add(supplement_to_add);
                        continue;
                    }
                    Supplements supplement_to_add = this.addSupplement(supplement2);
                    if (supplement_to_add == null) continue;
                    supplements_items.add(supplement_to_add);
                }
                item.setSupplementsCollection(supplements_items);
            }
            List<ItemIngredientInfo> itemIngredients = this.dlItems.getItemsIngredients(line.getProductID());
            HashMap<Integer, Integer> ingredientsItemQuantities = new HashMap<Integer, Integer>();
            for (ItemIngredientInfo itemIngredientInfo : itemIngredients) {
                ingredientsItemQuantities.put(itemIngredientInfo.getId_supplement_item(), itemIngredientInfo.getQuantity());
            }
            for (ItemOrderInfo itemOrderInfo : line.getListIngredients()) {
                Supplements ingredient_to_add;
                if (itemOrderInfo.getIdProduct() != -1 && itemOrderInfo.getIdProduct() != 0 || (ingredient_to_add = this.addIngredient(itemOrderInfo, ingredientsItemQuantities.getOrDefault(itemOrderInfo.getId(), 1))) == null) continue;
                supplements_kitchen.add(ingredient_to_add);
            }
            List<SupplementItemInfo> ingrediens = this.dlSales.getIngredientsByProducts(line.getProductID(), true, false);
            for (SupplementItemInfo ingredient5 : ingrediens) {
                Supplements supplements;
                boolean exist = false;
                for (ItemOrderInfo SansIngredient : line.getListIngredients()) {
                    if (ingredient5.getiD() != SansIngredient.getSupplement()) continue;
                    exist = true;
                    break;
                }
                if (exist || (supplements = this.addIngredientInclus(ingredient5, ingredientsItemQuantities.getOrDefault(ingredient5.getiD(), 1))) == null) continue;
                supplements_kitchen.add(supplements);
            }
            HashMap<Integer, Items> hashMap = new HashMap<Integer, Items>();
            boolean add_item_sub_product = false;
            for (OptionItemOrder optionItemOrder : line.getListSupplements()) {
                Items item_sub_product;
                ProductInfoExt subProduct;
                add_item_sub_product = false;
                if (optionItemOrder.getIdProduct() != -1 && optionItemOrder.getIdProduct() != 0 || optionItemOrder.isHidden_in_kitchen() && !optionItemOrder.isDisplay_screen_sorti()) continue;
                if (optionItemOrder.getId_sub_product() != 0 && (subProduct = this.dlProduct.getProductInfo(optionItemOrder.getId_sub_product(), false)) != null && (item_sub_product = this.getItem(subProduct, optionItemOrder)) != null) {
                    add_item_sub_product = true;
                    item_sub_product.setFromOption(true);
                    items.add(item_sub_product);
                    hashMap.put(optionItemOrder.getOption().getiD(), item_sub_product);
                }
                if (add_item_sub_product) continue;
                if (optionItemOrder.isDisplay_screen_sorti()) {
                    String color;
                    ++number_supplement_sortie;
                    String string = color = optionItemOrder.getColor() != null ? optionItemOrder.getColor() : "";
                    int id_supplement = this.slave ? (optionItemOrder.getRef_web() != null ? Integer.parseInt(optionItemOrder.getRef_web()) : 0) : optionItemOrder.getSupplement();
                    Supplements supplement_to_add = new Supplements(true, optionItemOrder.getColor(), optionItemOrder.getNameSupplement(), (double)optionItemOrder.getNumberOption(), false, "", "start", optionItemOrder.getWeight(), optionItemOrder.getPath(), optionItemOrder.getAlias_name_supplement(), optionItemOrder.getShift_option(), id_supplement, optionItemOrder.isCookable(), !optionItemOrder.isHidden_in_kitchen());
                    if (this.setIdOrder) {
                        supplement_to_add.setId_supplement_order(optionItemOrder.getId());
                        supplement_to_add.setId(optionItemOrder.getId_supplement_kitchen());
                    } else {
                        supplement_to_add.setId_supplement_tmp(this.id_element);
                        optionItemOrder.setId(this.id_element);
                        ++this.id_element;
                    }
                    supplement_to_add.setId_global_supplement(optionItemOrder.getId_global_supplement());
                    int parent_supplement_id = optionItemOrder.getParent_supplement_id();
                    if (parent_supplement_id != 0 && hashMap.containsKey(parent_supplement_id)) {
                        Items subProductItem = (Items)hashMap.get(parent_supplement_id);
                        subProductItem.getSupplementsCollection().add(supplement_to_add);
                        continue;
                    }
                    supplements_kitchen.add(supplement_to_add);
                    continue;
                }
                Supplements supplement_to_add = this.addSupplement(optionItemOrder);
                if (supplement_to_add == null) continue;
                int parent_supplement_id = optionItemOrder.getParent_supplement_id();
                if (parent_supplement_id != 0 && hashMap.containsKey(parent_supplement_id)) {
                    Items subProductItem = (Items)hashMap.get(parent_supplement_id);
                    subProductItem.getSupplementsCollection().add(supplement_to_add);
                    continue;
                }
                supplements_kitchen.add(supplement_to_add);
            }
            ArrayList<Items> items_to_add = new ArrayList<Items>();
            for (Items item : items) {
                items_to_add.add(item);
            }
            ArrayList<ScreenLineNew> arrayList = new ArrayList<ScreenLineNew>();
            List<ScreenProduct> screensProduct = this.dlItems.getScreenByProduct(line.getProductID());
            if (this.screens != null) {
                for (ScreenNew screen : this.screens) {
                    for (ScreenProduct screenProduct : screensProduct) {
                        if (screenProduct.getNumber_screen() != screen.getNumber().intValue()) continue;
                        arrayList.add(new ScreenLineNew("start", screen));
                    }
                }
            }
            numline = first_iteration ? ++numline : (numline += quantity);
            quantity = (int)line.getMultiply();
            String size_product = line.getSizeProduct() == null ? "" : line.getSizeProduct();
            double realQuantity = line.getMultiply();
            if (line.getName_sizeProduct() != null) {
                try {
                    String strSizeQuantity = AppLocal.MAP_SIZE_QUANTITY.get(line.getName_sizeProduct());
                    if (strSizeQuantity != null && !strSizeQuantity.isEmpty()) {
                        realQuantity *= Double.parseDouble(strSizeQuantity);
                    }
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
            Object comment = line.getNote();
            if (line.getTime_served() != null && line.getTime_served().equalsIgnoreCase("later")) {
                comment = comment == null ? "Produit plus tard" : (String)comment + " Produit plus tard";
            }
            LinesOrder newLine = new LinesOrder(line.getNameProduct(), "pending", line.getMultiply(), size_product, numline, line.getPlace_served(), null, (String)comment, line.getAlias_name_product(), realQuantity);
            newLine.setPrintWarning(false);
            newLine.setColor(line.getColor_product());
            newLine.setSendColor(send_color);
            newLine.setDisplay_image(line.isDisplay_image_in_kitchen());
            if ((line.getImage_path() == null || line.getImage_path().isEmpty()) && product_line != null) {
                line.setImage_path(product_line.getImageProduct());
            }
            newLine.setImage_path(line.getImage_path());
            newLine.setId_product(product_line != null ? (this.slave ? Integer.parseInt(product_line.getRef_web()) : product_line.getID()) : 0);
            newLine.setHidden(product_line != null && product_line.getSub_products() != null && !product_line.getSub_products().isEmpty());
            newLine.setTop_product(product_line != null ? product_line.isTop_product() : false);
            newLine.setMixedProduct(product_line != null ? product_line.isMixed_product() : false);
            newLine.setAlias_size(line.getAlias_size());
            int categoryId = product_line != null ? product_line.getCategoryid() : 0;
            CategoryInfo category = this.dlSales.getCategoryInfo(String.valueOf(categoryId));
            if (category != null) {
                newLine.setId_category(this.slave ? Integer.parseInt(category.getRef_web()) : category.getID());
                newLine.setCategoryName(category.getName());
                newLine.setId_global_category(category.getId_global());
            }
            newLine.setSent_from(this.getSourceOrder(this.ticket));
            if (this.dlItems != null) {
                String keenio = this.dlItems.getUserKeenIo();
                newLine.setKenio(keenio);
            }
            if (this.marqueNF != null && this.marqueNF.getSiret() != null && !this.marqueNF.getSiret().isEmpty()) {
                String siret = this.marqueNF.getSiret();
                newLine.setSiret(siret);
            }
            newLine.setFranchise_id(AppLocal.FRANCHISE_ID);
            if (this.setIdOrder) {
                newLine.setId_ticket_line(line.getID());
                newLine.setId(line.getId_line_kitchen());
            } else {
                newLine.setId_line_tmp(this.id_element);
                line.setID(this.id_element);
                ++this.id_element;
            }
            int number_screens_of_supplemnts = 0;
            for (Supplements supplement4 : supplements_kitchen) {
                if (supplement4.getScreenSupplementCollection() == null) continue;
                number_screens_of_supplemnts += supplement4.getScreenSupplementCollection().size();
            }
            if (number_screens_of_supplemnts == 0 && items_to_add.isEmpty() && arrayList.isEmpty()) {
                newLine.setLineSuivi(true);
            }
            if (!(supplements_kitchen.isEmpty() && items_to_add.isEmpty() && arrayList.isEmpty())) {
                if (!supplements_kitchen.isEmpty()) {
                    newLine.setSupplementsCollection(supplements_kitchen);
                }
                if (!items_to_add.isEmpty()) {
                    newLine.setItemsCollection(items_to_add);
                }
                if (newLine.getItemsCollection() != null) {
                    for (Items item : newLine.getItemsCollection()) {
                        if (item.getScreenItemCollection() == null) continue;
                        for (ScreenItemNew screenItem : item.getScreenItemCollection()) {
                            int found = -1;
                            for (ScreenLineNew screenLine : arrayList) {
                                if (!Objects.equals(screenLine.getIdScreen().getNumber(), screenItem.getIdScreen().getNumber())) continue;
                                found = 1;
                            }
                            if (found != -1) continue;
                            arrayList.add(new ScreenLineNew("start", (ScreenNew)screenItem.getIdScreen().clone(), "item"));
                        }
                    }
                }
                if (!arrayList.isEmpty()) {
                    newLine.setScreenLineCollection(arrayList);
                }
            }
            if (((tags = this.dlItems.getTagsByCategory(categoryId)) == null || tags.isEmpty()) && category != null && category.getParent_id() != 0 && category.getParent_id() != -1) {
                tags = this.dlItems.getTagsByCategory(category.getParent_id());
            }
            if (tags != null && !tags.isEmpty()) {
                ArrayList<TagLine> tags_to_add = new ArrayList<TagLine>();
                for (TagInfo tag : tags) {
                    tags_to_add.add(new TagLine("started", tag.getNumber()));
                }
                newLine.setTagLineCollection(tags_to_add);
            }
            this.dlSales.getCategoryInfo(String.valueOf(categoryId));
            if (product_line != null) {
                newLine.setId_global_produt(product_line.getId_global());
            }
            if (product_line != null && product_line.getZoneInfo() != null) {
                newLine.setZoneName(product_line.getZoneInfo().getName());
                newLine.setZonePosition(product_line.getZoneInfo().getPosition());
                newLine.setZoneColor(ColorUtils.getHexadecimal(product_line.getZoneInfo().getColor()));
            }
            lines.add(newLine);
            first_iteration = false;
        }
        this.order.setLinesOrderCollection(lines);
        return this;
    }

    private Supplements addIngredient(ItemOrderInfo ingredient, int quantity) {
        int id_supplement = this.slave ? (ingredient.getRef_web() != null ? Integer.parseInt(ingredient.getRef_web()) : 0) : ingredient.getSupplement();
        Supplements supplement_kitchen = new Supplements("Sans " + ingredient.getNameSupplement(), quantity, true, "", "start", false, false, false, 0, "", "", "Sans " + ingredient.getAlias_name_ingredient(), ingredient.getPath(), id_supplement, ingredient.isCookable(), true);
        supplement_kitchen.setId_global_supplement(ingredient.getId_global_supplement());
        if (this.setIdOrder) {
            supplement_kitchen.setId(ingredient.getId_ingredient_kitchen());
            supplement_kitchen.setId_supplement_order(ingredient.getId());
        } else {
            supplement_kitchen.setId_supplement_tmp(this.id_element);
            ingredient.setId(this.id_element);
            ++this.id_element;
        }
        return supplement_kitchen;
    }

    private List<Items> addItems(List<ProductTicket> products) {
        try {
            ArrayList<Items> items = new ArrayList<Items>();
            for (ProductTicket product : products) {
                ProductInfoExt product_item = CacheFinder.findProductInfoById(this.mSharedMemoryCache, this.dlSales, product.getIdProduct());
                String imageProduct = product_item != null ? product_item.getImageProduct() : null;
                boolean topProduct = product_item != null ? product_item.isTop_product() : false;
                String aliasKitchen = product_item != null ? product_item.getAlias_kitchen() : null;
                List<ScreenProduct> screens_item = this.dlItems.getScreenByProduct(product.getIdProduct());
                int id_carte = this.slave && product.getRef_web_carte() != null ? Integer.parseInt(product.getRef_web_carte()) : product.getIdCarte();
                int id_product = this.slave && product.getRef_web_item() != null ? Integer.parseInt(product.getRef_web_item()) : product.getIdProduct();
                String alias_size = product.getSizeProduct() != null ? AppLocal.MAP_SIZE_DESCRIPTIONS.get(product.getSizeProduct()) : null;
                String label_size_product = product.getSizeProduct() != null ? AppLocal.MAP_LABEL_SIZE.get(product.getSizeProduct()) : null;
                double realQuantity = product.getNumberProduct();
                if (product.getSizeProduct() != null) {
                    try {
                        String strSizeQuantity = AppLocal.MAP_SIZE_QUANTITY.get(product.getSizeProduct());
                        realQuantity *= Double.parseDouble(strSizeQuantity);
                    }
                    catch (NumberFormatException strSizeQuantity) {
                        // empty catch block
                    }
                }
                Object comment = product.getComment();
                if (product.getTime_served() != null && product.getTime_served().equalsIgnoreCase("later")) {
                    comment = comment == null ? "Produit plus tard" : (String)comment + " Produit plus tard";
                }
                Items item = new Items(product.getNameProduct(), product.getNumberProduct(), "pending", id_product, id_carte, imageProduct, product.getIndex_carte(), product.getIdProduct(), product.getIdCarte(), topProduct, label_size_product, alias_size, (String)comment, aliasKitchen, realQuantity);
                item.setId_global_product(product.getId_global_product());
                item.setId_global_carte(product.getId_global_carte());
                if (screens_item != null && !screens_item.isEmpty()) {
                    ArrayList<ScreenItemNew> screens_to_add = new ArrayList<ScreenItemNew>();
                    if (this.screens != null) {
                        for (ScreenNew screen : this.screens) {
                            for (ScreenProduct screenSupplement : screens_item) {
                                if (screenSupplement.getNumber_screen() != screen.getNumber().intValue()) continue;
                                screens_to_add.add(new ScreenItemNew(screen, "start"));
                            }
                        }
                    }
                    item.setScreenItemCollection(screens_to_add);
                }
                if (this.setIdOrder) {
                    item.setId(product.getId_item_kitchen());
                    item.setId_item_source(product.getId());
                } else {
                    item.setId_item_tmp(this.id_element);
                    product.setId(this.id_element);
                    ++this.id_element;
                }
                if (product_item != null && product_item.getZoneInfo() != null) {
                    item.setZoneName(product_item.getZoneInfo().getName());
                    item.setZonePosition(product_item.getZoneInfo().getPosition());
                    item.setZoneColor(ColorUtils.getHexadecimal(product_item.getZoneInfo().getColor()));
                }
                items.add(item);
            }
            return items;
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            return null;
        }
    }

    private Supplements addIngredientInclus(SupplementItemInfo ingredient, int quantity) {
        int id_supplement = this.slave && ingredient.getRef_web() != null ? Integer.parseInt(ingredient.getRef_web()) : ingredient.getiD();
        Supplements supplement_kitchen = new Supplements(ingredient.getName(), quantity, true, "", "start", false, false, false, 0, "", "", true, ingredient.getAlias_kitchen(), ingredient.getPath(), id_supplement, ingredient.isCookable(), !ingredient.isHidden_in_kitchen());
        supplement_kitchen.setId_global_supplement(ingredient.getId_global());
        return supplement_kitchen;
    }

    private Supplements addSupplement(OptionItemOrder supplement) {
        String color;
        String string = color = supplement.getColor() != null ? supplement.getColor() : "";
        int id_supplement = this.slave ? (supplement.getRef_web() != null ? Integer.parseInt(supplement.getRef_web()) : 0) : supplement.getSupplement();
        Supplements supplement_kitchen = new Supplements(supplement.getNameSupplement(), supplement.getNumberOption(), false, "", "start", false, supplement.getIsBold(), supplement.isSend_color(), supplement.getNumber_flame(), color, supplement.getWeight(), supplement.getAlias_name_supplement(), supplement.getPath(), id_supplement, supplement.isCookable(), !supplement.isHidden_in_kitchen());
        supplement_kitchen.setId_global_supplement(supplement.getId_global_supplement());
        if (this.setIdOrder) {
            supplement_kitchen.setId_supplement_order(supplement.getId());
            supplement_kitchen.setId(supplement.getId_supplement_kitchen());
        } else {
            supplement_kitchen.setId_supplement_tmp(this.id_element);
            supplement.setId(this.id_element);
            ++this.id_element;
        }
        return supplement_kitchen;
    }

    private Items getItem(ProductInfoExt product_item, OptionItemOrder supplement) {
        try {
            List<ScreenProduct> screens_item = this.dlItems.getScreenByProduct(product_item.getID());
            int id_product = this.slave && product_item.getRef_web() != null ? Integer.parseInt(product_item.getRef_web()) : product_item.getID();
            String comment = null;
            if (supplement.getTime_served() != null && supplement.getTime_served().equalsIgnoreCase("later")) {
                comment = "Produit plus tard";
            }
            Items item = new Items(product_item.getName(), supplement.getNumberOption(), "pending", id_product, -1, product_item.getImageProduct(), 1, product_item.getID(), -1, product_item.isTop_product(), null, null, comment, product_item.getAlias_kitchen(), supplement.getNumberOption());
            item.setSupplement(true);
            item.setId_global_product(product_item.getId_global());
            if (screens_item != null && !screens_item.isEmpty()) {
                ArrayList<ScreenItemNew> screens_to_add = new ArrayList<ScreenItemNew>();
                if (this.screens != null) {
                    for (ScreenNew screenNew : this.screens) {
                        for (ScreenProduct screenSupplement : screens_item) {
                            if (screenSupplement.getNumber_screen() != screenNew.getNumber().intValue()) continue;
                            screens_to_add.add(new ScreenItemNew(screenNew, "start"));
                        }
                    }
                }
                item.setScreenItemCollection(screens_to_add);
            }
            List<ItemIngredientInfo> itemIngredients = this.dlItems.getItemsIngredients(product_item.getID());
            HashMap<Integer, Integer> ingredientsItemQuantities = new HashMap<Integer, Integer>();
            for (ItemIngredientInfo itemIngredient : itemIngredients) {
                ingredientsItemQuantities.put(itemIngredient.getId_supplement_item(), itemIngredient.getQuantity());
            }
            List<SupplementItemInfo> list = this.dlSales.getIngredientsByProducts(product_item.getID(), true, false);
            ArrayList<Supplements> supplements_items = new ArrayList<Supplements>();
            for (SupplementItemInfo ingredient : list) {
                Supplements ingredient_to_add = this.addIngredientInclus(ingredient, ingredientsItemQuantities.getOrDefault(ingredient.getiD(), 1));
                if (ingredient_to_add == null) continue;
                supplements_items.add(ingredient_to_add);
            }
            item.setSupplementsCollection(supplements_items);
            if (this.setIdOrder) {
                item.setId(supplement.getId_supplement_kitchen());
                item.setId_item_source(supplement.getId());
            } else {
                item.setId_item_tmp(this.id_element);
                supplement.setId(this.id_element);
                ++this.id_element;
            }
            if (product_item != null && product_item.getZoneInfo() != null) {
                item.setZoneColor(ColorUtils.getHexadecimal(product_item.getZoneInfo().getColor()));
                item.setZonePosition(product_item.getZoneInfo().getPosition());
                item.setZoneName(product_item.getZoneInfo().getName());
            }
            return item;
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            return null;
        }
    }

    public Orders getOrder() {
        return this.order;
    }

    private String getSourceOrder(TicketInfo ticket) {
        if (ticket.getOrdered_from() != null && ticket.getOrdered_from().equals("inside") && (ticket.getSent_from() == null || ticket.getSent_from().isEmpty())) {
            if (AppLocal.modeCaisse != null && AppLocal.modeCaisse.equals("Caisse")) {
                if (ticket.getType() != null && ticket.getType().equalsIgnoreCase("Drive")) {
                    return "Drive";
                }
                return "caisse";
            }
            return "borne cb";
        }
        if (ticket.getType() != null && ticket.getType().equalsIgnoreCase("Drive")) {
            return "Drive";
        }
        if (ticket.getSent_from() != null) {
            switch (ticket.getSent_from()) {
                case "borne": {
                    return "borne";
                }
                case "web": {
                    return "online";
                }
                case "Uber Eats": {
                    return "Uber Eats";
                }
                case "Just Eat": {
                    return "Just Eat";
                }
                case "Delivero": {
                    return "Delivero";
                }
            }
            return ticket.getSent_from();
        }
        return "";
    }
}

