/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.ticket;

import com.openbravo.basic.BasicException;
import com.openbravo.data.loader.SerializerRead;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.ticket.TaxInfo;
import com.openbravo.pos.util.ColorUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.NumericUtils;
import com.procaisse.db.metadata.DataRead;
import fr.protactile.procaisse.dao.entities.AllergeneSupplement;
import fr.protactile.procaisse.dao.entities.MultiLanguageSupplementItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.image.Image;

public class OptionItemOrder
implements Serializable,
Cloneable {
    private int id;
    private int idCarte;
    private int idProduct;
    private int supplement;
    private String nameSupplement;
    private String nameProduct;
    private String nameCarte;
    private int numberOption;
    private Boolean isBold;
    private Double price;
    private int index_carte;
    private int number_free;
    private boolean separate;
    private boolean multiple;
    private String ref_web;
    private String weight;
    private boolean display_free;
    private int id_groupe_option;
    private String path;
    private boolean force_free;
    private int order_option;
    private int printer;
    private int shift_option;
    private boolean display_screen_sorti;
    private String color;
    private String alias_name_supplement;
    private boolean send_color;
    private int number_flame;
    private SupplementItemInfo option;
    private boolean no_printable;
    private int parent_supplement_id;
    private int groupSubSupplementInfo_ID;
    private String ref_product;
    private String ref_carte;
    private int id_sub_product;
    private String name_groupe_option;
    private int id_supplement_kitchen;
    private int id_shared_supplement;
    private boolean convert_to_product;
    private boolean hidden_in_kitchen;
    private int idGroupSubSupplementInfo;
    private boolean print_black_background;
    private double quantity_product;
    private String taxId;
    private TaxInfo tax;
    private double taxAmount;
    private double htAmount;
    private int numLine;
    private double price_already_included;
    private double full_price;
    private boolean platform_order;
    private boolean item_sub_product;
    private String id_global_supplement;
    private String id_global_product;
    private String id_global_carte;
    private String displayedName;
    private boolean cookable;
    private List<MultiLanguageSupplementItem> multiLanguageTexts;
    private boolean option_later;
    private String time_served;
    private Image image_item;
    private Image imageSupplement;
    private List<AllergeneSupplement> Allergenes;
    private String parent_supplement_global_id;

    public OptionItemOrder(int idCarte, int idProduct, int supplement, String nameSupplement, String nameProduct, String nameCarte, int numberOption, Boolean isBold, Double price, int index_carte, int number_free, boolean separate, String weight, boolean multiple, boolean display_free, int id_groupe_option, boolean force_free, int printer, int shift_option, boolean display_screen_sorti, String color, SupplementItemInfo option, boolean no_printable, String name_groupe_option, boolean print_black_background, String ref_product, String ref_carte, String id_global_product, String id_global_carte) {
        this.idCarte = idCarte;
        this.idProduct = idProduct;
        this.supplement = supplement;
        this.nameSupplement = nameSupplement;
        this.nameProduct = nameProduct;
        this.nameCarte = nameCarte;
        this.numberOption = numberOption;
        this.isBold = isBold;
        this.price = price;
        this.index_carte = index_carte;
        this.number_free = number_free;
        this.separate = separate;
        this.weight = weight;
        this.multiple = multiple;
        this.display_free = display_free;
        this.id_groupe_option = id_groupe_option;
        this.force_free = force_free;
        this.printer = printer;
        this.shift_option = shift_option;
        this.display_screen_sorti = display_screen_sorti;
        this.color = color;
        this.option = option;
        if (option != null) {
            this.alias_name_supplement = option.getAlias_kitchen();
            this.send_color = option.isSend_color();
            this.number_flame = option.getNumber_flame();
            this.ref_web = option.getRef_web();
            this.path = option.getPath();
            this.id_sub_product = option.getId_product();
            this.hidden_in_kitchen = option.isHidden_in_kitchen();
            this.taxId = option.getTaxId();
            this.price_already_included = option.getPrice_already_included();
            this.id_global_supplement = option.getId_global();
            this.displayedName = option.getDisplayedName();
            this.cookable = option.isCookable();
            this.multiLanguageTexts = option.getMultiLanguageTexts();
            this.Allergenes = option.getAllergenes();
        }
        this.no_printable = no_printable;
        this.name_groupe_option = name_groupe_option;
        this.print_black_background = print_black_background;
        this.ref_product = ref_product;
        this.ref_carte = ref_carte;
        this.id_global_product = id_global_product;
        this.id_global_carte = id_global_carte;
        this.setFullPriceAfterCheck();
    }

    public OptionItemOrder(int idCarte, int idProduct, String nameProduct, String nameCarte, int numberOption, Boolean isBold, Double price, int index_carte, int number_free, boolean separate, boolean multiple, String ref_web, int id_groupe_option, int printer, int shift_option, boolean display_screen_sorti, String color, SupplementItemInfo option, boolean no_printable, String ref_product, String ref_carte, String name_groupe_option, boolean platform_order, String id_global_product, String id_global_carte) {
        this.idCarte = idCarte;
        this.idProduct = idProduct;
        this.nameProduct = nameProduct;
        this.nameCarte = nameCarte;
        this.numberOption = numberOption;
        this.isBold = isBold;
        this.price = price;
        this.index_carte = index_carte;
        this.number_free = number_free;
        this.separate = separate;
        this.multiple = multiple;
        this.ref_web = ref_web;
        this.id_groupe_option = id_groupe_option;
        this.printer = printer;
        this.shift_option = shift_option;
        this.display_screen_sorti = display_screen_sorti;
        this.color = color;
        this.option = option;
        this.no_printable = no_printable;
        this.ref_product = ref_product;
        this.ref_carte = ref_carte;
        this.name_groupe_option = name_groupe_option;
        if (option != null) {
            this.alias_name_supplement = option.getAlias_kitchen();
            this.send_color = option.isSend_color();
            this.number_flame = option.getNumber_flame();
            this.id_sub_product = option.getId_product();
            this.hidden_in_kitchen = option.isHidden_in_kitchen();
            this.display_free = option.isDisplay_free();
            this.print_black_background = option.isPrint_black_background();
            this.taxId = option.getTaxId();
            this.price_already_included = option.getPrice_already_included();
            this.supplement = option.getiD();
            this.nameSupplement = option.getName();
            this.path = option.getPath();
            this.id_global_supplement = option.getId_global();
            this.displayedName = option.getDisplayedName();
            this.cookable = option.isCookable();
            this.multiLanguageTexts = option.getMultiLanguageTexts();
            this.Allergenes = option.getAllergenes();
        }
        this.platform_order = platform_order;
        this.setFullPriceAfterCheck();
        this.id_global_product = id_global_product;
        this.id_global_carte = id_global_carte;
    }

    public OptionItemOrder(int idCarte, int idProduct, String nameProduct, String nameCarte, int numberOption, int index_carte, int number_free, SupplementItemInfo option, int parent_supplement_id, int groupSubSupplementInfo_ID, String ref_product, String ref_carte, String id_global_product, String id_global_carte, String parent_supplement_global_id) {
        this.idCarte = idCarte;
        this.idProduct = idProduct;
        this.supplement = option.getiD();
        this.nameSupplement = option.getName();
        this.nameProduct = nameProduct;
        this.nameCarte = nameCarte;
        this.numberOption = numberOption;
        this.isBold = option.isBold();
        this.price = option.getPrice_order();
        this.index_carte = index_carte;
        this.number_free = number_free;
        this.separate = false;
        this.multiple = false;
        this.ref_web = option.getRef_web();
        this.id_groupe_option = option.getId_supplement();
        this.path = option.getPath();
        this.printer = option.getPrinter();
        this.shift_option = option.getShift_option();
        this.display_screen_sorti = option.isDisplay_screen_sorti();
        this.color = ColorUtils.getColor(option.getColor());
        this.option = option;
        this.alias_name_supplement = option.getAlias_kitchen();
        this.send_color = option.isSend_color();
        this.number_flame = option.getNumber_flame();
        this.no_printable = option.isNo_printable();
        this.parent_supplement_id = parent_supplement_id;
        this.groupSubSupplementInfo_ID = groupSubSupplementInfo_ID;
        this.name_groupe_option = option.getName_groupe_option();
        this.id_sub_product = option.getId_product();
        this.hidden_in_kitchen = option.isHidden_in_kitchen();
        this.display_free = option.isDisplay_free();
        this.print_black_background = option.isPrint_black_background();
        this.taxId = option.getTaxId();
        this.price_already_included = option.getPrice_already_included();
        this.setFullPriceAfterCheck();
        this.id_global_supplement = option.getId_global();
        this.displayedName = option.getDisplayedName();
        this.cookable = option.isCookable();
        this.multiLanguageTexts = option.getMultiLanguageTexts();
        this.Allergenes = option.getAllergenes();
        this.ref_product = ref_product;
        this.ref_carte = ref_carte;
        this.id_global_product = id_global_product;
        this.id_global_carte = id_global_carte;
        this.parent_supplement_global_id = parent_supplement_global_id;
    }

    public int getNumber_free() {
        return this.number_free;
    }

    public void setNumber_free(int number_free) {
        this.number_free = number_free;
    }

    public int getIndex_carte() {
        return this.index_carte;
    }

    public void setIndex_carte(int index_carte) {
        this.index_carte = index_carte;
    }

    public OptionItemOrder() {
    }

    public int getIdCarte() {
        return this.idCarte;
    }

    public void setIdCarte(int idCarte) {
        this.idCarte = idCarte;
    }

    public int getIdProduct() {
        return this.idProduct;
    }

    public void setIdProduct(int idProduct) {
        this.idProduct = idProduct;
    }

    public int getSupplement() {
        return this.supplement;
    }

    public void setSupplement(int supplement) {
        this.supplement = supplement;
    }

    public String getNameSupplement() {
        return this.nameSupplement;
    }

    public void setNameSupplement(String nameSupplement) {
        this.nameSupplement = nameSupplement;
    }

    public String getNameProduct() {
        return this.nameProduct;
    }

    public void setNameProduct(String nameProduct) {
        this.nameProduct = nameProduct;
    }

    public String getNameCarte() {
        return this.nameCarte;
    }

    public void setNameCarte(String nameCarte) {
        this.nameCarte = nameCarte;
    }

    public int getNumberOption() {
        return this.numberOption;
    }

    public void setNumberOption(int numberOption) {
        this.numberOption = numberOption;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public boolean isSeparate() {
        return this.separate;
    }

    public void setSeparate(boolean separate) {
        this.separate = separate;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public String getWeight() {
        return this.weight;
    }

    public void setWeight(String weight) {
        this.weight = weight;
    }

    public boolean isForce_free() {
        return this.force_free;
    }

    public void setForce_free(boolean force_free) {
        this.force_free = force_free;
    }

    public static SerializerRead getSerializerRead() {
        return new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                OptionItemOrder orderItem = new OptionItemOrder();
                orderItem.id = dr.getInt(1);
                orderItem.idCarte = dr.getInt(2);
                orderItem.nameCarte = dr.getString(3);
                orderItem.idProduct = dr.getInt(4);
                orderItem.nameProduct = dr.getString(5);
                orderItem.supplement = dr.getInt(6);
                orderItem.nameSupplement = dr.getString(7);
                orderItem.numberOption = dr.getInt(8);
                orderItem.isBold = dr.getBoolean(9);
                orderItem.price = dr.getDouble(10);
                orderItem.index_carte = dr.getInt(11);
                orderItem.number_free = dr.getInt(12);
                orderItem.separate = dr.getBoolean(13);
                orderItem.multiple = dr.getBoolean(14);
                orderItem.weight = dr.getString(15);
                orderItem.display_free = dr.getBoolean(16);
                orderItem.id_groupe_option = dr.getInt(17);
                orderItem.force_free = dr.getBoolean(18);
                orderItem.printer = dr.getInt(19);
                orderItem.shift_option = dr.getInt(20);
                orderItem.no_printable = dr.getBoolean(21);
                orderItem.parent_supplement_id = dr.getInt(22);
                orderItem.path = dr.getString(23);
                orderItem.display_screen_sorti = dr.getBoolean(24);
                orderItem.name_groupe_option = dr.getString(25);
                orderItem.id_supplement_kitchen = dr.getInt(26);
                orderItem.id_sub_product = dr.getInt(27);
                orderItem.alias_name_supplement = dr.getString(28);
                orderItem.hidden_in_kitchen = dr.getBoolean(29);
                orderItem.print_black_background = dr.getBoolean(30);
                orderItem.order_option = dr.getInt(31);
                orderItem.cookable = dr.getBoolean(32);
                orderItem.taxId = dr.getString(33);
                orderItem.htAmount = dr.getDouble(34);
                orderItem.taxAmount = dr.getDouble(35);
                orderItem.price_already_included = dr.getDouble(36);
                orderItem.full_price = dr.getDouble(37);
                orderItem.color = dr.getString(38);
                orderItem.id_global_supplement = dr.getString(39);
                SupplementItemInfo option = new SupplementItemInfo();
                option.setAlias_kitchen(orderItem.alias_name_supplement);
                option.setSend_color(orderItem.send_color);
                option.setNumber_flame(orderItem.number_flame);
                option.setId_product(orderItem.id_sub_product);
                option.setHidden_in_kitchen(orderItem.hidden_in_kitchen);
                option.setDisplay_free(orderItem.display_free);
                option.setPrint_black_background(orderItem.print_black_background);
                option.setTaxId(orderItem.taxId);
                option.setPrice_already_included(orderItem.price_already_included);
                option.setiD(orderItem.supplement);
                option.setName(orderItem.nameSupplement);
                option.setPath(orderItem.path);
                option.setId_global(orderItem.id_global_supplement);
                option.setCookable(orderItem.cookable);
                option.setMultiLanguageTexts(orderItem.multiLanguageTexts);
                option.setAllergenes(orderItem.Allergenes);
                orderItem.setOption(option);
                return orderItem;
            }
        };
    }

    public boolean isDisplay_free() {
        return this.display_free;
    }

    public void setDisplay_free(boolean display_free) {
        this.display_free = display_free;
    }

    public Boolean getIsBold() {
        return this.isBold;
    }

    public void setIsBold(Boolean isBold) {
        this.isBold = isBold;
    }

    public String printPrice() {
        if (this.price != 0.0) {
            return Formats.CURRENCY.formatValue(this.price);
        }
        return "";
    }

    public Double getPrice() {
        return this.price;
    }

    public String getRef_web() {
        return this.ref_web;
    }

    public void setRef_web(String ref_web) {
        this.ref_web = ref_web;
    }

    public int getId_groupe_option() {
        return this.id_groupe_option;
    }

    public void setId_groupe_option(int id_groupe_option) {
        this.id_groupe_option = id_groupe_option;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int getOrder_option() {
        return this.order_option;
    }

    public void setOrder_option(int order_option) {
        this.order_option = order_option;
    }

    public int getPrinter() {
        return this.printer;
    }

    public void setPrinter(int printer) {
        this.printer = printer;
    }

    public int getShift_option() {
        return this.shift_option;
    }

    public void setShift_option(int shift_option) {
        this.shift_option = shift_option;
    }

    public Object clone() {
        try {
            int i;
            OptionItemOrder o = null;
            o = (OptionItemOrder)super.clone();
            if (this.multiLanguageTexts != null) {
                o.multiLanguageTexts = new ArrayList<MultiLanguageSupplementItem>();
                for (i = 0; i < this.multiLanguageTexts.size(); ++i) {
                    o.multiLanguageTexts.add((MultiLanguageSupplementItem)this.multiLanguageTexts.get(i).clone());
                }
            } else {
                o.multiLanguageTexts = null;
            }
            if (this.Allergenes != null) {
                o.Allergenes = new ArrayList<AllergeneSupplement>();
                for (i = 0; i < this.Allergenes.size(); ++i) {
                    o.Allergenes.add((AllergeneSupplement)this.Allergenes.get(i).clone());
                }
            } else {
                o.multiLanguageTexts = null;
            }
            if (this.option != null) {
                o.option = (SupplementItemInfo)this.option.clone();
            }
            return o;
        }
        catch (CloneNotSupportedException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            return null;
        }
    }

    public boolean isDisplay_screen_sorti() {
        return this.display_screen_sorti;
    }

    public void setDisplay_screen_sorti(boolean display_screen_sorti) {
        this.display_screen_sorti = display_screen_sorti;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getAlias_name_supplement() {
        return this.alias_name_supplement;
    }

    public void setAlias_name_supplement(String alias_name_supplement) {
        this.alias_name_supplement = alias_name_supplement;
    }

    public boolean isSend_color() {
        return this.send_color;
    }

    public void setSend_color(boolean send_color) {
        this.send_color = send_color;
    }

    public int getNumber_flame() {
        return this.number_flame;
    }

    public void setNumber_flame(int number_flame) {
        this.number_flame = number_flame;
    }

    public SupplementItemInfo getOption() {
        return this.option;
    }

    public void setOption(SupplementItemInfo option) {
        this.option = option;
    }

    public boolean isNo_printable() {
        return this.no_printable;
    }

    public void setNo_printable(boolean no_printable) {
        this.no_printable = no_printable;
    }

    public int getParent_supplement_id() {
        return this.parent_supplement_id;
    }

    public void setParent_supplement_id(int parent_supplement_id) {
        this.parent_supplement_id = parent_supplement_id;
    }

    public int getGroupSubSupplementInfo_ID() {
        return this.groupSubSupplementInfo_ID;
    }

    public void setGroupSubSupplementInfo_ID(int groupSubSupplementInfo_ID) {
        this.groupSubSupplementInfo_ID = groupSubSupplementInfo_ID;
    }

    public String getRef_product() {
        return this.ref_product;
    }

    public void setRef_product(String ref_product) {
        this.ref_product = ref_product;
    }

    public String getRef_carte() {
        return this.ref_carte;
    }

    public void setRef_carte(String ref_carte) {
        this.ref_carte = ref_carte;
    }

    public String getKeyOption() {
        StringBuilder key = new StringBuilder();
        key.append(this.supplement);
        if (this.parent_supplement_id != 0) {
            key.append("P");
            key.append(this.parent_supplement_id);
        }
        return key.toString();
    }

    public int getId_sub_product() {
        return this.id_sub_product;
    }

    public void setId_sub_product(int id_sub_product) {
        this.id_sub_product = id_sub_product;
    }

    public String getName_groupe_option() {
        return this.name_groupe_option;
    }

    public void setName_groupe_option(String name_groupe_option) {
        this.name_groupe_option = name_groupe_option;
    }

    public int getId_supplement_kitchen() {
        return this.id_supplement_kitchen;
    }

    public void setId_supplement_kitchen(int id_supplement_kitchen) {
        this.id_supplement_kitchen = id_supplement_kitchen;
    }

    public int getId_shared_supplement() {
        return this.id_shared_supplement;
    }

    public void setId_shared_supplement(int id_shared_supplement) {
        this.id_shared_supplement = id_shared_supplement;
    }

    public String printName(boolean show_alias) {
        String name_supplement = show_alias && this.alias_name_supplement != null && !this.alias_name_supplement.trim().isEmpty() ? this.alias_name_supplement : this.nameSupplement;
        return name_supplement;
    }

    public boolean isConvert_to_product() {
        return this.convert_to_product;
    }

    public void setConvert_to_product(boolean convert_to_product) {
        this.convert_to_product = convert_to_product;
    }

    public boolean isHidden_in_kitchen() {
        return this.hidden_in_kitchen;
    }

    public void setHidden_in_kitchen(boolean hidden_in_kitchen) {
        this.hidden_in_kitchen = hidden_in_kitchen;
    }

    public int getIdGroupSubSupplementInfo() {
        return this.idGroupSubSupplementInfo;
    }

    public void setIdGroupSubSupplementInfo(int idGroupSubSupplementInfo) {
        this.idGroupSubSupplementInfo = idGroupSubSupplementInfo;
    }

    public boolean isPrint_black_background() {
        return this.print_black_background;
    }

    public void setPrint_black_background(boolean print_black_background) {
        this.print_black_background = print_black_background;
    }

    public double getQuantity_product() {
        return this.quantity_product;
    }

    public void setQuantity_product(double quantity_product) {
        this.quantity_product = quantity_product;
    }

    public TaxInfo getTax() {
        return this.tax;
    }

    public void setTax(TaxInfo tax) {
        this.tax = tax;
    }

    public double getTaxAmount() {
        return this.taxAmount;
    }

    public void setTaxAmount(double taxAmount) {
        this.taxAmount = taxAmount;
    }

    public double getHtAmount() {
        return this.htAmount;
    }

    public void setHtAmount(double htAmount) {
        this.htAmount = htAmount;
    }

    public double getDiscount(double discountPercent, double lineQuantity) {
        return NumericUtils.round(NumericUtils.round(discountPercent * this.getFull_price() / 100.0) * lineQuantity);
    }

    public double getTaxRate() {
        return this.tax == null ? 0.0 : this.tax.getRate();
    }

    public String getTaxId() {
        return this.taxId;
    }

    public void setTaxId(String taxId) {
        this.taxId = taxId;
    }

    public int getNumLine() {
        return this.numLine;
    }

    public void setNumLine(int numLine) {
        this.numLine = numLine;
    }

    public double getUnitPrice() {
        return this.getFull_price() / (double)(this.numberOption + this.number_free);
    }

    public double getPrice_already_included() {
        return this.price_already_included;
    }

    public void setPrice_already_included(double price_already_included) {
        this.price_already_included = price_already_included;
    }

    public void setPrice(Double price, double quantity) {
        this.price = price * quantity;
        this.full_price = AppLocal.MODULE_MULTI_TVA && this.addTaxeToOption() ? (price + this.price_already_included) * quantity : price * quantity;
    }

    public double getFull_price() {
        return this.full_price;
    }

    public void setFull_price(double full_price) {
        this.full_price = full_price;
    }

    private void setFullPriceAfterCheck() {
        this.full_price = AppLocal.MODULE_MULTI_TVA && this.addTaxeToOption() ? this.price + this.price_already_included : this.price;
    }

    public boolean addTaxeToOption() {
        return this.idProduct == -1 && !this.platform_order;
    }

    public boolean isItem_sub_product() {
        return this.item_sub_product;
    }

    public void setItem_sub_product(boolean item_sub_product) {
        this.item_sub_product = item_sub_product;
    }

    public String getId_global_supplement() {
        return this.id_global_supplement;
    }

    public void setId_global_supplement(String id_global_supplement) {
        this.id_global_supplement = id_global_supplement;
    }

    public String getId_global_product() {
        return this.id_global_product;
    }

    public void setId_global_product(String id_global_product) {
        this.id_global_product = id_global_product;
    }

    public String getId_global_carte() {
        return this.id_global_carte;
    }

    public void setId_global_carte(String id_global_carte) {
        this.id_global_carte = id_global_carte;
    }

    public String getDisplayedName() {
        return this.displayedName;
    }

    public void setDisplayedName(String displayedName) {
        this.displayedName = displayedName;
    }

    public boolean isCookable() {
        return this.cookable;
    }

    public void setCookable(boolean cookable) {
        this.cookable = cookable;
    }

    public List<MultiLanguageSupplementItem> getMultiLanguageTexts() {
        return this.multiLanguageTexts;
    }

    public void setMultiLanguageTexts(List<MultiLanguageSupplementItem> multiLanguageTexts) {
        this.multiLanguageTexts = multiLanguageTexts;
    }

    public String getNameByLanguage(String code_language) {
        String nameByLanguage = "";
        if (this.multiLanguageTexts != null && this.multiLanguageTexts.size() > 0 && code_language != null && !code_language.isEmpty()) {
            for (MultiLanguageSupplementItem multiLanguageText : this.multiLanguageTexts) {
                if (!code_language.equalsIgnoreCase(multiLanguageText.getLanguage())) continue;
                nameByLanguage = multiLanguageText.getName();
                break;
            }
        }
        return nameByLanguage;
    }

    public boolean isOption_later() {
        return this.option_later;
    }

    public void setOption_later(boolean option_later) {
        this.option_later = option_later;
    }

    public String getTime_served() {
        return this.time_served;
    }

    public void setTime_served(String time_served) {
        this.time_served = time_served;
    }

    public Image getImage_item() {
        return this.image_item;
    }

    public void setImage_item(Image image_item) {
        this.image_item = image_item;
    }

    public Image getImageSupplement() {
        return this.imageSupplement;
    }

    public void setImageSupplement(Image imageSupplement) {
        this.imageSupplement = imageSupplement;
    }

    public List<AllergeneSupplement> getAllergenes() {
        return this.Allergenes;
    }

    public void setAllergenes(List<AllergeneSupplement> Allergenes) {
        this.Allergenes = Allergenes;
    }

    public String getParent_supplement_global_id() {
        return this.parent_supplement_global_id;
    }

    public void setParent_supplement_global_id(String parent_supplement_global_id) {
        this.parent_supplement_global_id = parent_supplement_global_id;
    }
}

