/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.ticket;

import com.openbravo.controllers.borne.IOptionItem;
import com.openbravo.format.Formats;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.util.FilerUtils;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import javafx.scene.image.Image;

public class OptionItem
implements IOptionItem {
    private final String SIZE_IMAGE_128 = "_128px";
    private SupplementItemInfo option;
    private HashMap<Integer, SoftReference> refOptions;
    private FilerUtils m_FilerUtils = null;

    public OptionItem(SupplementItemInfo option, HashMap<Integer, SoftReference> refOptions) {
        this.option = option;
        this.refOptions = refOptions;
        this.m_FilerUtils = FilerUtils.getInstance();
    }

    @Override
    public String getName() {
        Object nameOption = this.option.getName().toUpperCase();
        if (this.option.getPrice_order() != 0.0) {
            nameOption = (String)nameOption + "\n" + Formats.CURRENCY.formatValue(this.option.getPrice_order());
        }
        return nameOption;
    }

    @Override
    public Image getImage(String Size2) {
        Image image_option = null;
        File image = null;
        if (this.refOptions.containsKey(this.option.getiD()) && this.refOptions.get(this.option.getiD()) != null) {
            image_option = (Image)this.refOptions.get(this.option.getiD()).get();
        }
        String resized_path = null;
        if (this.option.getPath() != null && !this.option.getPath().isEmpty()) {
            String name = this.option.getPath().replaceFirst("[.][^.]+$", "");
            String ext = this.option.getPath().substring(this.option.getPath().lastIndexOf(".") + 1);
            resized_path = name + Size2 + "." + ext;
        }
        if (image_option == null) {
            if (resized_path != null) {
                image = this.m_FilerUtils.getFileFullPath("images/supplements/" + resized_path);
            }
            if (!(image != null && image.exists() || this.option.getPath() == null)) {
                image = this.m_FilerUtils.getFileFullPath("images/supplements/" + this.option.getPath());
            }
            if (image != null && image.exists()) {
                image_option = new Image(image.toURI().toString());
            }
            if (image_option == null) {
                image_option = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/default_image_item.png"));
            }
            if (image_option != null) {
                if (!this.refOptions.containsKey(this.option.getiD())) {
                    this.refOptions.put(this.option.getiD(), new SoftReference<Image>(image_option));
                } else if (this.refOptions.get(this.option.getiD()) == null) {
                    this.refOptions.replace(this.option.getiD(), new SoftReference<Image>(image_option));
                }
            }
        }
        return image_option;
    }
}

