/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.ticket;

import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.CategoryInfo;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.SupplementInfo;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.ticket.SupplementProduct;
import com.openbravo.pos.util.FilerUtils;
import fr.protactile.procaisse.dao.entities.Allergene;
import fr.protactile.procaisse.dao.entities.AllergeneSupplement;
import fr.protactile.procaisse.dao.entities.ImageProduct;
import fr.protactile.procaisse.dao.entities.UberEatTimeTableInfo;
import fr.protactile.procaisse.dao.entities.UberEatWorkShiftInfo;
import fr.protactile.procaisse.services.UberEatTimeTableService;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class MenuUberBuilder {
    private List<CategoryInfo> categories;
    private List<SupplementInfo> groupsOptions;
    private JSONArray categories_array;
    private JSONArray menu_array;
    private JSONArray modifier_groups_array;
    private JSONArray items_array;
    private JSONObject displayOptionsOjbect;
    private String URL_IMAGE_PRODUCT;
    private String URL_IMAGE_OPTION;
    private List<String> days_of_week;
    private List<String> categoriesIds;
    private FilerUtils m_FilerUtils = FilerUtils.getInstance();
    private final String PLATFORM = "Platform";
    private List<UberEatTimeTableInfo> timestables;
    private UberEatTimeTableService mTimeTableService;
    private boolean rushour;
    private boolean checkImage;

    public MenuUberBuilder() {
        this.categories_array = new JSONArray();
        this.menu_array = new JSONArray();
        this.modifier_groups_array = new JSONArray();
        this.items_array = new JSONArray();
        this.displayOptionsOjbect = new JSONObject();
        long licenceId = AppLocal.getLicenceId();
        String POS_ID = String.valueOf(licenceId);
        this.URL_IMAGE_PRODUCT = "https://api1.biborne.com/resourcesOld/" + POS_ID + "/products/";
        this.URL_IMAGE_OPTION = "https://api1.biborne.com/resourcesOld/" + POS_ID + "/supplements/";
        this.days_of_week = new ArrayList<String>();
        this.days_of_week.add("monday");
        this.days_of_week.add("tuesday");
        this.days_of_week.add("wednesday");
        this.days_of_week.add("thursday");
        this.days_of_week.add("friday");
        this.days_of_week.add("saturday");
        this.days_of_week.add("sunday");
        this.categoriesIds = new ArrayList<String>();
        this.mTimeTableService = UberEatTimeTableService.getInstance();
        this.timestables = this.mTimeTableService.getTimesTable();
    }

    public MenuUberBuilder categories(List<CategoryInfo> categories) {
        this.categories = categories;
        return this;
    }

    public MenuUberBuilder groupsOptions(List<SupplementInfo> groupsOptions) {
        this.groupsOptions = groupsOptions;
        return this;
    }

    public MenuUberBuilder rushour(boolean rushour) {
        this.rushour = rushour;
        return this;
    }

    public MenuUberBuilder checkImage(boolean checkImage) {
        this.checkImage = checkImage;
        return this;
    }

    public MenuUberBuilder build() {
        for (SupplementInfo groupOptions : this.groupsOptions) {
            String text_id_groupOption = groupOptions.getId_global() != null && !groupOptions.getId_global().isEmpty() ? AppLocal.PREFIX_GROUPE_OPTION_NEW + groupOptions.getId_global() : AppLocal.PREFIX_GROUPE_OPTION_NEW + groupOptions.getiD();
            JSONObject groupOptionsObject = new JSONObject();
            JSONObject quantityInfoObject = new JSONObject();
            quantityInfoObject.put("overrides", (Object)new JSONArray());
            JSONObject quantityObject = new JSONObject();
            Iterator<ProductInfoExt> testObject = null;
            quantityObject.put("max_permitted", groupOptions.getHas_options() != false ? Integer.valueOf(groupOptions.getMax_options()) : JSONObject.NULL);
            quantityObject.put("min_permitted", groupOptions.getHas_options() != false ? Integer.valueOf(groupOptions.getMin_options()) : JSONObject.NULL);
            quantityObject.put("default_quantity", JSONObject.NULL);
            quantityObject.put("charge_above", JSONObject.NULL);
            quantityObject.put("refund_under", JSONObject.NULL);
            quantityInfoObject.put("quantity", (Object)quantityObject);
            JSONObject titleObject = new JSONObject();
            JSONObject translationsObject = new JSONObject();
            translationsObject.put("en_us", (Object)groupOptions.getName());
            titleObject.put("translations", (Object)translationsObject);
            groupOptionsObject.put("quantity_info", (Object)quantityInfoObject);
            groupOptionsObject.put("title", (Object)titleObject);
            groupOptionsObject.put("external_data", (Object)text_id_groupOption);
            JSONArray modifieOptionsArray = new JSONArray();
            for (SupplementItemInfo option : groupOptions.getItems()) {
                String external_data_option;
                if (option.getName() == null || option.getName().isEmpty()) continue;
                String id_option = option.getId_global() != null && !option.getId_global().isEmpty() ? AppLocal.PREFIX_OPTION_NEW + option.getId_global() : AppLocal.PREFIX_OPTION_NEW + String.valueOf(option.getiD());
                String string = external_data_option = option.getId_global() != null && !option.getId_global().isEmpty() ? AppLocal.PREFIX_OPTION_NEW + option.getId_global() : String.valueOf(option.getiD());
                String image = option.getImageUrl() != null && !option.getImageUrl().isEmpty() ? option.getImageUrl() : (option.getPath() != null ? this.URL_IMAGE_OPTION + option.getPath() : null);
                String[] allergens = this.getSupplementAllergens(option);
                JSONObject optionObject = this.getItemObject("", image, id_option, external_data_option, text_id_groupOption, option.getName().trim(), groupOptions.getNumber_click(), option.getPriceOption(null, "Platform"), null, 10, null, allergens);
                this.items_array.put((Object)optionObject);
                JSONObject modifierOptionsObject = new JSONObject();
                modifierOptionsObject.put("type", (Object)"ITEM");
                modifierOptionsObject.put("id", (Object)id_option);
                modifieOptionsArray.put((Object)modifierOptionsObject);
            }
            groupOptionsObject.put("modifier_options", (Object)modifieOptionsArray);
            groupOptionsObject.put("display_type", JSONObject.NULL);
            groupOptionsObject.put("id", (Object)text_id_groupOption);
            this.modifier_groups_array.put((Object)groupOptionsObject);
        }
        boolean id_category = true;
        for (CategoryInfo category : this.categories) {
            String text_id_category = category.getId_global() != null && !category.getId_global().isEmpty() ? AppLocal.PREFIX_CATEGORY_NEW + category.getId_global() : AppLocal.PREFIX_CATEGORY_NEW + category.getID();
            this.categoriesIds.add(text_id_category);
            JSONObject categoryObject = new JSONObject();
            JSONArray entitiesArray = new JSONArray();
            for (ProductInfoExt product : category.getProducts()) {
                ImageProduct imagePlatform = product.getImagePlatform();
                ImageProduct imagePOS = product.getImagePOS();
                String imagePlatformPath = imagePlatform != null ? imagePlatform.getPath() : null;
                String imagePlatformUrl = imagePlatform != null ? imagePlatform.getUrl() : null;
                String imagePOSPath = imagePOS != null ? imagePOS.getPath() : null;
                String imagePOSUrl = imagePOS != null ? imagePOS.getUrl() : null;
                double price = product.getPrice("Platform", AppLocal.TARIFF);
                if (this.rushour && price == 0.0) {
                    price = product.getPrice(null, AppLocal.TARIFF);
                }
                if (product.isMany_size() || price == 0.0) continue;
                String id_product = product.getId_global() != null && !product.getId_global().isEmpty() ? AppLocal.PREFIX_PRODUCT_NEW + product.getId_global() : AppLocal.PREFIX_PRODUCT_NEW + String.valueOf(product.getID());
                String external_data_product = product.getId_global() != null && !product.getId_global().isEmpty() ? AppLocal.PREFIX_PRODUCT_NEW + product.getId_global() : String.valueOf(product.getID());
                ArrayList<String> ids_group_option = new ArrayList<String>();
                for (SupplementProduct supplement : product.getSupplements()) {
                    String text_id_groupOption = supplement.getId_global() != null && !supplement.getId_global().isEmpty() ? AppLocal.PREFIX_GROUPE_OPTION_NEW + supplement.getId_global() : AppLocal.PREFIX_GROUPE_OPTION_NEW + supplement.getiD();
                    ids_group_option.add(text_id_groupOption);
                }
                Object image = null;
                Object image_uber = null;
                if (imagePlatformUrl != null && !imagePlatformUrl.isEmpty()) {
                    image_uber = imagePlatformUrl;
                } else if (imagePlatformPath != null && !imagePlatformPath.isEmpty()) {
                    image_uber = this.URL_IMAGE_PRODUCT + imagePlatformPath;
                }
                if (imagePOSUrl != null && !imagePOSUrl.isEmpty()) {
                    image = imagePOSUrl;
                } else if (imagePOSPath != null && !imagePOSPath.isEmpty()) {
                    image = this.URL_IMAGE_PRODUCT + imagePOSPath;
                }
                String description = product.getDescription_uberEat() != null ? product.getDescription_uberEat() : (product.getDescription() != null ? product.getDescription() : "");
                String[] allergens = this.getProductAllergens(product);
                JSONObject optionObject = this.getItemObject(description, (String)image_uber, id_product, external_data_product, null, product.getName(), 0, price, ids_group_option, product.getTax_rate(), (String)image, allergens);
                this.items_array.put((Object)optionObject);
                JSONObject entityObject = new JSONObject();
                entityObject.put("type", (Object)"ITEM");
                entityObject.put("id", (Object)id_product);
                entitiesArray.put((Object)entityObject);
            }
            categoryObject.put("entities", (Object)entitiesArray);
            categoryObject.put("id", (Object)text_id_category);
            JSONObject titleCategoryObject = new JSONObject();
            JSONObject translationsTitleObject = new JSONObject();
            translationsTitleObject.put("en_us", (Object)category.getName());
            titleCategoryObject.put("translations", (Object)translationsTitleObject);
            categoryObject.put("title", (Object)titleCategoryObject);
            this.categories_array.put((Object)categoryObject);
        }
        this.buildMenu();
        return this;
    }

    public JSONObject getMenuObject() {
        JSONObject menuObject = new JSONObject();
        this.displayOptionsOjbect.put("disable_item_instructions", false);
        menuObject.put("items", (Object)this.items_array);
        menuObject.put("display_options", (Object)this.displayOptionsOjbect);
        menuObject.put("menus", (Object)this.menu_array);
        menuObject.put("categories", (Object)this.categories_array);
        menuObject.put("modifier_groups", (Object)this.modifier_groups_array);
        return menuObject;
    }

    private JSONObject getItemObject(String description, String image_uber, String id_item, String external_data, String id_group_option, String name, int number_option, double price, List<String> id_groups_options, int tax, String image, String[] allergens) {
        boolean send_image;
        JSONObject itemObject = new JSONObject();
        JSONObject descriptionOptionObject = new JSONObject();
        JSONObject translationsDescriotionObject = new JSONObject();
        translationsDescriotionObject.put("en_us", (Object)description);
        descriptionOptionObject.put("translations", (Object)translationsDescriotionObject);
        itemObject.put("description", (Object)descriptionOptionObject);
        JSONObject titleOptionObject = new JSONObject();
        JSONObject translationsTitleObject = new JSONObject();
        translationsTitleObject.put("en_us", (Object)name);
        titleOptionObject.put("translations", (Object)translationsTitleObject);
        itemObject.put("title", (Object)titleOptionObject);
        JSONObject nutritionalInfoObject = new JSONObject();
        if (allergens != null) {
            nutritionalInfoObject.put("allergens", (Object)allergens);
        } else {
            nutritionalInfoObject.put("allergens", JSONObject.NULL);
        }
        nutritionalInfoObject.put("kilojoules", JSONObject.NULL);
        nutritionalInfoObject.put("calories", JSONObject.NULL);
        itemObject.put("nutritional_info", (Object)nutritionalInfoObject);
        JSONObject optionQuantityInfoObject = null;
        if (id_group_option != null) {
            optionQuantityInfoObject = new JSONObject();
            JSONArray overridesArray = new JSONArray();
            JSONObject overrideObject = new JSONObject();
            overrideObject.put("context_type", (Object)"MODIFIER_GROUP");
            overrideObject.put("context_value", (Object)id_group_option);
            JSONObject quantityOptionObject = new JSONObject();
            quantityOptionObject.put("max_permitted", number_option);
            quantityOptionObject.put("min_permitted", JSONObject.NULL);
            quantityOptionObject.put("default_quantity", JSONObject.NULL);
            quantityOptionObject.put("charge_above", JSONObject.NULL);
            quantityOptionObject.put("refund_under", JSONObject.NULL);
            overrideObject.put("quantity", (Object)quantityOptionObject);
            overridesArray.put((Object)overrideObject);
            optionQuantityInfoObject.put("overrides", (Object)overridesArray);
            optionQuantityInfoObject.put("quantity", JSONObject.NULL);
        }
        itemObject.put("quantity_info", optionQuantityInfoObject == null ? JSONObject.NULL : optionQuantityInfoObject);
        itemObject.put("external_data", (Object)String.valueOf(id_item));
        itemObject.put("suspension_info", JSONObject.NULL);
        JSONObject modifierGroupIdsObject = new JSONObject();
        modifierGroupIdsObject.put("overrides", (Object)new JSONArray());
        if (id_groups_options != null && !id_groups_options.isEmpty()) {
            String[] idsArray = new String[id_groups_options.size()];
            int index = 0;
            Iterator<String> iterator = id_groups_options.iterator();
            while (iterator.hasNext()) {
                String id_group_options;
                idsArray[index] = id_group_options = iterator.next();
                ++index;
            }
            modifierGroupIdsObject.put("ids", (Object)idsArray);
        } else {
            modifierGroupIdsObject.put("ids", JSONObject.NULL);
        }
        itemObject.put("modifier_group_ids", (Object)modifierGroupIdsObject);
        String image_to_send = null;
        boolean bl = send_image = this.checkImage ? this.checkIfImageExist(image_uber) : true;
        if (!send_image && image != null) {
            send_image = this.checkIfImageExist(image);
            image_to_send = image;
        } else {
            image_to_send = image_uber;
        }
        itemObject.put("image_url", send_image ? image_to_send : JSONObject.NULL);
        JSONObject optionPriceInfoObject = new JSONObject();
        int priceinfo = (int)Math.round(price * 100.0);
        optionPriceInfoObject.put("price", priceinfo);
        JSONArray priceOverridesArray = new JSONArray();
        optionPriceInfoObject.put("overrides", (Object)priceOverridesArray);
        itemObject.put("price_info", (Object)optionPriceInfoObject);
        JSONObject taxInfoObject = new JSONObject();
        taxInfoObject.put("tax_rate", tax);
        taxInfoObject.put("vat_rate_percentage", JSONObject.NULL);
        itemObject.put("tax_info", (Object)taxInfoObject);
        itemObject.put("id", (Object)id_item);
        return itemObject;
    }

    private void buildMenu() {
        Object serviceAvailabilityObject;
        JSONObject menuObject = new JSONObject();
        JSONArray serviceAvailabilityArray = new JSONArray();
        for (UberEatTimeTableInfo timetable : this.timestables) {
            if (timetable.getDay_off().booleanValue()) continue;
            serviceAvailabilityObject = new JSONObject();
            JSONArray timePeriodesArray = new JSONArray();
            if (timetable.getWorkShiftCollection() != null) {
                ArrayList<UberEatWorkShiftInfo> workShifts = new ArrayList<UberEatWorkShiftInfo>();
                workShifts.addAll(timetable.getWorkShiftCollection());
                Collections.sort(workShifts, new Comparator<UberEatWorkShiftInfo>(){

                    @Override
                    public int compare(UberEatWorkShiftInfo workShift1, UberEatWorkShiftInfo workShift2) {
                        return workShift1.getId() - workShift2.getId();
                    }
                });
                int index_work_shift = 0;
                for (UberEatWorkShiftInfo workShiftInfo : timetable.getWorkShiftCollection()) {
                    ++index_work_shift;
                    if (workShiftInfo.getStart_shift() != null && !workShiftInfo.getStart_shift().isEmpty() && workShiftInfo.getEnd_shift() != null && !workShiftInfo.getEnd_shift().isEmpty()) {
                        boolean exist = false;
                        for (int i = 0; i < timePeriodesArray.length(); ++i) {
                            String endShiftCheck;
                            JSONObject timePeriodObjectCheck = timePeriodesArray.getJSONObject(i);
                            String startShiftCheck = timePeriodObjectCheck.isNull("start_time") ? "" : timePeriodObjectCheck.getString("start_time");
                            String string = endShiftCheck = timePeriodObjectCheck.isNull("end_time") ? "" : timePeriodObjectCheck.getString("end_time");
                            if (!workShiftInfo.getStart_shift().equals(startShiftCheck) || !workShiftInfo.getEnd_shift().equals(endShiftCheck)) continue;
                            exist = true;
                            break;
                        }
                        if (exist) continue;
                        JSONObject timePeriodObject = new JSONObject();
                        timePeriodObject.put("start_time", (Object)workShiftInfo.getStart_shift());
                        timePeriodObject.put("end_time", (Object)workShiftInfo.getEnd_shift());
                        timePeriodesArray.put((Object)timePeriodObject);
                    }
                    if (index_work_shift < 3) continue;
                    break;
                }
                System.out.println("timePeriodesArray : " + timePeriodesArray);
            }
            serviceAvailabilityObject.put("time_periods", (Object)timePeriodesArray);
            serviceAvailabilityObject.put("day_of_week", (Object)timetable.getName_day());
            serviceAvailabilityArray.put(serviceAvailabilityObject);
        }
        menuObject.put("service_availability", (Object)serviceAvailabilityArray);
        String[] categoryIdsArray = new String[this.categoriesIds.size()];
        int index = 0;
        serviceAvailabilityObject = this.categoriesIds.iterator();
        while (serviceAvailabilityObject.hasNext()) {
            String categoryId;
            categoryIdsArray[index] = categoryId = (String)serviceAvailabilityObject.next();
            ++index;
        }
        menuObject.put("category_ids", (Object)categoryIdsArray);
        menuObject.put("id", (Object)"All-day");
        JSONObject titleMenuObject = new JSONObject();
        JSONObject translationsTitleObject = new JSONObject();
        translationsTitleObject.put("en_us", (Object)"All day");
        titleMenuObject.put("translations", (Object)translationsTitleObject);
        menuObject.put("title", (Object)titleMenuObject);
        this.menu_array.put((Object)menuObject);
    }

    public MenuUberBuilder buildEmptyMenu() {
        this.buildMenu();
        return this;
    }

    private boolean checkIfImageExist(String image) {
        if (image != null) {
            try {
                System.out.println("image : " + image);
                URL url = new URL(image);
                HttpURLConnection huc = (HttpURLConnection)url.openConnection();
                int responseCode = huc.getResponseCode();
                return responseCode == 200;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private String[] getSupplementAllergens(SupplementItemInfo option) {
        if (option != null && option.getAllergenes() != null && !option.getAllergenes().isEmpty()) {
            String[] allergenArray = new String[option.getAllergenes().size()];
            int index = 0;
            for (AllergeneSupplement allergeneSupplement : option.getAllergenes()) {
                allergenArray[index] = allergeneSupplement.getName();
                ++index;
            }
            return allergenArray;
        }
        return null;
    }

    private String[] getProductAllergens(ProductInfoExt product) {
        if (product != null && product.getAllergenes() != null && !product.getAllergenes().isEmpty()) {
            String[] allergenArray = new String[product.getAllergenes().size()];
            int index = 0;
            for (Allergene allergen : product.getAllergenes()) {
                allergenArray[index] = allergen.getName();
                ++index;
            }
            return allergenArray;
        }
        return null;
    }
}

