/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.ticket;

import com.openbravo.beans.CarteMenu;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.CarteInfo;
import com.openbravo.pos.ticket.CarteItemInfo;
import com.openbravo.pos.ticket.CarteOrderInfo;
import com.openbravo.pos.ticket.CategoryInfo;
import com.openbravo.pos.ticket.GroupSubSupplementInfo;
import com.openbravo.pos.ticket.ProductDayOn;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.ProductPriceInfo;
import com.openbravo.pos.ticket.ProductSizeInfo;
import com.openbravo.pos.ticket.PromotionInfo;
import com.openbravo.pos.ticket.SupplementInfo;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.ticket.SupplementPriceInfo;
import com.openbravo.pos.ticket.SupplementProduct;
import fr.protactile.procaisse.dao.entities.ImageProduct;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.simple.JSONObject;

public class MenuDishopBuilder {
    private List<CategoryInfo> categories;
    private List<ProductInfoExt> products;
    private List<SupplementInfo> options;
    private List<CarteInfo> cartes;
    private List<CarteMenu> cartesMenu;
    private List<GroupSubSupplementInfo> groupsSubSupplements;
    private List<PromotionInfo> promotions;
    private org.json.JSONObject jsonMenu = new org.json.JSONObject();
    private String URL_IMAGE_PRODUCT;
    private String URL_IMAGE_OPTION;
    private String URL_IMAGE_CATEGORIES;
    private String URL_IMAGE_INGREDIENTS;
    private final String AT_SPOT = "Sur Place";
    private final String TAKE_AWAY = "A Emporter";
    private final String DELIVERY = "En Livraison";

    public MenuDishopBuilder() {
        long licenceId = AppLocal.getLicenceId();
        String POS_ID = String.valueOf(licenceId);
        this.URL_IMAGE_PRODUCT = "https://api1.biborne.com/resourcesOld/" + POS_ID + "/products/";
        this.URL_IMAGE_OPTION = "https://api1.biborne.com/resourcesOld/" + POS_ID + "/supplements/";
        this.URL_IMAGE_CATEGORIES = "https://api1.biborne.com/resourcesOld/" + POS_ID + "/catagories/";
        this.URL_IMAGE_INGREDIENTS = "https://api1.biborne.com/resourcesOld/" + POS_ID + "/ingredients/";
    }

    public MenuDishopBuilder categories(List<CategoryInfo> categories) {
        this.categories = categories;
        return this;
    }

    public MenuDishopBuilder products(List<ProductInfoExt> products) {
        this.products = products;
        return this;
    }

    public MenuDishopBuilder options(List<SupplementInfo> options) {
        this.options = options;
        return this;
    }

    public MenuDishopBuilder cartes(List<CarteInfo> cartes) {
        this.cartes = cartes;
        return this;
    }

    public MenuDishopBuilder cartesMenu(List<CarteMenu> cartesMenu) {
        this.cartesMenu = cartesMenu;
        return this;
    }

    public MenuDishopBuilder groupsSubSupplements(List<GroupSubSupplementInfo> groupsSubSupplements) {
        this.groupsSubSupplements = groupsSubSupplements;
        return this;
    }

    public MenuDishopBuilder promotions(List<PromotionInfo> promotions) {
        this.promotions = promotions;
        return this;
    }

    private boolean checkImage(String image) {
        return this.checkImage(image, false);
    }

    private boolean checkImage(String image, boolean log) {
        if (image != null) {
            try {
                URL url = new URL(image);
                HttpURLConnection huc = (HttpURLConnection)url.openConnection();
                int responseCode = huc.getResponseCode();
                if (log) {
                    System.out.println("huc : " + huc.getResponseMessage());
                    System.out.println("image : " + image);
                    System.out.println("responseCode : " + responseCode);
                }
                return responseCode == 200;
            }
            catch (Exception e) {
                System.out.println("image : " + image);
                return false;
            }
        }
        return false;
    }

    private org.json.JSONObject getJsonCategory(CategoryInfo categoryInfo) {
        org.json.JSONObject jsonCategory = new org.json.JSONObject();
        jsonCategory.put("name", (Object)categoryInfo.getName());
        jsonCategory.put("position", categoryInfo.getOrdercategory());
        jsonCategory.put("parent_id_global", (Object)categoryInfo.getParent_id_global());
        jsonCategory.put("sold_out", categoryInfo.isSold_out());
        jsonCategory.put("display_time", categoryInfo.isHas_display_time());
        jsonCategory.put("first_period", categoryInfo.getFirst_period());
        jsonCategory.put("end_period", categoryInfo.getEnd_period());
        jsonCategory.put("has_sub_categories", !categoryInfo.getSub_categories().isEmpty());
        jsonCategory.put("id_global", (Object)categoryInfo.getId_global());
        Object image_url = null;
        image_url = categoryInfo.getImageUrl() != null && !categoryInfo.getImageUrl().isEmpty() ? categoryInfo.getImageUrl() : (categoryInfo.getPath() != null && !categoryInfo.getPath().isEmpty() && this.checkImage(this.URL_IMAGE_CATEGORIES + categoryInfo.getPath()) ? this.URL_IMAGE_CATEGORIES + categoryInfo.getPath() : null);
        jsonCategory.put("image_url", image_url != null ? image_url : org.json.JSONObject.NULL);
        return jsonCategory;
    }

    public MenuDishopBuilder build() {
        JSONArray jsonAllCategories = new JSONArray();
        for (CategoryInfo categoryInfo : this.categories) {
            org.json.JSONObject jSONObject = this.getJsonCategory(categoryInfo);
            jsonAllCategories.put((Object)jSONObject);
            for (CategoryInfo categoryInfo2 : categoryInfo.getSub_categories()) {
                org.json.JSONObject jsonSubCategory = this.getJsonCategory(categoryInfo2);
                jsonAllCategories.put((Object)jsonSubCategory);
            }
        }
        JSONArray jsonAllItems = new JSONArray();
        for (ProductInfoExt productInfoExt : this.products) {
            Object promotion2;
            Object carteProduct2;
            Object imagePOSUrl;
            if (productInfoExt.isProduct_ubereat()) continue;
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"idItem", (Object)productInfoExt.getID());
            jSONObject.put((Object)"id_global_category", (Object)productInfoExt.getId_global_category());
            jSONObject.put((Object)"position", (Object)productInfoExt.getOrder_item());
            jSONObject.put((Object)"name", (Object)productInfoExt.getName());
            jSONObject.put((Object)"tax", (Object)productInfoExt.getRate_tax());
            jSONObject.put((Object)"is_menu", (Object)productInfoExt.isMenu());
            jSONObject.put((Object)"many_size", (Object)productInfoExt.isMany_size());
            jSONObject.put((Object)"different_price", (Object)productInfoExt.isDifferent_price());
            jSONObject.put((Object)"tax_emp", (Object)productInfoExt.getRate_tax_emp());
            jSONObject.put((Object)"tax_lv", (Object)productInfoExt.getRate_tax_lv());
            jSONObject.put((Object)"sold_out", (Object)productInfoExt.isSold_out());
            jSONObject.put((Object)"free_price", (Object)productInfoExt.isFree_price());
            jSONObject.put((Object)"display_time", (Object)productInfoExt.isHas_display_time());
            jSONObject.put((Object)"first_period", (Object)productInfoExt.getFirst_period());
            jSONObject.put((Object)"end_period", (Object)productInfoExt.getEnd_period());
            jSONObject.put((Object)"description", (Object)productInfoExt.getDescription());
            jSONObject.put((Object)"has_timetable", (Object)productInfoExt.isHas_timetable());
            jSONObject.put((Object)"product_loyalty", (Object)productInfoExt.isProduct_loyalty());
            jSONObject.put((Object)"price_point", (Object)productInfoExt.getPrice_point());
            jSONObject.put((Object)"id_global", (Object)productInfoExt.getId_global());
            ImageProduct imageProduct = productInfoExt.getImagePlatform();
            String imagePlatformPath = imageProduct != null ? imageProduct.getPath() : null;
            String imagePlatformUrl = imageProduct != null ? imageProduct.getUrl() : null;
            Object image_item = null;
            if (imagePlatformUrl != null && !imagePlatformUrl.isEmpty()) {
                image_item = imagePlatformUrl;
            } else if (imagePlatformPath != null && !imagePlatformPath.isEmpty()) {
                image_item = this.URL_IMAGE_PRODUCT + imagePlatformPath;
            }
            if (image_item == null || ((String)image_item).isEmpty()) {
                ImageProduct imageProduct2 = productInfoExt.getImagePOS();
                String imagePOSPath = imageProduct2 != null ? imageProduct2.getPath() : null;
                Object object = imagePOSUrl = imageProduct2 != null ? imageProduct2.getUrl() : null;
                if (imagePOSUrl != null && !((String)imagePOSUrl).isEmpty()) {
                    image_item = imagePOSUrl;
                } else if (imagePOSPath != null && !imagePOSPath.isEmpty()) {
                    image_item = this.URL_IMAGE_PRODUCT + imagePOSPath;
                }
            }
            Object object = image_item != null && !((String)image_item).isEmpty() && this.checkImage((String)image_item) ? image_item : null;
            jSONObject.put((Object)"image_url", object != null ? object : org.json.JSONObject.NULL);
            JSONArray jsonAllIngredientsProduct = new JSONArray();
            imagePOSUrl = productInfoExt.getIngredients().iterator();
            while (imagePOSUrl.hasNext()) {
                SupplementItemInfo ingredient = (SupplementItemInfo)imagePOSUrl.next();
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put((Object)"id_ingredient", (Object)ingredient.getiD());
                jSONObject2.put((Object)"id_global_ingredient", (Object)ingredient.getId_global());
                jSONObject2.put((Object)"name", (Object)ingredient.getName());
                jsonAllIngredientsProduct.put((Map)jSONObject2);
            }
            JSONArray jsonAllSupplementsProduct = new JSONArray();
            for (SupplementProduct supplementProduct : productInfoExt.getSupplements()) {
                if (supplementProduct.isSupplement_ubereat()) continue;
                JSONObject jsonSupplementItem = new JSONObject();
                jsonSupplementItem.put((Object)"idSupplement", (Object)supplementProduct.getiD());
                jsonSupplementItem.put((Object)"id_global_supplement", (Object)supplementProduct.getId_global());
                jsonSupplementItem.put((Object)"free_able", (Object)supplementProduct.isFree_able());
                jsonSupplementItem.put((Object)"option_free", (Object)supplementProduct.getOption_free());
                jsonSupplementItem.put((Object)"has_limit_options", (Object)supplementProduct.getHas_options());
                jsonSupplementItem.put((Object)"min_option", (Object)supplementProduct.getMin_options());
                jsonSupplementItem.put((Object)"max_option", (Object)supplementProduct.getMax_options());
                jsonSupplementItem.put((Object)"option_free_size2", (Object)supplementProduct.getOption_free_size2());
                jsonSupplementItem.put((Object)"min_option_size2", (Object)supplementProduct.getMin_options_size2());
                jsonSupplementItem.put((Object)"max_option_size2", (Object)supplementProduct.getMax_options_size2());
                jsonSupplementItem.put((Object)"option_free_size3", (Object)supplementProduct.getOption_free_size3());
                jsonSupplementItem.put((Object)"min_option_size3", (Object)supplementProduct.getMin_options_size3());
                jsonSupplementItem.put((Object)"max_option_size3", (Object)supplementProduct.getMax_options_size3());
                jsonSupplementItem.put((Object)"option_free_size4", (Object)supplementProduct.getOption_free_size4());
                jsonSupplementItem.put((Object)"min_option_size4", (Object)supplementProduct.getMin_options_size4());
                jsonSupplementItem.put((Object)"max_option_size4", (Object)supplementProduct.getMax_options_size4());
                jsonSupplementItem.put((Object)"option_free_size5", (Object)supplementProduct.getOption_free_size5());
                jsonSupplementItem.put((Object)"min_option_size5", (Object)supplementProduct.getMin_options_size5());
                jsonSupplementItem.put((Object)"max_option_size5", (Object)supplementProduct.getMax_options_size5());
                jsonSupplementItem.put((Object)"option_free_size6", (Object)supplementProduct.getOption_free_size6());
                jsonSupplementItem.put((Object)"min_option_size6", (Object)supplementProduct.getMin_options_size6());
                jsonSupplementItem.put((Object)"max_option_size6", (Object)supplementProduct.getMax_options_size6());
                jsonSupplementItem.put((Object)"many_size", (Object)supplementProduct.isMany_size());
                jsonSupplementItem.put((Object)"option_free_size7", (Object)supplementProduct.getOption_free_size7());
                jsonSupplementItem.put((Object)"min_option_size7", (Object)supplementProduct.getMin_options_size7());
                jsonSupplementItem.put((Object)"max_option_size7", (Object)supplementProduct.getMax_options_size7());
                jsonSupplementItem.put((Object)"option_free_size8", (Object)supplementProduct.getOption_free_size8());
                jsonSupplementItem.put((Object)"min_option_size8", (Object)supplementProduct.getMin_options_size8());
                jsonSupplementItem.put((Object)"max_option_size8", (Object)supplementProduct.getMax_options_size8());
                jsonSupplementItem.put((Object)"option_free_size9", (Object)supplementProduct.getOption_free_size9());
                jsonSupplementItem.put((Object)"min_option_size9", (Object)supplementProduct.getMin_options_size9());
                jsonSupplementItem.put((Object)"max_option_size9", (Object)supplementProduct.getMax_options_size9());
                jsonSupplementItem.put((Object)"option_free_size10", (Object)supplementProduct.getOption_free_size10());
                jsonSupplementItem.put((Object)"min_option_size10", (Object)supplementProduct.getMin_options_size10());
                jsonSupplementItem.put((Object)"max_option_size10", (Object)supplementProduct.getMax_options_size10());
                jsonAllSupplementsProduct.put((Map)jsonSupplementItem);
            }
            JSONArray jsonAllCarteProduct = new JSONArray();
            for (Object carteProduct2 : productInfoExt.getCartes()) {
                JSONObject jSONObject3 = new JSONObject();
                jSONObject3.put((Object)"id_carte", (Object)((CarteOrderInfo)carteProduct2).getId());
                jSONObject3.put((Object)"id_global_carte", (Object)((CarteOrderInfo)carteProduct2).getId_global());
                jSONObject3.put((Object)"name", (Object)((CarteOrderInfo)carteProduct2).getName());
                jSONObject3.put((Object)"number_carte", (Object)((CarteOrderInfo)carteProduct2).getNumber_carte());
                jSONObject3.put((Object)"order_carte", (Object)((CarteOrderInfo)carteProduct2).getOrderCarte());
                jsonAllCarteProduct.put((Map)jSONObject3);
            }
            JSONArray jSONArray = new JSONArray();
            carteProduct2 = productInfoExt.getAdditional_sales().iterator();
            while (carteProduct2.hasNext()) {
                ProductInfoExt productInfoExt2 = (ProductInfoExt)carteProduct2.next();
                if (productInfoExt2.isProduct_ubereat()) continue;
                jSONArray.put((Object)productInfoExt2.getId_global());
            }
            JSONArray jsonPromotions = new JSONArray();
            for (Object promotion2 : productInfoExt.getPromotions()) {
                JSONObject jSONObject4 = new JSONObject();
                jSONObject4.put((Object)"id", (Object)((PromotionInfo)promotion2).getId());
                jSONObject4.put((Object)"id_global_promotion", (Object)((PromotionInfo)promotion2).getId_global());
                jSONObject4.put((Object)"name_promotion", (Object)((PromotionInfo)promotion2).getName_promotion());
                jSONObject4.put((Object)"type_order", (Object)((PromotionInfo)promotion2).getType_order());
                jSONObject4.put((Object)"size_product", (Object)((PromotionInfo)promotion2).getSize_product());
                jSONObject4.put((Object)"quantity", (Object)((PromotionInfo)promotion2).getQuantity());
                jSONObject4.put((Object)"discount", (Object)((PromotionInfo)promotion2).getDiscount());
                jsonPromotions.put((Map)jSONObject4);
            }
            JSONArray jSONArray2 = new JSONArray();
            promotion2 = productInfoExt.getSub_products().iterator();
            while (promotion2.hasNext()) {
                ProductInfoExt productInfoExt3 = (ProductInfoExt)promotion2.next();
                if (productInfoExt3.isProduct_ubereat()) continue;
                JSONObject jsonSubProduct = new JSONObject();
                jsonSubProduct.put((Object)"id_sub_product", (Object)productInfoExt3.getID());
                System.out.println("sub_product.getId_global() : " + productInfoExt3.getId_global());
                jsonSubProduct.put((Object)"id_global_sub_product", (Object)productInfoExt3.getId_global());
                jsonSubProduct.put((Object)"number_exemplary", (Object)productInfoExt3.getNumber_exemplary());
                jSONArray2.put((Map)jsonSubProduct);
            }
            JSONArray jsonDaysOn = new JSONArray();
            for (Object mProductDayOn : productInfoExt.getDaysOn()) {
                JSONObject jsonProductDayOn = new JSONObject();
                jsonProductDayOn.put((Object)"id", (Object)((ProductDayOn)mProductDayOn).getId());
                jsonProductDayOn.put((Object)"day_of_week", (Object)((ProductDayOn)mProductDayOn).getDay_of_week());
                jsonProductDayOn.put((Object)"id_product", (Object)((ProductDayOn)mProductDayOn).getId_product());
                jsonDaysOn.put((Map)jsonProductDayOn);
            }
            JSONArray jSONArray3 = new JSONArray();
            if (productInfoExt.isMany_size()) {
                Object mProductDayOn;
                mProductDayOn = productInfoExt.getListSizes().iterator();
                while (mProductDayOn.hasNext()) {
                    ProductSizeInfo sizeProduct = (ProductSizeInfo)mProductDayOn.next();
                    if (!sizeProduct.isSize_enabled()) continue;
                    JSONObject jsonSizeProduct = new JSONObject();
                    jsonSizeProduct.put((Object)"name_size", (Object)sizeProduct.getName());
                    jsonSizeProduct.put((Object)"label_size", (Object)sizeProduct.getLabel_size());
                    jsonSizeProduct.put((Object)"price", (Object)sizeProduct.getPrice());
                    jsonSizeProduct.put((Object)"price_sp", (Object)sizeProduct.getPrice_sp());
                    jsonSizeProduct.put((Object)"price_emp", (Object)sizeProduct.getPrice_emp());
                    jsonSizeProduct.put((Object)"price_lv", (Object)sizeProduct.getPrice_lv());
                    jsonSizeProduct.put((Object)"size_enabled", (Object)sizeProduct.isSize_enabled());
                    jSONArray3.put((Map)jsonSizeProduct);
                }
            }
            JSONArray jsonPricesProduct = new JSONArray();
            for (ProductPriceInfo productPrice : productInfoExt.getPrices()) {
                JSONObject jsonProductPrice = new JSONObject();
                jsonProductPrice.put((Object)"id", (Object)productPrice.getId());
                jsonProductPrice.put((Object)"price", (Object)productPrice.getPrice());
                jsonProductPrice.put((Object)"type_order", (Object)productPrice.getType_order());
                jsonProductPrice.put((Object)"id_product", (Object)productPrice.getIdProduct());
                jsonPricesProduct.put((Map)jsonProductPrice);
            }
            jSONObject.put((Object)"ingredients", (Object)jsonAllIngredientsProduct);
            jSONObject.put((Object)"options", (Object)jsonAllSupplementsProduct);
            jSONObject.put((Object)"carte", (Object)jsonAllCarteProduct);
            jSONObject.put((Object)"additionals", (Object)jSONArray);
            jSONObject.put((Object)"promotions", (Object)jsonPromotions);
            jSONObject.put((Object)"sub_products", (Object)jSONArray2);
            jSONObject.put((Object)"daysOn", (Object)jsonDaysOn);
            jSONObject.put((Object)"allSizes", (Object)jSONArray3);
            jSONObject.put((Object)"prices", (Object)jsonPricesProduct);
            jsonAllItems.put((Map)jSONObject);
        }
        JSONArray jSONArray = new JSONArray();
        for (SupplementInfo supplementInfo : this.options) {
            if (supplementInfo.isSupplement_ubereat()) continue;
            String string = supplementInfo.getIs_ingredient() != false ? this.URL_IMAGE_INGREDIENTS : this.URL_IMAGE_OPTION;
            JSONObject jsonOption = new JSONObject();
            jsonOption.put((Object)"id", (Object)supplementInfo.getiD());
            jsonOption.put((Object)"name", (Object)supplementInfo.getName());
            jsonOption.put((Object)"has_options", (Object)supplementInfo.getHas_options());
            jsonOption.put((Object)"min_items", (Object)supplementInfo.getMin_options());
            jsonOption.put((Object)"max_items", (Object)supplementInfo.getMax_options());
            jsonOption.put((Object)"is_ingredient", (Object)supplementInfo.getIs_ingredient());
            jsonOption.put((Object)"position", (Object)supplementInfo.getOrderSupplement());
            jsonOption.put((Object)"color", (Object)supplementInfo.getColor());
            jsonOption.put((Object)"number_click", (Object)supplementInfo.getNumber_click());
            jsonOption.put((Object)"prepared", (Object)supplementInfo.isPrepared());
            jsonOption.put((Object)"printer", (Object)supplementInfo.getPrinter());
            jsonOption.put((Object)"alphabetical_order", (Object)supplementInfo.isOrder_name());
            jsonOption.put((Object)"order_name", (Object)supplementInfo.isOrder_name());
            jsonOption.put((Object)"display_free", (Object)supplementInfo.isDisplay_free());
            jsonOption.put((Object)"id_global", (Object)supplementInfo.getId_global());
            JSONArray jsonOptionItems = new JSONArray();
            for (SupplementItemInfo supplementItemInfo : supplementInfo.getItems()) {
                if (supplementItemInfo.isSupplement_item_ubereat()) continue;
                JSONObject jsonOptionItem = new JSONObject();
                jsonOptionItem.put((Object)"id", (Object)supplementItemInfo.getiD());
                jsonOptionItem.put((Object)"name", (Object)supplementItemInfo.getName());
                jsonOptionItem.put((Object)"price", (Object)(supplementItemInfo.isMany_size() || supplementItemInfo.isMany_type() ? 0.0 : supplementItemInfo.getPrice()));
                JSONArray jsonAllSizesOption = new JSONArray();
                if (supplementItemInfo.isMany_size()) {
                    if (AppLocal.PRODUCT_SIZE_JUNIOR_ENABLED) {
                        org.json.JSONObject jsonSize_1 = this.geJsonSizeOption("junior", AppLocal.PRODUCT_SIZE_JUNIOR, supplementItemInfo.getPrice_junior(), supplementItemInfo.getSupplementPrices(), supplementItemInfo.isMany_type());
                        jsonAllSizesOption.put((Object)jsonSize_1);
                    }
                    if (AppLocal.PRODUCT_SIZE_SENIOR_ENABLED) {
                        org.json.JSONObject jsonSize_2 = this.geJsonSizeOption("senior", AppLocal.PRODUCT_SIZE_SENIOR, supplementItemInfo.getPrice_senior(), supplementItemInfo.getSupplementPrices(), supplementItemInfo.isMany_type());
                        jsonAllSizesOption.put((Object)jsonSize_2);
                    }
                    if (AppLocal.PRODUCT_SIZE_MEGA_ENABLED) {
                        org.json.JSONObject jsonSize_3 = this.geJsonSizeOption("mega", AppLocal.PRODUCT_SIZE_MEGA, supplementItemInfo.getPrice_mega(), supplementItemInfo.getSupplementPrices(), supplementItemInfo.isMany_type());
                        jsonAllSizesOption.put((Object)jsonSize_3);
                    }
                    if (AppLocal.PRODUCT_SIZE1_ENABLED) {
                        org.json.JSONObject jsonSize_4 = this.geJsonSizeOption("size1", AppLocal.PRODUCT_SIZE1, supplementItemInfo.getPrice_size1(), supplementItemInfo.getSupplementPrices(), supplementItemInfo.isMany_type());
                        jsonAllSizesOption.put((Object)jsonSize_4);
                    }
                    if (AppLocal.PRODUCT_SIZE2_ENABLED) {
                        org.json.JSONObject jsonSize_5 = this.geJsonSizeOption("size2", AppLocal.PRODUCT_SIZE2, supplementItemInfo.getPrice_size2(), supplementItemInfo.getSupplementPrices(), supplementItemInfo.isMany_type());
                        jsonAllSizesOption.put((Object)jsonSize_5);
                    }
                    if (AppLocal.PRODUCT_SIZE3_ENABLED) {
                        org.json.JSONObject jsonSize_6 = this.geJsonSizeOption("size3", AppLocal.PRODUCT_SIZE3, supplementItemInfo.getPrice_size3(), supplementItemInfo.getSupplementPrices(), supplementItemInfo.isMany_type());
                        jsonAllSizesOption.put((Object)jsonSize_6);
                    }
                    if (AppLocal.PRODUCT_SIZE4_ENABLED) {
                        org.json.JSONObject jsonSize_7 = this.geJsonSizeOption("size4", AppLocal.PRODUCT_SIZE4, supplementItemInfo.getPrice_size4(), supplementItemInfo.getSupplementPrices(), supplementItemInfo.isMany_type());
                        jsonAllSizesOption.put((Object)jsonSize_7);
                    }
                    if (AppLocal.PRODUCT_SIZE5_ENABLED) {
                        org.json.JSONObject jsonSize_8 = this.geJsonSizeOption("size5", AppLocal.PRODUCT_SIZE5, supplementItemInfo.getPrice_size5(), supplementItemInfo.getSupplementPrices(), supplementItemInfo.isMany_type());
                        jsonAllSizesOption.put((Object)jsonSize_8);
                    }
                    if (AppLocal.PRODUCT_SIZE6_ENABLED) {
                        org.json.JSONObject jsonSize_9 = this.geJsonSizeOption("size6", AppLocal.PRODUCT_SIZE6, supplementItemInfo.getPrice_size6(), supplementItemInfo.getSupplementPrices(), supplementItemInfo.isMany_type());
                        jsonAllSizesOption.put((Object)jsonSize_9);
                    }
                    if (AppLocal.PRODUCT_SIZE7_ENABLED) {
                        org.json.JSONObject jsonSize_10 = this.geJsonSizeOption("size7", AppLocal.PRODUCT_SIZE7, supplementItemInfo.getPrice_size7(), supplementItemInfo.getSupplementPrices(), supplementItemInfo.isMany_type());
                        jsonAllSizesOption.put((Object)jsonSize_10);
                    }
                }
                jsonOptionItem.put((Object)"removed", (Object)supplementItemInfo.isRemoved());
                jsonOptionItem.put((Object)"order_item", (Object)supplementItemInfo.getOrderItem());
                jsonOptionItem.put((Object)"many_size", (Object)supplementItemInfo.isMany_size());
                jsonOptionItem.put((Object)"many_type", (Object)supplementItemInfo.isMany_type());
                jsonOptionItem.put((Object)"sold_out", (Object)supplementItemInfo.isSold_out());
                jsonOptionItem.put((Object)"id_global", (Object)supplementItemInfo.getId_global());
                Object image_url = null;
                image_url = supplementItemInfo.getImageUrl() != null && !supplementItemInfo.getImageUrl().isEmpty() ? supplementItemInfo.getImageUrl() : (supplementItemInfo.getPath() != null && !supplementItemInfo.getPath().isEmpty() && this.checkImage(string + supplementItemInfo.getPath()) ? string + supplementItemInfo.getPath() : null);
                jsonOptionItem.put((Object)"image_url", image_url != null ? image_url : org.json.JSONObject.NULL);
                JSONArray jSONArray4 = new JSONArray();
                if (supplementItemInfo.isMany_type() && !supplementItemInfo.isMany_size()) {
                    for (SupplementPriceInfo supplementPriceInfo : supplementItemInfo.getSupplementPrices()) {
                        JSONObject jsonSupplementPrice = new JSONObject();
                        jsonSupplementPrice.put((Object)"type_order", (Object)supplementPriceInfo.getType_order());
                        jsonSupplementPrice.put((Object)"price", (Object)supplementPriceInfo.getPrice());
                        jSONArray4.put((Map)jsonSupplementPrice);
                    }
                }
                JSONArray jsonAllGrouSubOption = new JSONArray();
                for (GroupSubSupplementInfo groupSubSupplementInfo : supplementItemInfo.getGroupsSubSupplement()) {
                    jsonAllGrouSubOption.put((Object)groupSubSupplementInfo.getId_global());
                }
                jsonOptionItem.put((Object)"allSizes", (Object)jsonAllSizesOption);
                jsonOptionItem.put((Object)"prices", (Object)jSONArray4);
                jsonOptionItem.put((Object)"color", (Object)supplementItemInfo.getColor());
                jsonOptionItem.put((Object)"groups_sub_supplement", (Object)jsonAllGrouSubOption);
                jsonOptionItems.put((Map)jsonOptionItem);
            }
            jsonOption.put((Object)"items", (Object)jsonOptionItems);
            jSONArray.put((Map)jsonOption);
        }
        JSONArray jSONArray5 = new JSONArray();
        for (CarteInfo carteInfo : this.cartes) {
            JSONObject jsonCarte = new JSONObject();
            jsonCarte.put((Object)"id", (Object)carteInfo.getId());
            jsonCarte.put((Object)"name", (Object)carteInfo.getName());
            jsonCarte.put((Object)"size_carte", (Object)carteInfo.getSizeCarte());
            jsonCarte.put((Object)"id_global", (Object)carteInfo.getId_global());
            JSONArray jsonCarteItems = new JSONArray();
            for (CarteItemInfo carteItemInfo : carteInfo.getCarteItems()) {
                JSONObject jsonCarteItem = new JSONObject();
                jsonCarteItem.put((Object)"id_carte", (Object)carteItemInfo.getId_carte());
                jsonCarteItem.put((Object)"id_global_product", (Object)carteItemInfo.getId_global_item());
                jsonCarteItem.put((Object)"price", (Object)carteItemInfo.getPrice());
                jsonCarteItems.put((Map)jsonCarteItem);
            }
            jsonCarte.put((Object)"items", (Object)jsonCarteItems);
            jSONArray5.put((Map)jsonCarte);
        }
        JSONArray jSONArray6 = new JSONArray();
        for (GroupSubSupplementInfo groupSubSupplementInfo : this.groupsSubSupplements) {
            JSONObject jsonGroupSubOption = new JSONObject();
            jsonGroupSubOption.put((Object)"id", (Object)groupSubSupplementInfo.getId());
            jsonGroupSubOption.put((Object)"name_group", (Object)groupSubSupplementInfo.getName_group());
            jsonGroupSubOption.put((Object)"title_group", (Object)groupSubSupplementInfo.getTitle_group());
            jsonGroupSubOption.put((Object)"option_free", (Object)groupSubSupplementInfo.getOption_free());
            jsonGroupSubOption.put((Object)"has_limit_options", (Object)groupSubSupplementInfo.isHas_limit_options());
            jsonGroupSubOption.put((Object)"min_option", (Object)groupSubSupplementInfo.getMin_options());
            jsonGroupSubOption.put((Object)"max_option", (Object)groupSubSupplementInfo.getMax_options());
            jsonGroupSubOption.put((Object)"id_global", (Object)groupSubSupplementInfo.getId_global());
            jsonGroupSubOption.put((Object)"number_click", (Object)groupSubSupplementInfo.getNumber_click());
            JSONArray jsonAllSubSupplement = new JSONArray();
            for (SupplementItemInfo subSupplement : groupSubSupplementInfo.getSupplements()) {
                if (subSupplement.isSupplement_item_ubereat()) continue;
                jsonAllSubSupplement.put((Object)subSupplement.getId_global());
            }
            jsonGroupSubOption.put((Object)"sub_supplements", (Object)jsonAllSubSupplement);
            jSONArray6.put((Map)jsonGroupSubOption);
        }
        JSONArray jSONArray7 = new JSONArray();
        for (PromotionInfo promotion : this.promotions) {
            JSONObject jsonPromotion = new JSONObject();
            jsonPromotion.put((Object)"id", (Object)promotion.getId());
            jsonPromotion.put((Object)"name_promotion", (Object)promotion.getName_promotion());
            jsonPromotion.put((Object)"type_order", (Object)promotion.getType_order());
            jsonPromotion.put((Object)"size_product", (Object)promotion.getSize_product());
            jsonPromotion.put((Object)"quantity", (Object)promotion.getQuantity());
            jsonPromotion.put((Object)"discount", (Object)promotion.getDiscount());
            jsonPromotion.put((Object)"label_size_product", (Object)promotion.getLabel_size_product());
            jsonPromotion.put((Object)"label_discount", (Object)promotion.getLabel_discount());
            jsonPromotion.put((Object)"id_global", (Object)promotion.getId_global());
            jsonPromotion.put((Object)"description", (Object)promotion.getDescription());
            jsonPromotion.put((Object)"text_promo", (Object)promotion.getText_promo());
            jSONArray7.put((Map)jsonPromotion);
        }
        this.jsonMenu.put("categories", (Object)jsonAllCategories);
        this.jsonMenu.put("items", (Object)jsonAllItems);
        this.jsonMenu.put("options", (Object)jSONArray);
        this.jsonMenu.put("cartes", (Object)jSONArray5);
        this.jsonMenu.put("groups_sub_options", (Object)jSONArray6);
        this.jsonMenu.put("promotions", (Object)jSONArray7);
        return this;
    }

    public org.json.JSONObject getMenuObject() {
        return this.jsonMenu;
    }

    private org.json.JSONObject geJsonSizeOption(String name_size, String label_size, double price, List<SupplementPriceInfo> supplementPrices, boolean many_type) {
        org.json.JSONObject jsonSize = new org.json.JSONObject();
        jsonSize.put("name_size", (Object)name_size);
        jsonSize.put("label_size", (Object)label_size);
        double price_size = many_type ? 0.0 : price;
        jsonSize.put("price", price_size);
        double price_sp = many_type ? this.getSupplementPrice(supplementPrices, "Sur Place", name_size) : 0.0;
        double price_emp = many_type ? this.getSupplementPrice(supplementPrices, "A Emporter", name_size) : 0.0;
        double price_lv = many_type ? this.getSupplementPrice(supplementPrices, "En Livraison", name_size) : 0.0;
        jsonSize.put("price_sp", price_sp);
        jsonSize.put("price_emp", price_emp);
        jsonSize.put("price_lv", price_lv);
        return jsonSize;
    }

    private double getSupplementPrice(List<SupplementPriceInfo> prices, String type_order, String name_size) {
        double priceOption = 0.0;
        for (SupplementPriceInfo mSupplementPriceInfo : prices) {
            if (mSupplementPriceInfo.getType_order() == null || !mSupplementPriceInfo.getType_order().equalsIgnoreCase(type_order)) continue;
            switch (name_size) {
                case "junior": {
                    priceOption = mSupplementPriceInfo.getPrice_junior();
                    break;
                }
                case "senior": {
                    priceOption = mSupplementPriceInfo.getPrice_senior();
                    break;
                }
                case "mega": {
                    priceOption = mSupplementPriceInfo.getPrice_mega();
                    break;
                }
                case "size1": {
                    priceOption = mSupplementPriceInfo.getPrice_size1();
                    break;
                }
                case "size2": {
                    priceOption = mSupplementPriceInfo.getPrice_size2();
                    break;
                }
                case "size3": {
                    priceOption = mSupplementPriceInfo.getPrice_size3();
                    break;
                }
                case "size4": {
                    priceOption = mSupplementPriceInfo.getPrice_size4();
                    break;
                }
                case "size5": {
                    priceOption = mSupplementPriceInfo.getPrice_size5();
                    break;
                }
                case "size6": {
                    priceOption = mSupplementPriceInfo.getPrice_size6();
                    break;
                }
                case "size7": {
                    priceOption = mSupplementPriceInfo.getPrice_size7();
                }
            }
            break;
        }
        return priceOption;
    }
}

