/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.ticket;

import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.CategoryInfo;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.SupplementInfo;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.ticket.SupplementProduct;
import com.openbravo.pos.util.FilerUtils;
import fr.protactile.procaisse.dao.entities.DeliverooTimeTableInfo;
import fr.protactile.procaisse.dao.entities.DeliverooWorkShiftInfo;
import fr.protactile.procaisse.dao.entities.ImageProduct;
import fr.protactile.procaisse.services.DeliverooTimeTableService;
import java.lang.invoke.CallSite;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class MenuDeliveroBuilder {
    private List<CategoryInfo> categories;
    private List<SupplementInfo> groupsOptions;
    private JSONArray categories_array;
    private JSONObject menuObject;
    private JSONArray modifier_groups_array;
    private JSONArray items_array;
    private String URL_IMAGE_PRODUCT;
    private String URL_IMAGE_OPTION;
    private String URL_LOGO;
    private List<Integer> days_of_week;
    private List<String> categoriesIds;
    private FilerUtils m_FilerUtils = FilerUtils.getInstance();
    private final String PLATFORM = "Platform";
    private List<DeliverooTimeTableInfo> timestables;
    private DeliverooTimeTableService mTimeTableService;
    private String location_id;
    private JSONObject menuDeliveroObject;
    private String ITEM = "ITEMS";
    private String ADD_INGREDIENT = "add-ingredient";
    private String CHOICE = "CHOICE";

    public MenuDeliveroBuilder() {
        this.categories_array = new JSONArray();
        this.menuObject = new JSONObject();
        this.modifier_groups_array = new JSONArray();
        this.items_array = new JSONArray();
        this.menuDeliveroObject = new JSONObject();
        long licenceId = AppLocal.getLicenceId();
        String POS_ID = String.valueOf(licenceId);
        this.URL_IMAGE_PRODUCT = "https://api1.biborne.com/resourcesOld/" + POS_ID + "/products/";
        this.URL_IMAGE_OPTION = "https://api1.biborne.com/resourcesOld/" + POS_ID + "/supplements/";
        this.URL_LOGO = "https://api1.biborne.com/resourcesOld/" + POS_ID + "/logos/" + AppLocal.LOGO_DELIVEROO;
        this.days_of_week = new ArrayList<Integer>();
        this.days_of_week.add(0);
        this.days_of_week.add(1);
        this.days_of_week.add(2);
        this.days_of_week.add(3);
        this.days_of_week.add(4);
        this.days_of_week.add(5);
        this.days_of_week.add(6);
        this.categoriesIds = new ArrayList<String>();
        this.mTimeTableService = DeliverooTimeTableService.getInstance();
        this.timestables = this.mTimeTableService.getTimesTable(true);
    }

    public MenuDeliveroBuilder categories(List<CategoryInfo> categories) {
        this.categories = categories;
        return this;
    }

    public MenuDeliveroBuilder groupsOptions(List<SupplementInfo> groupsOptions) {
        this.groupsOptions = groupsOptions;
        return this;
    }

    public MenuDeliveroBuilder location_id(String location_id) {
        this.location_id = location_id;
        return this;
    }

    public MenuDeliveroBuilder build() {
        for (SupplementInfo groupOptions : this.groupsOptions) {
            Object id_option;
            String text_id_groupOption = groupOptions.getId_global() != null && !groupOptions.getId_global().isEmpty() ? AppLocal.PREFIX_GROUPE_OPTION_NEW + groupOptions.getId_global() : AppLocal.PREFIX_GROUPE_OPTION + groupOptions.getiD();
            JSONObject groupOptionsObject = new JSONObject();
            JSONObject nameGroupOptionsObject = new JSONObject();
            nameGroupOptionsObject.put("en", (Object)groupOptions.getName());
            groupOptionsObject.put("id", (Object)text_id_groupOption);
            groupOptionsObject.put("name", (Object)nameGroupOptionsObject);
            groupOptionsObject.put("min_selection", groupOptions.getHas_options() != false ? Integer.valueOf(groupOptions.getMin_options()) : JSONObject.NULL);
            groupOptionsObject.put("max_selection", groupOptions.getHas_options() != false ? Integer.valueOf(groupOptions.getMax_options()) : JSONObject.NULL);
            groupOptionsObject.put("repeatable", groupOptions.getNumber_click() > 0);
            ArrayList<Object> ids_option = new ArrayList<Object>();
            for (SupplementItemInfo option : groupOptions.getItems()) {
                if (option.getName() == null || option.getName().isEmpty()) continue;
                Object object = id_option = option.getId_global() != null && !option.getId_global().isEmpty() ? AppLocal.PREFIX_OPTION_NEW + option.getId_global() : AppLocal.PREFIX_OPTION + option.getiD();
                String image = option.getImageUrl() != null && !option.getImageUrl().isEmpty() ? option.getImageUrl() : (option.getPath() != null ? this.URL_IMAGE_OPTION + option.getPath() : null);
                JSONObject optionObject = this.getItemObject("", (String)id_option, image, option.getName().trim(), option.getPriceOption(null, "Platform"), null, 10.0, null, this.CHOICE);
                this.items_array.put((Object)optionObject);
                ids_option.add(id_option);
            }
            if (ids_option != null && !ids_option.isEmpty()) {
                String[] idsArray = new String[ids_option.size()];
                int index = 0;
                id_option = ids_option.iterator();
                while (id_option.hasNext()) {
                    String id_option2;
                    idsArray[index] = id_option2 = (String)id_option.next();
                    ++index;
                }
                groupOptionsObject.put("item_ids", (Object)idsArray);
            } else {
                groupOptionsObject.put("item_ids", (Object)new String[0]);
            }
            groupOptionsObject.put("type", (Object)this.ADD_INGREDIENT);
            this.modifier_groups_array.put((Object)groupOptionsObject);
        }
        for (CategoryInfo category : this.categories) {
            if (category.getProducts() == null || category.getProducts().isEmpty()) continue;
            JSONObject categoryObject = new JSONObject();
            ArrayList<CallSite> ids_items = new ArrayList<CallSite>();
            for (ProductInfoExt product : category.getProducts()) {
                String imagePOSUrl;
                double price = product.getPrice("Platform", AppLocal.TARIFF);
                if (product.isMany_size() || price == 0.0) continue;
                String id_product = product.getId_global() != null && !product.getId_global().isEmpty() ? AppLocal.PREFIX_PRODUCT_NEW + product.getId_global() : AppLocal.PREFIX_PRODUCT + product.getID();
                ArrayList<String> ids_group_option = new ArrayList<String>();
                for (SupplementProduct supplement : product.getSupplements()) {
                    String text_id_groupOption = supplement.getId_global() != null && !supplement.getId_global().isEmpty() ? AppLocal.PREFIX_GROUPE_OPTION_NEW + supplement.getId_global() : AppLocal.PREFIX_GROUPE_OPTION + supplement.getiD();
                    ids_group_option.add(text_id_groupOption);
                }
                Object image = null;
                Object image_uber = null;
                ImageProduct imagePlatform = product.getImagePlatform();
                ImageProduct imagePOS = product.getImagePOS();
                String imagePlatformPath = imagePlatform != null ? imagePlatform.getPath() : null;
                String imagePlatformUrl = imagePlatform != null ? imagePlatform.getUrl() : null;
                String imagePOSPath = imagePOS != null ? imagePOS.getPath() : null;
                String string = imagePOSUrl = imagePOS != null ? imagePOS.getUrl() : null;
                if (imagePlatformUrl != null && !imagePlatformUrl.isEmpty()) {
                    image_uber = imagePlatformUrl;
                } else if (imagePlatformPath != null && !imagePlatformPath.isEmpty()) {
                    image_uber = this.URL_IMAGE_PRODUCT + imagePlatformPath;
                }
                if (imagePOSUrl != null && !imagePOSUrl.isEmpty()) {
                    image = imagePOSUrl;
                } else if (imagePOSPath != null && !imagePOSPath.isEmpty()) {
                    image = this.URL_IMAGE_PRODUCT + imagePOSPath;
                }
                String description = product.getDescription_uberEat() != null ? product.getDescription_uberEat() : (product.getDescription() != null ? product.getDescription() : "");
                JSONObject optionObject = this.getItemObject(description, id_product, (String)image_uber, product.getName(), price, ids_group_option, product.getTax_rate_double(), (String)image, this.ITEM);
                this.items_array.put((Object)optionObject);
                ids_items.add((CallSite)((Object)id_product));
            }
            if (ids_items.isEmpty()) continue;
            String text_id_category = category.getId_global() != null && !category.getId_global().isEmpty() ? AppLocal.PREFIX_CATEGORY_NEW + category.getId_global() : AppLocal.PREFIX_CATEGORY + category.getID();
            this.categoriesIds.add(text_id_category);
            JSONObject nameObject = new JSONObject();
            nameObject.put("en", (Object)category.getName());
            categoryObject.put("id", (Object)text_id_category);
            categoryObject.put("name", (Object)nameObject);
            if (ids_items != null && !ids_items.isEmpty()) {
                String[] idsArray = new String[ids_items.size()];
                int index = 0;
                Iterator iterator = ids_items.iterator();
                while (iterator.hasNext()) {
                    String id_item;
                    idsArray[index] = id_item = (String)iterator.next();
                    ++index;
                }
                categoryObject.put("item_ids", (Object)idsArray);
            } else {
                categoryObject.put("item_ids", (Object)new String[0]);
            }
            this.categories_array.put((Object)categoryObject);
        }
        this.buildMenu();
        return this;
    }

    public JSONObject getMenuObject() {
        this.menuDeliveroObject.put("site_ids", (Object)new String[]{this.location_id});
        this.menuDeliveroObject.put("menu", (Object)this.menuObject);
        return this.menuDeliveroObject;
    }

    private JSONObject getItemObject(String description, String text_id, String image_uber, String name, double price, List<String> id_groups_options, double tax, String image, String type) {
        System.out.println("+++++++ tax : " + tax);
        JSONObject itemObject = new JSONObject();
        JSONObject descriptionObject = new JSONObject();
        JSONObject nameObject = new JSONObject();
        JSONObject imageObject = new JSONObject();
        descriptionObject.put("en", (Object)description);
        nameObject.put("en", (Object)name);
        String image_to_send = null;
        boolean send_image = this.checkImage(image_uber);
        if (!send_image && image != null) {
            send_image = this.checkImage(image);
            image_to_send = image;
        } else {
            image_to_send = image_uber;
        }
        if (send_image) {
            imageObject.put("url", (Object)image_to_send);
        }
        JSONObject priceInfoObject = new JSONObject();
        int priceinfo = (int)Math.round(price * 100.0);
        priceInfoObject.put("price", priceinfo);
        JSONArray priceOverridesArray = new JSONArray();
        priceInfoObject.put("overrides", (Object)priceOverridesArray);
        if (id_groups_options != null && !id_groups_options.isEmpty()) {
            String[] idsArray = new String[id_groups_options.size()];
            int index = 0;
            Iterator<String> iterator = id_groups_options.iterator();
            while (iterator.hasNext()) {
                String id_group_options;
                idsArray[index] = id_group_options = iterator.next();
                ++index;
            }
            itemObject.put("modifier_ids", (Object)idsArray);
        } else {
            itemObject.put("modifier_ids", (Object)new String[0]);
        }
        itemObject.put("name", (Object)nameObject);
        itemObject.put("description", (Object)descriptionObject);
        itemObject.put("operational_name", (Object)name);
        itemObject.put("image", (Object)imageObject);
        itemObject.put("price_info", (Object)priceInfoObject);
        itemObject.put("plu", (Object)text_id);
        itemObject.put("ian", (Object)"");
        itemObject.put("tax_rate", tax);
        itemObject.put("id", (Object)text_id);
        if (type != null) {
            itemObject.put("type", (Object)type);
        }
        return itemObject;
    }

    private void buildMenu() {
        String[] categoryIdsArray = new String[this.categoriesIds.size()];
        int index = 0;
        Iterator<String> iterator = this.categoriesIds.iterator();
        while (iterator.hasNext()) {
            String categoryId;
            categoryIdsArray[index] = categoryId = iterator.next();
            ++index;
        }
        JSONArray mealtimesArray = new JSONArray();
        JSONObject mealtimeObject = new JSONObject();
        JSONObject mealtimeNameObject = new JSONObject();
        JSONObject mealtimeImageObject = new JSONObject();
        JSONObject mealtimeDescriptionObject = new JSONObject();
        JSONArray scheduleArray = new JSONArray();
        for (DeliverooTimeTableInfo timetable : this.timestables) {
            if (timetable.getDay_off().booleanValue()) continue;
            JSONObject scheduleObject = new JSONObject();
            JSONArray timePeriodesArray = new JSONArray();
            if (timetable.getWorkShiftCollection() != null) {
                ArrayList<DeliverooWorkShiftInfo> workShifts = new ArrayList<DeliverooWorkShiftInfo>();
                workShifts.addAll(timetable.getWorkShiftCollection());
                Collections.sort(workShifts, new Comparator<DeliverooWorkShiftInfo>(){

                    @Override
                    public int compare(DeliverooWorkShiftInfo workShift1, DeliverooWorkShiftInfo workShift2) {
                        return workShift1.getId() - workShift2.getId();
                    }
                });
                int index_work_shift = 0;
                for (DeliverooWorkShiftInfo workShiftInfo : timetable.getWorkShiftCollection()) {
                    ++index_work_shift;
                    if (workShiftInfo.getStart_shift() != null && !workShiftInfo.getStart_shift().isEmpty() && workShiftInfo.getEnd_shift() != null && !workShiftInfo.getEnd_shift().isEmpty()) {
                        boolean exist = false;
                        for (int i = 0; i < timePeriodesArray.length(); ++i) {
                            String endShiftCheck;
                            JSONObject timePeriodObjectCheck = timePeriodesArray.getJSONObject(i);
                            String startShiftCheck = timePeriodObjectCheck.isNull("start") ? "" : timePeriodObjectCheck.getString("start");
                            String string = endShiftCheck = timePeriodObjectCheck.isNull("end") ? "" : timePeriodObjectCheck.getString("end");
                            if (!workShiftInfo.getStart_shift().equals(startShiftCheck) || !workShiftInfo.getEnd_shift().equals(endShiftCheck)) continue;
                            exist = true;
                            break;
                        }
                        if (exist) continue;
                        JSONObject timePeriodObject = new JSONObject();
                        timePeriodObject.put("start", (Object)workShiftInfo.getStart_shift());
                        timePeriodObject.put("end", (Object)workShiftInfo.getEnd_shift());
                        timePeriodesArray.put((Object)timePeriodObject);
                    }
                    if (index_work_shift < 2) continue;
                    break;
                }
                System.out.println("timePeriodesArray : " + timePeriodesArray);
            }
            scheduleObject.put("day_of_week", timetable.getDay());
            scheduleObject.put("time_periods", (Object)timePeriodesArray);
            scheduleArray.put((Object)scheduleObject);
        }
        mealtimeNameObject.put("en", (Object)"mealtime 1");
        mealtimeDescriptionObject.put("en", (Object)"");
        mealtimeImageObject.put("url", (Object)this.URL_LOGO);
        System.out.println("++++++++ URL_LOGO : " + this.URL_LOGO);
        mealtimeObject.put("id", (Object)"mealtime_1");
        mealtimeObject.put("name", (Object)mealtimeNameObject);
        mealtimeObject.put("description", (Object)mealtimeDescriptionObject);
        mealtimeObject.put("image", (Object)mealtimeImageObject);
        mealtimeObject.put("schedule", (Object)scheduleArray);
        mealtimeObject.put("category_ids", (Object)categoryIdsArray);
        mealtimesArray.put((Object)mealtimeObject);
        JSONObject nameMenuObject = new JSONObject();
        nameMenuObject.put("en", (Object)"All day");
        this.menuObject.put("name", (Object)nameMenuObject);
        this.menuObject.put("mealtimes", (Object)mealtimesArray);
        this.menuObject.put("items", (Object)this.items_array);
        this.menuObject.put("categories", (Object)this.categories_array);
        this.menuObject.put("modifiers", (Object)this.modifier_groups_array);
    }

    public MenuDeliveroBuilder buildEmptyMenu() {
        this.buildMenu();
        return this;
    }

    private boolean checkImage(String image) {
        if (image != null) {
            try {
                System.out.println("++++++++++++ image : " + image);
                URL url = new URL(image);
                HttpURLConnection huc = (HttpURLConnection)url.openConnection();
                int responseCode = huc.getResponseCode();
                return responseCode == 200;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }
}

