/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.ticket;

import com.openbravo.basic.BasicException;
import com.openbravo.data.loader.IKeyed;
import com.openbravo.data.loader.SerializableRead;
import com.openbravo.data.loader.SerializableWrite;
import com.openbravo.data.loader.SerializerRead;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.util.LogToFile;
import com.procaisse.db.metadata.DataRead;
import com.procaisse.db.metadata.DataWrite;
import fr.protactile.procaisse.dao.entities.MultiLanguageSupplementItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.image.Image;

public class ItemOrderInfo
implements IKeyed,
SerializableWrite,
SerializableRead,
Serializable,
Cloneable {
    private int id;
    private int idCarte;
    private int idProduct;
    private int supplement;
    private String nameSupplement;
    private String nameProduct;
    private String nameCarte;
    private int index_carte;
    private String ref_web;
    private String alias_name_ingredient;
    private String path;
    private String ref_product;
    private String ref_carte;
    private int id_ingredient_kitchen;
    private int id_shared_ingredient;
    private String id_global_supplement;
    private String id_global_product;
    private String id_global_carte;
    private String displayedName;
    private boolean cookable;
    private List<MultiLanguageSupplementItem> multiLanguageTexts;
    private Image imageIngredient;

    public ItemOrderInfo(SupplementItemInfo ingredientItem, int idCarte, int idProduct, String nameProduct, String nameCarte, int index_carte, String ref_product, String ref_carte, String id_global_product, String id_global_carte) {
        this.idCarte = idCarte;
        this.idProduct = idProduct;
        this.supplement = ingredientItem.getiD();
        this.nameSupplement = ingredientItem.getName();
        this.nameProduct = nameProduct;
        this.nameCarte = nameCarte;
        this.index_carte = index_carte;
        this.ref_web = ingredientItem.getRef_web();
        this.alias_name_ingredient = ingredientItem.getAlias_kitchen();
        this.path = ingredientItem.getPath();
        this.ref_product = ref_product;
        this.ref_carte = ref_carte;
        this.id_global_supplement = ingredientItem.getId_global();
        this.id_global_product = id_global_product;
        this.id_global_carte = id_global_carte;
        this.displayedName = ingredientItem.getDisplayedName();
        this.cookable = ingredientItem.isCookable();
        this.multiLanguageTexts = ingredientItem.getMultiLanguageTexts();
    }

    public ItemOrderInfo() {
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getIndex_carte() {
        return this.index_carte;
    }

    public void setIndex_carte(int index_carte) {
        this.index_carte = index_carte;
    }

    public int getIdCarte() {
        return this.idCarte;
    }

    public void setIdCarte(int idCarte) {
        this.idCarte = idCarte;
    }

    public int getIdProduct() {
        return this.idProduct;
    }

    public void setIdProduct(int idProduct) {
        this.idProduct = idProduct;
    }

    public int getSupplement() {
        return this.supplement;
    }

    public void setSupplement(int supplement) {
        this.supplement = supplement;
    }

    public String getNameSupplement() {
        return this.nameSupplement;
    }

    public void setNameSupplement(String nameSupplement) {
        this.nameSupplement = nameSupplement;
    }

    public String getNameProduct() {
        return this.nameProduct;
    }

    public void setNameProduct(String nameProduct) {
        this.nameProduct = nameProduct;
    }

    public String getNameCarte() {
        return this.nameCarte;
    }

    public void setNameCarte(String nameCarte) {
        this.nameCarte = nameCarte;
    }

    public String getRef_web() {
        return this.ref_web;
    }

    public void setRef_web(String ref_web) {
        this.ref_web = ref_web;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public Object getKey() {
        return this.idCarte;
    }

    @Override
    public void writeValues(DataWrite dp) throws BasicException {
        dp.setInt(1, this.idCarte);
        dp.setInt(2, this.idProduct);
        dp.setInt(3, this.supplement);
        dp.setString(4, this.nameSupplement);
        dp.setString(5, this.nameProduct);
    }

    @Override
    public void readValues(DataRead dr) throws BasicException {
        this.idCarte = dr.getInt(1);
        this.idProduct = dr.getInt(2);
        this.supplement = dr.getInt(3);
        this.nameSupplement = dr.getString(4);
        this.nameProduct = dr.getString(5);
    }

    public static SerializerRead getSerializerRead() {
        return new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                ItemOrderInfo orderItem = new ItemOrderInfo();
                orderItem.id = dr.getInt(1);
                orderItem.idCarte = dr.getInt(2);
                orderItem.nameCarte = dr.getString(3);
                orderItem.idProduct = dr.getInt(4);
                orderItem.nameProduct = dr.getString(5);
                orderItem.supplement = dr.getInt(6);
                orderItem.nameSupplement = dr.getString(7);
                orderItem.index_carte = dr.getInt(8);
                orderItem.path = dr.getString(9);
                orderItem.id_ingredient_kitchen = dr.getInt(10);
                orderItem.alias_name_ingredient = dr.getString(11);
                orderItem.cookable = dr.getBoolean(12);
                return orderItem;
            }
        };
    }

    public Object clone() {
        try {
            ItemOrderInfo o = null;
            o = (ItemOrderInfo)super.clone();
            if (this.multiLanguageTexts != null) {
                o.multiLanguageTexts = new ArrayList<MultiLanguageSupplementItem>();
                for (int i = 0; i < this.multiLanguageTexts.size(); ++i) {
                    o.multiLanguageTexts.add((MultiLanguageSupplementItem)this.multiLanguageTexts.get(i).clone());
                }
            } else {
                o.multiLanguageTexts = null;
            }
            return o;
        }
        catch (CloneNotSupportedException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            return null;
        }
    }

    public String getAlias_name_ingredient() {
        return this.alias_name_ingredient;
    }

    public void setAlias_name_ingredient(String alias_name_ingredient) {
        this.alias_name_ingredient = alias_name_ingredient;
    }

    public String getRef_product() {
        return this.ref_product;
    }

    public void setRef_product(String ref_product) {
        this.ref_product = ref_product;
    }

    public String getRef_carte() {
        return this.ref_carte;
    }

    public void setRef_carte(String ref_carte) {
        this.ref_carte = ref_carte;
    }

    public int getId_ingredient_kitchen() {
        return this.id_ingredient_kitchen;
    }

    public void setId_ingredient_kitchen(int id_ingredient_kitchen) {
        this.id_ingredient_kitchen = id_ingredient_kitchen;
    }

    public int getId_shared_ingredient() {
        return this.id_shared_ingredient;
    }

    public void setId_shared_ingredient(int id_shared_ingredient) {
        this.id_shared_ingredient = id_shared_ingredient;
    }

    public String printName(boolean show_alias) {
        String name_supplement = show_alias && this.alias_name_ingredient != null && !this.alias_name_ingredient.trim().isEmpty() ? this.alias_name_ingredient : this.nameSupplement;
        return name_supplement;
    }

    public String getId_global_supplement() {
        return this.id_global_supplement;
    }

    public void setId_global_supplement(String id_global_supplement) {
        this.id_global_supplement = id_global_supplement;
    }

    public String getId_global_product() {
        return this.id_global_product;
    }

    public void setId_global_product(String id_global_product) {
        this.id_global_product = id_global_product;
    }

    public String getId_global_carte() {
        return this.id_global_carte;
    }

    public void setId_global_carte(String id_global_carte) {
        this.id_global_carte = id_global_carte;
    }

    public String getDisplayedName() {
        return this.displayedName;
    }

    public void setDisplayedName(String displayedName) {
        this.displayedName = displayedName;
    }

    public boolean isCookable() {
        return this.cookable;
    }

    public void setCookable(boolean cookable) {
        this.cookable = cookable;
    }

    public List<MultiLanguageSupplementItem> getMultiLanguageTexts() {
        return this.multiLanguageTexts;
    }

    public void setMultiLanguageTexts(List<MultiLanguageSupplementItem> multiLanguageTexts) {
        this.multiLanguageTexts = multiLanguageTexts;
    }

    public String getNameByLanguage(String code_language) {
        String nameByLanguage = "";
        if (this.multiLanguageTexts != null && this.multiLanguageTexts.size() > 0 && code_language != null && !code_language.isEmpty()) {
            for (MultiLanguageSupplementItem multiLanguageText : this.multiLanguageTexts) {
                if (!code_language.equalsIgnoreCase(multiLanguageText.getLanguage())) continue;
                nameByLanguage = multiLanguageText.getName();
                break;
            }
        }
        return nameByLanguage;
    }

    public Image getImageIngredient() {
        return this.imageIngredient;
    }

    public void setImageIngredient(Image imageIngredient) {
        this.imageIngredient = imageIngredient;
    }
}

